function sd_write_keypoints(feature_locs, fname, img_size)
% Columns on output file:
% x, y, scale, orientation, detector score
% Scale equals detector support size / 4
%feature_locs(:,3) = feature_locs(:,3) * support_size / 4;

if ~exist('img_size', 'var')
    img_size = [0 0];
end

% write keypoints
f = fopen(fname, 'w');
fprintf(f, '# keys = %d, px = %f, py = %f\n', size(feature_locs,1), img_size(2)/2, img_size(1)/2);
fclose(f);

if size(feature_locs,1) == 0
    return
end

feature_locs(:,1) = feature_locs(:,1) - 1;
feature_locs(:,2) = feature_locs(:,2) - 1;

assert(size(feature_locs,2) == 5);
dlmwrite(fname, feature_locs, '-append', 'delimiter', ' ', 'precision', 6);

end