function [ imdist ] = sd_symscale_donut(img, k_width)
% Compute symmetry distance using a ring for the weighting function.

[x, y] = meshgrid(linspace(-1,1, k_width));
r = sqrt(x.^2 + y.^2);
sig = 1/12;
w = exp(-(r - 0.75).^2/(2 * sig^2));
w = w - min(w(:));

%w = double((r > 0.8) & (r <= 1)); % debug: sharp donut
w = w / sum(w(:));

%plot(w((end + 1)/2,:))
%w = fspecial('gaussian', k_width, k_width/6); % debug: gaussian mask

imdist = sd_naive_symdist('r', img, w);
end