function [ symscore ] = sd_symmetry_score(symdist, img_var, k_width, alpha, symtype, bilateral_angle)
% k_width - only necessary with type == 2

d = 0;
if strcmp(symtype, 'bilateral')
    assert(bilateral_angle == 0 || bilateral_angle == 90);

    if bilateral_angle == 90
        d = 2;
    else
        d = 1;
    end
end

assert(all(symdist(:) >= 0));

if 0
    sym_comp = exp(- alpha * symdist);
    fprintf('>> sym_comp range: [%f, %f]\n', min(sym_comp(:)), max(sym_comp(:)));
    k = -sd_laplacian_of_gaussian(k_width, d);
else
    sym_comp = symdist;
    k = sd_laplacian_of_gaussian(k_width, d);
end

if 0
    symscore = normxcorr2(k, sym_comp);
    h = (k_width + 1)/2;
    symscore = symscore(h:(end-h)+1, h:(end-h)+1);
else
    symscore = conv2( sym_comp, k, 'same');
end

end