% channels - which channels in the symmetry score image to use to find
% peaks.
function [ locs ] = sd_symg_locate_features_scale(symscore_prev, symscore, symscore_next, pnts_scale, feat_scale, nms_radius, nms_thresh)

locs = []; % (x, y, scale, orientation) in baselevel scale + (x, y, pyramid level) in pyramid level coords

[y, x] = nonmaxsuppts(symscore, nms_radius, nms_thresh);
% [y, x] = nonmaxsuppts2(symscore, nms_radius, nms_thresh);

% filter out those interest points that are not maxima in scale space
indices = find((symscore(sub2ind(size(symscore), y, x)) > symscore_prev(sub2ind(size(symscore_prev), y, x))) & ...
               (symscore(sub2ind(size(symscore), y, x)) > symscore_next(sub2ind(size(symscore_next), y, x))));
y = y(indices);
x = x(indices);

peaks_score = symscore(sub2ind(size(symscore), y, x));
[y, x] = sd_subpixel_refine(symscore, y, x);

locs = cat(1, locs, cat(2, (x - 0.5) * pnts_scale - 0.5, (y - 0.5) * pnts_scale - 0.5, ...
    zeros(size(x)) + feat_scale, zeros(size(x)), peaks_score)); % location, scale, orientation
