function [ score_h, score_v, product ] = ...
      sd_compute_horz_vert_symmetry_regions( I, sym_scale, grad_scale, hist_scale, num_bins )
% Computes horizontal and vertical symmetries, as well as their product
% (or minimum), as a final symmetry score
% 
% In addition, filters the symmetry scores to compute symmetric regions

% default grad_scale: 3.0

normalize_hist = 1;
smooth_type = 0; % 1
use_harris = 1;
use_log = 0;

if ~use_log
    harris_threshold = 0.0;
    % harris_threshold = 5.0e-8;
    % harris_threshold = 5.0e-9;
    % harris_threshold = 0.5e-9; % 2.0e-8;  %7
    % harris_threshold = 2.0e-8;  %7
    % harris_threshold = 1.0e-8;  %7
else
    harris_threshold = 5.0e-10;
end
    
% horizontal symmetries
score_h = sd_symg_compute_symmetry_orient_fast_bins(I, sym_scale, grad_scale, hist_scale, num_bins, normalize_hist, 'horizontal', smooth_type);

% vertical symmetries
score_v = sd_symg_compute_symmetry_orient_fast_bins(I, sym_scale, grad_scale, hist_scale, num_bins, normalize_hist, 'vertical', smooth_type);

[dog, dog_x, dog_y] = sd_oriented_dog(1.2, 1.2);
score_h = max(conv2(score_h, dog_x, 'same'), 0.0);
score_v = max(conv2(score_v, dog_y, 'same'), 0.0);

% now, filter the scores themselves to compute regions
% region_scores = sd_compute_symmetry_regions(score_h, sym_scale * 0.5, 16);

% Combining horizontal and vertical symmetries -- taken product or min?
product = score_h .* score_v;
% product = min(score_h, score_v);

if use_log
    product = max(conv2(product, -fspecial('log', [21 21], 2.0), 'same'), 0.0);            
end

if use_harris
    % multiply result by the harris score
    harris_score = harris(product, 2.0);
    product = product .* (harris_score >= harris_threshold);
end

end
