function sd_symg(filename, output_fname)
% Driver for the symnoah detector, with some default parameter values

% Defaults:
base_sym_scale  = 10.000; % 16.0; 
scale_factor    = 2^(-1/16);
num_scales      = 2%96; % 80
gradient_scale  = 0.500;
histogram_scale = 0.500;
num_bins        = 8;
threshold       = 0.00005; % 0.00001; % 0.05; % 0.01; % 0.0001;
use_rotational_symmetry = 0;
magnification   = 1;
max_image_size  = 4000;
generate_regions = 0;
debug            = 0;
% harris_threshold = 1.0e-8; (or 1e-7, 2e-8?)

output_basename = strcat(output_fname, '_');

sd_symg_generate_symmetry_features(filename, base_sym_scale, scale_factor, num_scales, ...
    gradient_scale, histogram_scale, num_bins, threshold, use_rotational_symmetry, ...
    magnification, generate_regions, max_image_size, output_basename, output_fname, debug);
