function [ y_out, x_out ] = sd_subpixel_refine( score, y, x )
% Compute a subpixel refinement of a set of features based on a quadratic
% fit

num_points = length(y);
y_out = zeros(num_points, 1);
x_out = zeros(num_points, 1);

[h, w] = size(score);

rad = 1;

% setup A matrix for least squares
A = zeros((2 * rad + 1) * (2 * rad + 1), 6);
count = 1;
for y_d = -rad:rad
    for x_d = -rad:rad
        A(count, 1) = y_d * y_d;
        A(count, 2) = y_d * x_d;
        A(count, 3) = y_d;
        A(count, 4) = x_d * x_d;
        A(count, 5) = x_d;
        A(count, 6) = 1;
        count = count + 1;
    end
end

for i = 1:num_points
    y_i = y(i);
    x_i = x(i);
    
    % check boundary case
    if (x_i <= rad || y_i <= rad || x_i > w-rad || y_i > h-rad)
        y_out(i) = y_i;
        x_out(i) = x_i;
        continue;
    end
    
    b = zeros((2 * rad + 1), 1);
    
    count = 1;
    for y_d = -rad:rad
        for x_d = -rad:rad
            b(count, 1) = score(y_i + y_d, x_i + x_d);
            count = count + 1;
        end
    end
    
    coeffs = A \ b;
    
    J = zeros(2, 2); Jr = zeros(2, 1);
    J(1,1) = 2 * coeffs(1);
    J(1,2) = coeffs(2);
    Jr(1) = -coeffs(3);
    J(2,1) = coeffs(2);
    J(2,2) = 2 * coeffs(4);
    Jr(2) = -coeffs(5);

    x_ref = J \ Jr;
    y_out(i) = y_i + x_ref(1);
    x_out(i) = x_i + x_ref(2);
end
