function [] = sd_show_keypoints(img_fname, key_fname, varargin)

top_n_scale = 100000;
top_n_score = 100000;

desc_fname = [];

defaults = sd_defaults();
desc_dims = [];
k = 1;
while k < length(varargin)
    switch(varargin{k})
        case 'top_n_score'
            top_n_score = varargin{k + 1};
            k = k + 1;
        case 'top_n_scale'
            top_n_scale = varargin{k + 1};
            k = k + 1;
        case 'output'
            output_fname = varargin{k + 1};
            k = k + 1;
        case 'desc_symd'
            desc_type = 'symd';
            desc_fname = varargin{k + 1};
            k = k + 1;
        case 'desc_ssim'
            desc_type = 'ssim';
            desc_fname = varargin{k + 1};
            k = k + 1;
        case 'desc_hols'
            desc_type = 'hols';
            desc_fname = varargin{k + 1};
            k = k + 1;
        case 'desc_dims'
            desc_dims = varargin{k + 1};
            k = k + 1;
        otherwise
            error('Unrecognized argument %s', varargin{k});
    end
    k = k + 1;
end

if isempty(desc_dims) && ~isempty(desc_fname)
    switch(desc_type)
        case 'symd'
            desc_dims = [defaults.n_ang_buckets defaults.n_rad_buckets];
        case 'ssim'
            desc_dims = [defaults.n_ang_buckets defaults.n_rad_buckets];
        case 'hols'
            desc_dims = [defaults.n_orientations defaults.n_spatial_bins];
    end
end

show_descriptor = ~isempty(desc_fname);
if show_descriptor
    desc = sd_read_descriptors(desc_fname);
end

a = axes;

img = imread(img_fname);
if size(img,3) == 4
    img = img(:,:,1:3);
end
if size(img,3) == 3
    img = rgb2gray(img);
elseif size(img,3) == 2
    img = img(:,:,1);    
end

if exist('output_fname', 'var')
    sd_log(1, 'Using non-display version');
    imshow_func = @(img) imagesc((img + 0*128) * 1);% imshow(img, 'Border', 'tight', 'InitialMagnification', 100, 'parent', a);
else
    imshow_func = @(img) imshow(im2double(img), [0 1]);
end

%img = im2double(img);
if ischar(key_fname)
    keys = sd_read_keypoints(key_fname);
else
    keys = key_fname;
end
    
assert(~(top_n_scale < size(keys,1) && top_n_score < size(keys,1)));

user_r = 25;

[ignore score_order] = sort(keys(:,5), 'descend');
if top_n_score < size(keys,1)
    keys = keys(score_order(1:top_n_score),:);
end

[ignore scale_order] = sort(keys(:,3), 'descend');
if top_n_scale < size(keys,1)
    keys = keys(scale_order(1:top_n_scale),:);
end

imshow_func(img);
sel_pnts = ones(size(keys,1),1);
user_button = 1;
while user_button == 1
    % draw
    cla
    
    imshow_func(img);    
    line([10, 100], [10, 10], 'Color', [0 0 0]);
    line([10, 10], [5, 15]  , 'Color', [0 0 0]);
    line([100, 100], [5, 15], 'Color', [0 0 0]);
    
    if size(keys,1) > 0
        hold on
        if nnz(sel_pnts)
            plot(keys(sel_pnts == 1,1), keys(sel_pnts == 1,2), 'r+')
            if show_descriptor && nnz(sel_pnts) == 1 && exist('idx', 'var')
                d = desc(find(sel_pnts),:); 
                desc_radius = 0.5 * ((4 * keys(idx,3))/defaults.k_width) * defaults.desc_support;
                
                switch(desc_type)
                    case 'ssim'
                        sd_plot_symdesc(d, desc_dims(1), desc_dims(2), ...
                            'center', keys(idx,1:2), 'radius', desc_radius, ...
                            'ang_shift', -90, 'has_central_bin', 0, ...
                            'n_channels', 1, 'flipy', 1);
                    case 'symd'
                        sd_plot_symdesc(d, desc_dims(1), desc_dims(2), ...
                            'center', keys(idx,1:2), 'radius', desc_radius);
                    case 'hols'
                        sd_plot_hols(d, desc_dims(1), desc_dims(2), 'center', keys(idx,1:2), ...
                            'support', desc_radius * 2);
                end
            end
        end
        if nnz(~sel_pnts)
            plot(keys(sel_pnts == 0,1), keys(sel_pnts == 0,2), 'rx', 'MarkerSize', 3)
        end
        
        if nnz(sel_pnts) > 0 %&& ~show_descriptor
            for i = find(sel_pnts)'
                w = keys(i,3) * 4;
                x = keys(i,1) - w/2;
                y = keys(i,2) - w/2;
                                
                rgb = hsv2rgb([1 1 0.9]);
                
                rectangle('Position', [x y w w], 'Curvature', [1 1], ...
                    'EdgeColor', rgb, 'LineWidth', 1.5);
                %rectangle('Position', [keys(i,1)- 2*w keys(i,2)-2*w 4*w 4*w], 'Curvature', [1 1], 'EdgeColor', rgb);
            end
        end

        % Show the size of the selected region
        %rectangle('Position', [user_x- user_r user_y- user_r 2*user_r 2*user_r] , ...
        %    'Curvature', [1 1], 'EdgeColor', [1 0 1]);
    end

    % where did the user click
    if ~exist('output_fname', 'var')
        [user_x user_y user_button] = ginput(1);
        if ( user_button ~= 1 )
            continue;
        end
    
        user_dist = (user_x - keys(:,1)).^2 + (user_y - keys(:,2)).^2;
        
        if show_descriptor
            [dist idx] = min(user_dist);
            sel_pnts(:) = 0;
            if dist < user_r^2
                sel_pnts(idx) = 1;
            end
        else
            sel_pnts = user_dist < user_r^2;
        end
    else
        break;
    end
end

if  exist('output_fname', 'var') 
    axis tight
    axis off
    colormap gray
    daspect([1 1 1])
    %print(gcf, '-r12000', '-dtiff', output_fname);
    [p n e] = fileparts(output_fname);
    if strcmp(e, '.eps')    
        saveas(gcf, output_fname, 'epsc');
    else
        saveas(gcf, output_fname);
    end
end


end