function [img_var] = sd_pointwise_image_variance(img, win_size)

% Image variance
if 1
    % old and slow
    var_mask = sd_fspecial('gaussian', win_size);
    
    %var_mask = ones(win_size,1);%gausswin(win_size);
    var_mask = var_mask * var_mask';
    var_mask = var_mask / sum(var_mask(:));
    
    img_var = conv2(img.^2, var_mask, 'same') - conv2(img, var_mask, 'same').^2;
else
    % fast and new
    var_mask = gausswin(win_size);
    var_mask = var_mask / sum(var_mask);
    img_var = conv2(conv2(img.^2, var_mask, 'same'), var_mask', 'same') ...
        - conv2(conv2(img, var_mask, 'same'), var_mask', 'same').^2;
end
end