function [dog, dog1, dog2] = sd_oriented_dog(sigma_x, sigma_y)
% Computes an oriented difference-of-gaussians filter

alpha = 1.6;

w = ceil(8 * sigma_x) + 1;
h = ceil(8 * sigma_y) + 1;

G1_x = fspecial('gaussian', [1 w], sigma_x);
G1_y = fspecial('gaussian', [h 1], sigma_y);

G2_x = fspecial('gaussian', [1 w], alpha * sigma_x);
G2_y = fspecial('gaussian', [h 1], alpha * sigma_y);

G_comb = conv2(G2_x, G2_y, 'full') - conv2(G1_x, G1_y, 'full');

dog = G_comb;

dG_x = G2_x - G1_x;
dG_y = G2_y - G1_y;

G_comb2 = conv2(-dG_x, -dG_y, 'full');
dog = G_comb2;

dog1 = -dG_x;
dog2 = -dG_y;

end
