function [J, Jori] = normalized_gradient_zitnick(I, sigma, e)
% Compute normalized gradient of the input (double, grayscale) image I
% sigma - scale of averaging window

sigma0 = 0.5;
alpha = 0.25;
% lambda = 1.5;
lambda = 2.0;

if ~exist('e', 'var')
    e = 5.0e-2;
end

% blur image
% sigma_blur = sqrt((alpha * sigma) ^ 2 - sigma0 * sigma0);
sigma_blur = sqrt((alpha * sigma) ^ 2);

fprintf('[zitnick] blurring with sigma = %0.3f\n', sigma_blur);

G_blur = fspecial('gaussian', [1 ceil(8 * sigma_blur) + 1], sigma_blur);
I_blur = conv2(conv2(I, G_blur, 'same'), G_blur', 'same');

% compute gradient images
D = [-1 0 1];
Jx = conv2(I_blur, D, 'same');
Jy = conv2(I_blur, D', 'same');

Jmag = sqrt(Jx .* Jx + Jy .* Jy);

% compute mean gradient at location
sigma_full = alpha * sigma * sqrt(lambda * lambda - 1);
fprintf('[zitnick] normalizing with sigma = %0.3f\n', sigma_full);

G_avg = fspecial('gaussian', [1 ceil(8 * sigma_full) + 1], sigma_full);

% mean gradient magnitude
Javg = conv2(conv2(Jmag, G_avg, 'same'), G_avg', 'same');

% division
J = Jmag ./ (max(Javg, e));
% zero boundary
J(1,:) = 0;
J(end,:) = 0;
J(:,1) = 0;
J(:,end) = 0;

Jori = atan2(Jy, Jx);

end
