function [ filtere_locs ] = sd_nms_features2(locs, overlap_thresh, featsize2radius)
% Non-maxima suppression accross scales.
% TODO Change the name of this function.

if ~exist('featsize2radius', 'var')
    featsize2radius = 2;
end

n_feats = size(locs,1);
f_valid = ones(n_feats,1);

z = zeros(n_feats, 1);

[ignore, order] = sort(locs(:,5), 'descend');

radius = featsize2radius .* locs(:,3);

% circ_overlap = area_intersect_circle_analytical(locs(:,1), locs(:,2), radius);
% overlap = zeros(size(circ_overlap));
% for i = 1:size(overlap,1)
%     for j = 1:size(overlap,2)
%         overlap(i,j) = circ_overlap(i,j) / (pi * radius(i)^2 + pi * radius(j)^2 - circ_overlap(i,j) );
%     end
% end

for i = order'
    if f_valid(i) ~= 0       
        circ_overlap = area_intersect_circle_analytical2(locs(:,1), locs(:,2), radius, i);
        overlap = circ_overlap ./ (pi * radius(i)^2 + pi * radius.^2 - circ_overlap );
        
        suppress = (overlap > overlap_thresh) & (locs(:,5) < locs(i,5));
        
        suppress(i) = 0;
        
        sd_log(3, sprintf('%d/%d points suppressed', ...
            nnz(suppress), length(suppress)));
        
        f_valid(suppress) = 0;
    end
end

sd_log(2, sprintf('%d/%d features survived', sum(f_valid), length(f_valid)));

filtere_locs = locs(f_valid == 1, :);

end

