% channels - which channels in the symmetry score image to use to find
% peaks.
function [ locs ] = sd_locate_features(symscore_pyr, nms_thresh, nms_radius, channels, k_width)

sd_log(3, sprintf('nms thresh = %f', nms_thresh));
sd_log(3, sprintf('nms radius = %f', nms_radius));

if nargin < 4
    channels = 1:size(symscore_pyr.levels{1}, 3);
end

locs = []; % (x, y, scale, orientation) in baselevel scale + (x, y, pyramid level) in pyramid level coords + (detector response)

% For every pyramid level
for i = 1:length(symscore_pyr.levels)
    %sd_log(3, sprintf('Working on level %d (%dx%d)', i, size(symscore_pyr.levels{i}, 1), size(symscore_pyr.levels{i}, 2)));
    
    width = size(symscore_pyr.levels{i}, 2);
    height = size(symscore_pyr.levels{i}, 1);
    
    pnts_scale = 1 / symscore_pyr.level_scale_factor(i);
    
    n_found_pnts = [];
    for j = channels        
        symscore = symscore_pyr.levels{i}(:,:,j);
        
        [y, x, y_f, x_f] = nonmaxsuppts(symscore, nms_radius, nms_thresh);
        
        % Remove detections that are too close to borders
        bad = (y_f <= k_width) | (x_f <= k_width) | (x_f > (width - k_width)) | (y_f > (height - k_width));
        x = x(~bad);
        y = y(~bad);
        y_f = y_f(~bad);
        x_f = x_f(~bad);
        if isempty(x)
            continue
        end
        
        % Get rid of featurea that are too edge like
        edge_like = sd_is_too_edge_like(symscore_pyr.levels{i}(:,:,j));
        edge_like_feats = edge_like(sub2ind(size(symscore), y, x));
        x = x(~edge_like_feats);
        y = y(~edge_like_feats);
        x_f = x_f(~edge_like_feats);
        y_f = y_f(~edge_like_feats);
         
        sd_log(2, sprintf('%d/%d discarded because they were too edge like', nnz(edge_like_feats), length(edge_like_feats)));
        
        % Get the peak intensities
        peaks_score = symscore(sub2ind(size(symscore), y, x));
        
        if 0 % debug
            debug = mat2gray(symscore_pyr.levels{i});
            %debug(debug == max(debug(:))) = 0;
            imshow(debug)
            hold on
            plot(x_f, y_f,'+')
            plot(x, y,'ro')
                        
            pause
        end
           
        
        if size(x,1) == 0; continue; end;
        
        locs = cat(1, locs, cat(2, ...
            (x_f - 0.5) * pnts_scale + 0.5, (y_f - 0.5) * pnts_scale + 0.5, ...
            zeros(size(x)) + pnts_scale * 0.25 * k_width, zeros(size(x)), peaks_score(:)));%, ...
            %x, y, zeros(size(x)) + i, peaks_score(:))); % location, scale, orientaion
        
        n_found_pnts(end + 1) = size(x, 1);
    end
    sd_log(3, sprintf('%d points on level %d', sum(n_found_pnts), i));
end

end
