% SD_LAPLACIAN_OF_GAUSSIAN - Returns a convolution mask of size w x w. If d = 0, then returns
% a Laplacian of Gaussians in both axis (a blob detector).  If d == 1 or 2
% then return a mask that is a laplacian of gaussians in one axis (d == 1
% for x and d == 2 for y) and a gaussian on the other.
function [ log_filter ] = sd_laplacian_of_gaussian(w, d)

sigma = 0.5;
sigma2 = sigma^2;

[x, y] = meshgrid(linspace(-2,2,w),linspace(-2,2,w));
  
if d == 0
    log_filter = exp(-(x.^2 + y.^2)/(2.0 * sigma2)) .* (-2 * sigma2 + x.^2 + y.^2) / (2 * pi * sigma^6);  
else
    log_filter = exp(-(x.^2 + y.^2)/(2.0 * sigma2)) .* (-2 * sigma2 + x.^2) / (2 * pi * sigma^6);  
    if d == 2
        log_filter = log_filter';
    end
end

log_filter = log_filter - sum(log_filter(:))/(w^2); % make the filter sum to zero
log_filter = log_filter / sum(max(0,log_filter(:))); % make max response equal to 1

end