function [ edge_like ] = sd_is_too_edge_like(im, curv_thresh)
% Determines whether a feature is too edge like to be stable by computing the
% ratio of principal curvatures at that feature.  Based on Section 4.1 of
% Lowe's paper.

if ~exist('curv_thresh', 'var')
    curv_thresh = 10;
end

dxx = conv2(im, [1 -2 1] , 'same');
dyy = conv2(im, [1 -2 1]', 'same');
dxy = conv2(im, [1 0 -1; 0 0 0; -1 0 1]/4, 'same');

tr = dxx + dyy;
det = dxx .* dyy - dxy .* dxy;

pos_det = det > 0;

curv = (tr.^2 ./ det) < ( curv_thresh + 1.0 )^2 / curv_thresh;

edge_like = ~(curv & pos_det);

edge_like = harris(im, 3.0) < 1e-6;

end