function [ img ] = sd_imread(img_fname, convert_gray)
% Load image
img = imread(img_fname);

if ~exist('convert_gray', 'var')
    convert_gray = true;
end

if ~isa(img, 'double')
    img = im2double(img);
end

if size(img,3) == 2
    img = img(:,:,1);
end

if size(img,3) >= 3
    img = img(:,:,1:3);
end

if convert_gray && size(img, 3) == 3
    img = rgb2gray(img);
end

end