% SD_GRADIENT Compute the gradient of the grayscale image img and return it in
% img_dx and img_dy. Kernels taken from 
%     H Farid and E P Simoncelli, "Optimally Rotation-Equivariant 
%     Directional Derivative Kernels", Int'l Conf Computer Analysis of 
%     Images and Patterns, pp. 207--214, Sep 1997.
function [ imgdx, imgdy ] = sd_gradient( img, win_size )

kern_b_3 = [0.223755, 0.552490, 0.223755];
kern_d_3 = [-0.453014, 0.0, 0.453014];

kern_b_5 = [0.036420, 0.248972, 0.42917, 0.248972, 0.036420];
kern_d_5 = [-0.108415, -0.280353, 0.0, 0.280353, 0.108415];

if(win_size == 3)
    kern_b = kern_b_3;
    kern_d = kern_d_3;
elseif(win_size == 5)
    kern_b = kern_b_5;
    kern_d = kern_d_5;
else
    error('win_size must be either 3 or 5');
end

imgdx = conv2(kern_b, kern_d, img, 'same');
imgdy = conv2(kern_d, kern_b, img, 'same');

end

