function [ m ] = sd_fspecial(type, width)

switch type
    case 'gaussian'
        m = fspecial('gaussian', width, width/6);
    case 'dog'
        m = fspecial('gaussian', width, width/6);
        m2 = fspecial('gaussian', width, 0.5 * width/6);
        
        m = m / max(m(:));
        m2 = m2 / max(m2(:));
        
        m = m - m2;
    case 'disk'
        m = fspecial('disk', (width - 1)/2);
end

m = m / sum(m(:));

end

