function regions_out = sd_filter_regions_scale(regions, max_overlap)

num_regions = size(regions, 1);

x = regions(:,1:2); % extract out positions
scales_x = regions(:,3); % extract out scales
scales_y = regions(:,4);
scores = regions(:,6); % extract out scores

% compute the area of each region
areas = scales_x .* scales_y;

regions_out = [];

for i = 1:num_regions
    % compute overlap with all other features
    area_i = areas(i);
    
    % filter only features with area within min_overlap of 
    % area_cands = find(((area_i ./ areas) >= max_overlap) & ((area_i ./ areas) <= 1 / max_overlap));
    
    % disp = x - repmat(x(i,:), num_features,1);
    x_disp = x(:,1) - repmat(x(i,1), num_regions, 1);
    y_disp = x(:,2) - repmat(x(i,2), num_regions, 1);

    left_edges = x_disp - 0.5 * scales_x;
    right_edges = x_disp + 0.5 * scales_x;
    lower_edges = y_disp - 0.5 * scales_y;
    upper_edges = y_disp + 0.5 * scales_y;
    
    my_left_edge = -0.5 * scales_x(i);
    my_right_edge = 0.5 * scales_x(i);
    my_lower_edge = -0.5 * scales_y(i);
    my_upper_edge = 0.5 * scales_y(i);
    
    left_edges = max(left_edges, my_left_edge);
    right_edges = min(right_edges, my_right_edge);
    lower_edges = max(lower_edges, my_lower_edge);
    upper_edges = min(upper_edges, my_upper_edge);

    valid_ids = find((left_edges < right_edges) & (lower_edges < upper_edges));
    num_valid = size(valid_ids);
    
    area_isect = (right_edges(valid_ids) - left_edges(valid_ids)) .* (upper_edges(valid_ids) - lower_edges(valid_ids));
    area_union = areas(valid_ids) + repmat(area_i, num_valid, 1) - 2 * area_isect;
    
    overlap_ratio = area_isect ./ area_union;
    
    % filter by (normalized) distance
    area_cands = (overlap_ratio >= max_overlap);
    
    % check if the feature has the highest score among the candidates
    if scores(i) >= max(scores(valid_ids(area_cands)))
        regions_out = [ regions_out; regions(i,:) ];
    end
end
