function features_out = sd_filter_features_scale2(features, max_overlap)

num_features = size(features, 1);

x = features(:,1:2); % extract out positions
scales = features(:,3); % extract out scales
scores = features(:,5); % extract out scores

% compute the area of each region
areas = 4.0 * scales .* scales;

features_out = [];

for i = 1:num_features
    % compute overlap with all other features
    area_i = areas(i);
    
    % filter only features with area within min_overlap of 
    % area_cands = find(((area_i ./ areas) >= max_overlap) & ((area_i ./ areas) <= 1 / max_overlap));
    
    % disp = x - repmat(x(i,:), num_features,1);
    x_disp = x(:,1) - repmat(x(i,1), num_features, 1);
    y_disp = x(:,2) - repmat(x(i,2), num_features, 1);

    left_edges = x_disp - scales; % 0.5
    right_edges = x_disp + scales;
    lower_edges = y_disp - scales;
    upper_edges = y_disp + scales;
    
    my_left_edge = -scales(i); % 0.5
    my_right_edge = scales(i);
    my_lower_edge = -scales(i);
    my_upper_edge = scales(i);
    
    left_edges = max(left_edges, my_left_edge);
    right_edges = min(right_edges, my_right_edge);
    lower_edges = max(lower_edges, my_lower_edge);
    upper_edges = min(upper_edges, my_upper_edge);

    valid_ids = find((left_edges < right_edges) & (lower_edges < upper_edges));
    num_valid = size(valid_ids);
    
    area_isect = (right_edges(valid_ids) - left_edges(valid_ids)) .* (upper_edges(valid_ids) - lower_edges(valid_ids));
    area_union = areas(valid_ids) + repmat(area_i, num_valid, 1) - 2 * area_isect;
    
    overlap_ratio = area_isect ./ area_union;
    
    % filter by (normalized) distance
    area_cands = find(overlap_ratio >= max_overlap);
    
    % check if the feature has the highest score among the candidates
    if isempty(valid_ids(area_cands)) | scores(i) >= max(scores(valid_ids(area_cands)))
        features_out = [ features_out; features(i,:) ];
    end
end
