function [ descrips, filtered_locs ] = sd_extract_descriptors2(symscore_pyr, ...
    locs, k_width, desc_support, ...
    r0, n_rad_buckets, n_ang_buckets, use_log_mapping)
% Change with respect to sd_extract_descriptors2: now locs follows the 
% format that is saved in the .ks file (colums are x, y, scale, orientation,
% and detector score), this enables the function to use detections from 
% other detectors.

err_thresh = 4;

%error 'TODO: remove repeated detections'

descrips = [];
filtered_locs = [];

% Figure out to which pyramid level the detections belong
supp_size = locs(:,3) * 4; % The descriptor support size at scale 1
pnt_level = zeros(size(locs,1),1);
pnt_level_err = zeros(size(locs,1),1);
for i = 1:size(locs,1)
    level_size = supp_size(i) * symscore_pyr.level_scale_factor;
    d = abs(k_width - level_size);
    [level_err level] = min(d); 
    pnt_level_err(i) = level_err;
    pnt_level(i) = level;
end

% For every pyramid level
half_support = (desc_support + 1) / 2;
for i = 1:length(symscore_pyr.levels)
    
    pnts = locs(pnt_level == i, 1:2) * symscore_pyr.level_scale_factor(i);
    pnts_level_err = pnt_level_err(pnt_level == i);
    fprintf('>> %d features on level %d\n', size(pnts,1), i);

    if isempty(pnts); continue; end

    % Get rid of the points that are too close to the border
    invalid_pnts = (pnts(:,1) < half_support) | (pnts(:,2) < half_support) | ...
        (pnts(:,1) > size(symscore_pyr.levels{i}, 2) - half_support) | ...   
        (pnts(:,2) > size(symscore_pyr.levels{i}, 1) - half_support) | ...
        (pnts_level_err > err_thresh);
    sd_log(3, sprintf('%d points were discarded', sum(invalid_pnts(:))));
    
    pnts = pnts(~invalid_pnts, :);
    if isempty(pnts); continue; end
    
    aux_locs = locs(pnt_level == i, :);
    filtered_locs = cat(1, filtered_locs, aux_locs(~invalid_pnts,:));    
    assert(  norm(reshape(pnts - aux_locs(~invalid_pnts,1:2) * symscore_pyr.level_scale_factor(i),1,[])) < 0.0001);
    
    % For every detected point
    for p = 1:size(pnts, 1)
        pnt = pnts(p, 1:2);
        
        % For every symmetry type
        fvec = [];
        for s = 1:size(symscore_pyr.levels{i}, 3)                      
            fvec = [fvec sd_logpolar_mapping(symscore_pyr.levels{i}(:,:,s), pnt, ...
                desc_support, r0, n_rad_buckets, n_ang_buckets, use_log_mapping)'];
        end
        
        descrips(end + 1, :) = fvec / (0.000001 + max(fvec(:)));
    end
end

end