function [ defaults ] = sd_defaults(varargin)
% Default used in sd_symdesc and sd_symdet

defaults.magnif = 1;             % Image pre-magnification
defaults.min_img_size = 64;
defaults.max_img_size = 2000;
defaults.n_iters = 100;
defaults.level_scale_factor = 0.95;
defaults.k_width = 15;%25;
defaults.geom_blur = 0;
defaults.uniform_blur = 0;        % How much we want to blur each level of the pyarmid using a standard gaussian blur, number is size of kernel
defaults.symscore_width = 7;      % Width of LoG kernel
defaults.alpha = 1;
defaults.nms_radius = 1;          % Radius of suppression region within pyramid level, make larger to remove more points
defaults.nms_thresh = 0.03;       % Threshold on the response intensity, make larger to remove more points
defaults.nms_feats_on = true;     % Enable non-maxima suppression across scales
defaults.overlap_thresh = 0.31; %0.21;   % Relative overlap threshold, make lower to suppress more points. Range is 0 to 1
defaults.baseline_descriptor = 0; % [DEAD] Enable computation of baseline descriptor
defaults.channels = 1;
defaults.randomize_seed = 0;      % [DEAD] if true, then generate different random numbers for each invocation
defaults.input_keypoints = '';
defaults.log_w = 7;               % Width of LoG filter used to detect blobs in symdist image
defaults.log_std = defaults.log_w / 10;    % Variance of the LoG filter
defaults.uncertainty_radius = (defaults.log_std * sqrt(2));

% symdesc
defaults.dist_func = 3;           % Which function to use when computing symmetry distance, 3 is the C version. 1 and 2 use random kernels and are very slow.

% logpolar descriptor defaults %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
defaults.n_ang_buckets = 20; 
defaults.n_rad_buckets = 4;
defaults.r0 = 2;                  % Radius of central bin, ignored for self similarity descriptor
defaults.desc_support = (defaults.k_width - 1) * 4 + 1;
defaults.use_log_mapping = 1;

% hols descriptor defaults %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
defaults.n_spatial_bins = 4;

% Compute bilateral symmetries for how many orientations. If equal to 2
% then computes only horizontal and vertical, 4 makes it compute the main
% diagonals too.
defaults.n_orientations = 8;

% User supplied values %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

print_values = 1;

for k = 1:2:length(varargin)
    switch(lower(varargin{k}))
        case 'print_values'
            print_values = varargin{k + 1};
        case 'min_img_size'
            defaults.min_img_size = varargin{k + 1};
        case 'max_img_size'
            defaults.max_img_size = varargin{k + 1};
        case 'n_iters'
            defaults.n_iters = varargin{k + 1};
        case 'level_scale_factor'
            defaults.level_scale_factor = varargin{k + 1};
        case 'k_width'
            defaults.k_width = varargin{k + 1};
        case 'geom_blur'
            defaults.geom_blur = varargin{k + 1};
        case 'uniform_blur'
            defaults.uniform_blur = varargin{k + 1};
        case 'n_ang_buckets'
            defaults.n_ang_buckets = varargin{k + 1};
        case 'n_rad_buckets'
            defaults.n_rad_buckets = varargin{k + 1};
        case 'r0'
            defaults.r0 = varargin{k + 1};
        case 'desc_support'
            defaults.desc_support = varargin{k + 1};
        case 'use_log_mapping'
            defaults.use_log_mapping = varargin{k + 1};
        case 'dist_func'
            defaults.dist_func = varargin{k + 1};
        case 'alpha'
            defaults.alpha = varargin{k + 1};
        case 'nms_radius'
            defaults.nms_radius = varargin{k + 1};
        case 'nms_thresh'
            defaults.nms_thresh = varargin{k + 1};
        case 'baseline_descriptor'
            defaults.baseline_descriptor = varargin{k + 1};
        case 'overlap_thresh'
            defaults.overlap_thresh = varargin{k + 1};
        case 'nms_feats_on'
            defaults.nms_feats_on = varargin{k + 1};
        case 'randomize_seed'
            defaults.randomize_seed = varargin{k + 1};
        case 'input_keypoints'
            defaults.input_keypoints = varargin{k + 1};
        case 'n_spatial_bins'
            defaults.n_spatial_bins = varargin{k + 1};
        case 'n_orientations'
            defaults.n_orientations = varargin{k + 1};
            
        case 'channels'            
            defaults.channels = [];
            if sum(varargin{k + 1} == 'r') ~= 0
                defaults.channels = [defaults.channels 1];
            end
            if sum(varargin{k + 1} == 'h') ~= 0
                defaults.channels = [defaults.channels 2];
            end
            if sum(varargin{k + 1} == 'v') ~= 0
                defaults.channels = [defaults.channels 3];
            end
        otherwise
            error('Unrecognized option: %s', lower(varargin{k}));
    end
end


if print_values
    % Print values
    sd_log(1, sprintf('defaults.min_img_size = %d', defaults.min_img_size));
    sd_log(1, sprintf('defaults.max_img_size = %d', defaults.max_img_size));
    sd_log(1, sprintf('defaults.n_iters = %d', defaults.n_iters));
    sd_log(1, sprintf('defaults.level_scale_factor = %f', defaults.level_scale_factor));
    sd_log(1, sprintf('defaults.k_width = %d', defaults.k_width));
    sd_log(1, sprintf('defaults.geom_blur = %d', defaults.geom_blur));
    sd_log(1, sprintf('defaults.uniform_blur = %d', defaults.uniform_blur));
    sd_log(1, sprintf('defaults.dist_func = %d', defaults.dist_func));
    sd_log(1, sprintf('defaults.symscore_width = %d', defaults.symscore_width));
    sd_log(1, sprintf('defaults.alpha = %f', defaults.alpha));
    sd_log(1, sprintf('defaults.nms_radius = %d', defaults.nms_radius));
    sd_log(1, sprintf('defaults.nms_thresh = %d', defaults.nms_thresh));
    sd_log(1, sprintf('defaults.nms_feats_on = %d', defaults.nms_feats_on));
    sd_log(1, sprintf('defaults.overlap_thresh = %d', defaults.overlap_thresh));
    sd_log(1, sprintf('defaults.baseline_descriptor = %d', defaults.baseline_descriptor));
    sd_log(1, sprintf('defaults.randomize_seed = %d', defaults.randomize_seed));
    if ~isempty(defaults.input_keypoints)
        sd_log(1, sprintf('defaults.input_keypoints = %s', defaults.input_keypoints));
    end
    
    if defaults.randomize_seed
        RandStream.setDefaultStream(RandStream('mt19937ar','seed',sum(100*clock)));
    else
        RandStream.setDefaultStream(RandStream('mt19937ar','seed',0));
    end
    
    defaults.channels_str = '';
    defaults.channels_conv = 'rhv';
    for i = 1:length(defaults.channels)
        defaults.channels_str = [defaults.channels_str defaults.channels_conv(defaults.channels(i))];
    end
    sd_log(1, sprintf('defaults.channels = %s', defaults.channels_str));
    
    sd_log(1, sprintf('defaults.n_ang_buckets = %d', defaults.n_ang_buckets));
    sd_log(1, sprintf('defaults.n_rad_buckets = %d', defaults.n_rad_buckets));
    sd_log(1, sprintf('defaults.r0 = %d', defaults.r0));
    sd_log(1, sprintf('defaults.desc_support = %d', defaults.desc_support));
    sd_log(1, sprintf('defaults.use_log_mapping = %d', defaults.use_log_mapping));
    sd_log(1, sprintf('defaults.n_spatial_bins = %d', defaults.n_spatial_bins));
    sd_log(1, sprintf('defaults.n_orientations = %d', defaults.n_orientations));
end

end