function [region_locs, region_scores] = sd_compute_symmetry_regions_dog(scores, base_sym_scale, pnts_scale, feat_scale, num_scales, nms_thresh)

scale_factor = 2.0^(1/8);

[height, width] = size(scores);
region_scores = zeros(height, width, num_scales);

% compute the DoG filters
dog_x_scale = 1.2;

for i = 1:num_scales
  scale = base_sym_scale * 0.5 * scale_factor^(i-1);
  [dog, dog_x, dog_y] = sd_oriented_dog(1.2, scale);

  % do the DoG in the x direction
  scores_x = conv2(scores, dog_x, 'same');
  % threshold at 0
  scores_x_thresh = max(scores_x, 0.0);
  
  % do the DoG in the y direction
  scores_y = conv2(scores_x_thresh, dog_y, 'same');  

  % threshold at 0 again and save
  region_scores(:,:,i) = max(scores_y, 0.0);

  % set boundary to zero
  % bdry_width = min(2 * rad, min(floor(width/2),floor(height/2)));
  % region_scores(:,:,i) = sd_set_zero_boundary(region_scores(:,:,i), bdry_width);
end

% find local maxima in xy-scale space
region_locs = [];
for i = 2:num_scales-1
  scale = base_sym_scale * 0.5 * scale_factor^(i-1);
  feature_locs_level = ...
        sd_symg_locate_features_scale(region_scores(:,:,i-1), ...
                                      region_scores(:,:,i), ...
                                      region_scores(:,:,i+1), ...
                                      pnts_scale, pnts_scale * scale, ...
                                      1, nms_thresh);

  % add in the x-scale
  num_features = size(feature_locs_level, 1);
  if num_features > 0
    region_locs_level = [ feature_locs_level(:,1:2) repmat(feat_scale, [ num_features 1 ]), feature_locs_level(:,3:5) ];
    region_locs = [ region_locs ; region_locs_level ];
  end
end

num_regions = size(region_locs, 1);
fprintf('computed %d regions\n', num_regions);
