package jif.util;

/**
 * An implementation of List, using a linked list to store the
 * list elements.
 */
public class LinkedList extends AbstractList {
    private LinkedListEntry head;
    private LinkedListEntry tail;
    
    public LinkedList jif$util$LinkedList$() {
        this.jif$init();
        {
            {
                this.head = null;
                this.tail = null;
            }
            this.jif$util$AbstractList$();
        }
        return this;
    }
    
    public int size() {
        int s = 0;
        LinkedListEntry e = this.head;
        while (e != null) {
            e = e.next;
            s++;
        }
        return s;
    }
    
    public boolean add(final jif.lang.JifObject o) {
        LinkedListEntry n =
          new LinkedListEntry(this.jif$jif_util_LinkedList_L).
          jif$util$LinkedListEntry$();
        LinkedListEntry m = this.tail;
        n.data = o;
        if (m == null) {
            this.head = (this.tail = n);
            return true;
        }
        m.next = n;
        n.prev = m;
        this.tail = n;
        return true;
    }
    
    public boolean remove(final jif.lang.JifObject o) {
        LinkedListEntry e = this.head;
        while (e != null) {
            if (e.data == o || o != null && o.equals(e.data)) {
                LinkedListEntry f = e.prev;
                if (f != null) { f.next = e.next; }
                f = e.next;
                if (f != null) { f.prev = e.prev; }
                if (this.tail == e) { this.tail = e.prev; }
                if (this.head == e) { this.head = e.next; }
                return true;
            }
            e = e.next;
        }
        return false;
    }
    
    public jif.lang.JifObject remove(final int index)
          throws IndexOutOfBoundsException {
        int s = 0;
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException();
        }
        LinkedListEntry e = this.head;
        while (e != null && s != index) {
            e = e.next;
            s++;
        }
        if (e != null) {
            LinkedListEntry f = e.prev;
            if (f != null) { f.next = e.next; }
            f = e.next;
            if (f != null) { f.prev = e.prev; }
            if (this.tail == e) { this.tail = e.prev; }
            if (this.head == e) { this.head = e.next; }
            return e.data;
        }
        return null;
    }
    
    public int hashCode() {
        int hashCode = 1;
        LinkedListEntry e = this.head;
        while (e != null) {
            jif.lang.JifObject mobj = e.data;
            hashCode = 31 * hashCode + (mobj == null ? 0 : mobj.hashCode());
            e = e.next;
        }
        return hashCode;
    }
    
    public jif.lang.JifObject get(final int index)
          throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int s = 0;
        LinkedListEntry e = this.head;
        while (e != null) {
            if (s == index) { return e.data; }
            e = e.next;
            s++;
        }
        return null;
    }
    
    public jif.lang.JifObject getFirst() throws IndexOutOfBoundsException {
        LinkedListEntry m = this.head;
        if (m != null) { return m.data; }
        throw new IndexOutOfBoundsException();
    }
    
    public jif.lang.JifObject getLast() throws IndexOutOfBoundsException {
        LinkedListEntry m = this.tail;
        if (m != null) { return m.data; }
        throw new IndexOutOfBoundsException();
    }
    
    public jif.lang.JifObject set(final int index,
                                  final jif.lang.JifObject element)
          throws IndexOutOfBoundsException {
        int s = 0;
        LinkedListEntry e = this.head;
        while (e != null) {
            if (s == index) {
                jif.lang.JifObject old = e.data;
                e.data = element;
                return old;
            }
            e = e.next;
            s++;
        }
        throw new IndexOutOfBoundsException();
    }
    
    public void add(final int index, final jif.lang.JifObject element)
          throws IndexOutOfBoundsException {
        LinkedListEntry n =
          new LinkedListEntry(this.jif$jif_util_LinkedList_L).
          jif$util$LinkedListEntry$();
        n.data = element;
        if (index == 0) {
            this.head = n;
            if (this.tail == null) { this.tail = n; }
            return;
        }
        int s = 0;
        LinkedListEntry e = this.head;
        while (e != null) {
            if (s == index) {
                n.next = e;
                n.prev = e.prev;
                e.prev = n;
                LinkedListEntry p = n.prev;
                if (p != null) { p.next = e; }
                if (n.next == null) { this.tail = n; }
                if (n.prev == null) { this.head = n; }
                return;
            }
            if (s == index - 1 && e.next == null) {
                n.next = null;
                n.prev = e;
                e.next = n;
                this.tail = n;
                return;
            }
            e = e.next;
            s++;
        }
        throw new IndexOutOfBoundsException();
    }
    
    public int indexOf(final jif.lang.JifObject o) {
        int s = 0;
        LinkedListEntry e = this.head;
        while (e != null) {
            if (o == e.data || o != null && o.equals(e.data)) { return s; }
            e = e.next;
            s++;
        }
        return -1;
    }
    
    public int lastIndexOf(final jif.lang.JifObject o) {
        int s = 0;
        int last = -1;
        LinkedListEntry e = this.head;
        while (e != null) {
            if (o == e.data || o != null && o.equals(e.data)) { last = s; }
            e = e.next;
            s++;
        }
        return last;
    }
    
    public static final String jlc$CompilerVersion$jif = "3.5.0";
    public static final long jlc$SourceLastModified$jif = 1466731418000L;
    public static final String jlc$ClassType$jif =
      ("H4sIAAAAAAAAAK09C3gU1bmzuyEhBAhB3s8lBBCERCiPDwPySIiELiQSQAU1" +
       "TnYnZGF3Z7M7CQFLpdqKlYq3qfioylUL3mpR2qq3L6GKVqC2WisVxYsit1W8" +
       "iorXB96K9vz/+ed1ZvaR7OX7cv7JmfOf85//fR4Z9pyWeiQT0sh14eZybWNc" +
       "SZYvCTfXy4mkEqpXIxtXsKrG4Bf3/yl05xXxN71S/mqpZzi5MpaUm5WAVCi3" +
       "aS1qIqxt1KR+gXVyu1zRpoUjFYFwUqsMSEVBNZbUEnI4piVbpW9LnoDUL8xq" +
       "5JgWljUlVJNQo5o0JhBnA62NqFqF0qFVxOWEHK1AUirqqyJyMsl6ysdavZOe" +
       "8YTaHg4pCU0aHWCEU+uI3KREKurpXQB+q+xISH69e5ofnxz2zGe344KK2+64" +
       "ut8vfVLxaqk4HGvQZC0crFJjGqNntdQ7qkSblERyQSikhFZLJTFFCTUoibAc" +
       "CW9iDdXYaql/Mrw2JmttCSW5XEmqkXZo2D/ZFmckwph6ZUDqzVnSFtTUhD6d" +
       "/OawEgnpv/Vojshrk5o0yGQLn14N1DNe9GLsVBLNclDRUfLWh2Mh4IWAYcyx" +
       "7JusAUMtiCpMXsZQeTGZVUj9ueQicmxtRYOWCMfWsqY91DYNGDwsZaeVIAg5" +
       "uF5eqzRq0hCxXT1/xVoVIiMARZMGis2wJyalYYKULPI5vWzO9mtji2NepDmk" +
       "BCNAf0+GNEpAWq40KwklFlQ4Yu9JgdvlQftu8koSazxQaMzb/OpbZ+ZPHvXU" +
       "Id5muEubuqZ1SlBrDO5q6vvSiKqJs31cBdVkGIRvmzkqfz29qeyIM8MaZPQI" +
       "L8v1l08tf+6KLQ8r73mlXrVSflCNtEWZHpUE1Wg8HFESlygxJQEmUisVKrFQ" +
       "Fb6vlQrYcyAcU3htXXNzUtFqpbwIVuWr+DtjUTPrAlhUwJ7DsWZVf47LWgs+" +
       "d8QlSSpgP9JgeriBIFO8yooWNapUrFNCFRvUxPoKMLAQM2h8iISbpiQTQXwm" +
       "U4+tZ4rN3pezunhu6B1AXb8NHg9j3AjRbCNM4xerEWbajcHb2hYuOvNo4/Ne" +
       "Q41pXpp0Hngy5LXZt+TxYJ8DQNHFl70nNly15JqbSn1MA+Ib8hgToGmpzSFW" +
       "mVZbiw4syFTn5Xnxa7bPGD7HK/VYzRxbslppltsiWn3VQrUtxhzAAKNqucJ8" +
       "Qww9kqtXLIgHEUeTBjv8GfdjDC1hdgJow5m6lolG40Zm8dZTn+29fbNqmo8m" +
       "lTms2okJVlkqCiGhBpUQ83Nm95P88hON+zaXeaU8ZupsbhqbGXiOUeIYNuus" +
       "1D0dzKUHm16zmojKEXilc6WX1pJQN5g1qB198bmESalI19/eTGLFBH3w9rw4" +
       "lAO4NoHYhVmgJ53bEL/31Rfe/YZX8ppOt9gSxBoUrdJi6NBZMZp0ialFKxKK" +
       "wtodv7P+RztOb12DKsRajHUbsAzKKmbgLJQxNn/vUOtrb76x64jXVDuNxbm2" +
       "pkg42GFMEuqlXjQ5L4fSl5ZJstHGm/QwRxFhzoqRmyxbGYuqoXBzWG6KKKDn" +
       "XxaPm/rE+9v7cT2IsBrO1YQ0OXMHZv3QhdKW56/+fBR24wlCoDJ5Zjbj3u88" +
       "s+cFiYS8Eejo+M5fR951UL6X+VHmu5LhTQq6Iwl5IKHQLsT5X4BlhfBuGhR+" +
       "Zs7iSzbccNNo0XhYrA/zRKAxOOjj0op4TfUJlHcvpqfNLL8JB1nmMsJhc1XG" +
       "WzA8iLdr9cYjHY1rzddgMoNFGmj8vKv8oY/9pWvQTopCSjKYCMd1xWLeuVcy" +
       "HI1HGLuVEJo3yws0dQljn5HkJORYMsKCAncJK/Dloo54AkJsu5xAOSFXxnaA" +
       "khpk1EPu1BictW1rQh1780wvMbIvFGM6WOYW4l7KHw/6I7p7uQjUGPvQhzWZ" +
       "aQ7dGLx34B1P9v9Z5wIeP0fbMRyt51xYdWPj9F/8GZUeFGSUyK3lisw8PGdn" +
       "Y/DjnceU5TO++IAbqbohJuZ8cZauBMNxGfI+eoJ0MYG9wDzmM6qGONSCup95" +
       "y317T79RPx912SIACOqOvJIkbGEdlFX2WGHQU75CjRskNQavHvSXC0Y8ecX3" +
       "rWwSECyttz90T8GHk7+4D6dtqMFYQQ0MhLSqAOVsTi/6CpuArERa5TR44PEj" +
       "h9oXf8DJFfXADWPetAH7Tw0Zei1JFgasplEBLHYV9mVs6WAK218eOPD7guV/" +
       "tAgbJchYsAEbcnlCucAUwDLW8Tg3fi5UNU2NWrg6d+yxdZXnXnpcN4BFBlcm" +
       "2icoYFqnmT/pd0O3v76lTu+jlk+1zjLVS3nVdO7Dv2b/POznK/gBPwUVAFne" +
       "XUXZnt9I9+JxZo89rXa4EruZkwTHIiQvi+VkCws+r0aOrt5xfNIoLitLcKL3" +
       "v63+3o7bf/2r6Ty/gfjRb958SeI+EzqfB8UqnM5V5mxW2WbjUrXURGsy5b3K" +
       "kLezisMh6K+9kOLZcqwaWAWZeUVw09y3O79qZXmFb7XUt0VO1sZYHIZFF1vb" +
       "gVM2ftOkEou1oreD7CJizZTElYIw2OqKPfcMq7r4PXQEZhID2KM7nLnoKtmS" +
       "X017OPqptzT/D16pgKWBmNyxBe4qOdIGqcFqtl5LVlFlQOpje29fe/GFRqWR" +
       "pI0QEyjLsGL6ZObA7Blaw3MvIWMC2UsT2E8h+3mB4GPWjMkj4UMMUUqxHAfF" +
       "+XqCUsDsi/kiRchQiqizXxL8maVTTcprYe44aQuNGBmUEF+D7f7pnkcrez+0" +
       "Gw2/EOXGpKhRGOwJGPrvfEp97FMaQ6MecpuSXc/0tIDpCMXlXp/KVU/esWAZ" +
       "ir4P7jPoTNakoaJimckx9D7LoGM00OGn8Q8SfM5Khybxwf04hMLcmT/gV5v9" +
       "QVjo+l0WLYC2KemIqUiG1SW9Gji3c+4r+58wYupQIfSbqjrz8MO+F1ddeS9n" +
       "tCVXt4Y7WO5Y1vi0uTAqFSf43gKyY73BjiES8QTWlNsIftfKDolr2vXumoZp" +
       "/ESWDydxL0Zjyh6OyREcZRVbzgWSTpNm/jrKfEI7Lf6Vm267+evy7bd5LTsk" +
       "Yx2bFFYcy0z6kN9KSGPSjYIYNe/s3fy7n27eyv1vf/t6f1GsLfrIK+f+VH7n" +
       "icMui1XTSfWz66mTxaX/XbC19tSS3egP+4FPwUDPnAp0gVW1MXtVUThpBDGc" +
       "1i1Q3Cp5JMeOX0NbU1Kz7Llcfv6qp787NLmNT2qiMSmlQytHBSZUEe+1V33T" +
       "irSyW1HD8prkJM61J/NWSWipSf7Uu33YF+d/kaFJ+G8g8z2gVR8SPCau8nZg" +
       "+4EaT/UEQ1oU0xIbcfXvmHFjsGT23U3N188/iMIpRiKRew2c3PF2wyCksgZ7" +
       "O/s2oyuPGoOn9t5yaMz/rDoP9490dlgXnEvleKW4wIQYzup7FBx7+plB17zk" +
       "k7w1Uq+IKodqZFyrS4VskawkW9RIqCNOYd2zoScEWNzIALZcZzBzELweSUz8" +
       "nOBHLmZ5XzqzhOJGKLaa9ggP26C4A4ofIqIZI0bQuOgVnyX4TM7ecTcOsJk7" +
       "kg6w1jI3EYvSmloZXHZAnT0RRZ6vtYSTZRfiMtZF0kwg0Pu9aKKcN5tw1BZn" +
       "VIVl+mcEX3eJqns4U6FodYZPwDpG8GV7+GReOoIIbc64B80/chtUEIERoKDh" +
       "hwQ/yFkEj1lFgJZo4dRjHeaMx9stOp9iQoJgxEKJJUvEVf3IVFvD6Bd3XX/b" +
       "zlDd7ql6Rn6LxmxCjU+JKO1KxNJVb4fPW4qb4WZ0nHV/ddmIA63b///28yiD" +
       "cdu6Gy1MSiTmoaV7Dl8yPtjJ3L2REDo2+O1IlfY0sBcfdYUtGRxl3z4Dh9Cf" +
       "+YF1BBtFx9rPTYLGphSgXE3wclGC7ts3z6V5dwiKpzW+KSQoPJJbQmMpbuQK" +
       "Cg87gkwRecMQwaA4P6T6T1YlxufvU/wH8ANN8jHZuu04QcV0KA5gZ5VQvEwL" +
       "NihXp1xucYRXzEXSAee6yV611ER73VySHXCu0owqKPnycb+djUO5N/ZOJTi2" +
       "a1IHlFKCI1JL3UN76XY5QhSQJhN2NcEZNjkmpGFiwr4gsZbS9Z/2+cPzp4fU" +
       "HMJtNG8wDDtyjr3skJLKJtricSVhtU1vexieokI+P9GNzAV2d1kL40bVRLwl" +
       "TAt2cJd8H9svJ9a2RZWY5lehkp+7+eVQyH9+E4yusF+a1HbF37TRH5gYN/Yw" +
       "jDS/So7FVM2xgZYfDD9xuqL5nO7t5nLB74fiLS47KE6mkwUU73AlOQXFe4j3" +
       "Ps7rg67151war4ytj6kbYjwbbCja03bDvimv6tRSWo3Pn6VxBP8HxQlmd4xh" +
       "8HhWkty2ex37STQ4qcqAivfvrTt78uf66LP4pGh36jQH54RKlsyogieZBONd" +
       "QDpQRXChXRe6Hjo9PpvXEXdDAmpQjpjhYMUPDh6dedepTsxZ0m9tCJiRXZGD" +
       "gU82vqBzYb3dFMtpPjVupsgTF09hiu0AeDRzQNWqXeYEO43x8MBxGHciHpng" +
       "Mk26KNsTQ9wlYbzhGyV03pgDNlJZrC8d+gP/oVG50Qhf3YXlzozJ9XDdZcC0" +
       "kgSbYIgS5GJ/Sq49g7ubXHvOQ5x/Y8uGoL76447HQwZiKu1MoGYWcf0nBB/I" +
       "WWlHCSk3wIfgxUCHP4FajCwfuMZCqPsQ2vRBXUE9Q3ngmzOpvYNnPHoHKP7p" +
       "liQMJE2e4hbdBC6dBwgDqKHu7i/ImUsTMyUUBU2qGlHkmJQiqTApBHtB1QLK" +
       "vkFwWs4UThXz9pWa5FUnuIniH2lEMUsUBVSej69Akz1TXCaIw+OQbrnJCO6T" +
       "fI8QvMc6VSjT5yaAcjfBHRbUrHITP/RSQdhPEfyFQ31OGQiT3RD22YUT6HKW" +
       "kFCikBm4JwqtZuiCIO2pNIK0Z06GoO9ZYAZ9TxXKoRod0qIu9Qe/nkXspWk0" +
       "A1JRz0UaHMXBbFpTRfFWisFsYGdgtla6BOYpegADtv+e4P6cbeMy0Xo9BXYV" +
       "mUpDHXBTEYqZa7oYM5lwcOxWIyRZxQSFjKJK5Us9NVA0Gn2sMQzYsziNmEIo" +
       "JijqU/lSmOGDbtaYypdCw90Ed+UsjbWCp3L1KQIpmNmMIhL2Enw0Z1IiqZ2m" +
       "yPN5aXieEHkOjzwZWZvOaVrOAwWnCRtBtZKUv4fg7V1zmoCyg+CtXXWa46CX" +
       "Cwj7Pwn+PI3TPN8N4TG7cOqzcpph5h47uus4201HtyGT4/yWxXF+G2VxHRr5" +
       "li71ZzrOmzI1uBmKti54z3Y379lu9Z49kFuCoeAydxLJ4AmCj+dsKJ1pPOg4" +
       "3YPCUE+66Qt50Nuz8aCWWZGkcHz4/UWHzKC4B+WW0ot+B4of63140JBexDc3" +
       "ZGUNldDTZTSrkwRt54CCBFYCwipq+BbBEzlL4AFHBspWOGPxXAGXOLXAtro2" +
       "ra4ZN0OSizqCCt5Gwrn+O6ofFNvcosIwInO3m7sR5ocngUOp4S6CP8l5fg+L" +
       "UaE4c1SAPStpLJHwKMFHciZlr0jKA8xuUS0nuOnRpkzO5n5sBks1z4P4+IQo" +
       "DXh8CF89nGrqSJipCPudAowy319MULIyoTVjvGAohV8T/MKCmibm7U/z7iko" +
       "fqNJPVvkZAts3rnpXAmRmu9GsiBoY+sXGvYgmJezoJ8Vw/+L6faEPb819oQ9" +
       "h7E2w54wR/DwzehqXoHPlj1hoWqpifYSVtRZ2lj2hM0qKF1TiDKghT3XEJzS" +
       "NZUAlMkEx6dWiTQpxPmEvYTgJQ4Boys/zmS3olvZwVpFc0kNrj15866TN3Zu" +
       "xuXqGzxappYTRvqjZqR/NZMxH7eRDuWbGNxOxLvSH/zKE4N3MzV4D4pXNMnH" +
       "pou1adOGo25pw9EUacN0u8DKSVD1bgLTpBL9VikTiL+Jdtw9/5uVJXyCUzlr" +
       "qv0nTkv4xGkJHO2cqfafOC3BVuUp4FU84/B6s8840PwdooVO8lG8KROMk9Cm" +
       "B7ICh2w1AsPfs7KVhdBTiFh+I8GQzVZc7kEvUcP6rnhJzzdPnE6UztTvQUfj" +
       "akyho8uxrCaGZhTeRNeQhXORNW7Db7YOj1eQhBujxvDWo4zXXzr64AM3FzVb" +
       "jjLgFCTjVfQGRdsysvOlW+/eslJHnezCbq8QFK6EyquI4usIftuus10PCt4B" +
       "jkTLxdahfMeiOiR7vFvAg7wXN9xegeJ9t/DnJ4IXurlnaOrtbSAMdkOYLcgI" +
       "UIo5KMmCe0YaB31VErwoZ+6NyZl7xZ4U/m266Voruf3PiZsehvk405UcdXqX" +
       "o07vgn15K0xXctTpXWxVFpFcCHTNJratIbg8N5HAGkqaRn2tINiQs0hm5yQS" +
       "W+orerjXM0RLbxGpMhR9Ub7eKs6WlAHDnVWmZYrueXFrevfsMgGUe5VpqgtE" +
       "U4XK4RbSR3LSA90mfYwr6Zd2k/RA1nYCrfUL56mo1u0H2l7ePRsyb5lnYUNQ" +
       "zOAMbeo2Q2e7MnRtNxnKr7sLCTQsLLdJUp9JBPtbLRHK9Ak0oJQQLLKgCiZj" +
       "WTd51awSBvAQ0jLqeSVBWzQQ/EoAEJZSwxUEc/crmtWvmMbUCsU6tvhj+WpN" +
       "OJHU3KLfMKJijBtvU0UqaOgnODpn8q8VyU9rUN71pkFtycagOIL3BsN6WIVo" +
       "UELVUhPtJsN69DYWgxKqTE7BnUVcdgGHKgiW58ypWxwBRLAU2If5kST1HcBh" +
       "n3NdsxRA+ZLgZ9lZyu1ZWcpUXfGBuHkE050ef1Mic4GGFxOcmzMD73a3lDuh" +
       "+KEmFTBLCcipDQWI6O3G2lSGAghFBHvlTP0DIvXpDaXTNJT/yMpQEMH7sGkV" +
       "nU5D6XQaCkfba1pFp9NQOlMYyniJrAU4pHNsSM6cejyTocAJ1j1sqH8SPNU1" +
       "QwGUdwi+ldpQvPT3WHZ1KtWdA8Mu7kG9fO1QJ/NYZ5wLQrHXzqSl3dq4Sbpu" +
       "3Lic6Xh/Y+ykeH+bbpbQ4Pfmzoz3aVSOA5hkPNOl/uDXs1hgF8+7OxqzwZ+h" +
       "+LUm+ZJZbM+w8Z3bM9bKFKc6hr6CCPII2v4yvlv6+jdRXy2nOqgu5TRUkZu6" +
       "0B7La1xlscz2VIfJCseH3190SA0KTOeeSZXJeZ+F4rjeh/c1syNT4XGJNo9m" +
       "MIJgnzQKP8cNYaidy3VZKbwSUfglkKxVHmZxmIUCwhTkPxcou5goGk5wWM7y" +
       "P5VG/si9S2ioMjfukfzfz0b+tnmhBpxEOWICb96O8P4da/8BxcdQvJ1eAz7S" +
       "+/Di5TQ8qfeKF9LdcwM8pmuleS0jaLuGJchABYQ4NVxKMJCzDM665wafoluB" +
       "4oVUaQEY5OdugSRVWgANPyP4ac6Ef+VIC1J5Ppe/WQESzhH8MldSfD5Rjy1D" +
       "wukD5nUgLj2aTch5yALrkNZlpdMhcW136Dgaz9tYPstWS2QgE9w0el86jYYG" +
       "n2Ozs4b6+PqJ6gOP57DVV6lkhZw05yakLnAZaA8zwqcI/trKQijTpy6A8iuC" +
       "1ttVWaUuuP85krD/SPBZh8qbnnyYG8JBu9C7l7qkvvDfKtlSF99AI9XwDcqQ" +
       "uviGm+rhG4mCGAV0+kZ3qT/41UxdfBMypC4+OCHzDchwKb+VshQ2vjN1sVam" +
       "SF3wEvUIEsFhgodytj/bdVchdKG6jKWh/uKmLjx0+WZ0I3Xx4QGKb6pp4Fap" +
       "QVGJkksVuHx+KGbrffhmWDyFPfWeTpS/RfCvaRR+qhvCG3Yudzd1yaTyMItx" +
       "KVMX3K36BlF0guCbOcu/Oo38kXtzaKh33bhH8l/crdTFdzHKEXdEzdTFh98x" +
       "8cFWsm8ZFAvTa0BA78OHG9jo6H2lWaUuGNKa+bxKdL/8uUM7TBnA8Z6kEEJ/" +
       "giU5y2CFa+riuxTdChSTsIFwUz6vXQ2HMqcKsJeEt1VhcgcIPp0zzVemSRUg" +
       "9Zfm01CnCb6f85DXpEoVnA6Aa5dDp1BZF2Lpt6cKDg0amiFV8DVgsxWmuMKm" +
       "uKC4PEVmcKU5FSEzAA/PXM6gSwna/qiuNWNmACjzCVrPH7MyBfw79HGEvYag" +
       "7RjOZGYy64sm1rv7KK265gwXTXzcPWS4aOKLmjE8lklQSRvpULahBrTHu9Jf" +
       "qxHtrxMaWIULlyR9EebraLatGbOBqFs2EHW53D/dLqtJJKNr3GQFSgkLE9/3" +
       "ESnDxqHvZqSd705X8wp8tmwcClVLTTR+o7XO0saycWivwkslrIqixh3ZRA2P" +
       "2moPDyRCKO5GMaYMD1j8GNmAw5nGLd40");
    public static final String jlc$ClassType$jif$1 =
      ("tIpwJ4oQiusFGzHSd+B3rZuRQlPL2XZfN4RqK0LXz7aNG3zQVw3BRdY+u+Vb" +
       "H3S4cxd7gXIziYR4yj8Ckfa6HxmX86oBqLmpYFGnzkWdOod9+R43FSzq1Dmj" +
       "CkrjDxEcStCaRgl+JyoBPN5nHmT7HsCJ+/Zx8aW0r5TnrsRwUaMPZNBoYTJY" +
       "uS9rCcDjc1l5BM7mw92TzgtdkI5bHITNjQ/Z6uMOgjdYtbs1YxwElOsJfsuC" +
       "mlUc9EMvEwn7foJ3ijbO5XaMiePyLsdBZoVabXax8PWsYuERM3b9LVMsPGYj" +
       "H8r/Qj0+Hu9Kf61GLHw7jQ3hIC9rUpFlxq0Z4+ERt3h4JG08RJmVk6wedJNZ" +
       "qx4PP8pK+88g/Z+Yqn7Gqf1nnNrP0b4wVf2MU/vPOOPhGT0eftWteEhiZEUe" +
       "OpbjKb0HLBbzPMgGHK7VcIVvpRZjXg8UIxTvpoqHwO9tbsaaKh5aEW60IuQQ" +
       "D6GvmwhutfbZnXiY18c9HtptBsq/6/GQ8zSbeHgkVTw8Yo2HR5w6d8Spc9hX" +
       "3nBTwY44de6IezwUlUC8YW1VglJRCaCywIyHeYU48byy7sZDYrio0RMzaLQw" +
       "GaS1LGsJQOspWXkEzuYLuyedGV2QDtPWXqYmwr3fIY7/pIH/xwLBR3cW9xy8" +
       "c+VR/N6L8fH/woDUs7ktErF+9dLynB9PKM1hnH4hln3jSOMcthzWTUGT8gAA" +
       "WXmV/PU8TfKx1/A4n9NufrwCjA9POeEPUK4mGNCkuV363P2CJvhSVFCzfC8/" +
       "tw6Q7gVI5UBNGmjYubUdvs32KxawEYrLLphfM0H4s+K8KtT9avqKRV6tux/P" +
       "/BWLPMzjfwgmOcryBYm8Szp4xBxiVWR3Q73U/jFR+JZXG/+/QhqDH02bWr3/" +
       "0PiD9OnilF/lMzH27lyy7NozM/nnR3swh7lpEwzaMyAV8BQHaYAPpY9J2Zve" +
       "V/7iif/s+/PCcbaPbPe35HO22Q0xQ9/1HUnbd6HpQ6XW/8ykMbhe2rzt2a39" +
       "v8MoXS0VhpMrEm1JDf5bkcKg/k006GsLjjcrzr3VFazjCeIXnC3dWu/ke9bd" +
       "VRco+Ppy406+q8dAgvv9C0RYgKM6ZgAA");
    
    public LinkedList(final jif.lang.Label jif$L) {
        super(jif$L);
        this.jif$jif_util_LinkedList_L = jif$L;
    }
    
    public void jif$invokeDefConstructor() { this.jif$util$LinkedList$(); }
    
    private void jif$init() {  }
    
    public static boolean jif$Instanceof(final jif.lang.Label jif$L,
                                         final Object o) {
        if (o instanceof LinkedList) {
            LinkedList c = (LinkedList) o;
            return jif.lang.LabelUtil.singleton().equivalentTo(
                                                    c.jif$jif_util_LinkedList_L,
                                                    jif$L);
        }
        return false;
    }
    
    public static LinkedList jif$cast$jif_util_LinkedList(
      final jif.lang.Label jif$L, final Object o) {
        if (o == null) return null;
        if (jif$Instanceof(jif$L, o)) return (LinkedList) o;
        throw new ClassCastException();
    }
    
    private final jif.lang.Label jif$jif_util_LinkedList_L;
    public static final String jlc$CompilerVersion$jl = "2.7.1";
    public static final long jlc$SourceLastModified$jl = 1466731418000L;
    public static final String jlc$ClassType$jl =
      ("H4sIAAAAAAAAAK28CawsWXYQmL+6uqr3pby129Xt7+5y0+1sV2RkRMZCsWVG" +
       "xh6REZGxh2UXsWZEZuxLRmSYQsYI24wlg8bdNqMxHmnk0bA0mwExI2TJQgwD" +
       "MotYxCrAICRAHguhEUZo7DGR+d6v/+vXr+ouwZPuPTfvFuece7b7de7/2q/O" +
       "3t/Us4dlkV4OadG+2l7KsHlVdusmDIjUbRpt6njd/+oc+MpP/8Anfv59s487" +
       "s48nudq6beITRd6GQ+vMPpKFmRfWzToIwsCZfTIPw0AN68RNk3GaWOTO7KUm" +
       "OeRu29Vhsw+bIj1fJ77UdGVY3775qFOYfcQv8qatO78t6qadfUI4umcX6Nok" +
       "BYSkaV8TZi9ESZgGTTX7vbMHwuz9UeoeponfKjyiArjtCFDX/mn6h5IJzTpy" +
       "/fDRkudPSR60s+98esWbFL/CTxOmpS9mYRsXb37q+dydOmYv3aGUuvkBUNs6" +
       "yQ/T1PcX3fSVdvbpd9x0mvSB0vVP7iF8vZ196ul58t3QNOuDN7Zcl7Szb3l6" +
       "2m2noZ59+qkze+K0fnX3237iB3Mmf+6GcxD66RX/90+LPvvUon0YhXWY++Hd" +
       "wo98j/BT7rf+wo89N5tNk7/lqcl3c/7S7/mPv+vLn/3Fv3435zueMUfyjqHf" +
       "vu7/nPexv/sy8SX8fVc0PlAWTXIVhbdQfjtV+X7ktaGcZPFb39zxOvjqo8Ff" +
       "3P81+4f+RPgrz80+xM5e8Iu0yyap+qRfZGWShjUd5mHttmHAzj4Y5gFxG2dn" +
       "L05tIcnDu14pipqwZWfPp7euF4rb74lF0bTFlUXPT+0kj4pH7dJt41t7KGez" +
       "2YtTmX3bfeP338NJ8F4D4iILgWMYAH1Rn4BjEgHBJKm3Rpp439vU/q19L8P5" +
       "aRLzafzVqa/8b1s+XLH7aP/gwcS4l59W4nSSeKZIg7B+3f9KtyH/459+/Zee" +
       "e1OM7+lqZ9807XPH68d7zx48uO35zVdBf3rwI19Sv5/73T/2ufdNElD2z09M" +
       "uE595Wl5fKzF7NRyJyF73f/4j/67X/szP/VG8Vgy29krb1OYt6+8Cvznnqav" +
       "LvwwmAzK4+2/56H7F1//hTdeee56eh+c7EjrTic9KeVnn/7GWwT/tUdG5MqT" +
       "54TZh6Oiztz0OvRI8z/UxnXRP+65Mf7Dt/bHfnP6ezCV//9arjJy7bjCyVIQ" +
       "9/L58E0BLcu7Q7ty9ymKbgbrt6vlH/3Hf/vfQ89dMXlk2z7+hBFUw/a1J/Tp" +
       "utlHbprzyceHpdVhOM37539E/smv/uqPft/tpKYZn3/WB1+51lc83Qm/ov4D" +
       "f736J//yX/zcP3ju8em2sxfKzksT/4b5y9NGX3j8qUnV0kndJ0yaV/Q8K4Ik" +
       "SlwvDa+S8usf/27wL/4/P/GJu+NOp5475tWzL3/9DR73f/tm9kO/9AP/+bO3" +
       "bR74V1P/mB2Pp93Zj296vPO6rt3LFY/h9/29z/xP/7f7RydLNGl/k4zhTaEf" +
       "3AvvFamX2tnHropwNeqvCq4Xpjdi57fBL9zq77me6W3J7DYGXKvvGG5j33Lr" +
       "f7F5u4mlrr7qsYg6wNd+5tPE7/iVGy2PRfS6x6eHtyux4T6hPcs/kf2n5z73" +
       "wv/13OxFZ/aJm5t089Zw0+562M7k6BrivlOYffQt4291WncW+rU3VfDlp9Xj" +
       "ic8+rRyPjcfUvs6+tl98Uh8mRnzkyqTfMpUPTuVv38M/fx39RHmtPzk8mN0a" +
       "q9uSz97q77pWrzwSuRfLOjlPCjO8uemN8x++3+zn7+GffGLTdvZ8HLrBo/P8" +
       "1DMMG5m39eVO/641+HaMPzSVX7uH/+wZGP+OO4yvFfZ21K6r/uk9/PtvRW06" +
       "6Jsf/m1PfP6mT8ODidz3Q6+uXl1cfxPPZsn7rs3vnlSxucVe04ooyd07KX25" +
       "nX3bMfVfeWRtjCkWmxTilYkBj5jxiZta3KT7LmR5BhaT9H7s8TShmOKaH/83" +
       "f/hv/qHP/8tJWrnZ+89XSZqE9Im9dt018PuRr331Mx/+yi//+M1mTKen/9AD" +
       "5Q9fdxWuFTkFRVfs1KKr/VBwm1a8KXkY3BB8u8rIdZJNtu18H5WEP/aV/+E3" +
       "X/2Jrzz3ROj2+bdFT0+uuQvfbqz50B1x01e+692+cltB/ds/88Zf/mNv/Ohd" +
       "aPPSWwMRMu+yP/UPf+NvvvpHfvlvPMOLPp8Wz+Rp+3DGwA27fvTHL3ACOuig" +
       "l43dhYw363gDNVi62RDknkjkbS9fVDYhhURRlbUOarmdOzQFOaiIEgollEHF" +
       "p3YFVVFSXFJdgLJyv6wqSEBo3qiIpZk0xmBPngE0saSorQ2O8Ph5BOZhADpn" +
       "d49KFuqfUS6LpAhbAUC0hx28vJhhomiLJgbh0Ll45s5XHftMaJF1gbMTWZUW" +
       "O7RWw9c0vIkg4JIuVoM17FBQBbKqdMZkJZaunq3MtUEkkKuCFVsNLcjv5wfL" +
       "uHTguC8L/UjZVK9XjaiSxmbneDqZs3CZGF5p4kJebHUBG6oVdzDTo54a3E4p" +
       "VsWCizf5GlnuKqqiFhVlDJJJMjy41pO6qi7cRWxS5NIE7tmRQszWXOYAl4S+" +
       "cBmTIPV5x0L8nuS7urSUzbyaD6zKIHi4KqJ8GJcjHUIwzPPLOQJ3LXaODGFw" +
       "qxPM0GfFIRZ+TXFHutrlbaCg1Un1UnJ/UdTkFFOOwGkURWh6kXhrnzDxZBtY" +
       "tlulgFj3Sy5rW0I1VxaZVSfLKZZbwKEy/9SXMeLo22o0cpVqNT3eIgEguT15" +
       "yMszYBTHJq5PE80XWhFyEN6B212I00JjbISdn273eiSY8VKMYdZc2/5lQLmu" +
       "WetimxClaDWOEmq0Y+hHvAuVxM+Gdm9LJiFGZlPZOLi1d/S2bxw3NNj1YdVR" +
       "q7Aa99UiJgZLA4HBKAw2Edd7R6STZtlzFze1bV4XZHZ1NkcJz9pjstyF5TY7" +
       "bYjdOlrM6R1Zrs0KXvD9KaVSBbY7nDsE51SJ2g47Fao7Doorjh4glZ4zd2Tm" +
       "bOlssMo6svO6ygHVdFNvpVWFnM9qwldcA4H+JjBONLs/Z+OpisYlXoUXVsRE" +
       "15EVVsDOYLrA2miO8IKC1SiUpVZtqFFK7FrSdJhSJ0HzgDEUqU6aO3AKmemT" +
       "PvA1pVAeMiFWT2xb+zoUt5a1G/WWqkqvZ43OrOfb9qhrcr1OY73n0G1jOkYE" +
       "o4J5aOYBpqSqWh7kibzpUrthKQm7FIW5c0u9pnYEtT/rg1zworBWxGWMJazq" +
       "lZM+KVaf6fC8deB6B5Xh2OVxh2zAteVhO+aAH6H1ce8ROxEewpo0PffoM94y" +
       "tjvpvCtgYBcqMFhaZblg8sNlJVhOO9cGm8O2yo6hUnSR79ILuOIqT81BcT1n" +
       "PSw+aAWdlaNKmZnheEkPNxdKy1dWPrioJ9NblOEBwx73g9ekZZm2TWLmkKHU" +
       "ejvE42SbdlXnc5jS9/ipai2BPTCkHmqb4xmjo+C4JcA4OHBFv8qQtEhpeOFk" +
       "WOBo+XyJR96uygosS7WsWRYnzkhPFZHQ8abUFQzaZfhKxrBY2s1H1wpdHXO6" +
       "svHiyqOtRNJD1t51XQNuF8HI60wGImNWHHnSSlIfMS2w5JTd6gBWGxDHvIxU" +
       "3ZQFcWASd4HaMFCP1z2criV4VzB2bGQHbgV5pABA4D4KAduxsLKUWvygDptC" +
       "rwMuQXYbR3TKReKmFD/wfN8WwRmV5/uxlTxwueWbvXtkdK9ZjzyfeQeBU4Zd" +
       "Dpx1qa09FBkQ+GgZ2243eNmyPB3gJU2JZFel1lFZCXCkpiuHa1qGzgCl3w9U" +
       "PBbVPrsMHm13VWFtRpNGeJ7f5tbgyhlQk3P8jPrakm02tQTaykKyRMY5Q0oc" +
       "8OYKAebRZr+E+5QottzKOXpHqMOwZu5Tia1iZHgs5uIq2uMrUBcQa24wWbcS" +
       "Yk2pELZPVyzPKEKjrSx4k8bRpqPj/dxp0EQdPd/f7YqFFdv1Ghj3/HqQpONx" +
       "UZSwFulcyvjnsop2goBxGzDPxIaLfdCizXGNJUJQ4759ZGywHoPgIBY7is6O" +
       "2Jk/Y4UN4KV5VrSiJNQjbxNiAA6mEHaGf2FYkKGFziC5Arr0zSJQ0mO+Yk6c" +
       "tLfFhifWuc/xwDYtihW8PnFNtxrWkkpZQ+6uT3F5Akm5AzdT6GOCtRKDKLbo" +
       "z6LHnilaREzJNuEU5ZkeQFi0RDvlqNPyWYlH03EVNKCFAYI3oIyfcWfVs6G8" +
       "iDxxf2lX4GAHpnzEKQCjHT2kaFW/8NB0VekxmQ5yG9gepyBYX2nSfM6uvcor" +
       "Yq5zMN9xu424G+iInYcFtxBtGu+3YyYiFS3tVKIr8dUFAlENxffygINLlV0T" +
       "UiWdOfbk0WSQUtbSpBlFR1fEcd+cdop7Zs6qRSxsLPQtqDZ7lSQubTviCw2j" +
       "mRM6hyd30VYiZSvKQowFtVpLRqMlAEKU3bom9+5K28OwTB5jvLAibMtRkbXe" +
       "mnLYrhlU6xdOmIAcdXCbMiU3AmMbeGY0iLnmlyAWSvIWPXQG0K4PHufHdrMm" +
       "PT9Pic5f6/1WMDHtAEXJSt/py51ZH5BgfhkCx8qtvPR38IbapH62TPzCpqo8" +
       "04AyWEjQGUVSrZsf09McHI+CoUK5EUjo9rz0AFkacx44bOReN9ZUHlq65eQt" +
       "zuJzbnAKDK8tFybrzjn1GsMmyjmZGyeib+b1wpXqdjVEO7YQklbweQE6I9Ac" +
       "KlAvApY1ol2AQzTZVXyFqSE7J8cq2mB6lYsrY5UN5tL0jnpt6Xu6uaw8iD8J" +
       "4Zg0Yozwc/wkCY5f9a65Np1QN/oFfoEkFK8cK6M81NLbhSGBjWMzrENR4Nk7" +
       "GOIyaqUTWXRgUYdblOCS0dHI1Gb7pVTxcuSLFVrDsqWQTsxul7yI5lOkw7eZ" +
       "ai1AVJKrsh01YAsi5YE3N9nuMmxCuJIClq58qmrTlWBcPatUHsPJxIYATe0r" +
       "c1+yC4W8HIWGFhBH8tboJnV7SDyzpkgs9UZbklg8h7INTMvmUTwdYV0Udb0a" +
       "mHVEza2K0JttkwCnZO/HSlIlozUIWOYamuaXtR3CsKt0O3qT6SQ136IRWuYn" +
       "vw7H+YLulwApWXTJx3ta6jlars8RWeIoJboKIoZ+2amWDyxadlsSopVaJcAb" +
       "OhA25tpJJjagR7nQdu6pcLlkCocGfIsKBS0uFhKdYwqmRuKKjy/e0EcLOBYF" +
       "f5Kjg7E644ox2bh0YQo2seTDjK30hAZVE6ePCeTP4Xq+wnq7KxU2Ur3qWI+Y" +
       "KM0pMAhCFc9bwrBa2EZNaWWD52TRaeuKUiMYOvAXG4U2x4RUMUUz013DRm3E" +
       "b4u0Xp6tLiucEiBVc3sJBmHhHC8xIl32pO/sDW88mKpW7jLgWPMRyaJChBjZ" +
       "EkHn4fmCesFK0JqTPSw9iprCjcWInHY4r9KyerQnPxcCDRRd0HyJhpczeI6A" +
       "FolAuhGimuXn0WS+0TzxxS4BLU2NzBFBMm1wLcDyCBBvVRUKD/Icpia12cr5" +
       "ulwcDBMUrdbQtbjcbGkfTEAFIsoVJ4aStdh5OsiPqJD60RmpShRDd0K205ZV" +
       "IqpZqlxaZqM6OhnOQQOCtKRWLybIbLGyPnEiAnLAzlTNpFQjVO8gyKbmAXBy" +
       "KW5OYwdsXB6MPabKhNthuXOYw6SrATqpgIW+GFjPj6xzxlDHhtaWkA7tQAwD" +
       "EpEt9wm/D/ulD8nUsr8Qp+bgoBIwhQyXTqYLKcfb1WWKGYF6W8g4jC+C9GDl" +
       "5DkNeRPuWcUeuxKlNgM6L9MNiI6nE9qDejVn+SKoHOpSq7DRnNz+ZOJ7tiJ2" +
       "kh0sx0L1SXM3sutJvZ1xM5JCH6r6iOXShhEyZ2WN1RhLHM0LrosfDvISIeA1" +
       "XERsxTrswlM66WDkFwvWRDT0NV9quBN6OiA9eGQh0j5PnCwci3HWubbY7x3k" +
       "3Nqq5uyjRGwdanHqDwu5w12e93ertgc3Tm6wRjrPfNKCQq7KG1hHqCKwHbnf" +
       "ljRGG+ic3odSwU5MROANtgD8uNVJltwX/DaOewW4UCfyCKbUgXMKONgfmdAV" +
       "B7xppRJPlII7DCTPcfqZNCKINajzFtkEkGUB3phuA7RKkX2OCEM2EEd9zvES" +
       "yA87zvDgSDbhyoNNZ5EzBhAEGbtGIA8AgCV2SbZ+0CH0BRTVRMsK10C3KXaR" +
       "2yMHCcs9uS2Wcwlk08heNBs/Cmy9pfdDCo3wNsaJaG5T4GbTUgNey5ot0GWs" +
       "HiwS6v2UJtC2gUbEWAV9wpejOedVpZA5zlMysfQ6hScOGHo49fvQF5XeXcMy" +
       "oiEaaKdDF511oGew9W6HHRmn6xaw4hsLfr06OCtDOZO9sEtiqwSHzrf31kha" +
       "6joMkYuBgCC5RyHjojIW0S2KfjLU+cX35sFRl1Y7wJE4LVm6IMtM0SHBgpwA" +
       "6TsUseyVEqsKF++WO590dsdTVtJU0tfwoXE8FXeA5dyXxxKOdEbk2h2N9dtt" +
       "eznWUHPiBJ5r68RXjekkwXM4JGFxYucyTu/GtbEMwJMALzxjL/Sptm6XPhdg" +
       "DN6cOdxd7h3TXqVhfCrnk30xlAuDz0n40jXU3AUZj4JQbc+sDvYOsPvjVgXU" +
       "AqUmtzQcHDvabvGhq4RVLqHtKhc2KBwlggqjPIlkp17XUWidSopFhfARkht0" +
       "8uoouAJ7t4Yv7RE5efax9zzi6C4gb3tOsjPS7lWzgOQcMYaNjDGDkmYBPMQY" +
       "E5un9rIMBwhVNQWu/GqdnKNzrbUo1kUIIshwSccQclSYFbzn0+ZSHJLQ2Ui7" +
       "QNmWyt4iYmsfIsyxwOXybJFWsF1npXIsj7Et6vI2RoIwCEutGZxFhreTm91b" +
       "Dr096NjyXG1G24MCSmxL+WhMt4qDRi3wOOkW63C7H5WdWVmhTUowNGDiZqAZ" +
       "P2HK/CCelgi/azQF71PbG2P6Yiyg8rDdpZxTE1gwP8hAYdCrhRJHkG2lYzFy" +
       "uLUNHJ9YnA6qZ7MHdUVzgFrB+AHtPIs5S8pqAGysowsBRWAYZZTeSfgOFAva" +
       "Nv1okW82AGuaKUOoJ6hno8OgE4wMU+6R6KNOdIhKbpTleb+xdBJXoPyQjVJ5" +
       "tne5zBQML6NlmigiRy5DOPaCDYEEm/6wrXimQxOAzSa/L150faMvKzplThk3" +
       "uXZtXW6YdgMqAn8+Ub05mRottsYpQHdXlJ53bJ4wy5QU9UbfGGp4RPD1aQQ1" +
       "i3DZfi4pXp1zhIRoEYspZ9FHDPWoTdZ57R+jDbP39JphNRnYq0oQy2R0oRQI" +
       "lGgl0aD9drm0dQ1hePNEEclpk8FcX7VOlxCstCx3LL9wFshk7nHHXju4Nlh8" +
       "sS+CRcV2uBIC+clqSvO0WIPcflzoLiNaG48qtX1EmUlDNTYdHNrURTaSXYaH" +
       "9bY9z8PJMPheKF4WVoFvLNvI9HLLWBuNtCvHRQtbXKW9Lw0me9k7g6JSR57j" +
       "V3qD74z1gs6XjaiMdjMmu4xkCy45VjqQqplEb73WtS9lQPT4ggzmenP0TKKE" +
       "BJBX2DLbZSIbC0syn4JrkE0qZ5ld5N3KtZKQZE7Scewd0zlLrlFL697MiX27" +
       "aR1eP8PRATXA6Y5LXA5zorUs04URwiL6Iyr3+VxmIU3eYTtYo1Ffqka/LONV" +
       "DKPTFRleLkCmvdAaDFzMwaLm9NIYmH29ShMUdMZaykYW7DYZ3yYreIRsCMXT" +
       "Dndg/ER1RBGur9EMB68z4jgPGp4DS1k6wJAtEzo5RxClXS123Yi5hGk69Mln" +
       "RhjQTWbkCXgzN81F0c43k19EIBBecJtw2PqQQ+u7NNhqjqbWk5luVzBBbCib" +
       "6JOymm+8DTmmArymmM10ohItD9aatiTBWrd1saxd2NktJDUZK4JoV3Rf53MJ" +
       "KSJqd/aLhu3ZXIIytNmvCj8/6FIJqwghY+kqOswF3SVhH1TXstqWAsf0vEhN" +
       "mu2k9eLIr7Gh09VF3kn5vjyN0ipfNZtTA46wDM9ZpdhaMUZQGJ7TdaVySUnI" +
       "XbAu+um6hou6wF4KzTie6XURG5gGiDyRJV6G6sCIJqciqnacbJxPznpyXHVe" +
       "Wutsn3U43SSbwp43Fn22DxkXjgWHGT0wF5DIJWUPA/FCwWOUXPYruN8D234M" +
       "48oqGDk9gnFhVmUS2arR7p1lelzG4qLiKVBLtvwh1iCL5EZ15+jrVDyRAxKY" +
       "iaaUg5yRZ1s7cAq8KS4NMGYqVKRnpzdKyl+cdvURXGEIou0gpxs6q6LHwS1L" +
       "W9ufq6NT7YGdIw4MGu63nenRu0EahLPK");
    public static final String jlc$ClassType$jl$1 =
      ("ACNPwjtIHA14C5fWTsyZcrrbuIFEF8tV2eOk7vq7RYdtedXYgt5B0MqNgBvJ" +
       "SUuEORe0PQ6sOoOzLoQ+pnV1XuTa6QwP9IljpKVfRW4kEdDG6PQSpnQMBjZI" +
       "g2HwQu6DojAkLKUxfi+JJ5zINihLxMseXDdy1KC8EQcbLaHiOYvRymg4Pnoi" +
       "z7ovI3Uec+MYyDmJ6GOrnRU9OrqnS1xg3VATLu3EWrjfhUpsSfudiW491JaO" +
       "4PR70x2H89Ys4NGyxhqB1yJEjYZ3PAoHitCORqTQ+6C5NGcpNefTHSblmDwc" +
       "Ca/CFIpHyEvVsXB3vTNc/+FqIRMtvDmeNGEI3DgSw0RK9uiZOq8PaG/t8CE8" +
       "hBzeAtucg1mrq9P8eov11LUYnCRb8A+szhYrXsyIcGG7Gwg0yLovnDmyuzgp" +
       "OjiwDkwXDMQo6i6C5MRpwvh8ghcr3Q+sSYwW6PmQgyt+MVh+q5WWORjUJAYE" +
       "o+242m1Z74DtVsyaPlXuPl+27C5RmkWcrS6Kas6nm2t9tMTFXvAGuhTjPa57" +
       "aMg3iJmumW1umJlj111oUXV4jhrxQOvhyiirQ0vqsMXDe0/dQ4K6xhdZZPc1" +
       "4gTLE7Bfg7lN1JEurJCsALvF5GbQUN43F2+V5ra+U0ZpLXphsVSWISrm+3Y3" +
       "5HyNNgKhKY0gBJxe4txGbj1hz/CTV1oUnKIIAn8gEudoasEKdHt1c14ri6NQ" +
       "haqxMUdFAchiTXKO2g866QN+nbXmORM9nWh0pD3Hx7lZ7iSO0SFeiER+svKb" +
       "9qwv9MqVDrm0LXOswoyLjtdTuAeWJ6q9+O5BYgVo0+wQkzUKnRQMPZZbbvqN" +
       "b23zMPCVRqKbXDf84EAz/CExV9ilNId+sxfW+pKNVidVAxl/E+fQLmiG/Xru" +
       "CAcHT51LBzqmX+pWRG865kQuVoswAsXEh2maGiQ/G8UtCrlQuu3iOU9mlLYR" +
       "CD8pt4rJIhJEL1OVXh9iasOcU01ebNmzVW5dazpwDbiIpUKKDNrQJyPXV1vE" +
       "UlziFHkuWFIlvlOkVLQvecLVax0umV2jiogfHi9a4a858Ag2FTPd63Y6qPS0" +
       "PsXl8zQolbOsQSbjgHxrBmtM7NATjUcSqEx3RNtZ9YJSM9M1Sk2hoIJVr+wg" +
       "IfERKwbs+eUUMnPPKz0FlqNsiqMg11Cl9So+yTspBbqt1YDxgcLmqDRUk8ec" +
       "x5N1z+YO53jivMccyBNxj6d4H4lrhCBkll2e4cs5PSPzY7C3Lstcqg7dStvr" +
       "J6dDFhtUcMEhbfxxabARRzQhM9n1hbpe8JoUhqpjcaEzp+D6GMaADzaXnQZb" +
       "NLcr8MmZc4d8VHgZ83e2mwQXyHB4r1f16JCe+MFgMmfIWJ3oY+0kD37RrQ4F" +
       "fVr1pohe5JVBA02Cq8ukEI9Rd4rGaFx48zbP4k05kJLJEh6OSJgMBy6AbQY/" +
       "UM4cGK5HVJ0D22SlKVgVhTyFC4Hfi1iZdWmoLo6u0NGcH683tgLvjIEXOWLc" +
       "igiy6t2oSLvJHRu6q5D2Sgq6g7o3zMN6J19k2PURMpobLAFyK7kMAVMh1TFm" +
       "MDEN1Gi72h8v4LbvTttVrh+E49LV/Hh1WQv1aeekZSDGvglCyPbgjnhry01r" +
       "qkvlQOL9Ikwx5GjbU8gkjQ3sIXO54pCDJK/QrWEg6Sl2+sUUI56EfO24a2zs" +
       "K58F2ppXkqNWXpA1lnQE2LaG6epdJ2OrU70FVHnjxFjl5fnFpjFu0+EEmqLV" +
       "6XzeRnybqhSOr1nc6rd+pXTnhM7mdUzDGUGvjcX85ECVBsCgPgTRRryUBDyX" +
       "CGbc+nHPe3OjiaeQ+rgDG8PNVArqJ6/Bkg0VH4pguuQAXmD4ccDTyJE3Y6Dj" +
       "M+E4LObTHZiFrAFWaN5DyslXuaVi0Nzp1BgdM8x52qujKM7M7YWSIzPUShXY" +
       "R8TZ3e/nVXwmaMjugjEAL652Edl24A3RgngI2aTU4tARnuR3gFRA2MlqR5eP" +
       "IcibDiadDFagUcHI8NP9hxyndoxjA+ZTZpNhDrU+a+5is0YxiaHxY4FMFvXK" +
       "Q3rHu3Nv4AMBwDpdRLVNvsYc5ESSHHBI9NVlSVDuvE66QQuIWNUalur1ETlb" +
       "ypIRK59vuJBsQSP2Dz4rl4txNMJM3esH3ImyBUjkhIdE2GprlWRh5Gtk7a6C" +
       "bQluHGoplC3i89vDws0SysC2xqEZzKwT+ayb4kWZNDKf11eUSo7rNSBbInJQ" +
       "+9wFqqTbmbtsTRxHwqhlBhUvm6hHcYae4hn3gO6PkkPbFwRuMrA+ozy/RFaH" +
       "3tKs0ZdNFXYlXsiOJJaeUkXdn0tdcONNrTEdzkXVwLT1ILomqwvpZY+ToVe7" +
       "gtvSnrSpqGZJMuYK2gKBULUcx+9qiFYo9XASSByASDXfDhVzdio1QBcrC+tL" +
       "rM16n0gNQdP28wK1pEXjXnwzOfenJq3ZKhliyNmvl/IyK+TtZU/w0ooWXVvc" +
       "gkeMnkjsVzktBPAtqcO6T4T45C1N480002MSXQe4ZyUOPG+1bNlzcKEk03Wf" +
       "Hhk1mG+g2un2SioLS8uJdvC+4heCNaLujoZGxeihzT6w593c8BhIhf0hQA8W" +
       "Oyb2Hr4csckHuAgzZBaGFJtKyEqbovPxZAZSEeDzPQxR6liB2+xInOrjdiB9" +
       "tSXc/SGdc5diM91rcibTUKYhuDngDJhrLuqVltfNvtddUXZ2UwCscXan4jXh" +
       "b48+mK42Ipr1+FIbD21wYlfedF/cHRXAQTpROhwDu/Ua0B56MpUaLmo6Ikt1" +
       "HyfFM9nnaFRwUHL0pJXlikkoX4Qm2DiF4XqWO2Cy2dgduRchDxcMsZFp+8hg" +
       "NaAcF/NJEvgIAWmB6dGjAsUsMTn0kkqHauHAc3LfQjHM0Qtsz2XGCenDgNs5" +
       "1QDLMlbycww7AM7crnKUriIwz3e1vPDg3oiWog6cZUmSY1qbHHVrtiEZJw6p" +
       "h1LpHXlvwQgbb5TFaxSAGj5rnMu9c7QOmM4O2rksKqaX8Ilcd9L3lUuayILt" +
       "FGWL0Oesj7s28pzcSmwQ83GmLdtNUwEIQCvYqHohczgZWo/ZxZLZr3okwNTS" +
       "x2MLyjdab8NwECJsOPZ6qhOYbYLGIeX2hEtcevbChLYOY97lgjbO1q6TYrEX" +
       "R1eY3LqrggLdcIo03cqsEzl2ttBdwoA2lsq2lU2rsrO+hiLWRoGSZYChFzZ7" +
       "yDfx4YL5c2O6PSACFjFAX2z1Bj21ZE3N8UC45Btc5kUwzhk4TnPoqEqi38aj" +
       "qem0hh3Wa9PKDEDWMS3iBxBYwzm+66K6J45rXJZCUtZ5OKN3xKkzIASSlwR3" +
       "jlWDIsaIwIC2RxT0YLArfbOjs6PdeXpwbqAlP7g9adeCUE5x94KBmzmP8a2G" +
       "u+eK3xtI2w2ADGxMQRbHY9QfMsmvLxs7w9SxhIfNkBjmHlJQSAeO1H7OORYN" +
       "zAElrrbMYumZNQQs5GSLS3mSUkAqjswSTSd+7opRBPJ8DzV9jKYl2Y+ueFkb" +
       "2EZhXHstlzbOLZ1zaABokkRAMwdkwvdc2ZNDaDXdhJbKYlBwAGT03AsQplQQ" +
       "ywSwy0n04nBZj+3ShfAzJhaWujDiUqzJDOS20co7+fwBOC0WCN0Ix6NfjzVk" +
       "UO54JELWygkoMDvgFOKTT9v7xVwuL/ACmVdYsD6czzix2NsHXkSc6RyuJub7" +
       "7g3SN73NIL0CvoNJust/+4Fnp6c9d23i14p5lJL27dfNpvL6NX/q9cc5eK/f" +
       "ssK+fPvA8Dib7nNvZtPd/l64T7Cu72H6RDbdEymXs2tq12feKRf+ltb1cz/8" +
       "lZ8NpP8NfO4+b1NvZx9si/J70/Acpk9s9clpp+98aifxlv//OAXzj4tf+xv0" +
       "F/z/8bnZ+97MnnzbM4K3LnrtrTmTH6rDtqtz7S2Zk9/+Ju0ffpRk/pHZ7MHH" +
       "7+H7nsxDfHwwT7Htxo4P3S957j6n8defZtuzc1nLdxm7Jaee2tk3X8/zepav" +
       "PD7LVx5jk7yVhm+dyksTIsd7+Pp7o+G65AfuofWN0XB5l7EfvFZte5f8e5uh" +
       "3CcGXoHWzt6X5O2zyPj2qXxmEm/wHn7+vZFxXfK5e/jyO5PxVCbyS29mInNJ" +
       "dJese/vWH3gXCv/gtfqhiRA3CJ5F4IteUaShmz+LyJen8ups9r4/dQ9/5r0R" +
       "eV3yP9/Dr35dIq8/f+S260++Czm3fX6inb1Qh1lxvqnKjz8L9e+aCjtZi6/d" +
       "w596b6hfl3z1Hv6hbwj1N267/sy7H+DnH2fIsnkQDlLXStGm6PKgIQc/LK/p" +
       "6rd9fvZa/fRbyPyRZ5H56alkE8ofv4ez90bmtOSDv3kP/8s3pk3/+7uM/fFr" +
       "9b+2sw/EbhMTRXDD+41n4f3KdcnUpu7h9743vK9LvnwPv/AejufPvvOE/+U2" +
       "4eev1Z+ctOUQtu/I9M9P5cdns49+zz186b0hf13yyXv44W+M6f/n18P7L1+r" +
       "vzBxfsKbSurmnZG/Wp2fnM0+9s138KO/8d6Qvy759Xv4a98Y8n/l6yH/V6/V" +
       "L0ymaEL+mgb+jrh/dio/M+H+/93Df/fecL8u+bf38F+9M+7PPQ5c3nhslH7p" +
       "61Hxt67VX5tEp3kX0fmmqUwm6RO/eA//j/dGwXXJX7qHf+69UvAPvh4F//Ba" +
       "/Z13dhXPn4skeBZV3zGVfzW5duUert8bVdclv+se/tZvSJvvCPrldxG6f32t" +
       "/tkkU8nNzkbvaIm+cyr/YQqtfvoe/v73hvt1yQ/fw9/zHnD/9++C+69cq3/T" +
       "zj48hast+8743x4efuG67+zu7wbbWfj212W/9WHVuU1SdUUbfvHu0dbD62k+" +
       "vMZuSX4uTuE2jJ54YffFLz38wTZOmlefFdx98UuvvfGlNx+sPYM9t78Xnsbs" +
       "OvofyncLKf/fdxn7T9fqV++e7zwT5ev4P36KRR+4Lv/k21n0O78ei+4eGT3J" +
       "o6S98uTh932/+vBZxGNvJf7FZxH/X96V+N94l7HfvFb/ebLvj3B5FrG3j3/m" +
       "bcQ++HrE3r0cengvFvfx4I3qR3eVIvri992eFV17f9DNvDduQcxd6/Yq7ta8" +
       "rRG+/PB+6hTrPD33Lmi9m1x8PzUxNIkefrF4mLz5oYeP5ezK7se/HvoPf/vD" +
       "Lz4xWrz28O7O9PCtD/T067OcJskPadgW+Re/9GpYddNppmHeasUX/Vff8fr5" +
       "5Rv6k2zfbxu5aRO+TdJv9dM33O++VvT9O8h3NMZffhQHPvFS6nEY/+DFdxaA" +
       "B9dA4foe7GNvPZbr1LfEv4/emH7q0fE/6riOfua/HyVXdD5ww+yld8H6m6/V" +
       "R9vZy1es/cmaPYvxN4yGdvahx13XB5ufett/PnD3RN7/0z/78Q9828/q/+j2" +
       "mvfNZ+wvCLMPRF2aPvkM8Yn2C2UdRsmNrBfuHiXeWPHgU3c6dXvLNXm4K7hS" +
       "8uDb7oa/Y/KGd/8Y++Dl8tHpfcubDwjX3mR8XL+9PSb9r9Pub7Y1QQAA");
}

class LinkedListEntry {
    LinkedListEntry jif$util$LinkedListEntry$() {
        this.jif$init();
        {  }
        return this;
    }
    
    LinkedListEntry next;
    LinkedListEntry prev;
    jif.lang.JifObject data;
    public static final String jlc$CompilerVersion$jif = "3.5.0";
    public static final long jlc$SourceLastModified$jif = 1466731418000L;
    public static final String jlc$ClassType$jif =
      ("H4sIAAAAAAAAAK0ZC2wcxXV8/jsfO07i2Pk4F8ehOAk+EiA0OGk+l5g4HIlr" +
       "hzSYz7Hem7PX2dtddufsS9JUQEsNpLgqzQdUElGJSEBp0iJSEL8C/RAKtKRF" +
       "EFLxkSq1aWn4SRShFtL3ZmY/t3emlcCSZ2Zn5r15//dm7sEzpNyxyZwhLd3O" +
       "dljUad+opbsV26GpblPfsQWmkuonP34xdeeV1lsRUtFHqjTnCsNR0jRBqpUs" +
       "GzRtje1gpC4xpAwrsSzT9FhCc1hHgkxQTcNhtqIZzLmefIuUJEidBjOKwTSF" +
       "0VSnbWYYmZew4KAB3WQxmmMxS7GVTIyTEuuO64rjAKYKPusiqbJsc1hLUZuR" +
       "uQkgXO7WlX6qx7rlWgK/OnI2ibroJX+COY5ZcLdvUWzvgWvrHioltX2kVjN6" +
       "mcI0NW4aDOjpIxMzNNNPbWdNKkVTfWSKQWmql9qaoms7YaNp9JF6RxswFJa1" +
       "qdNDHVMfxo31TtYCEvFMdzJBJgqRZFVm2i47FWmN6in3qzytKwMOIw2+WAR7" +
       "nTgPsqgBcVI7rajUBSnbrhkplEUIwuOx9TLYAKCVGQr68o4qMxSYIPVCc7pi" +
       "DMR6ma0ZA7C13MwyFPDMcZF2oCIUdbsyQJOMNIb3dYsl2FXNBYEgjEwPb+OY" +
       "QEszQ1oK6OfMphVju4wNRoTTnKKqjvRXAVBzCKiHpqlNDZUKwIkLE/uVhidv" +
       "iRACm6eHNos9j3zzg9WLm58+LvbMKrJnc/8QVVlSvbd/8onZ8bblpcIETUdD" +
       "5edxzo2/W6505CxwrAYPIy62u4tP9/z2yhseoO9ESE0XqVBNPZsBO5qimhlL" +
       "06l9KTWojS7SRaqpkYrz9S5SCeOEZlAxuzmddijrImU6n6ow+TeIKA0oUESV" +
       "MNaMtOmOLYUN8nHOIvJvOiEl0DW+J/tTjHTEBs0MjQ3RVGzEtLfH0MFS4NB8" +
       "oGv95zm2ysfS1Y3tYNiw3g5z1hcDzyF1dSMlJSC42WG31cHiN5g6uHZS3Ztd" +
       "u/6DI8kXIp4ZS75AHRjJuKx93OsNZu8gJSUc8TS09vCOiW2912y87paWUjAD" +
       "a6QMRIFbW/KiYtx33S4exVSwnz+tsq4bu2jWiggp74Po5qyjaSWrs+74WjNr" +
       "QBSY5k31UAgQBg9LRUNjpaVyGEZmFAQ1EcwAzPaRINgssNnWsOcUI7N29PS/" +
       "ju7fbfo+xEhrgWsXQqJrtoQ1YZsqTUGw89EvjCrHkk/ubo2QMvB34I0BZxg+" +
       "msNn5LlohxvukJdyYC9t2hlFxyVXKjVs0DZH/BluIpP5eApoqcw1YrDepjrR" +
       "N57F1akWttOESaHaQ1zwcLqy1zp48vd/vyBCIn7krQ1ksl7KOgLejshquV9P" +
       "8a1oi00p7Hvjzu4f7jszehU3Idgxv9iBrdjGwcshn4GYbz5+/etvvXnvKxHP" +
       "7EhO8HYW/krg/zP8x3mcwB7idVxGiagXJiw88ByfJAgYOgQtoNhpvcLImCkt" +
       "rSn9OkVT/0/tgiXH/jlWJ0xBhxkhWJss/t8I/PmmteSGF679uJmjKVExYfli" +
       "87eJKDjVx7zGtpUdSEfuxj/Oues55SDEU4hhjraTirAkxYBEnc9lsYi3sdDa" +
       "Umyi4NHhRThulu+33H8g52uiIEiqDR+2xKzOdW9zldeAqaahztFUqGBmF7hd" +
       "3FtF38O8O+BunlOwuctfRq+ZEaZBnl92TTT1YbTlKu4qE1LUUW3Ncm0LonSN" +
       "o2UsHcRNU9zDoT5g5kYQn1fs2Irh6KB1ERW28MX1OcvGVDus2FxPXCrzc2in" +
       "HhndWEMl1Yv3jNrm/NuWRaQgJ2MzLwcVXEoEqqilRnU3wlyClsxxuMf6wvSP" +
       "TqoHpx94ov4nd6wReXRuPkTB7hXnx7+bvPDnL0Wkr8wIx+QNijMIPnVSf61v" +
       "3xsLmwXWgM/J9cfW3bxv/6OPXCjC9kRQf92q1SKzoR00h3XQQxXIH0JJSfXD" +
       "Q6doz0WfvCu83xwxwhWlBcWQqlkKVpVyhMWozbGgdOJAVWOBsUn0y26/5+iZ" +
       "N7tXcw8JqBVLhoKqVdpNQCHYduYnIY+e9i2m5ZGUVK9teHnR7CeuvDUo/BBA" +
       "YPfY/XdXvrf4k3s4255xzQ8ZlwfwuQaG7XJBL49AeWoPEhnU/ozpb7xyfHjD" +
       "u4LcsHUVg1i1dNpTpxubdnF7sfjZl8pTsbvMKqbsb8DFxFd2tD3x7C8re34X" +
       "UDbXIIhghG8U+sR2na+ArwPiBcXkudZkzMwEpLpy/qmhjk9PPOy61QZPKm35" +
       "DIYgg2xWLHy8aezPN2x2cSQEqz0BVreIqQuxaQOnrQo66za+toK3q8LugJNr" +
       "BRi2V/uo2/JQF5nq9sEUX/htnvALp0TfyENyKVZzeZVUJ154/OpB3bnyr3d8" +
       "dj1UD6V9ZPKg4nQZkG3xfgXXOIy73hcjUwKuwwMa1hB6sB4KXwpCh/XFHrx7" +
       "Zvxr73Cv9EsVhJ6bKyw7tyqBKmrpA5mPIi0Vv4mQSij2eAkHd9mtip7FAqAP" +
       "rmZOXE4myKS89fxrlrhTdHil2OxwmRQ4Nlwk+eUujHE3jmuK1UVzoR4CU2q6" +
       "QPaNwbqohPBBBptWBljhsuvkpS0etWlK3JMO3/fgkY6J9x/m7lPNBQ7iZzJF" +
       "VSGE+y1omZRPS5Ok4bxitOQbiJuyQbkyZ9Z8pMSfOLBmE9fZJP4W4EqHkaaw" +
       "Rfi1K2K/2KNjBtLRKM9fLPtFQToYuYAfHuVHUAgK0UTUTEdVvIxGx7tYIGzW" +
       "KUh6nJagd59MfHpo5atPHZNBzCZNodzsG9qy5x8o/cPWqw8KaQfq6WDmwCtJ" +
       "4DIuXwGaxxOHeATgMhnyZNKAMpkjL38fy/79oEyIsJPdHKSFtwuwOVf4NiMV" +
       "VrYfQiwMHP5wwsBcNUPR+UltDFTmFDolhL8MePWwvKnTW/bedrZ9bG8k8Jwx" +
       "v+BFIQgT4GaSjDw2mfd5p3CIzr8d3f34fbtHReqpz7+crzeymZ+++umL7Xe+" +
       "/XyRm6UfZuryDbZQzC1/qRztOr3xMI9odRgVeN6EsIAo+FSXkT81QXO8nMDZ" +
       "uhWbPaCRgue53my/wwIPJNvO3frMd5qcPYKpNo8p8Oh2bskSNAz3+snSpRNY" +
       "6/e5lZX1Kw7ntQrijYM7GYmO/zTHcQn5T8Cmng9/4N22CglOqlOW/6g/fdPq" +
       "57hsa/kZnPlecdo5+bYtgVp78/flP+kVZTGpnj56+/F5/9g6lb/VuNwE73WX" +
       "K1ZH+B6HNSXMl1eeeuZXDdedKCWRTlKjm0qqU+FXYlINd1HqDJp6KmfJvFoy" +
       "UgVtBEe+lziee01zr6cYatpkf+4XDzki5eaEZ+bQ9FuLCTwsuyUd6qZnzeVt" +
       "XAEVbFBzWs/nF7cicu8Q2PdzjYoYkOWnDhQmGSi/m3pl/9UiSeYeN8lYNh3m" +
       "4FZhdkDgy4shCcnUC+O4MSH7y76cMH44KFffoAUXh4uxj5TDoCkj+21F2L/f" +
       "ZT+lMKUY+1Ml8EAxJCH28Z/Uy41p2dMvh/0jQfb5eMw7txLPnQn/NXCmIvtN" +
       "jFzy/7738cIH7EvUPvK18AtA84DzEKdvOlRXyBduavc28aU7eHug0F35/E6P" +
       "vVm4vFiy5ci+H1cf5uI45ibCx8ZJhDi8EZubsPm2n/1wMIrNLzjM9yAQqW46" +
       "EKU7JN2QkicjNbVSuars+7/8uIH9QWweDdj5EU57a6CC55fpOeO90POMd+9N" +
       "ew+lNh9e4l5dbmUQLk3rPJ0OUz0PFQbiMFVwiy74lUb8sqAeOVRbNePQFa/x" +
       "9xLv9b8aas50VteDtXBgXAGBJq1xQqpFZWzx7iW4MLmyAX/EjtP2olh+mZFS" +
       "WMbhCcu1rDqeIbhpCbvKkXzR4EfxN6pX8wtqsMzLs+I3raT6/tIl6546fs5z" +
       "8hI8bkbzIY4e2rhp1wfLRAleDoreuVPm60rxbipfSIN1UBibi6tiQ9u/J/+s" +
       "ekHeI1C9fCwt4E58iAyXc/JeGGSxHvzRLaluJ7v3/Hq0/kagtI9Ua84WO+sw" +
       "/PmrWnWNBnHtEgW6JezxTUD8lfBbQABtsJQuGbprc6Ly7DaX/JVFr7yc4Lr/" +
       "Ant9OzjiHAAA");
    
    public LinkedListEntry(final jif.lang.Label jif$L) {
        super();
        this.jif$jif_util_LinkedListEntry_L = jif$L;
    }
    
    public void jif$invokeDefConstructor() { this.jif$util$LinkedListEntry$(); }
    
    private void jif$init() {  }
    
    public static boolean jif$Instanceof(final jif.lang.Label jif$L,
                                         final Object o) {
        if (o instanceof LinkedListEntry) {
            LinkedListEntry c = (LinkedListEntry) o;
            return jif.lang.LabelUtil.singleton().
              equivalentTo(c.jif$jif_util_LinkedListEntry_L, jif$L);
        }
        return false;
    }
    
    public static LinkedListEntry jif$cast$jif_util_LinkedListEntry(
      final jif.lang.Label jif$L, final Object o) {
        if (o == null) return null;
        if (jif$Instanceof(jif$L, o)) return (LinkedListEntry) o;
        throw new ClassCastException();
    }
    
    private final jif.lang.Label jif$jif_util_LinkedListEntry_L;
    public static final String jlc$CompilerVersion$jl = "2.7.1";
    public static final long jlc$SourceLastModified$jl = 1466731418000L;
    public static final String jlc$ClassType$jl =
      ("H4sIAAAAAAAAAK16W8zj2HmYZnZ3Zr3eeC+tnV1nd/3bnhi71mYoiaRIZuIk" +
       "ulASRYkXUSQlGs6E94t4v4vOBk4Lx0ZdOEG7zgVpXCBxgSZwEiBAkIcigF/a" +
       "2nAQIEXRJgFyeQiQFokR5KHNS1KXpP5//n/+GY8fWgE65+ic73znu/Pw+/TV" +
       "b3WeSeLOWRi4R9MN0rvpMdSTu4wcJ7o2ceUk2dYT99UvdYF3f/7HXvztpzov" +
       "SJ0XbJ9L5dRWJ4Gf6mUqdZ73dE/R42SkabomdV7ydV3j9NiWXbuqAQNf6ryc" +
       "2KYvp1msJxs9Cdy8AXw5yUI9bs+8mFx1nlcDP0njTE2DOEk7L64cOZeBLLVd" +
       "YGUn6b1V55Zh666WRJ2f7NxYdZ4xXNmsAT+wuuACaDECs2a+Bn/OrsmMDVnV" +
       "L7Y8fbB9Le186PqOBxzfIWuAeuttT0+t4MFRT/tyPdF5+USSK/smwKWx7Zs1" +
       "6DNBVp+Sdj74HZHWQM+GsnqQTf1+2nnlOhxzWqqh3tOKpdmSdt5/HazFVMad" +
       "D17T2RVtfYv6oS9+2l/4N1uaNV11G/qfqTe9cW3TRjf0WPdV/bTx+Y+vfk7+" +
       "wO99/manUwO//xrwCeZ3f+LvfvTtN7729RPM9z0GhlYcXU3vq19R3veHr03e" +
       "wp5qyHg2DBK7MYWHOG+1ypyv3CvD2hY/8ABjs3j3YvFrm/+0/8yv6399s/Mc" +
       "0bmlBm7m1Vb1khp4oe3q8Vz39VhOdY3ovEf3tUm7TnRu1+OV7eunWdowEj0l" +
       "Ok+77dStoP1di8ioUTQieroe274RXIxDObXacRl2zj/v73Ru1N0rf3ve/0na" +
       "uQdYgacDjq4BRRAfAMc2AK221Hbg2soPJLHajs9t2D/UZl6v363nwv+37WVD" +
       "3fcUN27UgnvtuhO7tcUvAlfT4/vqu9kY/7vfvP/Nmw/M+JyvWh01npOsL3Hj" +
       "fhofOzdutIj/aWPt1yGef4v71PLHP/+Rp2ozCIuna1E0oHeuG+WlKxP1SK4t" +
       "7b76wuf+x//+rZ97J7g0z7Rz5xGveXRnY/Ufuc5kHKi6VkeVS/QfP5N/5/7v" +
       "vXPnZqPC99TBJJVrddee+cb1Mx6y/nsXkaQRzM1V571GEHuy2yxduP9zqRUH" +
       "xeVMK/33tuP3fbv+3Ki//6f5NobSTDR9HS4m50Z69sBKw/CkuUa61zhqo9Yn" +
       "uPCX/+gP/id4s6HkIsC9cCUScnp674pTNcieb93npUtlbWNdr+H+9BeYf/2l" +
       "b33uk62maoiPPu7AO03b0CnX9AXxZ78e/fGf/9lX/uvNS+2mnVthpri22lL+" +
       "Wo3oY5dH1f7m1j5fU5Lc4X0v0GzDlhVXbyzlH174/v7v/M0XXzyp261nTsKL" +
       "O29/dwSX86+OO5/55o/9/RstmhtqE+8vxXEJdgoi/+QS8yiO5WNDR/lT/+X1" +
       "X/zP8i/X4agOAYld6a1X3zg33oaol9PO+xpvaCL73ZWs6G7LbLdd/FjbfrzR" +
       "abul064BTfN9Zbv2/nb+dvJonJ01D6xLE5WAr/6bD05++K9bXi5NtMHxwfJR" +
       "TxbkK94z+HXvf938yK3/eLNzW+q82D4rZT8VZDdrlC3VT7tkcj656nzPQ+sP" +
       "P7lOYfreAxd87bp7XDn2unNcRpB63EA349tX/aEWRCukD9Wyra3oVfC8f6VZ" +
       "fTFs2pfKG512ALdb3mjbDzfNnSsCfi2tT6tvGa2/nJymafuPHlMb+KvceY8+" +
       "5pgfbBqkRhfGev5kdK/WaOrBq955v3sMuk9coNPkVL4wn5cfmM/SNk4SvnJI" +
       "y095o/alZ8C78N1e83v8eOafaobfXztd0l616h2G7cvuhUi+13HVOxdxRaiv" +
       "XrXp36nPvqDjxdYBWkJON5THUFHb6fsuwVZBfY35wl/+7O//zEf/vLbLZeeZ" +
       "vLGZ2hyv4KKy5p7301/90uvvffcvvtBGh1pC/GdusD/bYCWbZlrfgRrquCCL" +
       "VX0lJ+m6dWddawl81DmY2PbqKJafX0L0z7/7L75994vv3rxyU/voI5elq3tO" +
       "t7VWNM+dmKtP+fCTTml3zP7qt975D//+nc+dbjIvP3zvwP3M+43/9o+/f/cX" +
       "/uIbj3loPu0Gj5Vp+sI/LKCEGF18yJ40GRRquRNQwEkMuofYA+YAzVDdokeH" +
       "Lm6PevT80HVhE1oQbmxV3L5CFrqHMLuBlmpaZiQctuRZPKHClRlVrMbj7nzJ" +
       "4eOwZ9fdCp0AmxGZkpsZPluVBy7qy6IPcRvOmqUrUPL2QArqnqtOOGkg+XDc" +
       "hwFA85AEr0LqWB6lwlppIK25Di9r3SBUEmEwnIeKyxgJK3qHLPAZECo1XRf6" +
       "brLh09kicrb+JKE2PWczjkI+mVeb1NH7ZjiBynBUxAlXbbGZNVH71sI8lOxW" +
       "paw0IqRq5ekGkfFL3NbGDk0WW27WEzhfEfd7T9ILiByNQZEtPW9dcshc2BLH" +
       "LZ5l9BCKnRG5J5kssSNlmdR4V7yUbTL2YO5oRHR3w6hEYlc0SYD2iYGtxMFy" +
       "153Qe1hSV1rOi1Vuinm8sAM33Q0OgkMNPZXoUSIkT2knJMp1RVEUo4gaRR6E" +
       "rSFyZM165GKRHHgJspepEFvOhpsyKWZLuR9p1HQhrI0yAPvbdD/B89laq5bj" +
       "pRltpJngDWwImYkeNbR9MKqOKVmsaaIYdMXRBvG3JpNE5lgVCCSWHX5csx9b" +
       "h9DFeaLI6BLbrvYjciLM2XiIBlBUS2JPMMJERUJ7ut4MPbknjZBJH1wXxxkz" +
       "XavSbBBMCF5TkiO7pNcUoYDaPnEHsx013uOmgxeM0qX3tf1UbD8gh7SxDi3B" +
       "yaCC2gTbrU+SkZNvdiNhXE1IexFGLjWVeLIgDiscyATL1nJ7M5p4Q31BBQnm" +
       "gFVlYuLKg9HuKlfWZLz0VQBlBcHlckUD0PpVD1UUN1QJfMtrU1jXyioYAOIQ" +
       "7sGTsohHe4Y4DgcZlDIYUA2OVqIHNIZzeG8XCWOKkZIxDUe2Z7mr3tDFyK0Y" +
       "OBzCbeQoPOzjCuNgbqLTuOSOyqzyNM12YsLjh/4wKLpbnSBHvYDHOWFNyeuU" +
       "9ujVnqdQf0ET+TKnbdztTcXuEki3zmKLj5Pe2mHBjTCv8HRlLHrrGQdRYzSY" +
       "5xhceYNjYnD9PZjuKbsATbjqW+q0Os76Grd2l9wEGohzsK8ubAo2h9lC4kAp" +
       "1TJgOCXQw44IIYlD4NFi4ywzssRAOqGkDDWXHK+iW66H5RPaFgdYf3BEkVAW" +
       "eWc0lYfsekPMFBEg7X1agiAH6aXAFX7VTZMIUrKBI9qmGSIQE8DR0ZE5MU66" +
       "CCQ6VMyOuT18APv8yGTHJrba8JQTysJxjkvebMT2cbUYVYy8ISgzSShfTGiV" +
       "JxBqgDEc4GSIoRhBt8St2BSTHRst4zRg+3spibb8vEAxPHcm8eJwADIlGLDr" +
       "fAxCRG8slWbXq5HBKzewyjw7LLXjfoKlA8udlUdhRzpC0ptKC2DsZkTIwPoo" +
       "DCK16O/jqR468YaCkVlfPohpSuOcvJDZflWoq+jYr0IIzTUgP44nhI8cYrZ/" +
       "SFyEpM2V7iRWlAkYg8r9wO71QmSRO1UGGYiTVLrFg4Rmljlmj2PNmRdqYvnQ" +
       "fK9UcBfQ0zzf+TlZLhgEt2h0sReBQ2wCFYOWoKcWY8TWhHJuy+ZuaRcoOj4a" +
       "y5G5p002DSgrzNUV4U0Oacz5GF3HCKAHpKa9WwCOKy575dgqD5a4TBIgRQmA" +
       "8bxU5+azIYJlS88hBbzcG66NIvqSnDpCiVTzNOQ1Djey0gHoTE9gmJviPGRZ" +
       "Tixv7Xh0KPdj3FcxN9nbYKJNZd472hC1sDZbK3OzLgguUBMeZDaB29F00x2U" +
       "ZEVrIlbVL3ujSJatKp3x0XzszRBLA2fpDERplO6OM9+li/qdythEXQmXpbHv" +
       "YoPtdtvfK1uXzKAI7694XgQp1evV9wGOCgZ8slA3FI9V02ALm/Bhz/p9IxkQ" +
       "sTUkx318Iw7Q9a5Pq/lcmGbJYFYyu0lcqQPbX1i+JuJrt7/PwdpEPYDKxI3M" +
       "msvBuloVqrDDAzyKbHfj82DhHiduUpbZ2hgWOcdso2ARlhgU5JCvDYuNvttk" +
       "zGE7RqydXyJdJWem/qonHmK0IMouS9nOmmB8gTOG/Rwsk5VX7ERzDSwx1RBB" +
       "pcyBIV3T5Uyww4Y1sEHU58gq2PR6Frhj2XJHLHrLJWfspuxQC6qeaOSTDAXL" +
       "oiws0R2rIhu5B1IIhaO1FoNKmZsavRwJIj1OeL93HAwBuGtLFJLu1AJdRmNh" +
       "ZQVkJGghxU4Wey3b+8S+q2P2wIOlOS+QWKov/A0y0bN8ygfAeFxHRWMP7LRd" +
       "HhvQAUygAQyXFYtKbmEUGSvPkd1yvIKwkS4GDG75PBBUoYKUR2PhTDNopSYL" +
       "XjD7dl+jwm1YZormz5DEcCQXDbeJkq/JSEkUdDorZ9ognYIlMkFjHYR2/FTZ" +
       "EYRlWnOU7yabgS93R3HB2GN1d8g06VCtCzxchUcg8izngDEMfRz2WYkhPRCe" +
       "EnvTHJTianFEZb1iqEE5UDkWj6reWKhfyCM2K2WW9mM2GA4ruZsGJBihq8xc" +
       "UvF4Yw8EIKufDEt2BvsRluD8DrBSPx+twt7WOOLUkRSkSpcEftmHIYAOx6Di" +
       "H2NQQzWnz0+HAlZTYUI+Kx3mYGmYux1NHBHQUh2+ILOiWMt9azxMxhC5K8KJ" +
       "Bexmi7hEpLyMEXCSY3giWMuhQh4LJD1GY9KLwxHsMYTdE3LIYznbGeijw0LD" +
       "vNQOkdkoGjGxJ9E7HPKOJIdiRhnXt7WttrDdAV0W3oaFKLc4dHU+cxY46HgZ" +
       "2eeF2sagCT+IhiwjU4USBRYzHo/DVBy7jpVk+SHkenoquiS4XNMgYJiH/XCJ" +
       "lYCHuAw1ZhFbqpYzgZvj3WM/8KQNw8H0AVJKO6VZxV5mR1Y5HCVMQsM1Z9Cr" +
       "sYdjhrRkIBHCo8VBlouNYffJAQkMSMoZp6sNucaMFZPO2G2wz/YjY5EJi/qZ" +
       "Qfb4Lb/FNSEnynmJpHtiXokkbw39pWxqMLY2FmEAyymzkKj6oiBRgVYlcyw6" +
       "wiUaACojRgVKyqwRDcWpV0zSJTQlsl0xl8uSXuijrbm2/KNEkaN1eHBWIGoc" +
       "AQQL8CORLBltQXKztMgKWjAgyl4LQrw3WLtYLxi4KJKxSvHMpsu76XS29WbT" +
       "wLVW6FpnxCIn/a0IKLoWS5gyRw/osijz7nhGsOYWmsucMy0GnqHBITghqhjV" +
       "QAOEDCVdbPQorJCuGlf60ZO63W7mrZCd3gV2x4035A0pi49TRWKrSR+INlVK" +
       "x2C5JrBA25iCTg3x+nYfdGfc7rBF++yORv31VMosUWHkycbMdBj0jkBREMyS" +
       "ymnQiNcaHKnMngypAA1R2hooyYGjRhXYTXwu3FD7IaDDrrTrkwXip2xsO/s1" +
       "Mt97NFBtFyrrw1t04vkmBkDUYDAxXTpyaREYmoChMRGMWIkMHCSfcXVVC+Cu" +
       "sk9NIURQwHCZ7kGQtvPQd+BhF5jBAGYOXQUQMqrAEVDckX1p0R0PFxS3q4O0" +
       "ruuZtJtqukZOxE39NHC8XhTx3dlu7xKU1l9E02U4JD1jmc+CI28K6RjXu25l" +
       "63qvX8VDdS+n4cHoQrtpdbBhXcalrsJis2w12RZJduS1YST5lS6kuxEuKLNx" +
       "JSZAHaVUW81QdsBolbMP9gda9KcW6805G/DA0AUw3ub0vU6h7p6yQA+aSZZ2" +
       "mJpHKKlfMHx+0qWhNbdAjshQXS8giJwZRjDidxZUP1rh7TSYHJzuoD8brABD" +
       "2nbdNcnvu/21i+KjcjlZDFAJ4I9QPxxo69wCeg5rKLC+rmNCuWJ81geo3cQj" +
       "8pRyZlVtsgiIqsQCwXOeyck+OkpHKDStcFLLaXezO461TM7VASrziL7IzN4M" +
       "hAF8yOSCB+Uz+wirdnfRVw04IyDYViYlKi2tqY3iUqYkjDfwgX6xJmJqVTlr" +
       "7DhiIxEa4iSPLKkBe7BVh1IELpObKx+AZsQCY8VCn2oOjPMwIg8nExg2Qlqn" +
       "sR5Dr7UuRulF16UsTIdcWFM8nl0dwJhZ9mi+6jGzOnysZ0JhHxHI5RU0iUY6" +
       "LWwUSmfYmQyUWLnKMQWV5QTuCak+TXdjczeaj5dRv2SjcCaJVYnYIrReecfR" +
       "DsCdlBnUntn1pBknrpVaN1k/nkY6oVjhRMnJw67aQLhRUsNwhxZplNRXgKRL" +
       "gPV1ZwikhDuEoaGRwBVqEahyUCpiD+mD2Ar7hbHajFx9GsR6JjDesBeXih0a" +
       "HEH1+bGt2MPUZrEMWALdRD8sdKI/wYxJkUI4jNqj404Flvp8zpWLvNqsZDdb" +
       "IjkILKIecJDNlMB4GYVEupsU9Z0tFn2RGvuLFDfF4VKvyi0/RV1jrLCjcZos" +
       "2WyuhLE6XB2RqbwDlsIsRo4qtIqBkZ9idOXYi/p1v0kDiOdJkJfaFM2DipJj" +
       "G80C8WjS4JROkh6fB7qZdm6HsZ3LaZt8mF8kgN6o8TU47zfZivvXMvf3Vw3U" +
       "2+1R7QbkSn6y02RHXv9O1aM2M/KVf/bulzX63/VvnufgtmnnPWkQ/oCr57p7" +
       "BVVTO/zQNUzrtmJ2ma/8tfVXvzH/mPqvbnaeepBqfKTw9vCmew8nGJ+L9TSL" +
       "/e1DacZXH07YNWWZG53Oqy+e+le+fTVh9yDXhzwhkWs/Ye3QNEbaebUReiPw" +
       "O9cEfudSq9oDwm43+z/WORWKOhd92nEerQf84FmUyYkdZUGqv3lKs5/lga2d" +
       "NQfafh4c9KluXKmJvPnW2adTy07ufkeK3nzr3jtvPagztLbVNB95QF77uXWd" +
       "vGY1CMMnCCN5wlrWNN6ppvRYuttdzHmSrum4tPN0w+k12T3boHzpUdn9yHeT" +
       "3clVrgrPThthnX3yU9zZdYFcd7YbzfBT5cMiuv04Ef3EE0X0U09Y++dNU6Wd" +
       "Zy+oa34X19hvD3/9EfZvcN+F/VOy+OzcgpQgcHXZb+Vw4VuB8eYn20xyM/tp" +
       "2VPeaTO7p1Fb8miH7Z7V22fnoHIuX4c9JbdPwMGnZrWIbePszeDMfnDQ2TWT" +
       "bLRwbepMPfvE2ZvX4YJ7ZyeXP3u4GMM3idnE9k1XTwP/zbfu6lFWq9vV/XQb" +
       "vKnefXJIfLtlqfaKc9yG7Cb6Iz7ySPxt8/BNMzsvfD2s2puXUG8/Jvl+klK7" +
       "8wtPMIqfaZrPnqpPV1T1OG+5fa7VqxZzUWt85cJSLiaa1df//zHYNP+yhfrF" +
       "JzDzS03zbtr5cMOMKifpd1TK6QHVVDYfnm9KeK888p+U0z8n1N/88gvPfu+X" +
       "+f/e1ncf/Lvh1qrzrJG57tXC1JXxrTDWDbsl79apTHUSyr89OWKb868jUdO1" +
       "PH35tPwraeep8wf3r4Yn7v8vWTHA5TMjAAA=");
}
