package jif.lang;

public final class JifInteger implements JifObject {
    public Integer s;
    
    public JifInteger jif$lang$JifInteger$(final Integer s) {
        this.jif$init();
        { this.s = s; }
        return this;
    }
    
    public JifInteger jif$lang$JifInteger$(final int value) {
        this.jif$init();
        { this.s = new Integer(value); }
        return this;
    }
    
    public JifInteger jif$lang$JifInteger$(final String s)
          throws NumberFormatException {
        this.jif$init();
        {
            int i = JifInteger.parseInt(this.jif$jif_lang_JifInteger_L, s);
            this.s = new Integer(i);
        }
        return this;
    }
    
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 2147483647;
    
    public static String toString(final Label jif$L, final int i) {
        return Integer.toString(i);
    }
    
    public static int parseInt(final Label jif$L, final String s,
                               final int radix) throws NumberFormatException {
        return Integer.parseInt(s, radix);
    }
    
    public static int parseInt(final Label jif$L, final String s)
          throws NumberFormatException { return Integer.parseInt(s); }
    
    public static Integer valueOf(final Label jif$L, final String s,
                                  final int radix)
          throws NumberFormatException { return Integer.valueOf(s, radix); }
    
    public static Integer valueOf(final Label jif$L, final String s)
          throws NumberFormatException { return Integer.valueOf(s); }
    
    public int intValue() {
        if (this.s != null) { return this.s.intValue(); } else { return 0; }
    }
    
    public boolean equals(final Object anObject) {
        if (anObject == null) return this.s == null;
        if (IDComparable_JIF_IMPL.jif$Instanceof(this.jif$jif_lang_JifInteger_L,
                                                 anObject)) {
            return this.
              equals(
                IDComparable_JIF_IMPL.jif$cast$jif_lang_IDComparable(
                                        this.jif$jif_lang_JifInteger_L,
                                        anObject));
        }
        return false;
    }
    
    public boolean equals(final IDComparable other) {
        return this.equals(this.jif$jif_lang_JifInteger_L, other);
    }
    
    public boolean equals(final Label lbl, final IDComparable obj) {
        if (JifInteger.jif$Instanceof(lbl, obj)) {
            JifInteger that = JifInteger.jif$cast$jif_lang_JifInteger(lbl, obj);
            if (this.s == null) return that.s == null;
            return this.s.equals(that.s);
        }
        return false;
    }
    
    public int hashCode() {
        if (this.s == null) return 9473621;
        return this.s.hashCode();
    }
    
    public String toString() {
        if (this.s != null) { return this.s.toString(); } else { return ""; }
    }
    
    public static final String jlc$CompilerVersion$jif = "3.5.0";
    public static final long jlc$SourceLastModified$jif = 1466731418000L;
    public static final String jlc$ClassType$jif =
      ("H4sIAAAAAAAAAM1dCXwVxf3fd4YAckTuKwHCJUpABI+ACgEMNEDKJSIYNy8b" +
       "ePDyzk1IQCoqgoqFqliPKvWs2FKlVqvVqogHIvUArRrvYts/Hmix0qqt5T+/" +
       "38zuzM7u2+wLVOTzYWYzO7+Z3/x+398xu/t2tx5QQpm00ndptHaE3pTUMiOm" +
       "RWsr1XRGq6lMxJrmkKaqyNe3/7HmxvOS7/uV8AKlTTQzN55Ra7UKJV+t15ck" +
       "0lG9SVc6VSxVG9SSej0aK6mIZvTSCqVdJBHP6Gk1GtczKeVHiq9C6RQlLWpc" +
       "j6q6VjMlnajTlf4VSTLR4lhCL9Ea9ZKkmlbrSpCVksqymJrJkJHC2GoM0iaZ" +
       "TjREa7S0rhRWEMZZ75harcVKKtm5CvirtDGtFBnDs/XRxeHIdHXXDy/ZdMMF" +
       "nR4IKB0XKB2j8dm6qkcjZYm4TvhZoLSv0+qqtXRmQk2NVrNA6RzXtJrZWjqq" +
       "xqIrSMdEfIFSkIkujqt6fVrLzNIyiVgDdCzI1CcJizCn0VihtKciqY/oibSx" +
       "nHBtVIvVGH+FamPq4oyudONiocubAu1EFm2JOLV0rRrRDJLgsmi8BmQhUZhr" +
       "LP4B6UBI8+o0oi9zqmBcJQ1KAdVcTI0vLpmtp6PxxaRrKFGvg4B7ZR20FBSh" +
       "Rpapi7UqXekh96ukp0ivfBQEkOhKV7kbjkS01EvSkqCfAzPGbVgZL4/7keca" +
       "LRID/tsQon4S0SytVktr8YhGCdufUPFTtdvjV/gVhXTuKnWmfR6+6ODZJ/bb" +
       "/jzt09uhz8zqpVpEr4rcVd1hT5+yYacHKAQTmSgo37JyBH8lO1PamCSG1c0c" +
       "EU6OME5un/Xceat/qX3iV9pOVcKRRKy+juCocyRRl4zGtPQ5WlxLg4lMVfK1" +
       "eE0Znp+q5JHjimhco60za2szmj5VCcawKZzAv4mIaskQIKI8chyN1yaM46Sq" +
       "L8HjxqSiKMeR/0pf8j+P/L+c1fW6UlqyJFGnlSzVakqWJ9LLSsDAaohB40Es" +
       "Wn1SJh2hxwAY4i2mEjwu1tIjSFvyyMgbgbtOy30+Irg+stnGCOLLEzFi2lWR" +
       "TfUTJx+8r2q334QxW5euHA+eDMYewcdWfD4cswsAnSqCiHEZMUjCWPthsxdN" +
       "u/CKAQGCgOTyIBFCgHQdYHGIZdxqp6IDixDovHpW8sINY3qP8yuhBcSxZSZp" +
       "tWp9TK8sm5iojxMH0MVsmqUR3xBHj+ToFfOSEaTRle42f0b9GCFL80GArDeB" +
       "a7FsNE5sdly3/5/3/3RVgpuPrhTbrNpOCVY5QFZCOhHRaoif48OfUKQ+VPX4" +
       "qmK/EiSmTtamk5WB5+gnz2GxzlLD08FaQmR5tYl0nRqDU4ZU2upL0onlvAXR" +
       "0QGPOxMttQP8DqQHvrNZPRTOHp+EsgtFE6hdWgV60vGzk7e++dJHo/2Knzvd" +
       "jkIQm63ppYKhw2Ad0aQ7cxTNSWsa6ffujZXXXX9g3fkIIdJjoNOExVCWEQMn" +
       "oYyI+fLnU83vv3fXa34Tdj6dxLn66lg00mguEtqVtmxxQ1jdX1gkmW0w54c4" +
       "ihhxVoTdTPHceF2iJlobVatjGuD8Px0HjXro0w2dKA5ipIVKNa2c2PIAvL3n" +
       "RGX17gv+1Q+H8UUgUHGZ8W7U+x3PR56QTqtNwEfjJXv73rRTvZX4UeK7MtEV" +
       "GrojH5UBIerOTQ/RrtVQV333lq33lba/927UWD5aB4nluIreRFFAYfzdFnV/" +
       "nCnGbiDGIia+8aweLWKFzNuLz4uDE5YXIwNVkS3HPbv7QI8pzyPI/ZGorvS1" +
       "W1CNaRWlolMiQK5PkgCIFs6Y9TeQIfrIQ8xTLcbXXeaHMRNcVFTzRdGA85GZ" +
       "djVaJpKOJg2IwnSZaF0yRhSnGdOF9cQ0oggzXUqr8UyMhBfqXObgycmNyTQE" +
       "6wY1jRpH2Q1sBLibbFRCFlYVOXX9unRi4FVjAbpWm+zrJOczRDnryjRYdV0i" +
       "nVwSjRThwooStUXU/IvU9OL6Oi2uF2WgUUiWioZWg/y0miK1OtGgFVU3FVUM" +
       "gyHPIJobhCwaqxpRpsbjCV1aW1UkHIk+dKCk9lsa6gutNLbe40aWra065Tcv" +
       "+plNd5djR7maWUJs/83YGwuuf/eEfnRUwTew849Ouvz6nz7y8Ck0vLQnMul0" +
       "FngrhQmvSCegN9cgaLssgaqI6yh1pvtpL095Lzyybi1a33GYFRuQ0ZWeQvCo" +
       "FE+V4kynmmrqB7MXMvWMY3WpVU2UiyKcQiOpYFEFagTSsiKHEAsikkSKLIgi" +
       "fbPi283jX3/iIRQpEPSUoMWjythdvwy8PG/hrdTWhajSQ1gjBGYhG2VpcL9s" +
       "UqBZcKM9tRDsripy8i/rDvkHhJ/1K3kkqiMCiQ7mqbF68PQLSPqdKWONRAOW" +
       "89ZUmuaNpULKOlaKeaKPCAIr3HV1sOqqhKVnN7B6ragrRcGDSiQZgOUgKIbS" +
       "ZAYOh5HQksFtjU5YiMbVGAsxh8k/H/n/X/gPM0ED1GQtZSwZLTKz0STJr3wV" +
       "GXviXZmO1pEo2cASb+2KTVcdHrFhk1/YnQy0bRBEGqYb9NpQzAOH3N9tFqSY" +
       "8n/3r3psy6p11PgKrLn25Hh93a9f//aPI278YJdDohiKGakU5Ah9skARpxnw" +
       "Yd66qfunkcgTwEzPNE20SmyaGrc2tYtmCLvxSDRJZA2TLCLZRcSgo37PpyjW" +
       "mQmgKxIRNcbROOfqnW+MvWn/tcg/57i3w+ZHoozdFdtZ8WXTS4aTnmENhgOY" +
       "1Z/lFAx9FFGaM6J8cDgXB50HRRl2GAXFaGydgg1ddeYN0VMwN4EeG4ql2HMk" +
       "9hyOJWBcwQkow3XoHUneLp8kMustO8tKNZpmLrLbFwNKklMmfYCuoy0x0NrK" +
       "BMmpmiDgysl1mXkWMmzYWC82Ove1dZ7KTzOHCkV/4is71dA8vyjJIhqcSEMi" +
       "KHtExqXoFW/tesMfCn517QRDUWeCZ+wnL3CWppKdD529KvLF5re0WWO+/owm" +
       "r4nlcflaSNLAXomJQriMksZRYJblBEE9bFJkw4/98W33H3iv8mxEnZBOWN0v" +
       "u94iCKQDFQiUK6x7KJOfEXMSSZOlqsgF3V4Z3ucP510pxmSJQOi94d5b8j4/" +
       "8evbcNlmUjNQSmpMAtfEBsrTKb+YQ1sUJTIp6qp713dfe76h/DPKrqxdJ4qz" +
       "Tu7yxP4ePVeymAcTrmSzQnWxo7LPTUd1ruyiERU7nsyb9YKgbNQgEcFy7Ej1" +
       "CWUjV8Dl1pyCy3NiQtcTdYJUxw98a2npt3seNAB4kSmVYdYFSpSW3OqEx3pu" +
       "eHv1TGOM1XSpa4WlXkGbEtS9o4O5GlvoNvhsKTfCxgbaGcqNfMB5lgEdmtZw" +
       "sk1c5PNMkWdp6mXfW7bHbRmtF9r3lugfoRhs37EByfmsnivu2Kwuz9j3oA+1" +
       "+ug+jLqO1YstGxaoTjEJejoRLLWmdDM8Zd4NkMp4zb5vRwbGO2oQ2m4icRYH" +
       "xB6TTHZ7QY/ejM0Yq5cdYQYKhFOFXChiD3kwTcZJnCzk/cpbyPsFD3m3Yes9" +
       "2HCegKmFuhIgAQWFBMU27LfZJeA9iAJzCnim3dyMHfHv31HbSXI7oScf4ei+" +
       "2Q54a9MaTvY4t6Wb7eZlNnGrlYxlAL2i6HuE1bfnZixAchurb26VsRQy6odY" +
       "vdXFWPo4ETxgRV8bMZa/0ALMd+Amzgpx3Av3Y4M/yOrf/m8h3p9N87CTEBjE" +
       "X/MG8Zc5xHdh6ytGVteJZ3X0dgFKCIpm7LjTk9KGA79ljM9mVj8lo+YFY9JC" +
       "PumMergfMwXclj65MaLhtQ/s/Q7qwtWCnuYWtM9mQfTkX7i5PG23oKftFkTJ" +
       "PuLm8rTdgp4WLegF+kcP82qzdQ8wBe4H8Uw+smL83679b6oYdx8dlqhkr0F2" +
       "QXD7SUtj1mr+RTJuefNb2tK2QZpsQcnWW3qVnfkJpn584w3UhdI+orMB8Hyi" +
       "ue6sbuuAuC+cEeeHw2EUdlaP0IkNlk9r5VthUNPSRlkZ6c1oujgxIpkmBste" +
       "rOPxrC44ItMEsm9E84QC428nKgR68nOThx7AQyn5X0AkUc3qsyzS85kXm8Ut" +
       "VMG+2+761yXrTvPD9VMaXIlaO8n2sXbr9X3bbfpgPSaeq8n4MOh/3a4RQDHH" +
       "SR3dGXdnsnq4RR3506fOqJo3oWLuZEktPQyPBDTlTiukZmkS9HYimCgSQOXL" +
       "95I1+vA6iu840wJJg2yUUtMaa3woYgycw+oyyTf5CqhTsFL1Zb0nOVFZnIlJ" +
       "V+g02xQHOii3IaR8giAcIEUg7d/M6pUSpIBQufjw4cNw0KvVeIChV7BaTKQA" +
       "DxPmu+MBaNY4sZcNDyLBj2x4GOgJD8WosyFc+cV2PBS3hAdg4DJWXyzj4cRs" +
       "eIDeq52oWsCDONulHvAwsDEHR4v/QFhwPVFn9RJhFiFE+WxPiMyur87owj36" +
       "+UPnPbWmZ2Y93RgPM2OM1qiPQBfKSGW65jcDJ7fTizfi3jZYrWbw+lwbErQy" +
       "0FNXirI/HYJj0QsP7cxl5RmunWSVPpXVM3TljFxvS9PLt+ym9hFQIzRKjTSm" +
       "QAwdtBPel7bJtirS+fSfVddeevZOjMQdURx47Wg2Fcxg64VwRlQ829rP+gCM" +
       "ozaqIvvv//Hz/T+edzw+2WAIXrwVOl1Nlsq3PuH2BmkP5b311NPdLtwTIC5L" +
       "aRtLqDVTVLyLrOTrS9JaZkkiVtOYZPboW94G4KgY2eAPrKZ+IlNXhtXVILrx" +
       "CO0z2VVuX7lHjwXlPLhaDQfnAyVGHlXKBKbAvOcw3NzP6vtEW9OV06TLtrnk" +
       "BL7pYk7QCBdVip2ULettVGlkxo7E6cNQ+WF9STRTPBJvtTrovJS6wckweN9s" +
       "j9Hgdey7Lt20uWbm3aOMqzSLiLfWE8mTYlqDFhPsvZ3N3qfjg0M8TTz19knF" +
       "fXakNhy9Zx/gz97OjzkUSouSmbl3+tZd5wyOXEsSZPMJB9vDUFYi+Q4tnXWO" +
       "5R5MPxMlBYCSYhrCAo+yeovk/40dbnbvO0eKoywoBu5hdc4b30EwylBG/QSr" +
       "H7NFilMAHhGC5LmeLgBFoZE+KVakJ+gWz+EC0Mp9V921b+21q2BpvhqXDTKm" +
       "HPOhWEjlBIeL3BZI+RV5h1JDmNcmj+l49ruHc+PL4onlcRrPZrfbWn/Z4ye9" +
       "aVgYu5mF8+nSkMK1H3y2xXe+rrQxBA5/NyiKfSfrcLmYccDuf3Qp+fTWmV/t" +
       "22awcCpdGbv4PJ4ud6XUSDxlVMq+EFwnMFBtdwIX2W4aNz4IeIqqmRn7LvGU" +
       "kF2Ka15r7qxJg7zZlprWcLL1PGm71J7HWZsitIluRn0/cbZS8fIHCAMOttkQ" +
       "A8UmRI3j4uAMpFC+61AMOB0OhGcSLvq/AfUPRZNk4+h7ejPx/8bJ92TDNZRp" +
       "thaBmWa36yPMBDJUcsK1EQAL18tCu6oW2lWFY/nu4npZaFeV2QTl1XZuqeiW" +
       "uojuV7Lo4PAmV6nUHXupPJyTVPzRIU5iUV3E8oRHsUCxvQVIOzDgSV5w+Iwn" +
       "Z0CFsrN1svxjDrKkzt5qXUOohQW7sloRrQvKVkV2MlLgMKu/EEaUdOanQ0lW" +
       "D0FdGcH46cPqbiJfXJHNniN7RojsSXgMniSqLUX2tzxF9r08cr7qtkDKr8g7" +
       "lG+jVb6TPJbjwSmEYgMO8bFz/OcdPoViD9wnYIJMZYvYKSPe7nUKwnstQTgj" +
       "BWHEwUim/35OOIAxLoPiS0+GdggJvuJWdchuaIfshkbJvuVWdchuaIfsUfcQ" +
       "i7p+v6eoi6ebbdqEAcKo0awu6j3oE0Ix4HR8IG5TJ0PvMUyGA1ld5GhT/nxi" +
       "U+d5sqm0WhNtzNGuDIUDv/t1JYRjSJpHbksZl8OcuDU07+/gRfP+jkDgLzDV" +
       "TBpkzUtNazhZd1PNRh9B81JThDYxzffxonkqAfhjm6gDKNtBAev2t3fXfiGK" +
       "AqdMmRHyr85mLCFjMowUYTL+IatHW5Dh8MzRtETUyLk7t3n/gwPpAWONZ47q" +
       "kom4xva4A0lLHEETXcGeyJUex1zgNH25OD0+LSk9bmJOLz6H8faeN35xx1Xt" +
       "ai0PEw1q+fnu2Zq+uu+1ezb+bPVcg/REB3H7s3lahmR6eflLbvGiIhEO7a2g" +
       "5zqjT4S8jy0Doc8eKA5ImsJ4bfjB9k7xGrr6+R3mrk4EAUm2QEKN0j/8WKx6" +
       "m2sytTdb8rlXTD732v34Xrsfx7H8k7nT3mv345Ym/2Aohh5rKVnJU9y70zHc" +
       "xvvQPh73Dx+4+QfoO6jxKErhQ+9ScOBatJBzZQuBxtECr2O+D7x+17hOf+e4" +
       "PlIpkZ1VZkguwIbikpR7NNSVME40xAnxb+SIeKjWURllTTA8yg16Xp1yz+Mk" +
       "gTiuf2Pu60fiddx+LvdgP1Bdd/RWfuNRWPnPWrny6zxbI/T+uZd8kpncHa2z" +
       "1HtaYalQbT16+vjNUdDHg63UBy5DvgwBd7oLSXayldW3ppSjcBkCRrqF1RuF" +
       "Ed3cgDkKPNWHe1Cg/i2rfy3yxcXy5P/yMoR/O07UwmUI/yPmNt//+5b83JMW" +
       "3qF8CiG2I3ksx0sZFxj8r7TUYS8UD+dyBYLMb78CITY6XIFACJzAVP+QEwRS" +
       "xj70LS9+w/82Mv+e6SRIg+w3pKY1nOxD00kYfcR9qLUpQpvYPnS/s/G4X4Ew" +
       "FAnFp6jMbLbufwaKT1AMOB0OhGd2ezK1U2CkCibfN1j9ZDZTE+EF5UuMd2Fy" +
       "Gug+R5BA8ao0IfqcHmyiO518To4TusYXBn17tgfw44p/xI6FR+xYwLECClf8" +
       "I3YsWJu8rcK+JqrB51qy/YOustqVRTmBfFk5cHgo17G+a7n3OHK575LlTkOt" +
       "TfCPt0LwwOLAlLutOkxINdLfo0ag75DcJ/GkKhh7uCdXSvUxonVqHN1KNQLt" +
       "abkt3SnbgZAyUFFCp7AatyhHnO3ASL1Z3UEYUcKR800XfCR9FKMuZfUYkS9T" +
       "GIEyku3MyTnbwad1Z9a2kOwEJnlJdgLjzGQiMN5tfZRdkXUoJ8OSAlOSx3I8" +
       "6MrvuQTmtJDxBOCHCYFSXcljcky1lPAQHuwJj9jokPAgCkYz7Y93QkGKJTyB" +
       "C7xYaaAKea82TZI0yFYqNa3hZItNkzT6CFYqNUVoE014ArHWJDyGMqGgCs1m" +
       "5AG4QB1IoBhwOj4Qtyi426KcxmQ4kdX2R8Bx5gyxqPmtuuXiwaqEOy6BWVnu" +
       "uCCzZzImy52YNRXf6EnxTSini7iWm+yKb7IrnpJdwrXcZFd8k13xTYbi13pR" +
       "vNMdF6ICKOuhuAqKBnflX4miwClxIDyc6RayTVmDeJVaJuMkq2fJwBCu4y9y" +
       "IrD8gi+XK3mSz2KoQCYZmm1CwU4NVgDx9QvXZgM/hgLephE4V1o1Br4BjPkT" +
       "nQKftOqeTgQDv2erXuqW1LAoYM8/wQtzMxhnt4xxdsvAsQJbuRmMs1uGpQmv" +
       "HQWuOdZSspKnFPEiLxnDbbzp9vG4rU1zszXosLHxKEphuncpOHAtWsgTsoXA" +
       "4c0Cr7d8H3j9rnHd/J3j+kilZKT5noENxf6Ue2QRr5naED8hR8RD9RmVUdZg" +
       "7VFuUPwDZefGu0Ugjuv/Z+7rx/Izbj+ferAfqL45eis/fOQrD/pbufJvPFsj" +
       "zBKmFpl10YaVQt/8VllqsEMrLBXojj9q+gj2OAr66N06fdBlyPt5+HnEEJKd" +
       "vMhqy5PiULZqPw8jPcpq8aKzmxswR8En2Icz6tdY/ZLIlymW4OD/4X4+SH91" +
       "2MJ+Plho7peDRS24OcKuyDqUQxFhw5LHcryUsVMPntpSB3j1TrBfDlt5Mr19" +
       "Ky82OmzlEQAnMcW/7gSAFNvRBSd48RrBicj7ZNNFkAbZa0hNazjZNNNFGH0E" +
       "ryE1RWgT3dEFZzqbjvtW3tAjFLNRl9ksPQg/6A7OQjHgdDgQnjnZk6GdCiPN" +
       "ZPL9itUfZDM0EV1QjmG8C5NjmAvOQ4xAcYY0IXqcPmyiZ508To4TukYXhnx7" +
       "rgfw44ovtGOh0I4FHCvIL+sYfUQsWJu8rcK+JqrBk1oy/fmushqZTTlJWTlw" +
       "uDDXsb5ruV985HIfKcudBlqb4ItbIXgorkq526rDhFQjV3jUCBQbcp/Ek6rg" +
       "8FpPrpTq4/rWqfHmVqoRip/ntnQp18GXHcHvy09RlPDfWP1GSnHMdaBweNkR" +
       "kLzO6lcEUgkwwq95gve4nLsXijt0pU2U");
    public static final String jlc$ClassType$jif$1 =
      ("vYdUcpbtjGQK5nvXiWXsyn8U3REIOrGO77D6bZGgNa9HCf4aJxBej+J6Nyx4" +
       "J0fUA54QhQTBhzh87rQj6k47oijZoxw+d9oRZTZBKf+GCOU7WMGLmm0uZnVN" +
       "bpAAkgirF2WHhHP4HWKkOUC9ltWrbQpGQ3iO6G6BpzxXjdP3EwjprpaqV2OZ" +
       "lrJd+iuulrLd7TybfKolT/mcZQFQPo+ueFfyWI6XMpNZ+ZlK0TqboXiSbKWo" +
       "8FIt5rnbnfLc7WKe28ZQDTUWKw7GMv1vdMJBykh3/+zJovbhCv7KzWef3aL2" +
       "2S2Kkn3MzWef3aKsTRHaxNJd+kabFtJdqxCsryUTTog6huIQ6jmr998NxRco" +
       "IeQEin/gmb0uOv4KdQzFW06+t5CpotHJN0BX4Yp/gROB5cWIXq/5cX8Ob7hS" +
       "urCx6lgdE8dsjT8PKaI/z2ZQUP5J0BYXLUvhpHcm5lUnEjFNjbuGhu3Z8sLt" +
       "Yl643Q7W7Xaw4lihzhyZ2+1g3W5x/46r4UB5MTtQQj1koMDhN/zCXfA/XtTL" +
       "hZ9F4K9kETgQhr9jyQ7NSbL5BttDnET7jItoSzyIFvqNouLN6vlyETm0jk25" +
       "OxTnNSHLozzrAzqe4cllU6GPb52uJuagK6ckCH5UOVNR8utZLWYyHpIgIFnI" +
       "6nkCqackCK4/4i9lgfpSVjeIDJjqC80gDu9cT0lQQl9CfGGOGVBoppcMKFRu" +
       "ZhihqS1kLIRjkXsoKxHNP0wey/FSRgYUqnKxTBWKc7xnQGRiewYkNupKCPUi" +
       "pT+IgNOZ5tc7ISDF0p9Q1IsthfAd9aE603BIg2xLUtMaTsZ/i2T0EWxJaorQ" +
       "Jpr+hJZ7SX+4BHynmRLAl5/1pdbom8LqkboyPqfXl02dxL5SVB3T2PvPjmwA" +
       "lMdKI0/raqYTYj9cCV6E9U1p8W1h5jcxYH3zWX0OzLIKJfgj9raw0GXOomz5" +
       "bWEhfE8fINc3vZFC84fQfInNbKC4Ek0nWwwIzYZiBeIO9YviwDMLXMzmajQb" +
       "KKolV4e+tg8DeNzJ19KoZxIUOBFYstAjSCphrFpWa+KYrUoq6fva5aRS8lFQ" +
       "LjJsgMvVQ4LDnJo9wQH/wq263G7o5XZDx7FCd3CrLrcbermU4Mg8cyzMdcHC" +
       "vTIW4HADT25CP/GaN25yk+n874tMf5+TTMPI8xAnoVa4CHW7B6FCtYMKNmuw" +
       "yEXYUOxMuXsLhwXhiR2eNQGHuz2FOCrul1qnpVdz0BJNK6wuDB5om028xoes" +
       "hgXmkC4CyVOsFu/9SCp3ftYbLpfhOzaA+iNW/0VkgOvufc+/bItVx3JOFulP" +
       "0FtKFpt5MvaW2wIpvyLvUP4ZgbwvedTGg+IAjpkVx3/RlQCRh5SkodzHMnkf" +
       "cJJ7ykjS/u4JwQdxsi85XA/aEXzQjmBK9jWH60E7gg/ak7SDRpKW5U3a0lv0" +
       "Q7B5pQnFATySUAiPRiuTmBT+zerPHVEY9ntGYaJ6aa4oDAdcUGhok4wraRP5" +
       "n075bht04t/QZriNF22G8be14fam6sL5Nm1KTWs4Gb+IY/QRtCk1RWgT1Wa4" +
       "mydthvPQfk4DeVyEM/aEQ7ynmD13TWEe6vDaxklNcbUuGmGvkLnn5acfvrP7" +
       "nJPol8rgU71OH6yaEIlomUwlOSt/0w/fYVPOVHCY1f8RVaErY2volAw6aS2Z" +
       "1jIEMQQVBA8k5hTht+GKVJylCJgAl5a0fyBJ5F18/8zH267ZP/qZ3TdZ3j9T" +
       "KK+crwI/WjZqaq9Txy343Q78wEF+XGvQ0jPqY7EKxR+LOnxH1vKhM8uLXBsd" +
       "pMznmpVI6GOuid332zEfLaTvqbZ/8dPsnAieXnrOY+WD/ZavPcMsHTErCBcq" +
       "6AbQyIUdQrgXWhOCAw3nk+wZSPgE6PBmDjvjZqedcbO4MwaXi87T4M7wOdSF" +
       "iO4ESryNHw6hS/uImjgaKxoFX8TfXBYxFhcBR8Ml74ZBfhCD4jtOQZ7mWiZB" +
       "gRPBLpGg5Sw3iG0O+xQYazerX7DaRe77lPCZOIGwTwn3MaeE9+PjPWKYag+r" +
       "X0odHVOEqfrTCn4IEC6jOBSCrUPcN9RrAUdOWPCyD2jOtg9oFvcBzfb43GyP" +
       "zzhWeA4Pxs32+NxsyTB1JUiWNyQX8ENxPi7aLe4FiSCGcEnIMQAesPQWAxAl" +
       "6DtaDwAgVykIsoZSCoxCAxgoFtFF4S/LQu+62HRUtmk4PI1vjcJnUCe4jFpj" +
       "Vk6cLdS0HyqNsiOTRtKTNMos0nDKZ8MIVdd8VgKYI56acsUTki7zbF3Qe5Wn" +
       "zJia0OrWWd7lOVgeIsvhEZmF5Lgnqy2f44HSfW8HJPmsFt/W5oLZjS7nroHi" +
       "Kl1ps0TNLIEvdTtFqs5svk5OLEtRxXxEBjp2ZLX4g+PWRZXrxagChesjMuH1" +
       "HBI3e0qvkSB8K8+l19vT6/X29JqS8QtdRh8xvV7fIiTgwvSF5PhyVmdygwSQ" +
       "pFkt3rx2UftWl3PwkYfwPcIb150g0YXNd5ETyxIkMHk5nnVcyeoVRwyJB2RI" +
       "uL55ObyFQ+JhT5BAgvCjXP9b7JDYYocEJXuS63+LHRJbLJAgy29r/V54D/n7" +
       "zmpkmbpYq4rct7ljm+6b576BX7g3P5+dTxLxWrIvEL+aLRyHSciopT9pxe2g" +
       "0iGJPD5HdGzIFly4SlUdfpae3kUyHXIaDl/Am+f/aKQZeA9Rts4YehG/C2/5" +
       "TkZ9JX5yoyry95NHTXri+cE72adis36DhVPcv3najJUHx95Nv/NKQLEC0dOm" +
       "QsmjO3zkwdcofhhbHs0YK1w+7N8dtuUPMvZh6JoKBCuzrK4H3+1WNjpt2CrT" +
       "iYZojWZ8YnmZsmr9M+sKLiGckg1bNDMnXZ8hoRo+GGd8bwTGqqBb1CTNFf5E" +
       "Bh4ifzFXGFbcRvqW3jSzIu/wfHMb6QhiZLjT/wMpfKiewooAAA==");
    
    public JifInteger(final Label jif$L) {
        super();
        this.jif$jif_lang_JifInteger_L = jif$L;
    }
    
    private void jif$init() {  }
    
    public static boolean jif$Instanceof(final Label jif$L, final Object o) {
        if (o instanceof JifInteger) {
            JifInteger c = (JifInteger) o;
            return LabelUtil.singleton().relabelsTo(c.jif$jif_lang_JifInteger_L,
                                                    jif$L);
        }
        return false;
    }
    
    public static JifInteger jif$cast$jif_lang_JifInteger(final Label jif$L,
                                                          final Object o) {
        if (o == null) return null;
        if (jif$Instanceof(jif$L, o)) return (JifInteger) o;
        throw new ClassCastException();
    }
    
    private final Label jif$jif_lang_JifInteger_L;
    private Label jif$jif_lang_JifObject_L;
    
    public final Label jif$getjif_lang_JifObject_L() {
        if (this.jif$jif_lang_JifObject_L == null)
            this.jif$jif_lang_JifObject_L = this.jif$jif_lang_JifInteger_L;
        return this.jif$jif_lang_JifObject_L;
    }
    
    private Label jif$jif_lang_IDComparable_L;
    
    public final Label jif$getjif_lang_IDComparable_L() {
        if (this.jif$jif_lang_IDComparable_L == null)
            this.jif$jif_lang_IDComparable_L = this.jif$jif_lang_JifObject_L;
        return this.jif$jif_lang_IDComparable_L;
    }
    
    private Label jif$jif_lang_Hashable_L;
    
    public final Label jif$getjif_lang_Hashable_L() {
        if (this.jif$jif_lang_Hashable_L == null)
            this.jif$jif_lang_Hashable_L = this.jif$jif_lang_JifObject_L;
        return this.jif$jif_lang_Hashable_L;
    }
    
    private Label jif$jif_lang_ToStringable_L;
    
    public final Label jif$getjif_lang_ToStringable_L() {
        if (this.jif$jif_lang_ToStringable_L == null)
            this.jif$jif_lang_ToStringable_L = this.jif$jif_lang_JifObject_L;
        return this.jif$jif_lang_ToStringable_L;
    }
    
    public static final String jlc$CompilerVersion$jl = "2.7.1";
    public static final long jlc$SourceLastModified$jl = 1466731418000L;
    public static final String jlc$ClassType$jl =
      ("H4sIAAAAAAAAAMW8Cczs2nkY9t/3tEvWZsva5Sv7xZVM5ZEzJIccv8j2DIcc" +
       "ckgO92Xo5Zn7vi9DjqvECeDaaFA7aGTHLWI3AdzWCZQECJq2iJvCLdDUadIi" +
       "DYKkLdokaNqmRWKgCZAG6BKX8///Xd59917pNSo8AM855Fn47ef7BvzON377" +
       "5t1tc/OwKrMpzMru9W6q/PZ10W5a3yMyu23V+cGb7i8C4Nf/2E989M+/evMR" +
       "6+YjcaF0dhe7RFl0/thZNx/K/dzxm3bjeb5n3Xys8H1P8ZvYzuLLPLAsrJuP" +
       "t3FY2F3f+K3st2U2XAd+vO0rv7l956OH3M2H3LJou6Z3u7Jpu5uPcok92GDf" +
       "xRnIxW33BnfzniD2M6+tb37/zQPu5t1BZofzwO/mHmEB3q4IUtfn8/APxDOY" +
       "TWC7/qMp70rjwutuvufZGY8xfo2dB8xT35v7XVQ+ftW7Cnt+cPPxO5AyuwhB" +
       "pWviIpyHvrvs57d0N5954aLzoPdVtpvaof9md/OpZ8eJd13zqPffkuU6pbv5" +
       "xLPDblcam5vPPMOzp7j128ff9/M/VdDFK7cwe76bXeF/9zzpC89Mkv3Ab/zC" +
       "9e8mfugHuF+yv/sv/dwrNzfz4E88M/huzH/wL//jH/nKF37zt+7GfPY5YwQn" +
       "8d3uTffXnA//158jvrx+9QrG+6qyja+i8BbMb7kq3ve8MVazLH734xWvna8/" +
       "6vxN+S+ffvpP+//wlZsPMDfvccusz2ep+phb5lWc+c3eL/zG7nyPuXm/X3jE" +
       "bT9z8965zcWFf/dUCILW75ibd2W3j95T3t7PJArmJa4ketfcjougfNSu7C66" +
       "bY/Vzc3Nd8zXzefn673z9TP3dd/dvAFGZe6Die+B57JJwSQOQG+W1NtGFju/" +
       "t23cu/ZVYA5xwMzyGPrN6/Oz6l9s+niF7jvODx7MhPvcs0qczRJPl5nnN2+6" +
       "X++35D/+s2/+1Vcei/E9Xt3Nd87rvH5d+/Una988eHC75nddBf2OETMZ01k9" +
       "Z8A+9GXlxw8/+XPf++osAdX5XTMRrkNfe1Yen2gxM7fsWcjedD/ys//r//Hn" +
       "fulr5RPJ7G5ee5vCvH3mVeC/91n8mtL1vdmgPFn+Bx7af+HNv/S11165cu/9" +
       "sx3p7JnTs1J+4dl3vEXw33hkRK40eYW7+WBQNrmdXbseaf4Huqgpz0+e3BL+" +
       "g7ftD//O/HswX//8el1l5PrgWs+WgriXz4ePBbSq7ph2pe4zGN0arK8q1a/8" +
       "N//V/wa/coXkkW37yFNGUPG7N57Sp+tiH7rVnI89YZba+P487n/4ZfGP/uJv" +
       "/+yP3nJqHvF9z3vha9fyCqc9w1c2P/Nb9X/7d//Or/3NV55wt7t5T9U7Weze" +
       "Qv65eaHvf/KqWdWyWd1nSNrXtCIvvTiIbSfzr5Lyf3/k9yz+wj/6+Y/esTub" +
       "n9wRr7n5yjdf4MnzT29vfvqv/sQ/+8LtMg/cq6l/Qo4nw+7sx3c+WXnTNPZ0" +
       "hWP8g3/j8//Gf27/ymyJZu1v44t/q9AP7oX3CtTHu5sPP1YEznb87BZZ4Lbz" +
       "+2/LH7jy9HbKzW0feC0+O972feL2+Yfat5tY6rpXPRFRC/zGH/8M8UP/8BaX" +
       "JyJ6XeMz49uVWLef0p7ln87/6Svf+57/7JWb91o3H73dJu2i0+2svzLbmje6" +
       "lrh/yN18x1v637pp3VnoNx6r4OeeVY+nXvuscjwxHnP7Ovrafu/T+jAT4mNX" +
       "In1hvt4/0/eT9/UHrr0fra7lx8YHN7cN9HbKF27LL16L1+54cm3+njtx62YO" +
       "PWLRnYjf8ujeUt3p0rVcPH77p65vf2O+Pn5z84pzX//wW97+4LG+PL3Yx//H" +
       "P/Fr/+wP/iz+ylVO3j1cCTfz5KNPxh37q5/zr3zjFz//wa//vT98qyI/Pa9/" +
       "XfT3PR+TV28xmTWovXWZupmYcWFn42Ngb+Xpk/dA/tB9DTwFbHfzfp45vqlv" +
       "OI18jnyJTZzPhmC438L9n/v6v/o7r//81195ys/5vre5Gk/PufN1bml9y6HP" +
       "jfNbvviyt9zOoP7Bn/vab/z61372zg/4+Ft3bbLo8z/zt/6fv/b6L/+9v/Kc" +
       "LefV2SN7KeO+c6bBr97XP/UM466NH/oDs4m9No4vo/q1IK7F7jnkvi59ua/D" +
       "Z8i9Me/IfX3APAXoHXkezAbx3fDr6OvQ9V77FiG4l+VPJpn72qNdQZ995tlw" +
       "vTYbnkcS/pSw3bmWz3n9zJ8PPxnGlbP/+Yf/pz/y137h+/7uTOvDI8G9jv7h" +
       "WZW0n34g/ZHrzY9dC2P2UK8gKGXfuD5ntx1/a3F97zEU+3spuFaHbrbb5XOh" +
       "6B7e0EjLbB79+IVHmGd9DODAQ04bN1V79kwTB63abBlgQ4QkfyR37EFhTscJ" +
       "d3xxN13SBSMRZR2WNVVnscgORruk2EyvB70uQ5oZtE0jN8Opa0E6j0eorjtU" +
       "BUAYv/QXHuuXwJnTBfVyMk4XAQMsGBwBeI2PPdgtuxGVpCqHoMKrOtom4UrV" +
       "+FjIZaNtFqa8r1cZPx6aPGXtejr6MIjR+TgICgb2Or5hM1WVLkcUlW1MYw86" +
       "0C1QN4Wy/VrR3ZWujPrcUvwEstlVzliDqhC17h22tLjap4t9515YX6fjek2s" +
       "ZCnjjMpNVvVKT/issBM1CxBdUTkZySKCW5P22mLTPHMapSL0tK2n/NAc0gNN" +
       "LPclD8W2pSYyaWMK1ESyQfKWhaGR3bg6y3Y5Sgxx0+32HbUtdi1oyqNPMx5t" +
       "mrsJtDyepwoZYdgtZLLbZYJ7+apO3cQ65Yg6RFbJKQMEzEQ15VxKl0e9OW5W" +
       "8sXsDo1lJHU91kyj8B4ZMJSSMmmf1N0q0BvucmSmWA93HnFhFoR7iC9EAelx" +
       "1LFuXJ/AMnaUsaC3nc4M+p4GKDsXa6Scek84xqXbO5t+QVL58iBwOjTzV94d" +
       "uLDNY3ybS5FmRQ0nItuVtmVwoITKeH2p8617kBbsxtNdlYEGrsq7aiWOoy03" +
       "LLUfQmSLWfISorZKJFd2FWNabfpptF71aQXFQ7CVyFSIWB1LnSRVoAU5KGlN" +
       "BJuLuHf00OIQEEt91+ZkZgd2rVQWiAIpU6enXYOfoj3h9YEmUmrnDYkOhnpk" +
       "zrJdGHkgr4CVsLMOoOOAyaWD1n10wS91pVdkg8wc8haRigLTyXZpdiOpuRKW" +
       "MHaYtjSeCQvRzgllv3Ahl9RWAk+ifQGarm93YG3Csb6uBN1lZZmdgKQnSneS" +
       "5Qy57DtRQo1s5EIk4/WAXfgkZBUVUKMHOonzyC1X0MVetpc8QXXCtc+sddkM" +
       "SM7YbSoxLIO70XRcTDaPrJSaw+lkrJWY5X0ZhKoATwAR5AB3ERgrLaunA7Uv" +
       "MuWi22ltHNYcp7S7jV1GWwQiW6NYKIdoGY3nzQmJlzmZnPtFxyQKNUwTHzqh" +
       "0wkTDAFMEwJtV+wJgePICxUvM0NWA009jADeLGsYRqTRQP2e3gD+jj/5Z9cz" +
       "gh3itud2Uyg1EdOkxWsJYYhd1I7esQeJmZR7IhTUidlSREhL3oneM5Y31tWK" +
       "2cXjrhzoysBb5niCaxGf+mjrKqOlWFVnVGuVxdscjctk5GmI19u81mR43NIJ" +
       "oJZUICikrcqZjywDyFnvCYrDof2m2flbG6PaI4m2XjbBIArCICzrYdWLTaQ6" +
       "zbESCP2ESpRFCBEt22UcILgQaKwE6KKJ1DkLkrGSq52dp6ixRYGwuCz34yXj" +
       "dhBO2VIuo90pgwq53mmIpS37ioPKIhs2pgxJe1EY+a6TRHxXS/TQHC1RVgW6" +
       "Asg27ChyFXlGqK+gYX9JMR8AvANdgku2uAxekjJSvoKr6sRG5+XGg2wJc0f1" +
       "qBitvQqCPrHM+bcO4SBlGO+QlEeBHHXCICW+KE8TAwRcoeHwMMCBacOI6iUr" +
       "b+SK1SoLISgPe7Kr9S4fR2mReOYiTHMDOqOIi8RRNOql6qki7frUMj5kpaPb" +
       "XbLvd7g4QnRiNiV0XnrsBo0rRmeP9tJdisxm4OBC3psLLByAhQTQuKaFGr23" +
       "cAPTgBEWZXQlqXV3PJNBcjAHDG5kdbBMRPNZjO9Ifd+UCY3OhsNvBFUC5abT" +
       "JR2G4WwWs8yxwfUS04wdam+RIuuZxpcpanMKLh5V6GBBFHsn3u2Z2AZw++xz" +
       "Bktdjj13QfodiZ5M5nzUUwWmRWfAJAavLpPIgNa+bAZlYSyIoy0bWZnxscSi" +
       "YhoSDNWuTmvVl5igYSR8VDnXMU3fpnn56OqUepG9/QZH95aX6PahYoVDuGTO" +
       "hWLZFDTJkVLsPYFauxJUhuHF1OoG1yY+2ga1KTjh5ObHSZXI1fm0SOSKXkqL" +
       "dsvFjkPJBJWddGFmal/IMULpycapjBy4NAfBvci7opkS+eTpUFzoZyWR1ehc" +
       "lkqnmRo4b7ZrgVsJ8bKnlkaoabERl5YRghOUx+xC6PYhpWvwfPHhRIvMoXQi" +
       "4mzXYyVXrZMQ+sI2FlpKMyngsUS6zmYZC/vuyDk+AtlGY0MrVHUHoMqOHuol" +
       "MpbbhnZoQRw+7c99H4A+GRSydlb9M46shX64rIoLNuFEOht8qeD7DKKKsImk" +
       "fFAIPzyu3dDm2ja0a2Y1RYtq6GalWaPcZZqceGHD8P5Eyb0EWYYvDURJkYCO" +
       "pFOR5029xXiTHwz+BBuVri21eGJdKRaqE0VSdqgqbczS5KaN01RhOSaMA0eM" +
       "lzicmDAYM7JUkaKilbyRTF3kDecJF/dg1HiqEdmJIi3CZLufN42lXrncutXq" +
       "reWy/LqTd20TVxMeg81uSOnoAC5YOE3rmCdiCctrh1rhosQpYu2xhnCUN4KB" +
       "ry0t7+1jpXGskNmsb7MisWEamNYXrVDX845WHLHtqrHDRnb3OyWWrFDQQpZx" +
       "FGtzEiKUltKW6hINPcW8o+837RjhKUiD804DhiIPkbvFXuos5WxxKnuBFPXQ" +
       "wGd9bw6xaeXCoiLLpbtRHGDJqrrr0Q0VpQvwVEgT5Mhbcl+fnPWxki4bgYaP" +
       "646qlRNegHADV+20qhYLMWQbrliidLSG7XUAgrbILDH8dPB2ZRSzezvV0E20" +
       "btONXI3F+eStVnXQF6kbqmfyIh7JJaTkk71v3GV36nKCG0ZlJx+szVLlCM6S" +
       "3dsNVaymxMilPGRHZtYuRxaEoC4MYGZxAXZuCKJYDJ8Biy7LWde9brYnpqog" +
       "tlrk5DEKhdPCAjNqM64pam/zqwPu7kJzi0L0vOMu9xuTsveTF4YLz/NPR0jn" +
       "z0eE9PdInS1pPl1Hk3Awtu5ZSsszbJa0Vvhchad833YC3rFHq8q5hnOo85FN" +
       "Mz4PTkRfTtAIHRt2y+dVHu/Cqc0WuZkafD67sgS+FAZ/4VkYq14Emkh1EIlb" +
       "bOFt8GFKDkxUuwrJzxLakWNtlpQBdn7LB0SBLjBJ3mmGT1jAueBgwqgq1tuh" +
       "yzU7cBTa+JBhCABYnvNmtn/uHNQrR25jlvlBamI+bS35dHCyLUmuHeqQnhFw" +
       "jRswTMPxgOcjWVhbwThCQ79GYoKVdpQUa+xqxNiDEJAmryiWkNVtSME6YsG9" +
       "K6ILqBpz5SAJ8RrxUAdPEBD3B8c9ZrmWHCUlr/hNF5DbtlFZBzjNJkw7qEy1" +
       "qitsAXuBj60icCeyTT16B6S+qD02jSLii7o/5RtXbXLlIhXGWGKcqGreoumn" +
       "mJQ1rGgnZ31iQ+cohaRLTRiZLAhDS3R8ly2qiZjgYyx1ruqdDtp4XuP2sqg6" +
       "uPWPmy2SKrl+8k6UUikGLNTkCFe9Tw8LdS/wC1OpbMTIzHTvkJ2yLhEB3WdD" +
       "eRyillUDYgwde+/Wx4DfollIenlnndt04aLikU8Nr1rlZmBgDu3IeUetGzjr" +
       "w6CUoxbGyO0U5G0RD/2SPfeXdQKXG2AB9CGQcLWwOLXdfrRLNSEPflLKHGfk" +
       "3o7HLQ85pnyFXBx0kM/OXliW0jJHYlc+0eN2paq0hUkn0E946FSjrneSZieA" +
       "EiiTiOIdnJ5V1zoUxCUF3cqZxJbawTl88tv1kp6NK5tTfcSEG8mgtry2xLjA" +
       "Ovibdbw5zJ5+nMPexNMBPcAL2lFMBisVN0D8GFhKKGKveVsdTki3MhzMt7Jj" +
       "sW+y05htuGW8onty4QSFFY8bN+obZ7nSW1maVqV3GjyTMsQSIdUxlHXc4S0b" +
       "hDYc7wGb/BJWI7wZ4BPCg5PQBGCOR3C1PuIYoZLbhDRBfo9bLjrSXrSaur3e" +
       "+QcLNiEvpFiCqXKMS9R0ze432DpL+HWuJ3hWAifqtD4QYp/zfhMG/Nl0s2SF" +
       "8jYXdRLYghJWnzuDKPqT0c1zpEBNTSxGxf0SLtmgo1L1IPZcjjeqF1aIwfkh" +
       "BaSuiC/riyfh562PzP7LGWhzDodX2NpZlSdvxL2sjtIGopaSucMUrUsWeQPI" +
       "6qH3g6Oz7NilZFWt5BaGAdd6EaSHqkBx5AxrkccAZcNvcXqKe3/VOn2/6QnA" +
       "JX2fPi9JzctsEWLSY5auG1TvIu0oKnKWWit3UfZJODJVmm/bbvaMxLEhEITp" +
       "eLLN1ySOSASyxAs2lFd4IajRiG2kqUBNaJNqLly300XB0dTMca3T+T2wBLDV" +
       "YjIbdRB3a523TSazBbxYtqbTrE3YcYIqFBXbr/EC4YUIhG1ElnY0rciwtze9" +
       "oi1qRJZhFFoFQn0o4dLgeotM57BmErc7NVPjPrXyVFnTpzgnQkUSTG6NMgtg" +
       "2KziHkeg82F2lSZN63jbhs/lafaGzkA5TWqAEnWkthS3sByoEHTKKphsDt1D" +
       "aDlKtBDHMGPLeBhvXIbUQswD+VWlKRWzlfogOSPu8Qyxg+4zRKRjW1tlpc1u" +
       "FPMe4Lf28YS0lnvcTdw2WY7IXggPO9wo24lyAVdfilsFjjZeiOwOhjldEsSV" +
       "W5/Z+TW6LI2W2AnHPqOHzbndkbSMDKBERWdRp4q1fIioePZMjFGM+alvcKw8" +
       "J/AK0MRCdIzcWp7WsDzv08vZ/tSxKG0DVtkbKzRxdwcsUONLEMNzNN8YzhnI" +
       "zg7ZzBszdTTjhgHp0yGBpFacHf4MlfO+MBRdrEydh9UsocZBWYtcB0z5OqIk" +
       "5iKziark0ubsdVvRzzDn0MWNAgRKoM+7nj9YQsJLniaPCGaES8odwxWin+VM" +
       "wpfrRgRCgi8vsyM2DAMI0hdQBXzvcgaWxoYxm7MuZItj1taw2NPLbZ6KqAMv" +
       "FkfR47qzyhAoZ8sdV+90VecmbvbcG2V9sK00jfVOOFmiUxprZI+w4Wnpb8SG" +
       "tQAmO5pRZ+oM14yEAF2Wut6bWEYnZzMTucjeSUGxmfQ9nZnslnU2g+Ce4eNF" +
       "XA0daawFHVqpXNcU6ZbDqlOKScTW0+NqqXF+1+n7LJ03FXLlHiXAoNaKKqvi" +
       "9jB0alMOB2V1dtOzf1y3yZoOPX/CuG4J9YaTw7bA1xeFi7nAIPFcPWX1jorE" +
       "drDgI1wHSQjxuKpeFuu0oOZoKj1G09oawfCyxoTkkmpK2Su5k8FAZ3noeRJM" +
       "slUskT9s18NOo04xICFdYRoCKqO8OPLZ9kQop6ghNiUw+eWQggjkOYUzCJDP" +
       "ltO53PZo5LmIA0Pkecq2e1BSGho7UnHGb+hoP1M997lwS5UWCbBzhH8AQuMC" +
       "kATEV2t9vVzMPt+iXm6rIarNncrmtChEBplkc3DFwVuLAWQdjRaHXX508wTI" +
       "kHXT0y4gcsgct7pyI1pN4Mzul4VM/trWw1OP5hQOFErKswsanpaj6QNNI43b" +
       "DQoep5idRa1xufzkurs+gKUKCFQj18FuubTPLlF5e2dAxAPSeytTU3ZjpvM1" +
       "QFLngqe2nXdmzKWB2McLwvhMXedygXHDXkupJWsv0Aarx0OIXaysagyX4xbi" +
       "PscWB4w2rDbumKyXCwh0HUvBA4YmNrzQdam0wbVcZuAE6Td8RRHAajF3bCEh" +
       "2rsKN9TgJtBE2TqmCBBhfiKOIO4c1kt1d7TkqovsbW7Y8GoS+e3uoLktuyCl" +
       "DbfAO6JflcYyM6gTWPRIUc3xnq8vJTVbmFZf+7HRl0mvY1yJiJtcXxUabfaV" +
       "eJhUXbzIjIbGmg6TeCnTrUaMg6QzwmUXKjp6Bubo0YIIqm2Oi3YYk13DppcO" +
       "rU1NKCPJwNqslBtpYPVUX/IZF/JsD5KkrXmCXUhQZuwgytu7NLJyxdqJD4F5" +
       "oI9FfMTkMmkVM+SLWKk5zVx2l3F2XyDcnanapTu2wUMs2wOJ7qxU8eAkZyUn" +
       "TyEv4A51AQXXE0s93q3PxYk58NZpOLGK");
    public static final String jlc$ClassType$jl$1 =
      ("6GOFxp6LtpPUOVYyaPKsxTkIo4LAbEauFGMFAvazw30Y+oPhzY6CzQRtlDrz" +
       "vf74XgvmkA2rgGHll/HKdxyvJjcuW0L2uV/NLhQJMSNCyzizR9UDJA68Nu03" +
       "i8xD95EKFmOsAR7a1jlkRMfuctz3O0bbDWC3OJzkRDlUtDM7xBkuuP1OgzAA" +
       "DOVABJJ0F3KX2VBtq/SidUf7ElneQjzK0XqLLw5qtDuNlyAYyyKtN0GU5Ktw" +
       "xx677cYflh0cmEG8Zze1x+cyPTU4mnMElfDlWTupHMDYHW2guwjnL3JHqtrE" +
       "pVgHF2B4FqvNHA9aCFanZY6Mg41soIyjSVI13b0/HTR/XFzCI71EhR0EcEq6" +
       "dvKDwF1WNB7Y/hFGx3FhdnYMieR5UQNB0S+tGuh7YOFfHMAR9TlCksktTGMt" +
       "nNlRLq/8IOOcYR8zESlg9jJEL3WiIgqeTNCudHGf3aBM3h4QJ0i26xQb902z" +
       "AmQ4b1KE3Gj5UiLZI5SAuMGOq3zZTp3qOXiTmeoOg5cDjJhNG4wYjadYocL5" +
       "/AA95eByU0YR2swh7UFbTxh0od1xGCQxwuDdCCCAFJTCKhlZsokkYK24wtbu" +
       "DtuLJfXbsSOJZikAO2wEFlgkBICPiNns8VgL3UrD/sw4cVrJ2PGo6DyJQOOm" +
       "GB1AYXw2MTQ5y1R1g0/hYmVWi+kC8Gk4OyHBUuxXUBB73ghwgxeKi63ngbIR" +
       "9EfZmLdnoymm1WV0mHmz6y0PT6vCpe3lZUF39snOJEddrIAhOWrejg5XsLad" +
       "0N0QnrceVnKKaU+ZZ8BVpSTuNiXkpqYWck+RHuyGu5QVjwbtL4gQjJdNMMHT" +
       "6JoTKoITX8qgAGHaOdcYcBLzYweCwBxawQd+dhcpnIj3SwZO2xFqLWpM8AZT" +
       "tZOCazvAm7YnjncwnGDU08pkqA1xuGx0EZDIs6yMCQZxyho4g/iSHwB/pchM" +
       "CJzhij0tCmHcQVB6Clx5PRuASqqGk1gos4O8R0yEPFObgqpWCe9wTh+cbVZ9" +
       "bCe9pX9hF9qSSInYCY6LZG3tLJWcrTaq9by3pKb9HOPI6HaD2yXEBLVL51Ms" +
       "oAtcLRG1b0/mtlhgXRicEaQCR2ZFycB4OnMkQWQBzsCn1jj0eOOywKFutuii" +
       "nsCTMEfdtS6r+TagUtSlw3KB7QEbK2CBZlEM5TI1Fbo5XBM7iDufBW6TcX0n" +
       "pCNz9LhgNh4hhu7cA7hP2SjCesIzlUGb9Vmv6eOCPUpcZztpByuFE1qbSaMo" +
       "osI2djdFdCHAG2V2PWGNPGkuK+MQZAaEvKZYvrcC7TR7tOqeIae0h/lJLZyz" +
       "7S2stb1MhTN5KLKDF3LJZS/F/BHtAkv2UlMrD7igbDJBGWEGX/HN0Etq3h12" +
       "41YgaGIOU68Ri5tOi0zcSHR/PiTrpEzFTUikpws2u45SumcP6rQlsPFk2xvW" +
       "t/GlajHQRJ3qow1HFtMd04u6Iq73mj7bzAWyaWjjsJv2fL0PiXaRo5s9Im0X" +
       "TLmNzkKCSN0UI8sV6465hKSeuZTx7YiG01iLedf3Zny2a1KYVltDL/qeIC7W" +
       "hckndHk6ymawIotRVeIixmIjBybWwZimqA7euTFdi5p1aAGP6smJF3AlD0fe" +
       "o1YMwQp91G9qdlsEmYnk8ZnIRmY3uSvZnjfFfOcfdPvQ82m9DA7nLdEj03pi" +
       "mt3s5wMmC+fKZcmWEnGy8nxBnDXkqIe7cS0NphXyYBRyfhWRiL4oF9sG2SZi" +
       "qhbSHNwJta+G0m5Y+o3Z18aC25QnHgfPUnfhx6jokHH02mHTSgenl3O+XfT7" +
       "SsoHWjJ6wbOUtmILSiRjbix2jnOp1sMeabTFpb2YZcvRsw2ror5wK4HedEYb" +
       "qm1pbhAXIhrMw2k4WTcF7YEHOAHSOLNYFS1K8jgGK81fSnKDFja5wyMZl3dr" +
       "Odc1zwoxneo18byz/GDfQ1qY9ANoAVgzgszFSYDAbzZBzSGoH7dgIEjNDqxm" +
       "ZT0MItUml+0c7FfZAjrZutSBuJ5ldUvyDbc1yyRZ10CYLIVNs1od54jN22aT" +
       "2KEAXZDkgfUGPqpnwxRrnFWLZzwR3arGbfaSj+1ZxsliybiXVeedQItjsik3" +
       "EGEHzkYDUOj1YskfADGLSqzyd7KyRASX7addrUnjHByhHO02k9bqvFh0lbKF" +
       "k4XabINd1qF8s1izE74U8ks2+1QF7xogFiob6jjIW8VDcLnZxm6CWccjlW4c" +
       "y4aieZ9O5tsjtachspnIhWyEKuyRlHWpnWToDLjbJBR3lLN12opSCK42mCAl" +
       "s3+/C6UiKax0tfeIWDxaIreOOy2wdjxE6gspyfc4gR6TfI4wJGTcuKcTxJi1" +
       "K852zEKhOzuWnsyoGLHm1o6VQ7cXIohBKJoYGA5oT4EmvcWOpYtyAoO8b6Pa" +
       "UtXsYKjZud/tzNZBm15f4yjNBKzbz5yonTmIdxgzLJt0jjRXzW4O5RIdTjRi" +
       "KzluBZLpqglxqhKbSq0RsDHqgM71upTjCiy6QqoW+N6kXXqYoLWcibvAEBd7" +
       "paB5z97OMU4qp9xFWGXuHC2n53O9RsPBRwquNeOkgyptqV0/BXDvvyr42O2H" +
       "DY8/oE3i4NphPe/DgQ92w8nT3Mrpkr3EosVgxobZTgWuwTLJCM1ewLDdyrH2" +
       "4dFe00SA2Idx6yfAYXWcRuQABdoGRaRIUrfRJcKxRkpWKYKVcWKV4xnw1qVs" +
       "qdaWDYA9IWiYwe+5PId6q9CPTrXZpGHcUEuDjmgRoQ02FTRinXVG40jVXoJj" +
       "YbVfbavLaCaeCJPnpGoqu9aXgpU1Bw+I+z5rOA9TJydgy0wFc9eSKEksgd6n" +
       "gslgViZfHS3AylhIrZ3SjBWHNUqcYjq0KZwi4FzMYP0lbkk7VTPYM7bnh8Xg" +
       "zXHelEYwCFwO5eBExICxF8MPYJtbLpUlmxYwf3fPtqpM2+NxhiW1Hao7ePVI" +
       "tLOuqGoZrqKekVZJ3qzX+HGU3ZLxJTKefcjcgXphQFhPulAGtAI6lKjKjj4c" +
       "oa2JnKrZuxW2qGvMsguirokLDhYpfUOMqyz0SNxrExUXWZsBL0tL0kT0AG1P" +
       "JqcNUUW7OZppBZlQx8Tp91EPW3jLdadshcASZmCmfUayeGbTZC2BRQgb6Agi" +
       "qwbRtiivdpKULNKS30VH8EKYwQY0O5WLrDWFsOuUnC1w1KyTScKOisOh267b" +
       "FaSKJUxXKpeJoYb6WPbccTVkE6nmUJLODvCoFkeF5srLpdlcah9xs0xb7UUH" +
       "XfaH3g7ZlZsSNKoJ+lHG+87ijNNEV0zIUAWzKlKitud+FgGReJ2FQaXoic/s" +
       "DklN4FC469euCmWSlK2JYL8X9vq2rCqXZym5t6I4qpVFyjFykpptyY70UYTO" +
       "/gRSihyetLpgR3VrsC42FtJejv3zKT32FUuIWlypABMeBQvtXIxRdhRUraUF" +
       "03ZRsPHWNrmC4C0TLkfu+oeX2lqzT6hCpDEe7LKRDlUDRAcLU0wA2dJTkcuz" +
       "Q4OCi8pzyhzn6tQpJ7EOzAxaeiOHKvoWVpfiICb5eZPxHstAYGPXJ/WUrF1C" +
       "X5FrbVHhxiJCE3c80fDFMCHhwjHsIQjnXck+Q3tTKPML6hhkFJBzuHx04cGi" +
       "CBwJpIApjg5LIGQKFcb5zFxOVrz1GWF9GuLzjudM/pLbieSws97oiA90Ib7z" +
       "j5fDbM5La2Q0YUud2tkQK0QVNVRl2AB7arSyXgWDjdqygmeUxCWHNuQHXUK4" +
       "XXEo12eJBs/1cgXvsRI1rd2IUYQHEw3XuI7f5BrCh7g7XXjPnc2tyhgIvdmp" +
       "S5QQwb19XKJTChQ4hnR8gAKqyosMPkcGpW4jBG1g2xVFdCeePeb9eSLNkyaM" +
       "fG+2XHQ2o1he+kdpT/eXJSUQTZ8t6qLSvQu0PRzZ1Wyvt2iZQ0t8LP02Cs08" +
       "JRBi0oWW6sH1jB8cdCeHq4JIuNgbID4aIKSnoTD0gQuADtPpI3wQqD4TIapj" +
       "qWre9AbbWJ6Zapi4QRMRK3TOg++p+xBgNkmVzuNBOZMIOUKVtPQuNF+kgXs4" +
       "YFOaKGCPHM6SN7Yxjpob0CbNy7xxbdl1YtAriMTCELRTTNnJFWugGmxD2QBJ" +
       "2BatpILaqJOibWJRjvvZpVaBi9+ItE6e1kW3P9mHlW0j5W7judo+KlPk3Niy" +
       "iBYQhjpRByEdKFlNfKSWyz3u+AsksPNVy6HHfMGqRovsHYA5gZLcEenthrww" +
       "bCSfvC4aRClIkZ2vTyQ/gyths1zvFrBqkP5q2Nljmh1dR+v3+X5IuaJAbTcY" +
       "GhErDmKZ4U2oYQuBXk02yWRlrp1n97kDoTMYnHRR0Ge3eRHgsm6TzWk5lNnm" +
       "vLKVpbVIGJKXJH0ORVI0UqMO2LP6YcqIQzjrkw0F0/aAUgscxC/0coVZIlhb" +
       "sOpZs6+msizgNmcGNBKrtuu1Ok7w1fbhZ5ICzP0gQYlYnzCSHWWAE4qRXgxs" +
       "xOM9Z25br+IvRV7pzGov9LEHw8sLGXC2OtSOBeKe2Bab2DeLRjgBxg607EF0" +
       "+ZZWyYbYuvVq40gTo3lSE5pGJBCbM1ykwNlSxJBcidt8lwwzRL7nOgLCn20z" +
       "xjEV4bGz4ClULCCk0kxH+ryKZgFh8iS02bGkTFwNzO1pdsHcrYzzGYZY2yAi" +
       "dkjSCZKF5UZsbUNZ3HLVPkSVMxzvIQEYpZM9C4aJ7WzZx7BMJCyB2Z/V87xp" +
       "2T65BsRENNiTHQKNCZUerQtkHTQqUSAMSawSYasQjSa6x7XcbDRPMERi2i0T" +
       "oQvXJTW420vgIPB+Ei+XyPA3iDi28BI4ju2kbhcHLTaOk2Tis38sxpjN+QgV" +
       "K8TeJQuGlzb+7M0Zm3GTrXadvTtvQn1Kmba0FKIcic0YllRHUYgCclIPrJa0" +
       "rHV5iojMYkjcQ6ERPpJQVaKnK5fzFIie6mMbC6rcseqRL1uo2LEWzjO65+F6" +
       "yJ4YdGW7raamMXZxKFjyUaO4HGIbEhrD8LBM0EOfaYeItHIK5cKinpYBgtBK" +
       "YOD0QcxbqgMNtOSsRMGKpqRjNltULaQeOYYcPLWj6hZthxQVOLKTR3Mkt0m1" +
       "tDgTCQHRkC2zGe2QiPw24Xt6QW8Z2IfqIVW2OIsD2WI9qCvQXK4PtYJLnSdH" +
       "+DjoWMDEangeFAoVo0nPvSk8K1JFzQFuMy61oDMyWDzPof9ZdBlngUIhdDKP" +
       "Hkqq08ikPJ2iRaG7k1/q8nk6bJcy03MoKjgTJQGHSJ0D+3AgElNcO9hhdzqV" +
       "Lnkwe2UFAxwtHxzusAmn5boBdRTZgQV2yas0d6pTjTRuh2VJDqwcFFttTSyE" +
       "RRTw1JEbjYYZSA6wOXmiFTcuK3Vdjf4yhOL9QdyhtLe/MFQ2IUqmeUFl+3Cq" +
       "TbTJ2LsM3ORAANqsZPmbtdy1yMmP9iCxBFE1tdYHE53KqZnW6JFWzSYGXBJb" +
       "2l7cwqtdpIvuABd2ctDocR4wgEdW4kgC8oRcavNEgC/p2XPLIIocuoVO7OIM" +
       "YEfc6+aQjB+saHUo2TkuvTQsQsPAwjgmVbckGjU+WWViWPipyK12dtl4oGW5" +
       "eO+m4cI57vjCtPColEtgv/dw56zu63rrLAj1SAUouY2QOLhQ5p5yXHmoDThR" +
       "LkwPngOad1ZSFFtcooJnvgrY2dUoy81m89WvXt3v4N5Z/863OeuvLV7grt99" +
       "px8//yvnV7qb91ZNPNid/5avnD99XXG+3rx+ofzmk7yiN7nrgK+86C3FS7IB" +
       "nvpk/vZ3Tb56cN9+cJdt8+bbs21+8GHd221c92Xnf+ke0oczYD9l587Xbr+f" +
       "vmvdZnzcNh8+C/p9Ohv3xperqrv51Iu6X4pYd4fYtai+KRrOtx8NZnef4ONk" +
       "/iNMPvuSES9FZnonyPzEtx8Z2m6jpxH55At6X4rE7/9d5oha3n3e/2KOvHXE" +
       "E2TGF6ji44SD3TOa8qF7pLr7Onoq2+Gp5KXHeVAffzoh8E68rykhn39Rwult" +
       "Osiv/aGv/6on/NuLV+6To9ju5v1dWf3ezB/87Km3fGJe6XueWYm/TbJ9kuf0" +
       "p/hv/JX997v/+is3rz5OUXpbru5bJ73x1sSkDzR+1zeF+pb0pE8/JssHr2T5" +
       "vrvGgx+5r7/0dJ7JE7G5FZHvfWv+yAfup/xL9/UXn6Xok4SxB08s2A/ervr1" +
       "l2SU/dK1+IXu5ruugnDlwGtPTOdrT0D6196OyIdu0/Tu6h97Z4hcp/zofa19" +
       "S4gwt6v+yksQ+beuxS+/U0S+9+Y2yfbBf3hf/8l3hsh1yp+4r//NbwkR63bV" +
       "f+f5Ax6pw/c8m/5FXbNDO3J0/eqadni7xq9fiz/5DhD++BXq125uc55e/Yv3" +
       "9a+/AOEX6zrxTGbTx+5X+nfv65fQ4ZUnS33lCVf//Eu4+u9di290N+/ryie5" +
       "SdbzELsqxmdnkD5xX998WxCbV3r1d+7rf/JixF59koB1i5j1BLv/6MWy8Kdu" +
       "B/zH1+Lf766J+k3rM3dpaszzUPzifH3PDNw37utf+bageF3pj9/Xv/Ct8+5O" +
       "kP/yN8Put67Fb34r2P3AnV15N3Jff+7bgt11pc/e1x/+/8TAv/7NUPwb1+K/" +
       "mN3S2yQ44dbh/cEX6d4spu/+L+/r3/i2YHhd6S/e13/mnfLvv/tmyP331+Jv" +
       "vhy5W0v6mfmaWfee/+W+/tsvQO5aPMeSXqf8rfv6r78Yi6dtw99/Sd//fC3+" +
       "zix28X028vPE7hbu758v+ubmfX/gvvbeGdzXKe59/eMvhvsZA/9UyuW9t3Pt" +
       "+EcvQeh/vxb/oLt5jz87gVn7vKzJ9zplmfl28aINW7i5eX9/X//4O8PyOuXH" +
       "7mv9W8byE4+9uqdd/dvX/Z8vQfWfX4t/+hjV690/eR5OX5kvZQbo79/X/+k7" +
       "w+k65T+5r3/jxTg9qzf/13XpB+9+MfwP3nstbr45/FeNmYn6wU/f1x94Z/Bf" +
       "p7z/vn71W9KYBx9+Sd9Hr8X7Z42J5miGKL0Xa8z1PJKfnNs/c1+37wzu65Tm" +
       "vs6+Nbg/+ZK+T1+Lj38TD+F9j4zlM1HWD3+LUdZQxt5tMBUXcfelLz/8qYc/" +
       "+uPKw699+fHJGo8R/maR3RXaz1fVSxD64kv6vu9afHZG9hEsz7MD77pC+wwB" +
       "PvyIcW8lwIOvfhMC3B0h8PDuLI6H9wbmlhKPwqAy+NKP3p4v8C2EotxXHt4P" +
       "nc3fs2PvDOHd4PLHqZnIcfDwS+XD+PGLHj5xcK8seHL30H341Ydfeqq3fOPh" +
       "XTj28K0HbGjXkwLaWUgyvyuLL3359cbPrs9btfyS+/oL/0H6yi3wX37ja/eL" +
       "BrNa+288y/6Xbdu3HPomluW3b1n8+kvYf83+f/Clu2NDnmLA2yzMo9NgPvWI" +
       "0Y8eXHs///8H1NhLoF5fi2V387kr1K7dds8j8hOInsHhu/6FcNg9F4enofuR" +
       "l/Rtr8Ub9/+ShH73wj/hfjcAZ17Sx16LXXfzhWcBf85/br8bsMsv6VOvBX89" +
       "M+IZ2J/5m+13A+4ffUnf1aV6oD+H5s/5V23sbj7wRPavZwh96m3n4d2d2ub+" +
       "2V/9yPs++ava3749YOrxyWrv4W7eF/RZ9vTJOE+131M1fhDfovOeu3Nybknw" +
       "wL7bOm4t4vWYjbm64vLgJ++6ve7m1buvaB741Z1y/793RLR8r08AAA==");
}
