package jif.lang;

/**
 * A <code>Closure</code> is code to be executed that needs the authority
 * of the principal P. The label L is a lower bound on the side effects
 * of the closure.<p>
 * 
 * To execute a closure, a @link{Capability Capability} must be obtained
 * through the runtime interface. A capability can only be obtained
 * if the principal P grants authority to invoke this closure.
 * 
 * A subclass of Closure should be a final class, because this allows
 * the possible invokers of closures (typically Principal objects, via the
 * isAuthorized() method call) to reliably inspect closure objects via
 * instanceof.
 */
public interface Closure {
    /**
     * The code that requires the authority of the principal P.
     * The label {L} is a lower bound on the side-effects
     * of the code.
     */
    Object invoke();
    
    String jlc$CompilerVersion$jif = "3.5.0";
    long jlc$SourceLastModified$jif = 1466731418000L;
    String jlc$ClassType$jif =
      ("H4sIAAAAAAAAAKVZe3BU1Rk/uwl5gSREQoKGuCQBDUK2okVtRIEFJLjCTgI+" +
       "YmW9uXs2ucnde6/3ng0LSge0FNRKO5aXM02qDrY+KNRaRsf3OLbio1U7jlo7" +
       "Pmb6R+202OrUtk5L7fedc+5j7y6xnWZmz9k9j+98z9/3nZPDJ8gUxyZzRrRs" +
       "N9tiUad7rZZNKbZDMylT37IBhtLq5/e+mjl4rfVBlFQNkBrN2Wg4SpYmSa2S" +
       "Z8OmrbEtjDQkR5QxJZ5nmh5Pag7rSZKpqmk4zFY0gzk3km+QSJI0aDCiGExT" +
       "GM2sts0cI3OTFhw0pJssTgssbim2kotzVuKphK44DlCq4qMukRrLNse0DLUZ" +
       "OSsJjMvVujJI9XhKziXxV0/BJjGXvJRPCMcpC+n2nRvfe2BTw08rSP0AqdeM" +
       "fqYwTU2YBgN+Bsi0HM0NUttZnsnQzACZYVCa6ae2pujaVlhoGgOk0dGGDIXl" +
       "ber0UcfUx3Bho5O3gEU80x1MkmlCJXmVmbYrTlVWo3rG/TUlqytDDiOzfLUI" +
       "8VbjOOiiDtRJ7ayiUndL5ahmZFAXoR2ejJ1XwALYWp2jYC/vqEpDgQHSKCyn" +
       "K8ZQvJ/ZmjEES6eYeYYKPuOURHvQEIo6qgzRNCMt4XUpMQWrarkicAsjTeFl" +
       "nBJY6YyQlQL2ObHukj03GWuMKOc5Q1Ud+a+BTW2hTX00S21qqFRsnLYguV+Z" +
       "9fTuKCGwuCm0WKx57OZPli1se+64WHNmmTXrB0eoytLqocHpb7Qmui6uEC5o" +
       "Ohoav0hy7vwpOdNTsCCwZnkUcbLbnXyu7xfXbn+I/jFK6npJlWrq+Rz40QzV" +
       "zFmaTu3LqUFtDJFeUkuNTILP95Jq+J7UDCpG12ezDmW9pFLnQ1Um/w0qygIJ" +
       "VFE1fNeMrOl+txQ2zL8XLEJINXxIC3xmEBLdL/udjLSCMy9ybDWOkcWdIqGb" +
       "Dvh2NwxYjFwUHzZzND5CM/HNpj3Kl2Ug4PmXyfYW8OyGzZEIqKU1HJQ6+PMa" +
       "U4fATat78ytWfXIk/UrUc1LJNaAM4hQS7paESSTCCc5EHxY6Bg2NQqwBS9O6" +
       "+q9fe8Pu9gowrrW5EgUucOdvcX/AxhAnPMyW9lvj7/zqD+dHSdSPyPoAwvVT" +
       "1hPwAqRZz+09w+djg00prHvvYOp7+07suo4zASs6yh3YiW0CrA84B9Cw8/iN" +
       "v/ng/UNvRj3GKxiAYH5Q11RGapRBhFWVMVLrgYEQbMYX8BeBz7/xgzLiAPYQ" +
       "5wnpXTHPvSwrrI45p4pDjiGHbtk7kVl//3kiWhqLfXuVkc/9+K2Tr3Yf/PCl" +
       "MqarZaa1SKdjVA+cGS3JPVdyiOrlaUKFAL3w3pWdrc/fuCdKpgxA+nBW0qyS" +
       "11kqscLMGwCzM72hPgoIbHDcL5t7qi2V72GkuSRriGwB22yfCG7rBjHPCqkk" +
       "zOGDVx5+6fL56l1RUiHxqQwWF2/qCSoHIF2cimrGkTo4tD0cILap0gw4vH/u" +
       "gphyLP30ts4oqQSQBXkZSIuY3RY+vAgXe1yPxqOmgMhZ084pOk65mqpjw7a5" +
       "2R/hkTtdOBgYjTvLTPg0g18ast+Es6db2M4Ukc7Xn8nbNmzmCovj13ZsOviy" +
       "eeAB8/2gAajTAW4hppzOjUbOzGhZTRnUKYbzv+rnnXfsT3sahHPpMCK4s8nC" +
       "Lyfgj89eQba/sunvbZxMRMVU6we2v0zg9+k+5eW2rWxBPgo7fj3n7heVccgE" +
       "gL6OtpVyQCUyipCpS7jYF/K2JzR3KTbnQzxrxpg5SuGQZj8CuOfRjEhO9z9w" +
       "+EjPtAfv5zBUyz0VqhcudTegD+5wf9dx0qcV2+g0aZuhcjZCFPbP5cSxNlJy" +
       "nIW0WveZknjqwPJ1XE2n8QLM9T1GZgciKBWcwlzeHCYrKVZeH8t8Gmu/jjvs" +
       "1Ax1VFuzXPjEMHC0nKWDvWhGiljFzLWgf6/OsxXD0QG4RLxu4JOrCpaNVcaY" +
       "YnNDcxW0FhCKPTY4i4Ald+yyzY7bl0SlJXyXnorqmibVlJU9DaqLkXO5MDGu" +
       "CQqoG0vGzGxMRYCMhdMS7lkDGj6L8+CyLfjw2U6r7yRPTix965ljHOjR32aH" +
       "mPbDfclLD1W8dtXXx4UzBMK9JWALANBggSYrw7ZTWUsUhoXSfHyVYvsnL34o" +
       "91m0vernUVINEMyBFUr4qxQ9j/ltACpSJyEHwVOK5ourS1FK9Xgo2RoGqsCx" +
       "YZgK4mUl85Cy2Izz0YyLZC3zsOwPBc1ICP/SXx6cKjg4QWg6/A7AgAXNUHQB" +
       "VAwCwSktOlO2loMiYEwWnXT33tu/6N6zNxqozDtKiuPgHmkEHr/8IAzNuZOd" +
       "wnes/v3RbU8+sG2X68xdwK3u5q2G4uguNXr776p39X60FqClgqfVhMnjByyI" +
       "JPhQr1E8NFVzgAtD1SypkS5s0iRCuBqbsDpDsORxIExNIh4CRriCI8V8JRRA" +
       "Wzvhpeq02j73hlXH1196nKuvznLPK5uHYmjtLhmst8p+axHGFaOwz0Onz4N3" +
       "htCSJ2JabdVy+UN/fTlVBgGR4sqCG99hOj6JPQ9+v/rPCz+/hweth2YdITTz" +
       "NkyKaNhe7gl/Ngp/jhT6FtnvKBH+Cp5eQrXxGsUZhsh9R397YN97C9pENReo" +
       "XOX8Eyt37tv/+GMXiPIZ0bHhsmWE+GX0lR43s3GwUwbcfbI/UCbwnMkCD5ur" +
       "sbnGi7gUXzkg4wK766GU9HTtFxo3YLOVSCfRxNqEx2ATMjhLqsmSvfn/AfzN" +
       "QsMSUOD2WJpONVvmvlmftset1Ss/5I5QBxiZTZlQzG9BEAwXowlvFitSrPCH" +
       "3MVzShb3+tMCQ1YJXXGubsX7RjgFSZ6CaWi86cBTjQ/ftVx4Qihplay+5CuJ" +
       "b6UveOSXPGlxHZR4B8BkWBl9VIHbneA0rX468S7t++rnH4sblrnZCL/meCb2" +
       "owMfgmxOBc+8DThtKdG4JL/kznuOnng/tUzAiF9XFGdL+WIUUN50oTxsvw1C" +
       "zCsX3itMxswgTizteHek5+QbP3OReNRD8a5iTYZ2BnVateDJ2Xt+u329sEDY" +
       "ZuV2XLZ45jMftcy+SZYOeOadgTD5jlXOCFfbGvONEOtOPv9sdd/LASNwzYKe" +
       "N/OFQs/Y3u4rZh8Qbi+nmA2mFdDKplmvn9v61LW3lWplfrF0wW1BAZub3nvz" +
       "+Niaj10C3xVC7g8IeVAMLfLCHN8zyEL4NAL+LJV913/7aBEqVP6nB48yeye7" +
       "BvmA1wHlhqFgapf3oVPfHA5NMvdDoQlsxvnA4JcdfA029xWKrwzNUmfnyL4J" +
       "Zyc4mPxgktMPTzJ3BJsfMVIzRBkvTvmqZcU265DnXeDaLHBuoRy2bhjWHImt" +
       "+/82s++Wq/+xkbtxVOX3ocVwP8rmdX2d9wTBsdECmL9IwDxAOxumMceiqqbo" +
       "MTfZxtoZUG6PaUYsXM0ghUc9VPD8N6EYhslKULJK1Y6diGdPuu67kwszWKZK" +
       "csunen+C6ykSKdEnH9gujAyUMuLlI2apMa/0e5Kv+WZ5XMbB3b6PPOtH1HhR" +
       "RJUZ2utve8FHm3EPbUqHeAbC5qiwODaPcAKPYvN4JILdE5xpvhZEqpb5FdGr" +
       "peTlXrw2q0cm6muaJza+zS+S3otwrTR58KIQ+F5l2TSr8eNrBdZbvHsVPNPN" +
       "7oxUYsfZfUVMv8ZIBUzj19ctq0ACj1fCPCOeI1+MOv6aLH4el/1jwRojUDA4" +
       "4eI0GDJvFT8K4LNYXvwzJK3+ZfF5K585Pv9FmSk8HdEC6+ali/tM5e04OrF2" +
       "3U2fLBHPCFOgntnKi+SaJKkWbz+yug7eOsLUXFpVa7r+Of0ntfO8KzQ2jQGk" +
       "ayl9Z+VPPvx3f8Epqpll0g7+yyatjpJtd7ywq3EHsDtAajVng513GP7zpFZ1" +
       "r7ZIa50b0Vyd7wPhs8NZM0A2GJmRkbvXJ6u/uMaLzLKxwp2z4T9R+8XZIBsA" + "AA==");
    
    Principal jif$getjif_lang_Closure_P();
    
    Label jif$getjif_lang_Closure_L();
    
    String jlc$CompilerVersion$jl = "2.7.1";
    long jlc$SourceLastModified$jl = 1466731418000L;
    String jlc$ClassType$jl =
      ("H4sIAAAAAAAAAMVZW+zk1ln37iabS9PcaJo0NOltKU2crj32eC5Kg5jxzHhm" +
       "fJ3x2OMx0MX3y/h+t9ugUqkXWqlUkJYi0T4VCapQJKSKB1SpL0CrVkggxOUB" +
       "2gckhEof+oB4AYo9///uf3eTpvSJkXx85pzvfOe7ne+zf371B8C9aQK8Mwq9" +
       "2vLC7HpWR0Z6nVOS1NBxT0nTXTtwQ/scCL3yOx989E+uAI/IwCNOwGdK5mh4" +
       "GGRGlcnAQ77hq0aSTnTd0GXgscAwdN5IHMVzmpYwDGTg8dSxAiXLEyPdGmno" +
       "FR3h42keGclpz5uDFPCQFgZpluRaFiZpBjxKuUqhQHnmeBDlpNmLFHDVdAxP" +
       "T2Pg14BLFHCv6SlWS/hW6qYW0IkjtOjGW/IHnVbMxFQ04+aSe45OoGfAO+5e" +
       "cUvja2RL0C69zzcyO7y11T2B0g4Aj5+J5CmBBfFZ4gRWS3pvmLe7ZMDTP5Zp" +
       "S3R/pGhHxTJuZMBTd9NxZ1Mt1QMns3RLMuCJu8lOnKoEePoun93mrR8wH/jM" +
       "h4JlcPkks25oXif/ve2iZ+9atDVMIzECzThb+NDz1OeVt379k5cBoCV+4i7i" +
       "M5o//fAPf/GFZ7/xzTOan30dGlZ1DS27oX1Zffiv344/N77SiXF/FKZOFwp3" +
       "aH7yKnc+82IVtbH41lscu8nrNye/sf2Lw0e+Ynz/MvDgCriqhV7ut1H1mBb6" +
       "keMZCWEERqJkhr4CHjACHT/Nr4D72j7lBMbZKGuaqZGtgHu809DV8PS/NZHZ" +
       "suhMdE/bdwIzvNmPlMw+9asIAID72gt4qr0eA4DLnz+/fywD3t6G9vvTRINc" +
       "xzwLCtwL0zbSr7cDUQaMIDv0Dcg1dKgMk+OJTG8j+dR5o7VVt/eby0uXWrO8" +
       "/e4j6rXxvAw93UhuaK/k0/kPv3rj25dvBem51O3xaflc7xhfP2cMXLp0YviW" +
       "LobPbNxa6NievFakh57jf2X9q59895XWuVF5T6dwdQr+J05/rqSvDaFFdxZX" +
       "7YlV2jC6ocnQq7/3NP4L3z+J8kB7lDOlNXZ7Lp69O5DviL0uou9WUVSSC77I" +
       "V/z/uPzuq39+GbhPBh49pQglyETFyw3eaFPQg06Knw9SwJvvmL/zwJ5F54vn" +
       "B6P13t1y3bbtizezS2eCy7ebtu131F3/vpOb3nSiefhH7e9Se/1Pd3Xm6wa6" +
       "eysEfh6r77wVrFFUXbqUAfei17HrcLf+mc4xdxu4E+AlPvriP/zVv6GXOzFu" +
       "ZrxHbkuNrRFevO2UdcweOp2nxy78vEuMzlj/9AXutz/3g0/80snJLcV7Xm/D" +
       "a13bSay0kobJx74Z/+N3//nLf3v5VmBcyYCrUa56jtZ20lM9aDUxnUDxTgZ5" +
       "NgOedD3t2k2txbY+tIJda+PxZKrHu9jsRDsF51kaPcX7afapE4vqFKkPX5BR" +
       "YZtrP/0vn/3Ob77nu22ErYF7i87DbfDcxovJu2L08Vc/98ybXvnep08SA8Al" +
       "4SOXNp/tuF4/bfCuU3uta37+TJ+u+76uea5rnr+pxNOdEnyYJ5pBKWlGh7rT" +
       "lh/9pMdrTwOXOH7rgOI8oRqffOVTP7r+mVcu31Z13vOaxH/7mrPKc9r8wTMb" +
       "tLu86412Oa1Y/Osfv/xnf/DyJ86y8uN35tB5kPt/9Hf//Z3rX/jet14nRdzj" +
       "ha9r+uyRDy/76Wpy80eKsoFOhd72COWlh1n8dr4JSSLHN9OZQCLhUcy2q/li" +
       "Tbn4zlqBB38/zqUUybVANwYQGlgwxVsGvGC2JIspEg0j8Sw5gCSzVbapibKU" +
       "6oQ9Yeh64ZDz1cEWRGCETYTsiFFD09A1EHOH9aAK9rLfjI9jFxyPmnHLV+Zm" +
       "65ElVLXcbJNtyowzR1D0YSLLDKnKM7r2duhwNbUzKsYgA/Rdr5+Y4tRbbJjj" +
       "NGGQvdXno4PPKwgvj1g/UeeZO9sct9imWstY4NsYp1jDhJfJKPaP/WZxgK3m" +
       "iB59cMOvV7Aywx1iXu0IGkmzFNZWKLtb2CUcrdt6bKWp6vjIMcwaMScjm+z3" +
       "Zx4e92M6P24TikkNeEYJMsuna5cuxNxdr8aSTTaOVIkwNF27hFSstxxOaxEO" +
       "BkiwLUwDme5KeJTwHDyJdYM240O5E5DD1GLAaerASxpmhCyTgzTYNBNcPoi4" +
       "MlAMJMpdRfTskLDYI6wTxGwlee05gQXNFCp0aocYi1pzYQRXPfroe/ha8kVf" +
       "PSQ7T9yHaEJAO8GL62w2c9jGpITVSFRdlnWcWbZdD5XaEdpSiym2Ly8mUrhF" +
       "DHfdk8oJddhHiHvAoSKeRzNrs+RJvA7Ikbwp1pDsu/M5PzAOxuFAcjkrbJfF" +
       "Zr4KB7HVbBmczvqSENGbfaIkR0ebpO7OWHjBdH0YHOqNt6EQVl3mRxdGiX1O" +
       "k6yGbXqCDirgdLdH7J0EwzzSi+PFNg2og5WLoDw2dzmJE2WO+/CerLAhK3Oe" +
       "00sNcNDfLxnf30nJFDbCuo2VUFtG6nDj584gn+NYyNqhUsB2PSzKiNWZXYrj" +
       "pRwcBU2l1ECq82FlSmoAriB3QQ6CaO3tkxjcNn1404jNwld2OUrFwiKbrReG" +
       "cMyZ3Yrixtg6BtdDYYZHRA8xmll7ZqIFFbR6+FAJx7W1WouLec9kDDphPTCr" +
       "NkhDjSRqvl4xUrXC0cqfTymdgnLdpXicrse1OtuzR22vr2JCnRU2wpTVwV2U" +
       "wrKRG2aG4TS0ZCIXJT1EsPqcL9XmYT9ia6KR56uYFHrL9WYAcrQi9M3JTsmG" +
       "ozrbm9LqCAmJoPWoNaNM6L694YeRMuf5HY5r2HxZHQZTC2E2cTnlx+wAjMem" +
       "MeLysRWWSbLH5paQa6xeaBI0qexJwNH1fuwV7hBq4hmoL3md52ounJSFuOvZ" +
       "XDmJt3IDwuMS1F0LhqNkWRQHNhqC8DDNw34z4dNBbaMHZw/jyWTUn47xcgQ5" +
       "TAG1FV5giq2LEmTlTA7LNiR6W0KJtlN7sRdpkUqsw3yj0gdpNDWmzRCqrIZy" +
       "Jtxhg5VBJO2WXMG3Iq/6WNSPZq5DLNXsODyKHgShR2dvx5Qp5eJRg8YgiewS" +
       "9GBCHO7RsZLIitLjSd0VJ6BG8OiaE/XaYRNPEcjFhEJLNNrr7YOemeM6GVnV" +
       "BAym+9bDfK93jFONookSb+ghYnNWuFKXM43CsmHsIOIQIY45v00copwiSG3i" +
       "xDCZuksOj4/HhiVmYoWBA5PCBl5vKzjLKt6U+wUCxTgfLlcLRHP8hDjuwn42" +
       "a3MTpUSwVfaLJZRbkV1THApnaT+MN/xmKh1lfpUf0O0BLCaWZPRqropZ36Jt" +
       "GR71I/Y4wPw4csuhgiFbyD7uMp2dWgd3V1A7zoKt3qitj+A8HegqQveFozaU" +
       "glGgMn7j42Hh9lA5ZQunNozJdAQh1kRxd5N9346ihnUFlW0IW95tA4E8qE0B" +
       "JkEgmekOTRV7yUU0TvbTUYBTtWm5o7GxURUozYNClSt6S4vCoDSQAm6sMXgE" +
       "MWOPJPtq2tpxaLpoMLQNUdOsuUUN2CwS6w0u1E6ER/zQPSwgElk3W5TcqW2y" +
       "rJIqsjA+JzayO8Jz1ty6c5sdN20Yzl0um5gF1kyFuoHF2NZyfWdYMxArzbFe" +
       "wbEmIqAFK3Jua66MLziVwzS+Yrx1Haz28L4w5GPgxiXXJsU5Eow2FD3e9QjZ" +
       "0hxyutdKrzGW+CHpSuxylI0IP4dct0h7k6onLvJG4tw5vcThgNzPir1NOJ67" +
       "aKi9ZQ4gNq2kGbwh+luqyvtrNsEjhRE15XAImJlW7eGFjZPc7tB3+hNPB+u6" +
       "OQxVD+a9tVRLQZjEvqOK3loYz5SYOkosRs+6kh6HBFwQDdHa94DTtk7zQ+84" +
       "I9wBNQLxmjLdEhEGybDecjunGg8wz12y7hZFlKXPqTNT86hZbz/SM0mq+kIz" +
       "pcnxej+hJszUsvhDUg7l3V5IBTuUeHNZi4eiTdFoPxz3fLgwkkAQV8ycrqcL" +
       "IenH1WbsQl42aV22rufLUmRJrH0e43sLcixZIbINiTjFq4NskX1f8EYYXiOr" +
       "poEPNSXjaJOyJTfVeiucg3ipGmika/U3e2sATYYTayIxwnIzFSclXvLHjPVY" +
       "xAtp5zAv94G0Q9EshwbMoGGqOGxmGenknLX0j/NlAo1Wk4bJZVYvg/YZrkC3" +
       "qjACUwKRBqNKL0k0x2KE6OdWzkjJcDiI0LE0gBcx7lmxKdp04E7rerXm7E3S" +
       "m4+YhdhYk2zW4+voyGMp7GzxfBqr6Syapey2Ws0rZmX38TYL4G3hHa2328m+" +
       "Kez2DQRG3CFqe9Ky1xsPAjIvmoDiSCxfHnw3o2w/zUYRqFRLYqGwZQOzQdNn" +
       "UDvD+TWyVlRdrEGBgcy2yE8tYttPY5wYj23WHay5zRgsoITDGxCySyOzkYO+" +
       "2u0a5liTCmMbQ8uDGCuCXHs3WGRBQU6XIB5hxiaRKiIVZDu1x1t0PDww4yE+" +
       "jubM1gglVhrN6wwdZgUEErTkcCsZVpd26u/nICHB3raPpihRCqWqmeoKEnC1" +
       "DOgjPsPyJFUDwhlagtQcrX5JDgcDQhgvd9miCtEDxYo8bm4rJp5XyGRHuzYV" +
       "pz5fmAE0MRtmk9K8wM6Q/TpiGbHwC883s/bdv8enELbCNtPKkXeyt2mI8XQ+" +
       "KaWw9IqFk/Gt9kuUFhveVlEwo/FN77CWJCJXU2m4da0FLw9wZe+MBtp0524g" +
       "MxOr/saxI0+pQQzP1+pAKAyWlzjCq5bytj8dTY/7qTcWV0s1MCZwIvUHI36Y" +
       "gW2+a5+1VS8JZJyCfANXkbCkTcuv2KkGjmY7OyN1or+moGMT5GzQlrlMaCbO" +
       "YiwtCJ0C9ytBYDA43FVpUfbwBk8l1MnoKi2tndNkxtI4YuBG5VB2azDb2UjB" +
       "nN1BRqaB2L6HztaIlIE5iozT+ewg5yIiUXIfc2kz02qQlw+swSq6tZthriex" +
       "+MJUiYJl5mzGcsU41XWImvBM2RxIg4HYxSaFDmjeT2R7tFEdMPAniL/QZ2Tk" +
       "+UUwLgY9ao96+8gzkwVc7nvTiZyraFA0IOMobg9uH2lEfGiNVoY4oSmTwpfM" +
       "qKnnVJ+ZUCC1Fsc9FBoq03kscoNg2h/VRm0Mp4U/6ZVLz44XlhKZaChy5nKC" +
       "MXShz8KNl1ZFMOmvNd2cwMi42pNJ2TCCbwY11V/Ltdb3uco6ZjS3a9bodJ2a" +
       "tLhqttNjsSv8WNYEZIDNAsmYKdRymofbGlFtd79c+RkIjZAUBPcxBFZHNatE" +
       "VkJDTSy5UeLrEqKPy9001ee4T41X5ayasFXu05rhxLEa0jtTrrJQFogBpwiH" +
       "tH0hsmxBG4vcbMQM5gc79UiBWpO9w0B3CJ3L88HwWKbNnpRJrS1+RgDig/rY" +
       "PnLMg+XYyt1JLdA55a0QJaIVCDYwsgD3MibR6hRVBxzHZsve0t5u14KM5Flh" +
       "jBZLH51zqhAvjYmKY7FTsjOF0yYkdyiY/npF6XOsigpbnseRii10IomMnScl" +
       "JRLDmj/wc2XdKGDDgzwaZmWy22IjcrUBF5iH7PhkZDDJVJfVYpmKHMMxw7Bq" +
       "tTRlUxDpYiSvpkLj9sZaFsMT3O2ZOIezxqoH0mwxaO3cNzyo55bb0BVmk37f" +
       "WMHEbF0sdiOyTzEHqSibNYmCsrnASGyEtXG48PnjaNnaegAqngNlNGbAfTZZ" +
       "IKiAmNS0fV5asFaQBaQD8sqaPO7VBqxza2iwKSVIi0hUhgnImnCQmeyIbDaI" +
       "uyGOSu2NZVDkuKJCzdE8iiPPg61hW0WVzI3WmT6syxidL9NZ1j7OiIGF9VCC" +
       "GzbRQu4lQ3mlYLAKi7U+LDk7HTEyDU8QYu1vj2ohrQc5lNMK1VBkVUZI09+N" +
       "t+BIag2Tti/bL73UvYZ/4KfDKh47AS63QGzXMbuJF07v9tUbscqA+xU1zRJF" +
       "yzLggVt4+Rnf2wBAoEMjnvlxyPMJifjyR1/5ks7+fq9DIrqF45ZhFkbv94zC" +
       "8G5jdU/L6R13caJPaPsF6PeH9KvfIt6r/dZl4MotvO41oP2di168E6V7MDGy" +
       "PAl2t7C6BHj3a8CUUDP0PDEu9n3+ncrXbnz95WuXOxYXIGbH4W13QYJvMsPE" +
       "V7xug5tfCR7M7CQsL0Zuxwc7xTs7vqW9nmytH5zfP9jNPhp17WPVBRbzGndd" +
       "vuV5/Nw5CfDeC4QPDz3P0DoAML0mBP4Jq1JUz+iw3f965Od6X/v3zzx6hgB5" +
       "7ciZdAnwwk9mcDH+tinwkW9/8D+fPbG5pHXfXS5QyAuyMzD/Zy44T5JEqTs5" +
       "ql//m2d+9y+VL14BLq3aKHAa44SuA+cB1gklntTenFrhrjmpa+gMuOoERXg0" +
       "XgdLPEN4TxPrC1QWOEfwL92Oynaz74iin87iP1425Q3mtK755Qx4W3sqr1lG" +
       "1t5udOLeOMflb3A3VXn8FmTPJU6gOZHi/X8o473B3Alftt5AGeqmMg/fUoZS" +
       "VOMORc6/pgAvtNfjrWwvnd+f+79+MrkL0/+pPre8zto3MtxFxsXb0AuUDnz9" +
       "iRZs3mDuw2eW6Jr0NCD/pI2f75qqujOPPHlus/ed35/oZrNTHsm7pu6aD3XN" +
       "y22Obz11StY3nfPIxaE5jXfDv941H60y4L5zX3bn+KnXfCA++4ypffVLj9z/" +
       "5JeEvz9lylufGq9SwP1m7nm3fy65rX81SgzTOWl99Sw5ngXtx1sRb4ZLB0u3" +
       "t5NIHzub/o0MuHJe0j7Vhvn/Aph9sre8HgAA");
}
