package jif.lang;

/**
 * A <code>Capability</code> represents the authority to execute
 * a given @link{Closure Closure}. A capability has the authority of 
 * the principal P, and can be used to invoke the contained Closure. 
 * The label L is a lower bound on the side-effects
 * of the closure.<p>
 * 
 * A capability can only be obtained through the runtime interface, and 
 * only if the principal P grants authority to invoke the given closure.
 */
public final class Capability {
    /**
     * The only way to construct a Capability is through the
     * PrincipalUtil class.
     */
    private Capability jif$lang$Capability$(final Closure closure) {
        this.jif$init();
        { this.closure = closure; }
        return this;
    }
    
    private Closure closure;
    
    public Closure getClosure() { return this.closure; }
    
    public Object invoke() {
        if (this.closure == null) return null;
        return this.closure.invoke();
    }
    
    public static final String jlc$CompilerVersion$jif = "3.5.0";
    public static final long jlc$SourceLastModified$jif = 1466731418000L;
    public static final String jlc$ClassType$jif =
      ("H4sIAAAAAAAAALU6CZQUV7Wve/ZhgGHYhm1ohgEZINMBExAnJJAmyGAH2hnA" +
       "ZEjSqamunimorqpUVQ8NyP+Y8xNioqiEJYnCUQ/JyWZQjxyXLJq4QIz6P/6Y" +
       "RDwxOcdvxCj6yTdqVMy/977XtXUNiUbnnH6v6i333X15NQ+fZTW2xWZsUfNd" +
       "znZTsbvWqvmMZNlKLmNo2zfAUFZ+47Pfz911rflSnNX2s3rV3qjbUl5Jswap" +
       "6AwZlupsd1hzeos0LCWLjqol06rtdKfZKNnQbceSVN2xb2L/xmJp1qzCiKQ7" +
       "quQoudWWUXDYrLQJBw1qhpNUSk7SlCypkCRUkpmUJtk2QKql0TKQetMyhtWc" +
       "YjlsZhoQF6s1aUDRkhkxl8a37pLFEmXwgj5OHEHm1B1YkNx/6IbmL1Wxsf1s" +
       "rKr3OZKjyilDdwCfftZUUAoDimWvzOWUXD8bpytKrk+xVElTd8BCQ+9nLbY6" +
       "qEtO0VLsXsU2tGFc2GIXTUARzywPplkTZ0lRdgyrTE5tXlW0XPmtJq9Jg7bD" +
       "Jnls4eStxnHgRSOwU7HykqyUt1RvVfUc8iK0w6Wx4/2wALbWFRSQl3tUtS7B" +
       "AGvhktMkfTDZ51iqPghLa4yigwyeOiLQbhSEJG+VBpWsw1rD6zJ8ClY1ECNw" +
       "i8MmhpcRJJDS1JCUfPI5u+6yvTv1NXqccM4psob418OmttCmXiWvWIouK3xj" +
       "0/z0QWnS47fFGYPFE0OL+ZqvfOjcioVt3zzJ10yLWLN+YIsiO1n56MCYU9NT" +
       "ncuquAoatorCD1BOyp8RM90lEwxrkgsRJ7vKk9/s/e61ux9Ufh1njT2sVja0" +
       "YgH0aJxsFExVU6z3KbpioYn0sAZFz6VovofVwXNa1RU+uj6ftxWnh1VrNFRr" +
       "0DuwKA8gkEV18KzqeaP8bErOED2XTMbYaPixGfwh9gvR/9hh3ckho6Aktyi5" +
       "5DbD2ppEA8uBQdMDKPpFtiXTMylMSjKlAVUDF9AFY+Y7215C7Jq3xWLAuOlh" +
       "s9VA49cYGph2Vt5fvPKqc49kn4m7aizocth49GQIu8uDzWIxgjkBFZ0LAti4" +
       "FQwSEGvq7Lt+7Y23tVeBBpjbqoERuLQ94BBTntX2kAOTQXX++wrzxr2XTrss" +
       "zmr6wbHZq5S8VNScTOpKo6iDA5jgDvUq4Bt08kiRXrHOlGmPwyZX+DPux2Cb" +
       "5QHBbdNAXTvCRhOF5tg9Z/5w7OAuwzMfh3VUWHXlTrTK9rAQLENWcuDnPPDz" +
       "E9Lx7OO7OuKsGkwdaHOAMvQcbeEzAtbZXfZ0SEsNkJc3rIKk4VSZK43OkGVs" +
       "80ZIO8bQ8ziQUhPq72L4tTAWv0/0u3F2vIntBK5NKPYQFeRJl/eZh1/44a/e" +
       "HWdxz+mO9QWxPsXp9hk6AhtLJj3O06INlqLAuhfvytx54OyezaRCsGJ21IEd" +
       "2KbAwCGUAZtvOXnTT1762dFn457aOaAIljoMdl9yqcQJNkpQ9++iL/mohOPm" +
       "egiBp9DAWwG+dsdGvWDk1LwqDWgKKvpfx85ZdPw3e5u5ImgwwtlqsYVvDcAb" +
       "n3Il2/3MDX9sIzAxGSOVxzRvGXd/4z3IKy1L2o54lD78oxl3n5AOgyMF52Wr" +
       "OxTyRzHX9iZ7tkfqruS4r773/ocf6W564F4SWQOZBwRzomIaSAp3lN8biUWj" +
       "XTZORjZ2CvYdFv0dfmWBc6d65xJwQHmQEMjK94/+zjNnW1efJC2Py6rDZlSa" +
       "UM41i26/VwJNLpoQAcnEBbLxYQAxPQxikxSwvslhfAQy1dcncq8l2jcTMqNy" +
       "ii1bqlnWUTzOVgumBoJTysfVOsZaEISbL1mSbmugZ9y7bKDJq0qmhdF6WLJI" +
       "4sS72SXUdxeNDKZhWXnpHXssY/btS1B3g0Y5O4rPh/x8dthGpLpgWOaQKieI" +
       "sISRT3D7T0jWYLGg6E5C1gwbHA1O+XKmxLwB5KKSS0gDxrCSGNie2OkMqfau" +
       "ToT+XhDiHMK2TCAEAV03nBCZWblWVo+fTebP87A/M7inYvVlF6duzV7yxR/E" +
       "hX1PDseRNZI9BH7gBe35/gMvzm/jUH1+Qsx/fdUtBw5+9SuX8FCDDqz5ihWM" +
       "/oiPCfAAgm44ZVpY/BuAUKECB/8woffmD/5pI5lCXCadnwk2kC9q2jo3HGK7" +
       "1ASWf8BlszOkJGxTkSF9TZQlnWhHFrYnVD0RETw3g0/SZdWEDZmFQl7p600S" +
       "+XISanN01MUgHoiiaUOWNC9ybPjoieeX3H1mHzmSGs0f2MKJXWindlQ7kf79" +
       "9h9yPoczBZ8VZeXFDxZej7fXfifO6iBIkyZB+bFJ0orouPshm7ZTYjDNRgfm" +
       "g5kxTwO7fRnoklAI81t8NaLiOaIxQUe0SBjGvVGOKMbo4Wra0k7tHGzmlYNE" +
       "TV7VJU2EiDfhLwa/v+EPYeMA9oB9SmSTCTedNAl0irYuwubdhN5VFRVgX3HA" +
       "dnw5+DXzNj35H1PsOzjHO12OQ4XURbWZ2Bre95MXqhaPcjo+TnpaPSDZxJR6" +
       "4JyNKx2WGLn6I1jdhOAol391SFsr/OAlflD0t4AvrUwtuSGJtPQ9f19a6u2l" +
       "86+h8ydClevpuWunEyo5l5XHLfvUQP7mFSdIuccSsWS6fZzsub48z9vU0Rdc" +
       "FyxfI3mdlc8c+9jJWa9uGk91SZmt/kTmasnsDicu6JBgvKbu9JPfmnTjqSoW" +
       "X80aNUPKrZYoB2QNkHwp9hDk2yVT+KiqbfUiIYkDsCmhqOCZ3JKnH6z6z03X" +
       "HeZh2pcRtgaJ9leSooRt860IQOUVLMni/a4uzEWsLhI68JDoj+JsP+n55hLj" +
       "tjQUbUtVDqs1iwOaCklMrU1V/zu0LgdkYFe6r4ylFiCJHBZ1qXLb/tvf7Nq7" +
       "P+4r3mdX1M/+PT7yR2NjYLoy60Kn0I7Vvzy269H7d+3hVtsSLEWv0ouFzz93" +
       "/vtdd738dEQd5Tnk64KOvFIu7T+v29NzZi3kZVVUCKUMiiw612Qa6tGDQ6NU" +
       "O1MOK0TWMDYlFmPBw3jgoyNF5Gt8XUo9dmjlOkJ5tOlHxmFTRtIfzrulrurM" +
       "QiG2C/d7UPQHgnkKPzxBRygOCDpNyQhqbVScxG277IpkgtDwJxMvpM8fWf7c" +
       "E8cpmeBhVHHxWlAuarAY/7Po/8+Pl1Dpm9+2SuPkB4j8XlJPfLLolQa3UQTH" +
       "ZkcIlymIS4cwq8+J/lCEed0+Ai74SBpUwEan4wzAIePhYHBDKzqswU0zuM5h" +
       "Szz9JC8KOjylcFdy5rqKlJWnq4Xi0d9/LxOhHAjqQ26uF4bjgdj7wKfrfrfw" +
       "jc+Q93Lz5tmhvNndcMHcGdtlLj9nIj8TQtf2i/7OQA2C3W5qV4TSw5Bs2sp5" +
       "NurHOdG/EqEn91xANrdisyeoH5mwfnzC1Y99pVJQDiMHrkXd8rqnjGWdJIda" +
       "zC47LqZCMSLoQWxC6AOUwFOwpXMvJkQWUJtEaglvnieTj0/EYhWTUVlzRlIt" +
       "4TsmvdaeNFeveplk2wiRKZ8xwFS2YykWvndJubN4+YJ3roPlxTMqFvd408LT" +
       "YDMLnEhzjl8BJUxR6+DEA3hHEHYTAku/qzg88dBjLQ/tW1musy7HKN4WJrBX" +
       "kXKKxU/Pyq8dOa30XvrGb/m9hrFND1+Tu1rvKTHesFsEBU95BKyktYKLAvyS" +
       "j33m2NmfZVaQZH2FZjC6i6t4H0PGcIZg+8Xg9ZpnhRsM02eIN0z6rwXTH7v2" +
       "I2Xi93MIdN8RYJ1/m597kye++OzJ4TW/5dEvzO+oHVcsnvDEmdYpO32u+Uvi" +
       "VOy+HMn+D1qq47E/0ZV+6ht1vd/zsZ94ChzeRgs5h7E95rHk627hGmLJlYbj" +
       "GH4Pt3z26S3d5099uZIrnUECQzsDxe/8R6fs/enu9WUYxzmpj/pIfZwP3cf9" +
       "ABnokzTy0Mje6fOe0/i2B7A3ADBi6Gvetqc9lve6LK8c4n2re18UrDJX49cU" +
       "LxuVdyx/Zd/fbuqg5GTMkASpCCRJ+PFGsciw3TeHjQunD91vVZiGDutPPvzp" +
       "qanLf03W4aW+uHtmKHltQcZ1wW8SeGPG+/j/+D24KAR/FO3B4/jYyZ138LZw" +
       "nAD2c9E/5wPqu2DA90VBdOaIHX+MQoeWrvrX3CYg6NNvfaNA0YHmOWtOly7A" +
       "m1tDvKG/JhEqnxX9SR+FPq2iSDJjpE9SlPQevXn/kdz6exeVjWgYUhjHMC/S" +
       "lGFF84GKV9TWV9NHOE9pln52Vcf0p27a+8/7jkDaGv3JYGaIqDAyD1z98NPv" +
       "myvvA3NxvxZUfFgMbgpfdvJTNwQuQNpcMeBdNpvHi/iq+aIf7Vc0EvAItx8k" +
       "2JC+NwogTaKvDcs0Oon43QXmzmHzK4c1DipOKtJeiIwZ4sSZUWT8q+3l9bdp" +
       "L1FpkuvbXyVyH8Tmz2/Lv/MN5z2v/Gqlow4Ofc3dFot7MeDVyrDgDnnR5hWX" +
       "33j1QFXbVOCzLPq1I6gNNr9xt8Zwa53Y0iP61NtSkljTBeYwpYnVQZ2l6sPG" +
       "1rCCEMJTxWnXRSEclayuNVRdJKvj6l96+azVvqScrBZMQ1eErc+GEZ0uzCFw" +
       "cXMPFbhjoo7P+I/HLja+MhN1UfCnDD899fx9n7t9VN7NRKPVBLOYt/yU1Kc4" +
       "u2fsO/XxT+3eWAa3MAJc3AsKO12y8OaPClMkZ7Po+/1k/SN1e2war7x4ZV3i" +
       "jMFnuvFDgmgPvwJmnj15n6x8n45WFp2hlOuas3L69R9PGp5nfJdnzK45R37T" +
       "xMsstkyQtVP0RoVXWVCBAb7f6YJZimDeI7bvEP32CjDRlSaO3UM8mFsKcR8v" +
       "TOgTD8JTRJ97x9xf4Oc+GT/AafTWYNrdWvFfPPw/T+RHjoytn3xk4/P0Mcy9" +
       "m28Q30L8V/K+51rTUvIqkdrARWASxYscVl9G0mHV2CFusYv59CUOq4JpfLyU" +
       "zGdmiQVy0aAYLkd2XcEzjXid6Gv/LjFcwP1cFvxSiolFkf/DVFb+38WLVj1x" +
       "cu4JUfqMeIXs7Th2ZO26neeW8G+rNSCuHTvw0HpIKviXOaGv/mvHMLQyrNo1" +
       "nX8Z84WGOe7nQWxafA661R+HWr2U7R5uf3bglkbUn/5/68rKW9muO769p+XD" +
       "gG4/a1DtDVbRdvAfrBrkcpaGsPLlT2AkrVUA+F3hMtAH1u/wYlvuXp+ue/Oa" +
       "Czs8ykea/x+zYKnuRCcAAA==");
    
    public Capability(final Principal jif$P, final Label jif$L) {
        super();
        this.jif$jif_lang_Capability_P = jif$P;
        this.jif$jif_lang_Capability_L = jif$L;
    }
    
    private void jif$init() {  }
    
    public static boolean jif$Instanceof(final Principal jif$P,
                                         final Label jif$L, final Object o) {
        if (o instanceof Capability) {
            Capability c = (Capability) o;
            boolean ok = true;
            ok = ok &&
                   PrincipalUtil.equivalentTo(c.jif$jif_lang_Capability_P,
                                              jif$P);
            ok =
              ok &&
                LabelUtil.singleton().equivalentTo(c.jif$jif_lang_Capability_L,
                                                   jif$L);
            return ok;
        }
        return false;
    }
    
    public static Capability jif$cast$jif_lang_Capability(final Principal jif$P,
                                                          final Label jif$L,
                                                          final Object o) {
        if (o == null) return null;
        if (jif$Instanceof(jif$P, jif$L, o)) return (Capability) o;
        throw new ClassCastException();
    }
    
    private final Principal jif$jif_lang_Capability_P;
    private final Label jif$jif_lang_Capability_L;
    public static final String jlc$CompilerVersion$jl = "2.7.1";
    public static final long jlc$SourceLastModified$jl = 1466731418000L;
    public static final String jlc$ClassType$jl =
      ("H4sIAAAAAAAAALV6Wcws2XlQ3zszd8bj8WyxHXsy41zb16MZ1+RWV1V3VxWX" +
       "Ianu6q26upaurbssZ6iupbv2fXUGHFCwIcKJYBwCSiwhmSiEIUZIEQ8oUl4A" +
       "R4mQQGF7gPghCFDwQx6AFyBU9b/e/96ZWIr4f9U5p8/5zne+9Zyvzlfvf7/3" +
       "VJr07kahVx+8MLuf1ZGZ3ue0JDWNiaelqdh2vKN/EwDf+1s/+eI/fqL3gtp7" +
       "wQ6ETMtsfRIGmVllau853/T3ZpIShmEaau+lwDQNwUxszbObFjAM1N7LqX0I" +
       "tCxPzHRjpqFXdIAvp3lkJqc1Lzrp3nN6GKRZkutZmKRZ70Xa0QoNzDPbA2k7" +
       "zR7QvTuWbXpGGvf+Qu8W3XvK8rRDC/hJ+oIL8IQRnHX9LfizdktmYmm6eTHl" +
       "SdcOjKz3ozdnXHJ8b9UCtFOf9s3sGF4u9WSgtR29l89I8rTgAApZYgeHFvSp" +
       "MG9XyXqvfCDSFuiZSNNd7WC+k/U+dROOOxtqoT5yEks3Jet94ibYCVOV9F65" +
       "obNr2vo+82e/8ZVgEdw+0WyYutfR/1Q76TM3Jm1My0zMQDfPJj73RfoXtE/+" +
       "5tdv93ot8CduAJ/B/JOf+qOfeOszv/XdM5gfeQwMu3dMPXtH//b++X/16uRN" +
       "/ImOjGeiMLU7U3iI85NWufORB1XU2uInLzF2g/cvBn9r8893X/018w9v955d" +
       "9u7ooZf7rVW9pId+ZHtmMjcDM9Ey01j2PmIGxuQ0vuw93bZpOzDPelnLSs1s" +
       "2XvSO3XdCU+/WxFZLYpORE+2bTuwwot2pGXHU7uKer3ex9qn99pZ49Z/Pq//" +
       "TdZ7AB5D3wQd0wDLMHFBx7ZAo7XUU6M1+x9LE/3UPhnMRIu0ve3ZWX2/7Yv+" +
       "dNOrjrqPlbdutYJ79aYTe63FL0LPMJN39Pfy8fSPfv2d37l9acbnfGW9H2rx" +
       "3O9w37/C3bt164Tz452hnymiFaPbumdL2HNvCl+m/vzXP/dEawFR+WQriA70" +
       "3k17vPLiZdvSWiN7R3/ha//1f37nF94Nrywz6917xGEendkZ/Odu8peEumm0" +
       "G8oV+i/e1X7jnd98997tTnsfafeRTGs13TrlZ26u8ZDhP7jYRDqZ3KZ7H7XC" +
       "xNe8bujC85/NjklYXvWcBP/RU/v5P27/brXP/+2ezka6jq5ud4rJuX3evTTQ" +
       "KDpTWifdGxydNqy3heiX//2//G/I7Y6Si73thWuboGBmD675U4fsuZPnvHSl" +
       "LDExzRbuP/4i9ze/+f2vfemkqRbi849b8F5XdnRqLX1h8jPfjf/D7/+nb//e" +
       "7SvtZr07Ub73bP1E+astotevlmpdzWvdvaUkvScFfmjYlq3tPbOzlP/9wheg" +
       "3/jv33jxTN1e23MmvKT31p+M4Kr/0+PeV3/nJ//XZ05obundVn8ljiuws/3j" +
       "h64wE0mi1R0d1U//69f+9r/QfrndiVrvT+3GPDn07RN7t09afLlV1qUjcO2e" +
       "rtuR5l0MPX85RGt70zvJATgNvn4qv9ip+4StdxqDuuJHqtPYJ079d9JHd99Z" +
       "d4xdWa8Kvv9Lr0z+3B+e2Lyy3g7HK9Wj/i1r1xwL/jX/f9z+3J1/drv3tNp7" +
       "8XSCakEma17e2YHanoHp5LyT7n3sofGHz7OzzfvBpXe+etNzri1702+u9pW2" +
       "3UF37aevu0oriJc7Id1vn0/2ek/0zurbf9CNvhh15UvVrd6pgZ6mfOZUfrYr" +
       "7l1Y49NRYhetL52ZY/tb98K0iyzOtfXi1Y52NnDmcF2JnKZUt1osTyH3h/f7" +
       "3e8ff/xKT3TNL7TGn56inXaGZQead7HqDzuefu/Cv+U2+mlN8F678hUVnSGe" +
       "yDgLEh5DRWsUz1+B0WEbSfzsH/z87/7c53+/NQKq91TRKajV/TVcTN6FWn/l" +
       "/W++9tH3vvezJy9thSJ99Rb/8x3WRVcQbRjSUSeEeaKbtJZm65NbmcaJwEct" +
       "sTV4v91NivM4wPz6e3/tj+9/473b14Klzz8Sr1yfcxYwnUTz7Blz7Sqf/bBV" +
       "TjNm/+U77/7TX333a2fBxMsPH/3TIPf/4b/9P797/xe/99uPObee9MLHyjT7" +
       "+E8sBumSuPijpdFE5SUZVQoTVI+H+WJ39KHweJiqS2Y9nlZEQFGEX8+JBXwM" +
       "CHXqCLHm54Hth0kcSTKPMTUH7LCKscPYnlK7YCLxIFUrKu9U9Zam4gG/bEYc" +
       "ONptyLJidaOoJs6oFo1YXtcgjqLbbCsxtrQPgsWoGNkIgmyhIcMDlioqcKWo" +
       "qWQxRhOoYrovlLjw1yrjrWifCeHGIqSZCgxQzmpwCEosTwiYLZwiiYzEzl7y" +
       "hlRaatGIKFUvj1IDOjZmmPbpiUI7cej1R0lmrCx1xQT8XjcFmYGrPUyDlU9F" +
       "UNxM7BWPxjkf5oaiSFtyl9A8NS6h+BgxkuCigjepI3eykdzIl6jMhflV7PXF" +
       "FW9m6/qYKfrO8VL1GPKzUQppErlxj27lYRqCRvRs6m/LgzNkF9OFD42hnctU" +
       "4Gi592lIqVILSpNVgrDqyqltjzTKiWVlqiQRIWn7StGwHTnYPqqzVeIClTz1" +
       "RAMbT3gAD+j9bhRPM7Yv0+k2leBsPtPh+XIrSsSmqUsu8lxR7Xsb41An4nSY" +
       "bT2lv+X8jIpx6oDuSSrw0oEpZFWwOGwEtpTQRe3GtZRBm0K2JB2zV/1ypFQD" +
       "EC4Jeq/MNgLvIZmUCeiYmBdHN1u7lkiqQ8iOucOR1ga1fShrk7Vpfn8UptQc" +
       "kMeRkpZQQo4aCpt4O2g6YUobW/vHSN9QFClA1ESyuOUwB0Z1IRYQs411fT2I" +
       "0nA/gDDWz7KJv7WVQlmG+QqpnD7Y9HklEAaoNZvvuNm0z9KAGhcW6+h2KGdI" +
       "01BQv6YVmgF2y9RmoWA4Wk92Es6IgZ7HORF2R/uEhMZsHWGbNd73pmWVuId0" +
       "Q6HFysXBFDRHUF7hknWEAkeEU9nR+rvDoq9RVTqbVrI0apDVPrLDXdBPCXXW" +
       "jOSwCC253DIatJGA3BlZWaUER0hOmNkm6ZN5uSKwgzuVIWzVxKbGYftpwk5J" +
       "eCuu9zuNs6u5VR7xQ7EB8eMR0d1jOCLcrLaHQ3JPwlE0JbB8zBtrcsVFs8xu" +
       "p9XeWnBWHiFL5AwnZjtgh8LQcIJSMVIpNJGz3jHFZWKA67t5dITlbGgV3CrW" +
       "B7gbDHxUs5tQz44DfM4vcywnG2VZHRx3PFP7NJHZgxlfCtN5EaN0BqA7GMlk" +
       "czyOnH0cTjc5zeOD8VgMsi3sEqzIb7cAUCZNlbT8JGna+Mmo3C/UeChgMiPo" +
       "IhutwpFNEkPnQBZSPBhnfcy1N9tkwXpznytrdQuQXF7Bk/2QX4z3BkNsxWKy" +
       "ObKzYXbAVXBYoiyRl83aOiKypCy2npiIKzwheHrKKHpOBhxHNlOcrlCWRdl8" +
       "lc7d0tAWLLEueH1vThsi26tbS+0L05RxKR1Jlit3IAvqaoCw7lxOsb66ZLE9" +
       "jzU2Lx25GIXpQSYSStEH+zkyg4tlkI1XQ2bF7fiZuaE80FSPEDgYaKC5UIyq" +
       "AXwW55WKS7cRfnRHxDGjKQdh+6Ml48WtPo5WUWfVcMDWZqNtJumcgqHl1IBX" +
       "e6KczCVCzQp2G4gihI5gYxYMhqjGasTSc8K14eF1rPMU40Y8DgA2DfrhkeV8" +
       "82CPI5wklHIOGKkxLxTShegyJpXDalVEVoUNVYMrEXOYD5f+oSwzL053ckHq" +
       "xD5Alh4MImtyi6fLhqjmAitXzaaYbw1w0CDLVQ3RcDgceCSKhZWHBEOCPdTr" +
       "2RBWErYS602z2OK2imauFSe5MEhQFAFD3Ropw9FgNhAUnlXH5aYJ/aUmEBHi" +
       "MdjelhRnK6rsxlHhSbEzZkXfsHxlrI+M0bCiSn7h89O1s8IHINA4TKBApkVN" +
       "YK4eJaTqCZq0HkA2PALlkmLaI5gn9GA63tPVjicqjq9stxLKIvWOFsHXkKEH" +
       "eox5sKOL65ipbRvax16gSGLDyofcH4eUWKeWzKaqNl0Kexryhb2fH1S8Rvcr" +
       "kor7sX80ZiOFppaDVEBhYSsZlcmQK/WobINosU3THbjPBGiMHPq7ITtIuCNY" +
       "YUZ2nEd0dFBYjV/Z5jJdChsRIVGx7yg7en4YTYcT6NB6BwGxwHblV3Q5Hq5W" +
       "gtA/kFUyEeaMbcKsu44tLRdDEdgeSXuxXsHihJgSch8JxhNV2XuKHAKWaO45" +
       "DCXANWoHu0L2ZiMjb2S0rjbg9LiFODI1N4y6xMcL9DA2kSF4WBeNDzrSAgL4" +
       "tAItQ8rG5RDAhXyLzSYkGTdD+6iswdDmJhZBHPzBQJWjHTjOCWk1nYxBrAwt" +
       "yyfBYbQcepPtRDOC0oXdCR7DTogs5isUIgTFwsZe2rAuNa9EV5jhosq3kj8u" +
       "ZskukMn+ZiqWrcxAQTWUKan6M95Do1G/LwDbpaAFTB9aS4dFaNuaxCrMBK/3" +
       "nBPaprlFFpC/aHxhnvYteL2itkobN3k86loojh/xmgv1ZqxismpuZ2Slmg5q" +
       "bS3bYkf2eOnW6hjYz6h+mIQ5lx59VBV3DslsDpZ/GLqVWLKotQlC1yOWGJRh" +
       "jEbbrLaseMnsC2NnXshzdrXehwMl0foumi3mje/tmKkoozIlwVObtI50qYEF" +
       "MOV25prAwzEu+II4Ec12N/P6drLLy3xvHJmhPNvIh5YZohXeECC3DeMgwwXE" +
       "pWzjLFgIZvnBVtrsFRUeJyY+XG/jo8bpTgiIQaRxAqlW1GY0oGpmVcHKnA5G" +
       "S8gxjiwReggOCbM0AVnCszyynw2IIpHKLBfmVMbxuAXh2iiHPWwEHLHamHhm" +
       "EeVKHkzrcOgNtwvaKiSeQ/2ZYCxzXRdSRRhZapPm+wHW4IXU3xj6rK6sJeIb" +
       "no7pAO5Qiobnc7ddV/Uz0BV9LQ1S0tbzETU+FKt9jlOc5QeiEwuhssX6GiNx" +
       "q0TdhWOYZ9xF2e6VpAvXsgis7HhvSfZy55LpxD/G7ERFqFUbJjajpo9sF+12" +
       "C7cxQ3bQKNwzhTDcZNiov+RZSabXgQ1qg7yZKil9XI4wigwdgEo5IBgOj7ST" +
       "Oby0lzKZjFPILllt4nrrRIJksMn79MFwdzNzlAxqb2ZPqMVYheItvQezwkKZ" +
       "GOWAQdKyu4XWIMCJaL2BGWdHh/Wovwr6S1Qumhoe4QvUAJCjnKUCPW2PjDCf" +
       "NQ2OgEVmGCiCGVPeGIqBOxqs2GK2zFERKGCcaVQbcVVZliYraW3b5QiCeW2U" +
       "zUl+xEgstGZXfVFZkztv5nPjEnEOYc3MhvMM20ohbviO13rYMGO9ReXPxE22" +
       "tJok95I8WfP2HJ6ABipx/OIQuCuuqcab+sBOyIip+WO8lwW9msMouozcQ0aW" +
       "VLUuojVmKRaqTzE98s3xUV4sKsUjci0hdiDKhSAGcB5ERj4OwELOueOBg229" +
       "Vrk0HXq8hki8uFBdfenV/lIY6GWMARToTaam0QcIGx0I40gqp1owKBtiaXLH" +
       "3WJMtqFQWkr9Jl8Pj0IrMGqCrVin9vSZUQ+TeOVRShAPtnbfwEG6Yo8Lwol5" +
       "eJTPBnvnYDhoubKS9r90dIDHEboZZv6xYAJDXy/0uZF5tIMHSwcT+cyCbRBl" +
       "eQKeIMowlgeiUA7HKZxGQyZvgxBjDk7jaYBDFcEkhp3WZrgY+qUVNBNoh+OR" +
       "TPGkvV4k7tbAkjhw5opBLQ2tmQxQOlYna4EO26N/MiJYqZyxZbRdF5TLK+2L" +
       "wlQ7eEVgm2IbuE53R0WUZK/ZeMtsIKZ+YWgmMzMLsw3U4dLerFSsKmcCvKtd" +
       "pQgMKt8zA2BHIUnIeVV7is0KY9DHaHFHrulgemwcDxtTUrUZAeSUQI7t68VO" +
       "JNwcjJsDhhljh+bBTIH8PK3RxYoZKFQy3rrb1aqSQK6OMYPVkP62SOZ70MeP" +
       "yYwhIUDMoaRYiQsznaXTsYQPx6vazXYrmihqwUEQH2Z8S5U1Xl3AM9WZjOxR" +
       "Nlj0ubm+VA8Atm2DtSg4btJ1HzaXTL8ZJeVWXKAFvIS3No6slwaDbXYUBPpD" +
       "HHVrEwDYhhqICjg0pu27DhAuZD0NCnLqG7uIReAckApbZmtgsQ4AEorjAToF" +
       "+6oMjI4ZVBhgk6r4YNK+6m0O6fCITvFhsnBHMHqc+zTl7fbOfDHg2pcCeCQg" +
       "xrCP47m6TAJpOuGblKxMENuMrDbeD3JckXZV40cOGC0tteQQ3cKJcXseNGLd" +
       "XzvmyGLNPmjDY5RACHJsj+aFmcU67hXmiF5h+iCAExPCpISktm3MLdFVLht1" +
       "BaoGaO3z+DCci2uXEKLJZEMB3Gye6naJiObC4fOAxKFCVu05mWccVzRRrAW0" +
       "1UeUgaYA+SLzVwsv43UVKhVMMOfcHAAdECDhwYrYgDMWGQ9AZ1erEILRahkQ" +
       "JKzj0zZi5uIcJgm8L49bRS8XW2DNh6aSFMkWmewOI4YpLI0h+ruFzyrtLlKj" +
       "hA9lZLGag9RxGgfVFhc2wIyLYVsgKSea4oLH8WaxDUDXaEZmZcqOcthJR2ex" +
       "noCCN5/NsMF8JeOiIuPMgp3ikRcMYVm3+hGMagAGoo5LavMCoXZzbRmTRE1C" +
       "DY4xXOHXRUEgTFVUqmTNDuv9IbKMghKZks95JtLX5thgomJhg3YMaEsLlfX+" +
       "tCCWWYW5MDUBmDI8iNqqjWvTPhsGA4Tf+k0bKawGOkTaEbvKKNNelmobx6mS" +
       "ImIxgHj43ohoaBa5ebHf1nK9wES/gUG6ANfMsIELcB57YTlgLR0xZmGGrk1S" +
       "rhPyQAbBZthGgAjiQPxsu5fZSUNzMbQcHRgmwasMU0ttiOz6NjeCmExwPUcc" +
       "m7syakMfXoW9UcrNoWQyma4psX1F3G6Eqe5pdc7IG4NaFc7Iw0eA1shFLOjJ" +
       "WF3zkDlNdGA+Vft5M5mV+nbNzfZHJwzbo2kJLmhHA9ZHBpKsSUCSGI5bFR6g" +
       "GS4zKLNZcfKYZncZWEvQSh/ksJWy4LYSAcRUCA1ZE+2LEJGu2pijxliNm3hr" +
       "V233egCEXFBgIBMutQSt2hgQsZ31LMiLGXnwD1xRUn7gQMNgVGHti4oyi+Cj" +
       "x+ZaitAjfINz82gYWJQRtAoYbhBUrNZpmrk1n8lcfxPKW0WejIk9ao12lGr7" +
       "pLlE98WUQ+CJQ27aMJ9FpDXmz9KVvsEKkT2IJEaJGwpHK7yyBmwrDBEkNEtU" +
       "du1mrRQzi+NKUAQ2CyesswCp3AHI9dd6jfswxiN9GpPBFTCEElEqlrFrJMRG" +
       "IYRql+qyh8/7/kKGJ7M83RVDfCKx8YCKLLqWmrnh27xc9zViR7sGvNWnjbO1" +
       "jdbvQdqZ6SUH6bOiEuzQm7kWSMqzPYBgCi07UKXnA0qy4rW53KaoeIRVFh4F" +
       "pqlgcyBhhEm+EIuyv4iWq8Lesq1HgH6xWNN8nTAhFGwxFRsoc9ZEg/ZM0Sxi" +
       "NII2wEJJYAndDHML2R88dy8F4BAcYclKwf2cRUd4BGzJw3wAahCZkfJ+YxSE" +
       "lYwTV4+0ecrRnggTbiJLBDBDjuuMWEA5WO68It9GQG6CbUzUpFjtmhpYAc1u" +
       "FeSbiU4QxNtvd1eJ4vlF6kuna97LxLBjW93A7NGLx7Nba+Xxd8m3u+aDriAv" +
       "7o8/3aLq0L3TXeu+c5V7e4frAN76oAW+9KdfgO4A7p8WqD4E2xfOsF3e3J/+" +
       "njvPe/7eef3dazf319Idve7+97UPSlGf7n6//Zfe+5bB/j3o9nnOhM96H8nC" +
       "6MfaAN30bmROfvQGpvUpLX+V/vj76/d/e/66/jdu9564zFw8kt1/eNKDh/MV" +
       "zyZmlieB+FDW4tOXvHds9+Cz9MXtXzmvv3o9a3Glr0dTFifdXAnyJKCPniP5" +
       "i+d1dVOQV5mlW1dY3j6BhR+Seoq7ws56H++032n+3pXm710RebikpiOk90b7" +
       "fKrXe+KL5/XHPoC1rvjcw4w8ez7lufP6zgczcp3O6kPGmq5Is96zBzO7lsJ5" +
       "+wblz3QTPts+r7TL6uc19QNRfqub+vT5lOV5PfnBKP/pDxn7y13xU1nvjh0U" +
       "oXstI3WZvzlLsD2Ok5cu6Lqos96PP5o//jN34/bQseM8zMw3zhNhd4vQNu52" +
       "CrcDO3vjzbtfufulLwt3333zMtl8KQLvYXd++uaa3ehfjaIPYfGvf8jYz3XF" +
       "17LeMxe0nKDW5xmhruKy3pMdtTcE8PzFtxUPC+DW9/4EAZyl5u6epafv7sPQ" +
       "M7XgJIkLPw+tN750ytt1vV/R/P27Jz2c");
    public static final String jlc$ClassType$jl$1 =
      ("tS4Tvaefp3ncW3c/EPyU/L0CpS9BW+3ehD3T8xlw+OVZqxPbuvtGeNe+pOvu" +
       "lWN2Grv6dVe/+/bdN66Nhg8uWQvddixLcvPBqdUWr79+99HEtdQl0Mw4b83D" +
       "M4NMDN/Q73/gefPWie83H4vxxPIJW2oHB8/MwuCNN39QzPQJM/3mg7PNtcX9" +
       "4N3zpqV5qfngpoV+8Dk0Of/24GHbe+IqUfvW5aH2MyfQv/MhZvpLXfHeWVr/" +
       "mqE8zlifPhf8dXu9+L7jUxd2etHRjb72/42jX/kQjn61K/5u1nu140jX0uxx" +
       "+jiRVbXb6lVX98XEpx75+u/sGzX917/1wjM//C3p350+p7n8juwO3XvGyj3v" +
       "erL/WvtOlJiWfSLqzlnq/0we75/tCier6pK3bXXi5B+cDX8n6z1xHlv9o+iM" +
       "5/8HQ6+yZp0oAAA=");
}
