package jif.lang;

/**
 * This is an abstract implementation of the principal interface.
 * It provides convenience methods for delegating authority to superiors.
 * This class assumes that principals are equal if they are the same class
 * with the same name.
 */
public abstract class AbstractPrincipal implements Principal {
    private String name;
    
    protected AbstractPrincipal jif$lang$AbstractPrincipal$(final String name) {
        this.jif$init();
        { this.name = name; }
        return this;
    }
    
    protected AbstractPrincipal jif$lang$AbstractPrincipal$(
      final String name, final Principal superior) {
        this.jif$init();
        { this.name = name; }
        return this;
    }
    
    public String name() { return this.name; }
    
    public boolean delegatesTo(final Principal p) {
        return this.superiorsContains((Principal) p);
    }
    
    public native void addDelegatesTo(final Principal p);
    
    public native void removeDelegatesTo(final Principal p);
    
    protected native boolean superiorsContains(final Principal p);
    
    public boolean isAuthorized(final Object authPrf, final Closure closure,
                                final Label lb, final boolean executeNow) {
        return false;
    }
    
    public ActsForProof findProofDownto(final Principal q,
                                        final Object searchState) {
        return null;
    }
    
    public native ActsForProof findProofUpto(final Principal p,
                                             final Object searchState);
    
    public boolean equals(final Object o) {
        if (o instanceof Principal) {
            Principal p = (Principal) o;
            String name = this.name;
            return (name == p.name() || name != null &&
                      name.equals(p.name())) && this.getClass() == p.getClass();
        }
        return false;
    }
    
    public boolean equals(final Principal p) {
        if (p == null) return false;
        String name = this.name;
        return (name == p.name() || name != null && name.equals(p.name())) &&
          this.getClass() == p.getClass();
    }
    
    public static final String jlc$CompilerVersion$jif = "3.5.0";
    public static final long jlc$SourceLastModified$jif = 1466731418000L;
    public static final String jlc$ClassType$jif =
      ("H4sIAAAAAAAAAM1dCXxVxdW/b0vYl7CvhhBWJWERUOMCJESCEWICVKMSX967" +
       "SR68vPuWGwhYcGkVFUsrVdS2Uq3YulVtlWrrrm3FulU+W7WiWC1Uq7h9KpWC" +
       "fHPOzL137sy8924ov/bj92PmZu6cuTNn+Z8zy73v7n1aKJPWRq2ItZSZa5J6" +
       "pmxhrKUunM7o0TojvmYJKWqKfHXL89Ebzknu9msFjVq3WGZpIhNu0Wu17uEO" +
       "s81Ix8w1ptavdkV4Vbi8w4zFy2tjGbOiVusZMRIZMx2OJcxMSluv+Wq1fjFS" +
       "Ek6YsbCpR6vTRrupjalNkge1xg2zXO80y5PhdLi9HLtSXlcZD2cypKUCLLUa" +
       "6ZZMG6tiUT1tasfUko6z2vFwsx4vr2P3auGvis60Vmw1z8ZHB4ct09Fdd2z5" +
       "tdcv7/fLgNa3UesbSzSYYTMWqTQSJulPo9arXW9v1tOZudGoHm3U+id0Pdqg" +
       "p2PheGwtqWgkGrWiTKw1ETY70nqmXs8Y8VVQsSjTkSRdhGdahbVaL8qSjohp" +
       "pK3hFLTE9HjU+ivUEg+3ZkxtsMMWOrxqKCe86EHYqadbwhHdIgmujCWiwAuB" +
       "wh5j6RmkAiEtbNeJvOxHBRNhUqAVUcnFw4nW8gYzHUu0kqoho8MEBg/P2mgF" +
       "CCIcWRlu1ZtMbahYr47eIrW6IyOAxNQGidWwJSKl4YKUOPnsW3TypgsTCxJ+" +
       "7HNUj8Sh/90I0WiBqF5v0dN6IqJTwl6Ta7eEBz96hV/TSOVBQmVa58Fvfjrn" +
       "uNFP7KB1RijqLG5eoUfMpsi25j4vj6ycdGKAqqCRiYHwXSNH5a9jdyo6k8Sw" +
       "Btstws0y6+YT9b8/5+I79Q/8Wo8arSBixDvaiR71jxjtyVhcT5+uJ/Q0mEiN" +
       "1l1PRCvxfo1WSK5rYwmdli5uacnoZo0WjGNRgYF/Exa1kCaARYXkOpZoMazr" +
       "ZNhsw+vOpKZp/ch/bQL530PTfNNYPtzU5pW3Ge16+Qo9Wr7aSK8sBwOLEoPG" +
       "C6LoUzLpCF6jwsxtBguPmHVEbyKxZDheRm4lj0orndDXfqt9PsLGkaIRx4n+" +
       "LzDixNCbItd2zJv/6T1Nz/ltpWajJOoLuAaPKJMeofl82PRA0H4qHcLblcRK" +
       "STd7TWo4f+EFV5QEiFokVwcJd/ykaokLJSsdU65BVIsQffqf05IXbJo54mS/" +
       "FmokaJep0lvCHXGzrnKe0ZEgqDDQLqrXCWAkEKaUUFmYjCCNqQ2RQI6CGyFL" +
       "O40A2Qiiw6WiJam62XfDe1/eu2Wd4diUqZVKpi5TgqmWiLJIGxE9SsDPaX5y" +
       "cXh706PrSv1akNg/GZtJRgZwMlp8hstkKyz4g7GEyPBajHR7OA63LK70MNvS" +
       "xmqnBJWkD173J1LqA0o9nV747mT55XB3QBLSgVSpQOzCKBBeT2lI3vTai+/P" +
       "8Gt+B4n7cp6tQTcrOOuHxvqinfd3tGhJWtdJvTdvqPv+dfs2nIsqRGqMVT2w" +
       "FNJKYvXEvxE2X7Yj9frut7a94rfVzmdq3Ym7MwkE6dFOe5xwS+vNxncZy7/J" +
       "jZM8cLzTJQIgcdIC6XGmdGmi3YjGWmLh5rgOqn6w77hp2z/c1I+qQpyUUMam" +
       "tePyN+CUD5unXfzc8v2jsRlfBByYwzanGkXFAU7Lc9Pp8BroR+clO0fd+Ez4" +
       "JoKvBNMysbU6wpSPsoEQDXGsDxVej1IIv+32u++p6HXHbSi07mggxMfjKEYQ" +
       "WQGF9XcPFH9vm43FwMbjGPu2sfwGXl3Ic4c7z8XGSZdbsQNNkdt7/+65fUOr" +
       "d6Ce+yMxUxslG1HUNowKHp6ILnckiWNEI2ed9a8iTYwUm1gWdtnfELE/rDPB" +
       "84ujnxWXnIud6RnVM5F0LGlpKTwuE2tPxongdOtxBaaxkAjCDqPS4UQmTtwO" +
       "xZcleHN+ZzINTnxVOI0SR96N7QSNt7tRB9FZU2T2xg1pY+xVs0B73WY5XsXn" +
       "rTyfTa0eRt1upJNtsUgxDqzYaCmmCFAcTrd2tOsJsxjYB+VcHFU8sRlYqEeL" +
       "w83GKr24eU3xhWZbLLNuEjR9EpHgOOyqNbqyynAiYZjCGJsiBZHY9n3lLYdo" +
       "KHCMm0aqffLUysubjv/FC35m3kNEN7IgnGkjMPBa/NXG696cPJq2ysEEu/+b" +
       "qsuu2/LQg8dTT9MLHPNpczT8h0wsNqnOkEeMEAW/hIySCX/LlwPrL/3GP5ei" +
       "EfgjqO3HEO1v6YjHF9keEdLZScLseTaDzTa9OJPUIySeLbZkXFwC/CspjiWK" +
       "s/vPJEr3FJRfv5yeFvy3y3PWGpFw3PEWS65+5tVZN763GaEjFOedmRjhCZTx" +
       "bfFnaj9f8yJlrhgkcHbTFJl+Z/sX/pKC3/m1QuKYUX3IPGRZON4BYN1IwupM" +
       "JSus1Xq77rtDZBoPVnCh6CzBbfE2HoSuONDTxw0905gp3KGCHp+GF2ciSQmm" +
       "4yCZaDmGUEssEY4zp3CY/POR/1/Df2gbCiAnva9kYWWxHVcmselKJJ0GyQzs" +
       "3nwsGERmc6inKE46JUBTgmQpVpyKFY/FtByegn2iGns2qi2JrcSbKhWuC8fS" +
       "TIUHf1ZSnqyuehtVuAeRQAuZgcYiawARxQCo0r4LURDMiFqtyqOkyjXO7Qpq" +
       "ApCMIWbQL0pjseIkgxy4cT44a7f1273kEeCmQdc/UnTX5rkW3J0KMDBaHGC9" +
       "HiZBKn16U+SzrX/R62d+9RENMIzVCXESm7SMptw2H5j/prEVeEozUfShEhdZ" +
       "87O+c/O9+96qm4OWxOE9zFKkiTLHkD6UIZDq7jjX7k/ZEiNpd6kpsnzwH48d" +
       "+cg5V/JgKRBwtTfd8aPCj4/76mYctu11xgpexybI6XkgPZH2F4Mcl6D4TvKy" +
       "GjLozVd2rFrwEe2uKF0VxWnTBz723tBhFyK+U6xrYU+FbIVS2N9Ix0xH2MVl" +
       "tU89Xlj/B07YKEHCgtVYkcoT0ogjgKTtsAR+zjNM02jnuHrK2L+sqDj08gOW" +
       "ArbaXJnkHqBA6XJ6kx8etumNixdbbaykQ01xQ83QokZI6jsROFZjSROmcwSn" +
       "hYVhWhnStU6D9a4GFUWGQ3aRw/J6m+VZioa74/9a8r+IzNiG09y3S47/EVIh" +
       "GS+H1EDyBst38iG1G/L8bFqIECpHlEB9gOUfuSJKyI6XQyOe4PP/SGh0NfXg" +
       "SilC2bet0AP+qPrPhw1QpUZ2mMCgwyrOMoe5JYvDhMuzcGD1kFzjOL+NWLoZ" +
       "3RsyBq8Eyc6A589jqtWP5b4ckj1ZRdDDLdllniSLC2gxIs6uSPcmjtFEkt2s" +
       "Rv5/SBO5eQZjyjAVN5k0f+pNmrc40vwRlv7ECmWK7D7ZfUH2QHIXVr0yRzBz" +
       "D7JPFczYmHgZVlwOyX0UF5MOBtKbv3SQ6zIZzNxFhkP2oIOTl8nQaRchItM/" +
       "htqzZXfEXQ1LzE4wHFl7yt7NX6dK/VqgUevTFs7UJGImrmjraYyn7L9MrT8X" +
       "OeBEryJfkC48rLH87h8Nrzz1AwxKnMUgoD4Gh3mGrRVFwNpS8p+AkS/B8vMU" +
       "WvGEWiv8plZIHCYJLnSqH250789aPJfli7iWeayb5u7QaFa9TdWho2pO0Naz" +
       "nk3Kxqt+lCnPdmblSkGyo5kEJQQGwqwVhzX4r69GF4CHsZzHKV6zqNXAjlG2" +
       "BXvcbNh26bVbo4tvm0bjrSL3Ivj8REf7z/986PmyG95+VrFm2900klPi+io9" +
       "zj24h7RJdSbuZThqNvuWqtKRT6U2Hb2VV9Rv9SLrMcLoxc7ccebdz54+PkKm" +
       "tAF7fVXan3ETiYtD9KlLXNPH0bbQeoLQRpL/Q4l8t7L8O7xiomLkAM+XBOPo" +
       "wRq5muWXixqgBsi/5rj3LiRvqC0LBzCEPetG1QCOumX9vWuWlRP0dzmg/6Gn" +
       "YJgSfOyg/i7ZEeySHQEl+9xB/V2yI9jlcgR4/Zqbz1Oosvg/YfmLWRQFkrdk" +
       "tQCSF1j+THa1sJZq3YIug1ZmM+oDLP9UEvTxJPFpRNhnewqJklBItzOLo3pc" +
       "byWQn1liqEKid67a9s7lmzEoYiJVh7yUcZAcoDyB5F+5xki7zHcfUj8MyxdI" +
       "dqk9efVqaWJlgswZ6Rp3Q8+7O7716JTXrGlab0jqO/F5vbJboA+f+ZUJy8E2" +
       "j6CczJNUyzPShJZ1gq3QDCz/8KbF/3znPqsXs+ngklYUCJlvgFBoaj42gXSr" +
       "xIlMFQ6qVIKEHdbSDBF5cTODY98wL7bmG45jH20bFikQbU0oMhyysbZhWXU4" +
       "WxOKamgRDUp8E/OHqsgMOWIiwNNOQq5VbONav+Laqw6XbbrWz+3uj5U22Hka" +
       "usPPqwZ5yphcT0GK6r/fu+7h29dtsAT6Cu428RE7r9eQTEfdzjZl9IUgORYl" +
       "hRyBpAzvFObQ0pmopXDVX+UlxjAN+ZsKvVSLiguNmKWy/bvtfntfumSWtajY" +
       "njQSOnP1Y0lJAnGFRLrU21O1dod/4uP/xD8+mZRXC+3H8wstb7z86k9/clXP" +
       "Ftdq4bj8O2wNunnxqM0vf/eHFy+1SI9TsD9wtL2lb07XpnYKAIS0B2i8ow+2" +
       "A/WdhCtJvmpPBn0StlvjmOFJsmW6iwxbhrAKhIsHILt3Wf4mL0OgXmSvJQqr" +
       "blVrSPASi3DLbksPLRzx1b4znqLWCYcqVCvUcyMRPZOpI3epWba6OzSadeSv" +
       "qg6Rvkx2q5TYC16zrm6uu//MXV93cEt4CiR3+gO7RpOGDt1T9euyGTgGtl2E" +
       "J2qyk9Ubhjnzmvg99898/zwa1ssbo3ZlI3hixekPLxjvdx2Wgaf0pXJvSNlR" +
       "B8LxYguOO6kXOY6hGFyXk1lds2HE9XAiZ0xG3ezypDQJP9DJBVkH5LjrgBx3" +
       "YVu+VifIOiDHXQdccZep+ZMTFMinfZ0D+RIi8sHlbDrsEzgzoUypyGomPlVI" +
       "E3DMWITxjjwwrhhMNd7B3pznRQxQcY2n0Jjy+ptHJqJLuiAiITRGdC+iCB+I" +
       "UpQInCkgQ7Y5FLBRe4nMrBNhcKmKlQZorZblp3GteoqaS6CVk1jfrma56QIJ" +
       "lKtNcKyKYB1PYGp6l0PrcDRalTu6Bm9CwuuKYnrxvXWT+GgQ41/fBjv+9V2R" +
       "L57+LhdPX4MS3ow69/0utQe3+iD1D3NYH6wB+i43tT7uYaayBcgpFt6SDsgx" +
       "L1/oxLx0GDiC2/Iagy1M2A/AY0wgxG+zfL2gmb7b8dl1bqqprPalKiokWEL7" +
       "vAySuxwNRxi+w21mdtO4XHsia3Ijyy8TO3Sf0CGkms1qX6mikjp0v9ChX7g6" +
       "5Kwfo32czJrcpLIPFpQ/5DEo5xQQhQVJmaSKkDxG1RHSayF5xK7/UMoOd7fk" +
       "ULsnUO0g2arydcFVRiyqOQjrU63pVoZJuJiutNeumiIlYy6Yv2PxqTvo3q87" +
       "ihePyRVCXwZSNga2sfx6CV2UZsrJFxYNtQGM/FaW/1iWb3a3hTJ/DmWOrGFL" +
       "mM5U0Y7AQb4ZC6v5R6AgXvJuW9BfbRhraSXLdVGV/0cYKlINYbVjKipJlf8s" +
       "qPIrWWzLDlChyTTL42KH3hA6ZEeRUDupopI69JbQIXu5CVInfhFV+Ts5VHmP" +
       "o8qQPKlQWyj/HSTPZFEquPcHbO19TF9KZfPVg8j/cWSYr2q4SxB4VGBSbl8N" +
       "bV+l8NPQ0iMsv5dr0ZOfHgetnML6dZjlf5csyfHTZSqCT3gCU2vrsp9O6+3E" +
       "IR8FV/2B41o/zOeqP+Nc9ecoui/QGL/sUnsp21XnCJT9GlT4h6n1l0aayuut" +
       "P1B56w+yeevPEVH83bwjCj51JhPlfpa7lrOgwZ6CASPVDFb7CxWVaMD+Pm4D" +
       "9vfKgiizLOcITX7N8n+KHRogdAipTmK1D6qopA4NFjo0MIu3Ris5jV4EfSor" +
       "od7aP6Kr3vozHEq3lNtbM22EW2OoRkK6H/4+xqrvH5GyIe6rHJo3FjUPrlBV" +
       "s0Kc7FzHk8EOYblr379rzhXIB7O8SBZHbufqn5yynKt/ouhcAU9xuxXEsdcC" +
       "V/4RKJQy76YA/cRtKWjpLZa/JmredGGoSDWc1d6lopI0b6ageTOymMIoaHos" +
       "a3IPy3eLHTpJ6BBSjWG131VRSR06RehQhdK5Spr3SQ7Nq/KoeVBjfHbn6p+E" +
       "rS3AtCylcK6oB5BMIioGm+MTSV4uMCmnc8XNFdG5DmQtlbF8NNeiJ+eKenEM" +
       "65fOcnn3HUzefxbxm8u77DftQzGV9FhCJs8Gkr+e+ozstgBq619oez3/GXm8" +
       "qP8s1yAgbUCrW5LsSnspy4v6z8+hUU2Q1BAvKo07lc+Lkj7IXpQvVOzzDLbM" +
       "COTWqpIfNATW4G/NizFQqw1HsdKxsjZppUgoMhwyZ1nIqpPJWlRDi5hX6vDm" +
       "leDiLkmYkKyhAoUUwQLvtGLTSIR/n51DcBei4CC5QLARtN1jmYXNV9kuSusE" +
       "m2CkimAWT5Bkq400U64sYtlR3G3wf4tpEeq5t90GwVogPZeJgfHWDur8F1FP" +
       "dqUnLbsI273a0Y2LZHVxFzn+BrypNplxtYrlpwoq779G8DdINZHVnqeikvzN" +
       "tSm3v9nsLKBDHX6J1llA4Fbs53aYbfzyQe0Xfxq8aqLxe8/LB0PoQIMXszwp" +
       "djdvhINzusGM/CKWXyiPOk+EczNyAvm61VmGZpgp7wYAZjlsWygDyEIZQLAt" +
       "/12O+BfKGmEXpVwOX7TyxTms/JeilcPlOmc3wFLjB6h9ZudLtt0AZmYiPP0a" +
       "LUjZHNxZJg/GfyXeeSCbqsHNH0DyoxxxyY+xjcdlmcHlE55MlQrm6SOT544u" +
       "yFOImHBfGs70TiEqu1vDtdfgZsHM85yqAZJrWL6RIxUYFkSGBQXYhwUsDI2g" +
       "Ax+x/D3JBFHSrxCYbvIUGsH3HOrSLVyAFMvMpd94WEtCojyx0Z88xUYvOrHM" +
       "S+qhglL1ERIU2Bs5bAc2UP0vmFovvsepvFHNi6qo5kU+qunGmDJBCG5QAhMY" +
       "579USSBlBTd7POnyXhzH+47i7pV1ea+sy5TsI0dx98q67C6qoUUsuPlfL8FN" +
       "IWMC1nK/H0bfh+O1DVJY/PTDxqb/1ay48jokXyKDsCOQ7Bf0HA0NHAWZRIR6" +
       "sDyg1vODnvU8EjcyHWn9CPX8UA49x3ERpWFPEJUGh1PKhjFSNRxLaQJ+L0oT" +
       "CABBoMDWEFIgKo1QZDhkPW0NsepwSiMU1dAiqjSBXAdLHaVhTJCO7jZ0kKCO" +
       "+8LH2ROXPfntYZmN9FjBJPvYkt5pluGXXxipSPf6a4HpPc3S7+LhnmBzOIML" +
       "8t1qtVAGappacfZvy2Bb9GhGT3dgM1TDdWH/FpZfZmojpS9WVNKhsa9dnNCl" +
       "r11wtCiGIY5VWVFvpc25gTLnmiL9T/xhc8ulc57BYK0vDhYPHDXQYY/nTqM4" +
       "RKUN7nruj+Moed0Uee/e7+wY849lA/CrJxZb+S8inBlOVohfQIBXm0l5qPAv" +
       "Tz49+IKXA5q/WusRN8LR6jB+TELrbraRwbUZ8Whn0gpPVndjzhG+tDFMeLnc" +
       "OVk969k7Ay8tO+8m+rY/92mJoe5B89+pYUfoRotvMlitcqfnnHcR8MWsKUwH" +
       "7mL5NpDXMDSB4Z0atYUJalsIcKfuCzL4TaF/85VdMrmpRScFG4aBMnvD0H4b" +
       "IzDCvUkoD7Lk3cINNe8tvA1f/OgHrzzjTC1B1QKLahLuop6xjD33oocE4Ukz" +
       "NJ+mOmbEDiqx03c/e+npB28dsmSKc1QKunyWcMoOPekIBoYDWN6fB0VTmxml" +
       "DTNMT+tJokAEyglIE3iGqSdytjiMR5CK4VHF8eak/IYo30H+FNU/7rvmvRm/" +
       "fe5G1/m8Y7KfcMI30afVDJ99cuOvnkJ2dk/oq/T0oo54vFbzx2OKj5243l53" +
       "nfdH2P8GMPYEGq3UuF0GcIUEMKFpLJ/Ec4dh8mleMNkfb7ZViL5pGZhOPagc" +
       "28KDylQPNLVGT2423nxkHjYwP5+HhUqV9rwhMMdxmws9uU0kCJzp+Mg5stuc" +
       "I7tNSlbv+Mg5stucw80b8NwP7Wig1K3vpQxRfsLy6xXI8o0syAL34JBtAIFg" +
       "CnaqjKBDHY8OcDmVggKkuC8yTZ6E2xvbYHR9Wd6TlzYS5JmEB2BlkUzC4ehi" +
       "qcpjic5nWkVk0VPGiZMQGQpgkah0Kn4zRuG4KnDWGxjDR3qQfg2lGBYfzq0p" +
       "ENQH/HbcEhgIyVBkW5vDoVGYlsj+yAb5");
    public static final String jlc$ClassType$jif$1 =
      ("wCy00COGI6DGxcvASVnZGTiZogBqj6kF4s0TUBUgWd5Jq8Db4oEYjZThstoJ" +
       "ggN4TC9wOiRYd0GuMNVqfaGtq1XZ4u+pRC3ms1xamaKPXk0Y0+wJGPROPdJh" +
       "6ouM1UcIEJ35Q/CezkOUUfgoNpg61aBsOFnnCU7WI9MvcbBjvQwn62U4oWSX" +
       "O9ixXoaT9XIUvt5C/I1eEL+HwwcY1Xm8vCCFtenAdyFZm9uKNiE/8LnYEN7Z" +
       "iTTKKXkA1kP8L0DylkqrTtfo2seLmmL5BJHFWbQuUhHcyBMgQ65Dsi4ujBWq" +
       "5q6BH6Zyz125hYGUPYNVItTWPAjFzRbdOCUZ9C1dNGiKWTYTYVkaDwkC8+5n" +
       "+S94Jv47wLbNE7DdxgObUhXvyqOKbst2dBIpjuKWROAeijFetyQwENlC9fCX" +
       "nlBjCw56u2PrW2Tzdxc5+wzYWjWT4Qss59/Nw7Z/Izh7pKpitZ9TUVFn7+wz" +
       "0DNWzj5D4GF7nwENDpGA25jmvorh/4F7Xg1BBglAQjGWnyM+1/uGAZC3sTwq" +
       "dz9PrLIDh4T9/717wkTfCdbnZjJkRhkzEk2R56Zd8vorV7bcgi/yBuJt2PQI" +
       "cpm2L+3v2UxWfUWNa437rI1qQwUsczoZ0PUsT+fAQyQYzypeoyJAPfzjkeBh" +
       "UImHfz5qePj6UcPDXUeAhxLe7D5CvOm0GayCWF6Q1x0tiH3HE8S+64JY6VWi" +
       "7FrZFHn28fBrXz598+340SPxtBB+MBYWx2Ch++8sdx2KQZ37wBP2fYjs+9gB" +
       "ug9l7PswC/b1t9AEOrCX5W+L2Pe5AB5INYjV/puKSsK+/QL2feE604PXwpYQ" +
       "HJ87UdMK5rN8sNCrPFtCQDKI5X05UgEd1Z8eqrDAHagXs7xaAlnQ/2CA6OF5" +
       "nkL1FBehE72M1qUNo6XKWJ0w871sHQzmCNIp84Cph+z9oIB4ANQ1TtptfgiQ" +
       "hmBowYJkV9pLuXaVgn2zh7BBWIUKHDS1vsLQU/k2lkg35I0lvpBM11OCgaEA" +
       "q5ngzlIJMMWmJUFP70EH8YXm4ChbgYPye9BB+T1oRlZiG2JQfg86KL8HHbTe" +
       "gw5mWRAVjsvg+1l3SfKE5FgqU0jhvFxwMg4Zm3aIHMVfAMNexPh1Dssb1Io/" +
       "hSh+i7ePLunhdKQNPgavH5kJWJKGx/YmXoRrUBA8DqCRdVxXDcAW/HRPgsev" +
       "OQZnOVKeIQt+hix4SlbhSHmGLPgZsuBnWIKf40XwPB9S9o4fEw6kcHgpCGcf" +
       "g1MdFajEweNDkAhr9shhudVouXBVJKgLAvVkxuWZKqAWgq0hKoISnuC/cGIq" +
       "uMhRL68npgTMZIqJlsjMiyomXNon+7ijM0E8NxFc5miDfG6CK0prY1Rv5nOf" +
       "42yK+B+cvvSNW9c9yr7gqqpvVTXGD5jb+OwNKdz56dYWzrTBt5VNbQD3cVZs" +
       "W4fPRvZZQUgr3e/7owpGnIEst7etkHGMuOidm7ftv2TDCX74EHVoFXwBlnSN" +
       "2/Fe1AE/CHH53deN6nnt27hpmTy8/85tWWXvF+IXOLaBR+JBj6ayfLJg7sGo" +
       "EL8g1VhWu0xFJcYvQfwgpBO/BPUsh6Rxq2sSa/J4lk8TOxQXOoRUE1jt6Soq" +
       "rkMYmgYNDbXM9n3Yq3Z7RskOZg0ytUGONkfMTLWRRszN9dox8/vyeS9wuk4I" +
       "d0hemDskASFtK3iRE4oekqNTuwhSOO+VmuDYUcpxUxTYJJBLcgBnar04UJyg" +
       "gjpfDqi7UoQ6uFzgHBsDW4ZsIwWprL4j67ExhjWim/4ewoiyOTYsF09c2ALZ" +
       "93P4Mhtnguc69oovVQabDu+/Z252Y7Nth/q0dqT8AdVd1MEcasn6m8EP6+Ch" +
       "rGCHF6WDijd78cxMs249MoW8vQsKidfO7ASXTk6j/wsn07zgEG+sKe0I35+D" +
       "lg6y/GOuRUFj1ZMWDH3OYv06meUz+H45qrfd88ZjUhWxLU3mn7L8ijrV7EKE" +
       "KUbwHnuKEbw31yhpp/kBQPogKv9Dya60l3JPWZ7MgQZPQ/JzU+vtGngq34SF" +
       "dEKesPCFivP9KLwGJrRTVcJLWXHrc16sI/g8juAlxzc8L8etz0vWwchecWKQ" +
       "5+WwxF1UQ4tY3Pq6Wu1zn++3pAnJm1SikP4Gkl04ZGzaIXKUfikM+1zGr2qW" +
       "z1Er/W6i9NGjMWHJp/78dOXxnNMV7H4r63a9qvu22P/mSex7kJPvOTLeI4t9" +
       "jyx2SrbPkfEeWex7ZLHvscT+mRex55iu7Mbn/xUSOMUYfMdRgC9w8PiQlO3D" +
       "H8lhtf9Eq4Xkt4KyIHJPY1weqUJu6uhtgtEKgsLuPMF/YboS0hz18jxdceMl" +
       "U0y0Q2ZcTkhxUDVdwUXnUDdHGw7KCuIqosEGJettBRt33po92KDKaLPe/pg3" +
       "sHwIy10nmaDl/jQYcVMxn1w4SEXFRSwY2YcGpjQ+sg8VZYns4fwafhIEmhzB" +
       "8qFih4YJHUKqMlZ7mIpKDKFCIzGEet12Etgre22pkwZ8Heo3GLmNIgOefBF7" +
       "4gqWN4pPzrtRtBaaWc/IYyxXfK0hKy5RLk9ELiOLxour4RBL4Y40ND2d5a7p" +
       "GGSh47wAYAjnBKGptlaGpkiKKhQpdgKhA5bZHyuKeKbAIaSqYrXLVVSSzp0g" +
       "6Nws12q49Y6I7PZSCJUSbKJGMMhUTIBE8Lw/O3iG5qUE8ITLA9wE6CAVRhWF" +
       "vexSzzYBYugluP0QupOHlM2xYbl44kIroK/NoRwpC7l4TFpsYdLP38mOSSkL" +
       "YtBLhnA1N9RA5Y+mmsN6aX9DxTgBClXlNFqoUZrFHuHeBGzjXEzxuKFyxwTg" +
       "ZS7RvatYzv+ImYcdEyC5kOUdHGl2mOBcq/3lFaC+huX8qziO1oYixBU2eIrD" +
       "DC760lMdxKHlmXWE6HQ1z6wjdL49SwgtzzU82lu+55DqqHEtya60l7ImHCEj" +
       "h/UhOp1nagV0sKl8Mw3yYHmmwRcSJ2IIaIuSKmES+r5KUikWcoY8fXMutBa7" +
       "vs5Bs7VSyCkUGQ7ZpQ4qr5WB2l1UQ4toyBnaQJUZ0+wzDXyvZ78kQUg2ohSz" +
       "IgYcZwxdhWzAx6Us/AytyCHBTShBSNK2Clk/saJQIUjbWTed5+T+KiDTNnl5" +
       "DgTvsPx8WQrny1LAtkI/cFh+viwFuyjFvJMxQcWWcA623OKRLZDcmkcucge8" +
       "8Qsuf+ZJoylT7jwyXt7bBV5mQ/FaTev2Ocv3prqE4kCyh+X8iQLvKD6WUX/N" +
       "8i/4DjgSe9gziie7jOKPeELx7Q7q/iofij/s6jmkj6LxPZbsSnspG8WfyaHs" +
       "z0LyQBdQfLsKxbfnXC9CSY2jEuquqSSVslD8ZU86vxO7/idHwXfKOr9T1nlK" +
       "9hdHwXfKOr9TRvGdForv9oTiwnqRJUFI3kUpZkUL+EBg6B1kAz4OG8I7T+WQ" +
       "4F6UICR/UMOVW4Ug/R3rpvOcPKi0PRuKb+dRfLsshe2yFLCt0GcOy7fLUtgu" +
       "ojiNT0W2/DoHW77yyBZI/pVHLnIHvPELLg970mgkKPAfES8LCrvAS/jEvuLn" +
       "nNLaUPGr8ew33iP3bO3bbcjWpa/i78vaP37Znf3IKP+bl9x1QTKtt8SQC90x" +
       "7YMHRwv6mFo3awnI1IKQQe8KetPb/U0tQG7DZRH0l3hrikVDeRYrBV4wyP1b" +
       "wfBTMR11+DpgU+ST6dOqHtsx/hn2O4BZ3350KO7dunDRhZ/Oor8uHIrEw2vX" +
       "wkO71WqF1GVgH+Dnksdkbc1qq2DBpH/1ua/7OPsHciEp4vyja3T2H4r30OrS" +
       "xqpYVLd+OnOltm7jbzcUXUI62ah1j2WWpDsyph6FFySt1yBJi4Fx+KjZ9BMh" +
       "BaNIwxPEX0LkmuUPBvpW3Li4tvDw2fbbcUo1RgDs939UDfN9U4IAAA==");
    
    public AbstractPrincipal() { super(); }
    
    private void jif$init() {  }
    
    public static final String jlc$CompilerVersion$jl = "2.7.1";
    public static final long jlc$SourceLastModified$jl = 1466731418000L;
    public static final String jlc$ClassType$jl =
      ("H4sIAAAAAAAAAK28ecw8W3YY9L03q8djz5KMY4+XjO1nY7vsqaVrzWBMV3Vt" +
       "XdVdVV1bV5lkqK6qrn3fy3FkQF5kg8kyDkYiFkJGCpaJRaQIoWDJQpBFMRFE" +
       "gImA2EJhiYwJYf0nIVR/v997vzfvvXn4SWmp7q2ue++559yzf1+f+tXfe/pI" +
       "1z59oa7yJcqr/ov9UofdF1Wv7cKAyb2uM7YHX/Z/AQC/8q/9sU//xQ89fcp9" +
       "+lRS6r3XJz5TlX049+7TJ4uwuIVttw+CMHCfPlOGYaCHbeLlybpNrEr36bNd" +
       "EpVeP7Rhdwm7Kh8fEz/bDXXYPu/55kP56ZN+VXZ9O/h91Xb906fl1Bs9cOiT" +
       "HJSTrv+S/PTRexLmQdc8/Ymn1+Snj9xzL9omfpP8JhXgM0SQezzfpn8i2dBs" +
       "754fvrnkw1lSBv3TH37nircofkPaJmxLP1aEfVy9tdWHS2978PTZFyjlXhmB" +
       "et8mZbRN/Ug1bLv0T5//mkC3SR+vPT/zovDL/dM3v3Oe+mJom/V1z8fyWNI/" +
       "fe6d054hze3T59/Bs7dx6/fO//TP/1gplK8/4xyEfv7A/yPbou94x6JLeA/b" +
       "sPTDFws/+QPyn/W+6dd/5vWnp23y594x+cWcf/+P/4N/9ge/4zf+2os53/oe" +
       "c5RbGvr9l/1fvn3jf/5tzPdTH3qg8fG66pKHKHwV5c9cVV+OfGmuN1n8prcg" +
       "Pga/+Obgb1z+ivMTvxL+7utPnxCfPupX+VBsUvUZvyrqJA9bPizD1uvDQHz6" +
       "urAMmOdx8elj272clOGLp8r93oW9+PTh/PnRR6vn79sR3TcQjyP68HaflPfq" +
       "zfva6+Pn+7l+enr69HY9/VPb9Ymnp9fgl/3n+ycajKsiBNMwAKeqzcA0uYPB" +
       "JqnPN5vY/1DX+s/3zwKzv23C7fm9usmNn9Re/sVtqP4nAmV+4PoN02uvbcf4" +
       "be9U6XyTf6HKg7D9sv+VgWb/wV/48t94/S2hfknlJr4bnC8+tvjiu7Z4eu21" +
       "Z9B/8CH9L7iznW226eyG5ie/X/+jx3/+Z77rQ5tY1NOHt9N5TH3jnUL6SrXF" +
       "7c7bJO/L/qd++n/+v3/tz/549Upc+6c33qVF71750ILveieZbeWHwWZlXoH/" +
       "gS94f+nLv/7jb7z+YOnXbcal9zb2b5r6He/c46u04UtvWpbH0bwuP339vWoL" +
       "L38MvWkOPtHHbTW9evJ8/l//fP+N/3j7vLZd/+/jegjO48Gj38wH81Jov/CW" +
       "1Nb1C949TvcdFD1bsR/W6z/3X//Nv7d7/YHJmwbvU2+zjHrYf+ltSvYA9sln" +
       "dfrMK2YZbRhu8/67X1T/zC/83k//6DOnthnf/V4bvvFoH3h6G35V+5N/rfnb" +
       "v/13fvm/eP0Vd/unj9bDLU/8Z8y/bQP0va+22vQv32zAhkn3hlkWVZDcE++W" +
       "hw9J+Yef+h74L/0vP//pF+zOtycvDq99+sH/fwCvnn8L/fQTf+OP/T/f8Qzm" +
       "Nf9h/18dx6tpL4zKH3gFed+23vLAY/4X/ta3/+t/1ftzm3naTEKXrOGzlj89" +
       "k/f0TBXwzMvvfW5/4B1jP/RovnV+Hvvc8/OHJ32ngeUenuqVLLrgr/4bn2f+" +
       "md99RvqVLD5gfH5+t9Ja3tvUBPmV4v96/bs++p+8/vQx9+nTz07SK3vLy4cH" +
       "V93NzXXMy4fy0zd81fhXu6wX9vlLb+nat71TD9627Tu14JWx2O4fsx/3H3u7" +
       "4G8H8dnHIb2xXZ/c5KR82f9zj9FP14/2M/NrT883u+cl3/HcfuejeeNN2fpY" +
       "3SbjphkvhKt/se/zvM9uIcEzN5+N1Av3+0J3Hi34PH9+bQPxkd0XsS9Cj+9f" +
       "eu9tPvS4/Z5NjrvnaGZbcU9KL39zyz+U5v4bb6qqtUU3mzS9sVnHxzD1Hjtu" +
       "3P/GV4jJ1RYV/Nzf/ZO/+a9+929v3D4+fWR8cGJj8tuwPw+PsOmnfvUXvv3r" +
       "v/I7P/esXBv15k+8pv3JB1T60fzwwyZvmOjV0Pqh7HX96VkbwuCBzHuI3Gav" +
       "i80IjC99evgzX/nZf/zFn//K628LfL77XbHH29e8CH6ej+ETL4jbdvnO99vl" +
       "eQX3P/3aj//lP//jP/0iMPjsV7txthyKf/e/+ke/+cVf/J2//h5e58N59d5c" +
       "/MKTgHbi/s3PCQ6Y62zNgQ3eoNHJCWaMY9o+2uzFVE7MkdUZ1hYZSzrpVwon" +
       "9AtOjupg81Ps+HxmcWbXWoGOmM3OGXKrz+22bYsdN+QmYBN2YjOw2RAxJdU2" +
       "cxdUZZXhHdEtJIWg1QjeUgpRC3fA/cE4l4BLrguxG4kS9qSjal8aROxd3fWw" +
       "I14Xc9xK5lCeiAoyqnQsnKNkN9JduMokxd7WrByoouNSq9nZvFuL8XmA7AEm" +
       "BlbpSFicyQmue28MMgu1bgk5oSu3IH3K35TEGjr3dBHd04woR38+6fkwAnYD" +
       "31NOZzPc6W5MfcFH49IOderl5ywK4TlC1qtCQgumxpu3pgS516+57x4Qf6kl" +
       "k5Fl08Nd98TjfWIacO91dzOr8BUZuamb0bFF1J038GPS4ZBVTPBKugKN+j1E" +
       "cUGArFgf+CMB3uXo7O3MsLvpq+44xsluDE0/DrlaUV57takR7hV3CPhKKHYm" +
       "kASQGjRRjahxyE99Y0cZ39qJIU0wazgEVDbFtSMd0rK0Tk+NTL8EMR948c3y" +
       "ZLLR0yqua2kXc7LBUkK6wRtNNgJ2bjb33elkK+3cSExI4qzgNF5wm2IhEKNi" +
       "SBk7mfYDPcVYil+KbJ+w/e0cHkdlFujLOTabvWX6JTehpU1GziqYA5Q1VVyR" +
       "J5aOQBUpIo5hRN++5APs9qebFzstSoRia+Piouzns8YngT0ddSlHHclU1LKz" +
       "d5uWRJ3BzEeAEM5mSuoxSEEiZCd0w2EjFJxxsTkaU44bHhGy9ErhsQUaumLR" +
       "WmF5GMmN97QthzOnEhINX5K0kXksrMz7qe4SBEvRMcUXP+ClfdMwl8QRpqt+" +
       "FjCPSoOlwjNSn+i+66cOWnDAMagbCWKASFAaSNoV6bU6ncyH0UsuBJzOab9Y" +
       "sW9gwHAENahgkzOcw+qFGed7Bdu6hLXOVAR5gg2eX1ZuBdkpf75EDgeyswdn" +
       "jLe/ONdMqd3q5K2te467CRiVWnJr0I/BmyZjO0g17uezo/aridX2jg9hHNAq" +
       "ym4JT5fIjp4Uma1UnsHlylzlmuHwdBPEno4GtRAs9rZIs3uIw0uB5ilUtWVw" +
       "uN6bnlI7mc888TKjJSCvh2Q+Mzex3yT0OIK4AZ9XMO9r20uPSiUPe0+Vjqew" +
       "uuckol72kIA2gi/fcv8i6UZAGHaF3gGWszCNTbgqsyb/GIBL5lWZfNS7wMQx" +
       "2hI77X5v7hAmXm/HCkMLHeSKKvOOYQ3lIyNc+bUtpRBy2ag5HDS5aa+Mvc9Y" +
       "yTNNrnBShjk3GnLRRJzhF05WUGiPaEky4XZy9Aocud4PIQyGA2IHaJCYjWtJ" +
       "dYIZUVPYiXwU+Zml9O6gelds8a8xAeFqq4+wl50jkHf74yVyp1Nek3HXZ9Ky" +
       "ohHBs4tKe6lwIZQ9vpMlAjqdR30umpI+2tkBJnZHWG72UEWVFoEShYFhV3qn" +
       "0bIeWXqtKSsj0XRoILm4Gw0vAUCV5HuARkvCr/FeM/xWUQZhHpstjQp2PR8f" +
       "7T44jkYwNuoIBPcOKcWuufDNyTKQiTsfJWe8suPMIlfCSal7O/SER6Ht3VqL" +
       "YLPSBXGaMhYPOCXE5kkHxvNc+u5CgMfUPZG+vBpHTYz8QGTwK18EfJHsnJS3" +
       "CznG2khpSnwiiLhGVtCHRaDR6sU0T17Rh+pyBhjzgA3l9b765Iik3SW/0/Ti" +
       "TKtX8tmV25uE7FNqTdJtdQH8XIHuAcCu6LGSRvp8WrqbiU+1rnYVqx2ufHeY" +
       "rTCFRXEEdsgAADUuXIWbnkBEEUXz6Z5KrKPZGs9RV1/lBGos0B03nW4prw5I" +
       "d5/4a74TfdQnVvLK625w67TzOQt6AgRw7G4qbYAzIbCcZnPuch4WzHM1SUKN" +
       "i3LpZ4l9ZkUkDCiPTAxnMgs4soO+vLMyC7YHlSbRIS1n+1qKQ4BfSuuEcZDM" +
       "57VkTAOL9Oq8ed9A6Wfa8+ZsnzKHRtVRUyuMflJm189D4Qy4q3g2ytlSREi/" +
       "UPiZ0PRzT/QXmuJcEzGQOYJrB5itDqKJne1g1+5atsZyNzwovPTwUB/PfWdG" +
       "86FZHY8pCobb+0YbIL3SHbs5dWjA8gXOJDc+OA0byhO546UWQUNzN8e2e5Pl" +
       "88CmF4qthUhRluZ8a5al3CeOmzL8sUtoV3CocpfLTlBJAnMqIK+532Vz6YZb" +
       "OoIcs8OKXXZmz4QYbQxOT5segOcrj1O4rx4bZOlYdgCBW9MNAwLKWkQGhkGd" +
       "ZEE91/5qkDE0deemVDI2PLF7G4zFRWeuoJxPaiuDO17FwoS9R2mj7ARWgUfc" +
       "SQWOykI2kF3dl7vQ8A6r4VHKUTW3paF8czcpmxiQ6eo0saUOHNUj2+644+U+" +
       "YkvIjctu2ak2X3PTTmVtHccArLfcM4HveI9NN40IiksaM64x3+5c6W3aQy7H" +
       "vI2jzBduBnfMARfsrmAtMTuwgLVBcszrTlT5i6ucUdo5w+I01KejPnTwtSGI" +
       "tj+4dKVaJRPjzErf7iwiVPqgnA/GPEEUhEX1TuIZoQZ4DvETXSsKdGFc71Dw" +
       "Jtt1rIOu9Y5xQFW5gDB4uCPRjUn25ehRmWPbs2D5RRfm0vEI8Yu2drty6nj2" +
       "Uvh4Ukosih9N2ogKrbbqReIckOvpJYxKJOHLDmkS5Nj6+k2K7YEh77ohmsId" +
       "dvWyWYYw7q1hH160/eBGvpN40/4ya0wFtahsXg6nhGv6pVGyJb0qhFY3+5o5" +
       "ifbmhaA67UIxi+YF9Q0U9Yg7jBC7jb1MoQU+aJbGFWsze3eEpNOB9gSeoYTE" +
       "paUSxk1AX9sreMGRAKAu7PkkrhZzZfWC0E91PyECloJ1y1ohW63mXY/ZOHBJ" +
       "QgF8UKEACm8KVLFnhaVWTsoSQxayA26K7qEh0vRKZKC7udw6wLO6K9dJQMkA" +
       "8CPMAo+RdKGn3rgHpKcyKQoSeOH4/QBv8V0dzstNxK9ZpLoCwqEnP8cPqDFK" +
       "C5/K1WoFSMu1Exsig8RB1myXBr0SyK6nY26RABOfW8cEuJto6ciZEmdoFpCT" +
       "lfcmSV3zFKQhwpFYgYl6y8n8yoCqKI0ko+/2F2BNzycISctBaCVE3jLmQwqR" +
       "kWLv25t3PZaZ0NB7/HrEs5kM+6E4J3Nwu3lLpkHwrJE7rcpcEd+sr8K5qX5R" +
       "Cn/Sy9ixYjsu9d7ED5SH8pxp89rOu0zgES8Ay00qj0DBzdq1gLieEx6ilp2O" +
       "EiBriTGvAwLMHha663dkwsM8KJM3rhFZphZylqYixbwP+lFattPSFiVEVRXU" +
       "+Rg636+RnuQMcgt7aK8Cjdqq8QRrtekixYmJpqVVTlWIHZ3xEJ+G1ecPcMat" +
       "qSIDZ1uu3N2lW+iGZBcf32MklTa9rWI31M9S2L0Eh4Mc5HmZ6DKDRLPY4YOu" +
       "+kXac2zWI91lxECdVrBQc9Ml3VtnLIPuQH0uWh+FxumSjwTLFLZEHAj3bgqI" +
       "JohXq4WWy0qvB+Kocv7qFELkWvmkLFfI5LCTQvfSbdzpGr6K7nqeuThTkUpU" +
       "jJwsNe/ix2J/AuO+Wd3rnb1qsLyy6CRwObH0xPmKBxJoNZEZjgbXEeaRF4u2" +
       "SFvPWUpCpk6tQV6VkGbb5XjPGJRsZYEkYvLcriu8n2apPJlRdUD5eFfw7cXi" +
       "pnOtkzWwz3SQJseTaY88aycjWeeuKDDOUS71RkAwiCApTz3e84RI7NBbbthA" +
       "aB7nUUZgxxVSK9DZW8tsJ81ND+RMqQbFLdczfqmwjD1qGj81kxWvV7TFKZ5D" +
       "GaFzV0Gy8LU5X/dpziP0dfRv5xjBb9atQvuxgG5pq8s7cUzJC3snVpAicbVY" +
       "eAoDrJYrEAqCslxNgKSi1hRBY+JyDPTb4Bpxcx4Hu+mli4GbiHBDLIu6jJQu" +
       "tydfrmaf8P3wFqwYCqiZVPR7jrhbV6/csUbi9AdKyuXrWRWg200LK1m71DKo" +
       "oTnZEzKpEHNSFXK2PwFXWlGr6dJgxWBfk7mJ6C4BsTbdycllbBhIpleGVcOe" +
       "hzVGGYorNdqDnV9UKFiLCMT50jlG+l1ZIjAhXDZcdEFjc4CaadBCFpFKcz+6" +
       "oKDb3FZYqboxAp17IdsXjcvaIOs1RufgFDAED+6O7haLiUMEu8UJqA6ySpns" +
       "aMyb5NVbylSGU3PMclrsV0WudrV/W2ythPOkYaUkwLeAriPyYmUrJzlaMbGY" +
       "vrv3q01FMQ7A5iwhVsG/b0nRaZkDMWgyKrxbjWcf86ibXPxS7zQSIBSCgPGj" +
       "cW353LtBm5sFt8TpdrxVe+AOuOZxIVkkxRl/PZ7NZVX1+OjCUbPTDswKktKN" +
       "A3drqTbdtQPKKMsdkznmY8TRlZeiSHTV21nMT5yGN5a4Wbrgph9oDvMN5eBQ" +
       "5CQTt4JHsVRAoBuXZNrNhKpTvGwxoBvbVxPdjLnkFdHlYNYkCypC00UnxRaT" +
       "6XxWtAazbsrZGwHZayb8eru19grshhQzEUTIvKFT1WZysaXeci6Il/AWvA8A" +
       "ESNUsNlXA2cGFNmEk2ipUDPYe7Cmbk6JZqRcnDy+LHS9X0dOuWlQXVT19WBd" +
       "ATOf0/0WsHXSaOlyEg3nQrIX8Db297K/D4Vu917qlKmmK6UKO1B+3Jc8d5Fb" +
       "E4EVOKgCEB1UcD6QQOFergywE8ip629bZIpnFOjnV5Xrgwa9paSCTOehLOfm" +
       "BI13MBS4BYB1kTK6AzX1MpLfIOJal460F3WIRhKymgBkD9pBzPTHsahVuoT0" +
       "Ph/TQuGOXWHjyTTf4nYvxWIniHK/s+9oIUNKdC308ag17S23Wl3d68nuIN+y" +
       "TpUv6wzf0LVsZJtx/MZiRtNfThfVVWpxF9b2zcOVVfeCUB+bCL+M2Yw0mOEw" +
       "ML62BT4MIHi6WtTOZ3uUSS47IFKIS63whx42qHBYeCPi+xxhj0izZJR5i9Ny" +
       "LcaIokiKBNdpU4zuVu3cLRmKkznMVHlOx2BG7Mi7Q/X1OOrn/EKT8uxEg6Lg" +
       "2VVx8JjnlmsG50GHCCx13ScuNPO7cF3qg3ZUqcORtjIBk9M2ouedYw2AldxF" +
       "JTkI1y0o8d2wBtyTwZ229MqFDsBFTMhOyG+HtmPXaK3MpV74qlBzS2R3h5Mt" +
       "GnOaTlMbx6dzQNC7ei0v2qz5DlJCx3QB6l44Nkd5SPaJaFz4gAEShgZEs9bE" +
       "kskijXAwTqYvIVqeWvoc+1Ih5Zpbte4tr3d8H1aNp+OMlcHpvS08DNfEYy71" +
       "Z19aJIeGVYev8RxSW/9w8XJjwOmCYqZhC0TLdh6vtgHwkYbC4J1OR4CykIuM" +
       "EYAcB+oVPem7asIpEBp6LdwByQE+7M6OgE80kKC73iAGx/MW2o9qrsf1QxfN" +
       "MgxWszxD/CFhEFD0ogU+bcK2d6ApmnlgvctIVNyIGxnk8K1p6lb1cimpMpuV" +
       "iXG/6MM8nS9zAkwIXAS9gl6FLvF2YrospKHs9DvE8FnRwc0VL5IsraGRYuIr" +
       "EeGYNN2rHbLZndavZXGziBqIHdgKmzUt1qxj4elSdph5+CLo3sJhs0SA5qlS" +
       "AuKemXJXmgoUIV67BD5nXZItUtXS1sR3tVW5x+GYDP05HIpEzJ0Fd0ZEnRtj" +
       "rHYNSSTxlsRetrBzcvVz5G055LxxAjHdrj1ys3PuNf4Ecp4Nwol923m72DiC" +
       "h8JWWp6TixNmQg6x126oy+AjdsH30XU8DjZF32+XuPX0qxxYvAVCviPl4tm5" +
       "WamU1Mf8TnaNKra2vcqHnIkXw5BRRBJ28R7fHMzFPAx1VYs4dbxp4nXAGEss" +
       "7zFnAUaHWUKhVmSjqZsE2UsKCrqhuhzbDOqWrSgwZXCU5N5VKyJT0Ld1p0Ua" +
       "VJ9p1OJp/ZaT55sFbK2qQcmpG7GghVzlLkRhX55kPHDT/I753XIXDFdvGGMX" +
       "MSYytl1NKTiwY8ULyVkgQqNwBa5K2KjA2adCvxoSUONlsDPLrkbga8kcDYrP" +
       "DTTGN+8FbQI2DL0K0xg+AUsYjiprCeTuNqVMisHHWM3vtUfkrRJtXorZ66p1" +
       "4G4EM9uWdzoAaoEeqPEuRUmyyoovGlfiTJaAJFyqKNgntVFI8AFvqnqPnrm0" +
       "gk7isLskHZZaKHvXq7YKCE/FpXY3VqvA");
    public static final String jlc$ClassType$jl$1 =
      ("Nrv83N9OCMLaiFJdMgkXQBSYm3YUMH4RQ7wVjtWOS021zektB5d8gluFjGQV" +
       "55a3O4Jq1/gq0oRC6luifBvuTYlt6bPUg9UQ+3uTmof5ynaBz1ggepGO2kLg" +
       "zh70L71kp7XseuCxaMOA5yv9YPtwgOcbn6Eb7kWhoSzFSaw8oeo2fVGXXSgL" +
       "Rn3EaVpPbR7ewdZFv0D4JYy1OJAwvW63qJQ4N6BUhRad3oVbidcA2+q7fc8s" +
       "uS/hFY3RJzGp+AI4GbqFDiemKH3yeuYCHjsUWp/fOPJ8DpMjEEphyZ5w7K74" +
       "ZbkTzDW8z7e5IAeCONx7beUtiouZY0fyWQuEQLV2fUQ3OExV4boD+WtBNirZ" +
       "wcs+uplMa2Nyp2+ysKAjvpJAbJqIBtP7UaogIvcBOUsJ8Vpro6Ws6+aBToxi" +
       "2E0t3s97w0Z58JysnNZMsNAF0tylbl1vYfApnhYXLsWmVo9bcHZIsPiKj4ci" +
       "Dw+JnBVOJi3xvjLNSZPHnpcNXbyAJQYffDpMUIbBNHl/6c9wWjjXs0Vlw5au" +
       "swXCZEmxtw2MzhoUgkwc7Zw+v+z43XRH+5oNG6ynIH6yqi0fDI/RXbAPQ0ty" +
       "MKcGjVnKt07ccl0PchDZFayZW0uAbpf6XOdz77R5PVUNQVA8eQjE8zahbMIk" +
       "G9dzrxe7kSo7WaI3h4Qf4Tzfo9ytw3aec7uvixZC1/vckF4jzyEJyjSkVpp4" +
       "unbrVAdpMMbieR26zS4xkn1dElXJANZfz8t+LHDYKni3jmpicvabOnf2Eh0W" +
       "VnQ3+nsQRhSAvkt8wV5ra1KuhLHMRtGBxzDJfTXfssbdxMkpjceUOwRyv2Vw" +
       "buEkqgp5spm6wnl2jxHI35drGOrMremEswAdlmqe58UB5tQP8sLf0kMMO+Xa" +
       "FhnoioGh6LBwilgI9J3vCMhINlsFj4c+uEduJ5xIbGn27rG1ZfwizqbDZTpP" +
       "a1cnnszuICLRfgZm8LA70pywBZeMcxtFk++EnaBsGYe17LnTeKoDCrXZnqnS" +
       "ZYZcktzAjEornHSgiaNchtmLaCJ0h932PmKq0Fhw1Th2YT1ywjnZbAeWmUAz" +
       "lHyxhQ0Mj2n7+ORgBGXqOp3TRkCoSrlc41UAUCIhagsOPaBbMKMToWCmyAYn" +
       "mA2IaXbDZspkkjuL9omBSwncEpN7DCjwwTo6oGoc5uYGwt6CkmmVXRfp0DGK" +
       "RtB3SNhDZ2FvuxfxgneHJYJH5VCOJsmm/iLYJcWoV9Lco9S8Yy+1zans0eRj" +
       "WJXilNM3Zyt72hGQocpg9jRdnQ42y4mRVMGae9iyVRs6b6ROenIy4c1gNqlO" +
       "X/eBLHjW5soYhUhdKJMYBSBlAbkoV3ULbh23OFNcSh/V0cl6rM4H/nqdk1pX" +
       "77iHCrXq7/RHhFEW9KqIJ5ns4aa39rxX155/d8cFoW8UH/PGLohOsHEIbAHk" +
       "avfuFlVa65RtnaW486igPDN5C8NTzyS86GCWbXFj7SNYZMhlkciUAc6xTw65" +
       "jxG0I0HjIXZU4XDVHAcsjea0GVjzTJTtkAKnKgwgMwzBkAAmh0SpfA8y7XF2" +
       "b4BOJiWdK1YV3zWRvhZQjjXqfjRWlAJE6brHGtAeusuZlC94SgMGK7e31rtM" +
       "N9Ml7biEolq1yiBdYx7oD9wplEtfsTIKpzJiv5D9dnAF0DoghRTHKsRokgJq" +
       "x7xXl6ofT3nS+829LAX/Qp7sTjIngShk7FwfrqeDTqMu5PWOefTyTvSl+8Cs" +
       "Mmp4HEhiVnBqi/qi+xyPevSpHA+QgN7E9bBF5ll1IORs54ub6Sb7cQ/fQSUS" +
       "2nVNDQamYU2SvVgeqhqf08NuV1U+i5rZej4ChVLc2EPSzNDOB0OgrGmEDLpC" +
       "l/xt0VAutr/FU2qYiXTlHOwzfqchyyjmIj8Y55MB9Mcq27NLlG8xccI3erD0" +
       "aXK6YIyEWgJHhl4Gik61gwSAO5sg0Y7FeCnAe4jxMFiQDiHd/ZO4g7y7dThS" +
       "lD8oY5kdkSADqwY0oKrC0JG7rTOiSCmGoLsc25X3QEBUkj+pDss3O3PgIN4X" +
       "TfYkcbV8BFkfDWJy8wCnc3a/Ea6VyFjNu7GiepGPkNJhyTX1LFu8gaDIrpwz" +
       "IXUmFQOE2Gwsqp3i0ymYi6mjBhPKmONaA6cI6/rBF4n+rOe38c3vEwndyPOk" +
       "EnYSwdJurLX5cu/kBZ+vIllB3bKXd+iR7vciFzGl16QPu+6Qin8orCiSsoEh" +
       "F8PFWWQeb45woewAN/LV0bFjwdIInWfmyqBhnDR+nSY+VtqZlUGWyifuSeO1" +
       "Osq8GJJKdL0MPCqVB5vfOHvZNdo9QnKedu5rA9XsWRNA4eazcSQuFp3Z2Hio" +
       "LN7JuxRY9jfs8VOA88sfQnzm+ScZb/1I831+jNF/ipyYBYIYhRfxAz/74163" +
       "Spc3ErfaAoAUzzi0gwyTNiM7wI4NebihFeukrhF3fXWMojNqMNSkJBcngPjh" +
       "dLaau8f3DXx10QGoL8xuywVmr/Ak9ZpBDgRMR169KGpwjPFqOMGmL7LHHaaB" +
       "TLhmimneo+pcRzjs0Z3ClSVjErZInUb/tqU+2lTiiIlWtn5VqGS+Vp5BXUVz" +
       "7DEGFOGQlQFhmnwH3oKVkWG4Piz3wcK5BTVI54QFSbl02DPhJoYhSddsD2cq" +
       "KW/OLc+a1ujvFdKFcrEpL30UOPumDWYs+At9ijQcO3QJOqS03WANTgu4u6ww" +
       "gsUOb6rO2RJ7w1b3KbdeboHCmC7FwMGZTyTbcAzHyrzDlDEkgJWATqHHESUm" +
       "+XZmiUMwR8rNjK/jlspIt65HAlqs00GyL8o+TFIu7BdtYs85Q92Za5nTKTNh" +
       "+ICorY0YazD7GDCtjp3aBqp1HUaB54lwQXGNiVqqk96lDNPiys1YrtDhbK8p" +
       "dkB5jig3iIea3yNYWoxVG4MoR1wjmKajfK+lvF0uJwAGB37vMrvOmJpgpdRW" +
       "Fg8xalAgARNTZtyZ4Fa66TG7xNnKZsgFw92A3IBZxM2PEnChh2OPqJro1wUi" +
       "A7sRMWf7btpnD90RrQg32ub4/bVyIdXsDOC+1xbN2dL6sFqOe/W+pllIx+YW" +
       "TtxXrAnVFDd99XA1w308yyFxwJhRKSDeWxibwzV4hvpkixVYUgdw9Ojglp0Q" +
       "XOtyQomQd7q9rhhFAjsU0tW5p2ngRDv2jDAxAJBdMCOS5u6IiVaRu5N2ABXR" +
       "Q0TlhNpNDHiDe2rPKi1zxWxARtQQ29PYluGlFlgPkt5JAKjJyD1kcQhVr1Pt" +
       "aMKRJMzgJGHtmezOTKtyPaMdJBG7QpgZsQHskmHTHvaCF107Yvb2eamBCLPH" +
       "FQ4rMxnm6DBmCeQEN+a5wq+SfYQmkoA7QVsL5izWJMrUMbBSlUij+7MGG33d" +
       "36NEiwu6mpxjZlG1PFw9KyqRTQpo2hZNSTjo8NjJmglmSJ5FO0yE8rGmTzCs" +
       "MJHH7husjNZcPJ5OdnE0OZWAWIF0rgXKxLfIUZeQ2g7NgKtL7iY8ctwMEolL" +
       "MikINyOMJqywL3sr7cYIgPMt9ZdYjIsaE0rjkZunU4S6xc4ThZN135/O4azG" +
       "8KHrbrBYgbEeAwkRqvJQbrmOdlYjb0vQsqN9lPgZdIprdWlNek8eGuYSWPP1" +
       "4O9tULioUReOiuaWiiWFotYDcTKjmyGPdaHgZXWLNwe6tEXpjkLXSaUpnarQ" +
       "OzvhmS9ENcP79wg+BZyXslN4PmT7uKW6OB4CqxqutHWUInk/Wtk82K7U7O2o" +
       "gWKpEvVyYECfF5vhFF9knCzryDi5YnPcDO8pWarieq5KgEjSE8SS55nzsSI5" +
       "3HmckaC6deDLiJXKHUUWCaABfxz1s0351NISUdPUo2Vc+QOW3gBlOkvBiuGB" +
       "Y6+tQfeYdb5ph51vuZ2N3tXL6LqaGbW7ECSqqeZLke16IuwzgT8NShIUxL0f" +
       "EePAXAmUFayKu050XupnBORCeM+CjCBguyA842XZI0RcF8ZCblFIb9vXkQPE" +
       "qyJ79AU40inuLXf5GBEdX7EyGcFWbA/QzB19Z9TuU1TTCkhvehvjl7lBOn1L" +
       "d9E8Iw1l1q5bum2ycNrjetW02ckpIud8uF1PVLlzmp1LXLpMcSNo6U1e2fz5" +
       "yZDty6Vbz1RQzSQ4LqFOTUOGigEUh8Why/Y610u75MKiVZg1Z2OYYl1RAKsY" +
       "Do7p17M5G87xSMt+RJdeC6HmcYmitL4fmoQwKw0fuDUS6O5go24nTnbdymiK" +
       "E+wcp3ZSgGg4VcmiGE7HQZSP7GWX2qnoKe7LaPBxqqpGS/NuhwEAXQRDHOLc" +
       "x2ADBY1B7gMrgE+s73UlXpCsigNM3PKMwOH2IUkDgvTnU4eg1KmyyVHrpCS4" +
       "K8RevxoZnoJTV0LEGrE80EkhJO4w4JBH+ALyynAxuRR2T/ZB2CnOCOFFaK6A" +
       "gGJNew9I0k3N2J5lc1eUhEwm6WZuWYmVzNsklIPE3qYdvMR1DWa0plaRNFKH" +
       "xcOhfHdUbZfYnJirauBxNYEtdy6jZofqXMBKYacyXDKqlCRP/LG9GJZ/lO2r" +
       "0Pow3olgRKbDPp9Xn5TJsF+h0Z78OPRtScMAe5o52NTQ3tmpDW4P8JYaA7t6" +
       "Xx4LWE8yFeWzHEJdfvXEq2Tek2xzLCvfIo29wmwL2nhCnfn0ZAvHGiTIQLnO" +
       "5flkEQLa4juPasYBQVSw0MOZyLYsRTHkUER7asv/EL29qdmdDe1tzJWFsfMN" +
       "oLiEM4YlA3G6leBs6srJdO6n4BJtsQmpJlqu7A4Cmcf9nWIb9Jr1qLSIwlF1" +
       "4ClszOOAD3Ef9awUdfKgnjjQuVU6FK8wmc6BH55yE1ogDXF9I4tn82AFk3kt" +
       "zUMg8BMhMYPYVB3LH8O+py/9bldXFCIdJE9WQ7COdp0wiQsMlYV3yMFUc3zr" +
       "NJfwhOrslbvok4M4Pl+nGtBFpOU6ZYfeJ+8ei2wRrzTZcEmMOkfBlJpT7hKF" +
       "WG+QOUZceTbsYYTtozZEkDqbXFIIqx0vF2cxUsI7zRFo1NhntFbXtr/0tOfZ" +
       "/ha+L/P1Lm12bcEuckaxcqLIczW06IWWUQeFzgckwDyi5nk93iKVvbNPS1ri" +
       "6z73+DpLJCnW6iCS4j12c4VlkELpthc9vXHaq2xZur7WUISfpw5GGpRycJFQ" +
       "XZ05mvpNOvKnU2waIs2S8gQqW4KBNSZLioa8pyYWZ/bWJba5MZz1dXVoZ4jy" +
       "QYW0oVaE/ITMzi1H0UxsKwk8V5epZogcNbi6cwJZ3ZGFouuZ7PT0lrHu4TN1" +
       "2WMOUBTdGfeu1GE2IprJr/mZ23J4t+WEQQhpfk2v7DoPErfMkxG5OnEZt1Rt" +
       "HQGxcPyAXRhsC0c3BudIodB+A+5yzmOAeLiSzZoocOUkM20iodgeDgyxKdqW" +
       "aUhCXlxtFhc0eMWnNJBRSp+ifl1NEskHAMMOTSOw/bNeEluAw7BpDJqxUsOl" +
       "F1lQJ+XkadotjlAU08XXj4goeuKgSwWrAy0mmUlm+5VD3q+nYeMnMXYY3RGW" +
       "vjCZyWuEW2to02I2jeTPelktm1nUjqa7xdzr4bqMLkFmmw9Bqlhfxcjx3WkO" +
       "Ynvdz7jZgfulXxiBNvSY1s8SwuQZ2HlHTTTTm22EAQYYgJRsaWKZY4fIGDt1" +
       "Jm2tLRdY3veZCPpcDIzJxA1Lyo3H06z5tu3vcWSnSBfZPfhF5g9+FJKk1g13" +
       "wD1WS24Q6bRce+JGW1ihgZxnhCOi+OOubhsWzZglBq5kosmjdMBt8wqeyQRE" +
       "D2mkh1S0JklIpIqkbkH/TGhEAybVPUnBDk+LLMXlWXVvz3+g5En7vnhCt0Ly" +
       "otGBdpc7ab7dyytDMbqDpOzQDI2uW11+IF2TxMdZIcAkEKZNS5SWMuAyl6j4" +
       "1ffLyAdc1Y5UZSRT2Vy2mEncZWbtZqYMsHSE03C2X1GFJ0XCAGwN5XBTZC6g" +
       "eVIsGzUj8LJr61HxVSmB1Msg3YDgsuHUxSGycDLTb+mvshB32eyjoUqTswHZ" +
       "CHioBJsgloV2RbC2BLkUhVFlZTmiCKiIMknd31mdlJl2y93AlB0HuSzPsmeq" +
       "fEuG026XqLubsrvd/NSuPTAhyNFTd4Rb3neipAK3nJphzZD6ntQ1hoJmwjkJ" +
       "l2nEC67aeVMpwqKkaSEphb16A02o13ji4F6EzbfEbZJZh/DitLSFTosK36Y7" +
       "bZwuMAwc6sgEdAMPlEbouxmMS0RBaXe3wyBJIYKhPFxiF1SqlhwEsWUnZLxO" +
       "mULAdsPBvBUJwKHMuiC7+XDTIAe6FkB48EBCUTvBT9gaHZfU2xnI5i52kNLq" +
       "c1M7lhwASqnkfUGkt9U3r6aII14Mp4ht14duqWOc4xa9hxf6mKDcDEipS9Gn" +
       "mPbO4jSr7BWSs2IwVXqs7Z2coP14mJD7dmxmBV+iQ0ftKPNwP1Mm+vid/Q//" +
       "8COF1l4m3H/gXQn3G/CrlHt+77qK11/WVXzce1lBNr9VGfL8+dTL0rlvedl/" +
       "4m2VIW8rp3ntzXKPz75VkvZWKdqjIuHbv1YB5HM1wi//i1/5pUD5t+HXX5br" +
       "SP3T1/VV/UN5OIb523Z5lFz94XdAOj0Xfb6qvPl3Tr/61/nv9f/0608feqto" +
       "5l21o1+96EtfXSrziTbsh7Y0vqpg5lveOpbno0Fe3Lz2Ky/7n3p7wcyrP3G8" +
       "V7XM19Vt1Yd+Hwavjvq5UukbXsL6yZf9H3/nUb+qbXrtBbBn7j5vF79P8VP6" +
       "aLz+6VsfEvFgzRvvqhZ84xXKX/5qQuUXJUKvf/5F/9p/+zUIfTTBu+l5LPlv" +
       "XvZ/62vT8/orWXyWVucZdPM+RD0/zD84UV//gPBt2/XN236/9LL/V96HqO/6" +
       "aqI+8XLJv/yy/6mvTdTb0V3fZ+yZz0P/Sgap98L5h17g/fr/9rL/mx8M58eS" +
       "//Rl/1d/X4L1ggf/0vsg/pOP5k/0T18fhHkYeX3YGdXzRP5lJdKjO/ZPH7tV" +
       "VR565TvIeq48ezTf+fT0oWDrv7D1p9+nIr1ptz5aeo/Cpneo0mdeQpNf9j/y" +
       "ASj+U+9D8Z95ND/bP32jFwSH9yf6w2OVBO9F8ee263s2nH7rRd3dh379A1H8" +
       "aH7+Pah9QPoPX/a/9gGo/aX3ofbffDS/2D99pg2LagzfRvBj4BfeQdzn3iTu" +
       "+ze0fnTrv2/rwQ9CXPhexP3Bl5C++LL/jg9A3J9/H+J+5dH8Wxtxz/X7SdU+" +
       "CjIfFZ7Ps3/6vVTw0y/U8MO/vfU/uPV/+oOp4GPJn3rZ/9zXpuLDz0h++D3q" +
       "J1/Ugr4aeNPTMnnVPd7V8HLgG98akL1b+Pw6gZ9+Ru/fe5/j+A8eza/2T59M" +
       "uv2wOcc2WcPga57EH9ku6unpo+zL/ps+2Ek8lnzuZf+pr30Sb/MKzqP5i8+g" +
       "f+N9qPiPHs1f7p8+dd+iCrWtqvuhmsq+evNoPveqYH47yC2Ifp7zXlr6Iy+u" +
       "j/3Ai/6j/+ifiJY+IP3Dl/3f/6CE/+b7EP7sDf5K//QNbxFu1v2zmv7H78W/" +
       "RzS336j72Zf9H/8a1H0N/j2W/NjLfvh96eMLCv7L96Hgtx7Nf7YZ9LAZvPxr" +
       "K+ED9c2sf/z/fNn/jx8M9ceS/+Fl/9sfwJT8nfdB/Xcezd9+X9Q//qYEvPb0" +
       "4vPc908/8u7XC/yRL2xQuqQZtijx+15WVn/h4Uy+8Ah1kjLpv+/7v/BjX/jR" +
       "P6p/4ce//613EbynMD7jT7wjov/YO7F4jP7dun4fAv/e+4z97qP577cE4k3s" +
       "Ht9/Yd4M67sCskdx/ze/6+01L96x4v+FX/rUx//QL5m/9fzmh7feg/JR+enj" +
       "9yHP317J/rb7j9ZteE+e8fjoi7r2F+fx91/g86zqj4LlrXtG/n99Mfy/908f" +
       "evn/yP+jfiGe/x8Dp8qSXUcAAA==");
}
