/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import jflex.StateSetEnumerator;

public final class StateSet {
    private final boolean DEBUG = false;
    public static final StateSet EMPTY = new StateSet();
    static final int BITS = 6;
    static final int MASK = 63;
    long[] bits;

    public StateSet() {
        this(256);
    }

    public StateSet(int size) {
        this.bits = new long[this.size2nbits(size)];
    }

    public StateSet(int size, int state) {
        this(size);
        this.addState(state);
    }

    public StateSet(StateSet set) {
        this.bits = new long[set.bits.length];
        System.arraycopy(set.bits, 0, this.bits, 0, set.bits.length);
    }

    public void addState(int state) {
        int index = state >> 6;
        if (index >= this.bits.length) {
            this.resize(state);
        }
        int n = index;
        this.bits[n] = this.bits[n] | 1L << (state & 0x3F);
    }

    private int size2nbits(int size) {
        return (size >> 6) + 1;
    }

    private void resize(int size) {
        int needed = this.size2nbits(size);
        long[] newbits = new long[Math.max(this.bits.length * 4, needed)];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public void clear() {
        int l = this.bits.length;
        for (int i = 0; i < l; ++i) {
            this.bits[i] = 0L;
        }
    }

    public boolean isElement(int state) {
        int index = state >> 6;
        if (index >= this.bits.length) {
            return false;
        }
        return (this.bits[index] & 1L << (state & 0x3F)) != 0L;
    }

    public int getAndRemoveElement() {
        int i = 0;
        int o = 0;
        long m = 1L;
        while (this.bits[i] == 0L) {
            ++i;
        }
        while ((this.bits[i] & m) == 0L) {
            m <<= 1;
            ++o;
        }
        int n = i;
        this.bits[n] = this.bits[n] & (m ^ 0xFFFFFFFFFFFFFFFFL);
        return (i << 6) + o;
    }

    public void remove(int state) {
        int index = state >> 6;
        if (index >= this.bits.length) {
            return;
        }
        int n = index;
        this.bits[n] = this.bits[n] & (1L << (state & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public StateSet complement(StateSet set) {
        if (set == null) {
            return null;
        }
        StateSet result = new StateSet();
        result.bits = new long[set.bits.length];
        int m = Math.min(this.bits.length, set.bits.length);
        for (int i = 0; i < m; ++i) {
            result.bits[i] = (this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL) & set.bits[i];
        }
        if (this.bits.length < set.bits.length) {
            System.arraycopy(set.bits, m, result.bits, m, result.bits.length - m);
        }
        return result;
    }

    public void add(StateSet set) {
        long[] tbits;
        if (set == null) {
            return;
        }
        long[] sbits = set.bits;
        int sbitsl = sbits.length;
        if (this.bits.length < sbitsl) {
            tbits = new long[sbitsl];
            System.arraycopy(this.bits, 0, tbits, 0, this.bits.length);
        } else {
            tbits = this.bits;
        }
        for (int i = 0; i < sbitsl; ++i) {
            int n = i;
            tbits[n] = tbits[n] | sbits[i];
        }
        this.bits = tbits;
    }

    public boolean containsSet(StateSet set) {
        int i;
        int min = Math.min(this.bits.length, set.bits.length);
        for (i = 0; i < min; ++i) {
            if ((this.bits[i] & set.bits[i]) == set.bits[i]) continue;
            return false;
        }
        for (i = min; i < set.bits.length; ++i) {
            if (set.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object b) {
        int i;
        StateSet set = (StateSet)b;
        int l1 = this.bits.length;
        int l2 = set.bits.length;
        if (l1 <= l2) {
            for (i = 0; i < l1; ++i) {
                if (this.bits[i] == set.bits[i]) continue;
                return false;
            }
            while (i < l2) {
                if (set.bits[i++] == 0L) continue;
                return false;
            }
        } else {
            while (i < l2) {
                if (this.bits[i] != set.bits[i]) {
                    return false;
                }
                ++i;
            }
            while (i < l1) {
                if (this.bits[i++] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int i;
        long h = 1234L;
        long[] _bits = this.bits;
        for (i = this.bits.length - 1; i >= 0 && _bits[i] == 0L; --i) {
        }
        while (i >= 0) {
            h ^= _bits[i--] * (long)i;
        }
        return (int)(h >> 32 ^ h);
    }

    public StateSetEnumerator states() {
        return new StateSetEnumerator(this);
    }

    public boolean containsElements() {
        for (long bit : this.bits) {
            if (bit == 0L) continue;
            return true;
        }
        return false;
    }

    public StateSet copy() {
        StateSet set = new StateSet();
        set.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, set.bits, 0, this.bits.length);
        return set;
    }

    public void copy(StateSet set) {
        if (set == null) {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
            return;
        }
        if (this.bits.length < set.bits.length) {
            this.bits = new long[set.bits.length];
        } else {
            for (int i = set.bits.length; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        }
        System.arraycopy(set.bits, 0, this.bits, 0, this.bits.length);
    }

    public String toString() {
        StateSetEnumerator set = this.states();
        StringBuilder result = new StringBuilder("{");
        if (set.hasMoreElements()) {
            result.append("" + set.nextElement());
        }
        while (set.hasMoreElements()) {
            int i = set.nextElement();
            result.append(", ").append(i);
        }
        result.append("}");
        return result.toString();
    }
}

