/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.util.ArrayList;
import java.util.List;
import jflex.CharClassInterval;
import jflex.IntCharSet;
import jflex.Interval;
import jflex.LexScan;
import jflex.Out;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharClasses {
    private static final boolean DEBUG = false;
    public static final char maxChar = '\uffff';
    private List<IntCharSet> classes;
    private char maxCharUsed;
    private LexScan scanner;

    public CharClasses(int maxCharCode, LexScan scanner) {
        if (maxCharCode < 0 || maxCharCode > 65535) {
            throw new IllegalArgumentException();
        }
        this.maxCharUsed = (char)maxCharCode;
        this.scanner = scanner;
        this.classes = new ArrayList<IntCharSet>();
        this.classes.add(new IntCharSet(new Interval('\u0000', '\uffff')));
    }

    public char getMaxCharCode() {
        return this.maxCharUsed;
    }

    public void setMaxCharCode(int charCode) {
        if (charCode < 0 || charCode > 65535) {
            throw new IllegalArgumentException();
        }
        this.maxCharUsed = (char)charCode;
    }

    public int getNumClasses() {
        return this.classes.size();
    }

    public void makeClass(IntCharSet set, boolean caseless) {
        if (caseless) {
            set = set.getCaseless(this.scanner.getUnicodeProperties());
        }
        int oldSize = this.classes.size();
        for (int i = 0; i < oldSize; ++i) {
            IntCharSet x = this.classes.get(i);
            if (x.equals(set)) {
                return;
            }
            IntCharSet and = x.and(set);
            if (!and.containsElements()) continue;
            if (x.equals(and)) {
                set.sub(and);
                continue;
            }
            if (set.equals(and)) {
                x.sub(and);
                this.classes.add(and);
                return;
            }
            set.sub(and);
            x.sub(and);
            this.classes.add(and);
        }
    }

    public int getClassCode(char letter) {
        IntCharSet x;
        int i = -1;
        while (!(x = this.classes.get(++i)).contains(letter)) {
        }
        return i;
    }

    public void dump() {
        Out.dump(this.toString());
    }

    public String toString(int theClass) {
        return this.classes.get(theClass).toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("CharClasses:");
        result.append(Out.NL);
        for (int i = 0; i < this.classes.size(); ++i) {
            result.append("class ").append(i).append(":").append(Out.NL).append(this.classes.get(i)).append(Out.NL);
        }
        return result.toString();
    }

    public void makeClass(char singleChar, boolean caseless) {
        this.makeClass(new IntCharSet(singleChar), caseless);
    }

    public void makeClass(String str, boolean caseless) {
        for (int i = 0; i < str.length(); ++i) {
            this.makeClass(str.charAt(i), caseless);
        }
    }

    public void makeClass(List<Interval> l, boolean caseless) {
        this.makeClass(new IntCharSet(l), caseless);
    }

    public void makeClassNot(List<Interval> l, boolean caseless) {
        this.makeClass(new IntCharSet(l), caseless);
    }

    private int[] getClassCodes(IntCharSet set, boolean negate) {
        int size = this.classes.size();
        int[] temp = new int[size];
        int length = 0;
        for (int i = 0; i < size; ++i) {
            IntCharSet x = this.classes.get(i);
            if (negate) {
                if (set.and(x).containsElements()) continue;
                temp[length++] = i;
                continue;
            }
            if (!set.and(x).containsElements()) continue;
            temp[length++] = i;
        }
        int[] result = new int[length];
        System.arraycopy(temp, 0, result, 0, length);
        return result;
    }

    public int[] getClassCodes(List<Interval> intervalList) {
        return this.getClassCodes(new IntCharSet(intervalList), false);
    }

    public int[] getNotClassCodes(List<Interval> intervalList) {
        return this.getClassCodes(new IntCharSet(intervalList), true);
    }

    public void check() {
        for (int i = 0; i < this.classes.size(); ++i) {
            for (int j = i + 1; j < this.classes.size(); ++j) {
                IntCharSet y;
                IntCharSet x = this.classes.get(i);
                if (!x.and(y = this.classes.get(j)).containsElements()) continue;
                System.out.println("Error: non disjoint char classes " + i + " and " + j);
                System.out.println("class " + i + ": " + x);
                System.out.println("class " + j + ": " + y);
            }
        }
        for (char c = '\u0000'; c < '\uffff'; c = (char)(c + '\u0001')) {
            this.getClassCode(c);
            if (c % 100 != 0) continue;
            System.out.print(".");
        }
        this.getClassCode('\uffff');
    }

    public CharClassInterval[] getIntervals() {
        int i;
        int size = this.classes.size();
        int numIntervals = 0;
        for (i = 0; i < size; ++i) {
            numIntervals += this.classes.get(i).numIntervals();
        }
        CharClassInterval[] result = new CharClassInterval[numIntervals];
        i = 0;
        int c = 0;
        while (i < numIntervals) {
            int code = this.getClassCode((char)c);
            IntCharSet set = this.classes.get(code);
            Interval iv = set.getNext();
            result[i++] = new CharClassInterval(iv.start, iv.end, code);
            c = iv.end + '\u0001';
        }
        return result;
    }
}

