/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.io.PrintStream;
import polyglot.pth.OutputController;
import polyglot.pth.ScriptTestSuite;
import polyglot.pth.SourceFileTest;
import polyglot.pth.Test;
import polyglot.pth.TestResult;
import polyglot.pth.TestSuite;
import polyglot.pth.TestSuiteResult;
import polyglot.util.ErrorInfo;
import polyglot.util.ErrorQueue;
import polyglot.util.SilentErrorQueue;
import polyglot.util.StdErrorQueue;

public class VerboseOutputController
extends OutputController {
    private boolean alwaysShowErrorQ;

    public VerboseOutputController(PrintStream out, boolean alwaysShowErrorQ) {
        super(out);
        this.alwaysShowErrorQ = alwaysShowErrorQ;
    }

    @Override
    protected void startScriptTestSuite(ScriptTestSuite sts) {
        this.out.println("Test script " + sts.getName());
        if (sts.getDescription() != null && sts.getDescription().length() > 0) {
            this.out.println("  Description : " + sts.getDescription());
        }
        if (sts.getTestResult() != null) {
            this.out.println("  Last run    : " + this.getDateDisplay(sts.getTestResult().dateTestRun));
            this.out.println("  Last success: " + this.getDateDisplay(sts.getTestResult().dateLastSuccess));
        }
        this.out.println("==============================");
    }

    @Override
    protected void finishScriptTestSuite(ScriptTestSuite sts) {
        this.out.println("Test script " + sts.getName() + " finished");
        if (!sts.success() && sts.failureMessage != null) {
            this.out.println(sts.failureMessage);
        }
        this.out.println("  " + sts.getSuccesfulTestCount() + " out of " + sts.getTotalTestCount() + " tests succeeded.");
    }

    @Override
    protected void startSourceFileTest(SourceFileTest sft) {
        this.out.println(sft.getName() + ": ");
        if (sft.getDescription() != null && sft.getDescription().length() > 0) {
            this.out.println("    Description : " + sft.getDescription());
        }
        if (sft.getTestResult() != null) {
            this.out.println("    Last run    : " + this.getDateDisplay(sft.getTestResult().dateTestRun));
            this.out.println("    Last success: " + this.getDateDisplay(sft.getTestResult().dateLastSuccess));
        }
    }

    @Override
    protected void finishSourceFileTest(SourceFileTest sft, ErrorQueue eq) {
        if (sft.success()) {
            this.out.println("    Test completed OK");
        } else {
            this.out.print("    Test failed");
            if (sft.getFailureMessage() != null) {
                this.out.println(": " + sft.getFailureMessage());
            } else {
                this.out.println();
            }
        }
        if (this.alwaysShowErrorQ || !sft.success()) {
            StdErrorQueue stdeq = new StdErrorQueue(this.out, eq.errorCount() + 1, sft.getName());
            SilentErrorQueue seq = (SilentErrorQueue)eq;
            for (ErrorInfo ei : seq.getErrors()) {
                stdeq.enqueue(ei);
            }
            stdeq.flush();
            if (seq.errorCount() > 0) {
                this.out.println("-----------------------------");
            }
        }
    }

    @Override
    public void displayTestSuiteResults(String suiteName, TestSuite ts) {
        TestSuiteResult tsr = ts.getTestSuiteResult();
        if (tsr == null || tsr.testResults.isEmpty()) {
            this.out.println("No test results for " + suiteName);
            return;
        }
        this.out.println("Test script " + tsr.testName);
        this.out.println("  Last run    : " + this.getDateDisplay(tsr.dateTestRun));
        this.out.println("  Last success: " + this.getDateDisplay(tsr.dateLastSuccess));
        int total = 0;
        int lastSuccess = 0;
        int neverRun = 0;
        int neverSuccess = 0;
        for (Test t : ts.getTests()) {
            TestResult tr;
            String testName = t.getName();
            if (TestSuite.executeTest(testName, tr = tsr.testResults.get(t.getUniqueId()))) {
                this.displayTestResults(tr, testName);
            }
            ++total;
            if (tr != null && tr.dateLastSuccess != null && tr.dateLastSuccess.equals(tr.dateTestRun)) {
                ++lastSuccess;
            }
            if (tr == null || tr.dateTestRun == null) {
                ++neverRun;
            }
            if (tr != null && tr.dateLastSuccess != null) continue;
            ++neverSuccess;
        }
        this.out.println("Total tests: " + total);
        this.out.println("   Succeeded last run: " + lastSuccess);
        this.out.println("   Never run         : " + neverRun);
        this.out.println("   Never succeeded   : " + neverSuccess);
    }

    @Override
    public void displayTestResults(TestResult tr, String testName) {
        this.out.println("    " + testName);
        this.out.println("      Last run    : " + this.getDateDisplay(tr == null ? null : tr.dateTestRun));
        this.out.println("      Last success: " + this.getDateDisplay(tr == null ? null : tr.dateLastSuccess));
    }

    @Override
    public void warning(String w) {
        this.out.println("Warning: " + w);
    }
}

