/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.tools.JavaCompiler;
import polyglot.main.Main;
import polyglot.pth.AbstractTest;
import polyglot.pth.AnyExpectedFailure;
import polyglot.pth.ExpectedFailure;
import polyglot.pth.Main;
import polyglot.util.ErrorInfo;
import polyglot.util.ErrorQueue;
import polyglot.util.SilentErrorQueue;

public class SourceFileTest
extends AbstractTest {
    private static final String JAVAC = "javac";
    private static final JavaCompiler javaCompiler = polyglot.main.Main.javaCompiler();
    protected final List<List<String>> compilationUnits;
    protected String extensionClassname = null;
    protected String[] extraArgs;
    protected List<String> mainExtraArgs;
    protected final SilentErrorQueue eq;
    protected String testDir;
    protected String destDir;
    protected List<ExpectedFailure> expectedFailures;
    protected Set<String> undefinedEnvVars = new HashSet<String>();

    public SourceFileTest(List<List<String>> compilationUnits) {
        super(SourceFileTest.testName(compilationUnits));
        this.compilationUnits = compilationUnits;
        this.eq = new SilentErrorQueue(100, this.getName());
    }

    private static String testName(List<List<String>> compilationUnits) {
        if (compilationUnits.size() == 1) {
            List<String> filenames = compilationUnits.get(0);
            if (filenames.size() == 1) {
                return new File(filenames.get(0)).getName();
            }
            return filenames.toString();
        }
        return compilationUnits.toString();
    }

    @Override
    public String getUniqueId() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        if (this.extensionClassname != null) {
            sb.append("::");
            sb.append(this.extensionClassname);
        }
        if (this.extraArgs != null) {
            for (String extraArg : this.extraArgs) {
                sb.append("::");
                sb.append(extraArg);
            }
        }
        return sb.toString();
    }

    public void setExpectedFailures(List<ExpectedFailure> expectedFailures) {
        this.expectedFailures = expectedFailures;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean runTest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void postRun() {
        this.output.finishTest(this, (ErrorQueue)this.eq);
    }

    protected boolean checkErrorQueue(SilentErrorQueue eq) {
        ArrayList errors = new ArrayList(eq.getErrors());
        boolean swallowRemainingFailures = false;
        for (ExpectedFailure f : this.expectedFailures) {
            if (f instanceof AnyExpectedFailure) {
                swallowRemainingFailures = true;
                continue;
            }
            boolean found = false;
            Iterator j = errors.iterator();
            while (j.hasNext()) {
                ErrorInfo e = (ErrorInfo)j.next();
                if (!f.matches(e)) continue;
                found = true;
                j.remove();
                break;
            }
            if (found) continue;
            this.setFailureMessage("Expected to see " + f.toString());
            return false;
        }
        if (!errors.isEmpty() && !swallowRemainingFailures) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = errors.iterator();
            while (iter.hasNext()) {
                ErrorInfo err = (ErrorInfo)iter.next();
                sb.append(err.getMessage());
                if (err.getPosition() != null) {
                    sb.append(" (");
                    sb.append(err.getPosition());
                    sb.append(")");
                }
                if (!iter.hasNext()) continue;
                sb.append("; ");
            }
            this.setFailureMessage(sb.toString());
        }
        return errors.isEmpty() || swallowRemainingFailures;
    }

    protected List<List<String>> getSourceFileNames() {
        ArrayList<List<String>> result = new ArrayList<List<String>>(this.compilationUnits.size());
        for (List<String> compilationUnit : this.compilationUnits) {
            ArrayList<String> sourceFileNames = new ArrayList<String>(compilationUnit.size());
            for (String sourceFile : compilationUnit) {
                sourceFileNames.add(this.prependTestPath(sourceFile));
            }
            result.add(sourceFileNames);
        }
        return result;
    }

    protected void invokePolyglot(List<String> cmdLine) throws Main.TerminationException {
        polyglot.main.Main polyglotMain = new polyglot.main.Main();
        polyglotMain.start(cmdLine.toArray(new String[cmdLine.size()]), (ErrorQueue)this.eq);
    }

    protected static void invokeJavac(List<String> cmdLine) {
        javaCompiler.run(null, null, null, cmdLine.toArray(new String[cmdLine.size()]));
    }

    protected static void deleteDir(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                SourceFileTest.deleteDir(f);
                continue;
            }
            if (f.delete()) continue;
            f.deleteOnExit();
        }
        if (!dir.delete()) {
            dir.deleteOnExit();
        }
    }

    protected List<String> buildCmdLine() {
        String[] sa;
        LinkedList<String> args = new LinkedList<String>();
        String s = this.getExtensionClassname();
        if (s != null && !s.equals(JAVAC)) {
            args.add("-extclass");
            args.add(s);
        }
        if ((s = this.getAdditionalClasspath()) != null) {
            args.add("-cp");
            args.add(this.prependTestPath(s));
        }
        if ((s = this.getDestDir()) != null) {
            args.add("-d");
            args.add(s);
        }
        if ((s = this.getSourceDir()) != null) {
            args.add("-sourcepath");
            args.add(s);
        }
        char pathSep = File.pathSeparatorChar;
        if (this.mainExtraArgs == null && (s = Main.options.extraArgs) != null) {
            this.mainExtraArgs = new LinkedList<String>();
            String[] stringArray = sa = SourceFileTest.breakString(Main.options.extraArgs);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element;
                String sas = element = stringArray[i];
                if (pathSep != ':' && sas.indexOf(58) >= 0) {
                    sas = SourceFileTest.replacePathSep(sas, pathSep);
                }
                this.mainExtraArgs.add(sas);
            }
        }
        if (this.mainExtraArgs != null) {
            args.addAll(this.mainExtraArgs);
        }
        if ((sa = this.getExtraCmdLineArgs()) != null) {
            List<String> appendFlags = Arrays.asList("-d", "-cp", "-classpath", "-sourcepath");
            boolean appendFlag = false;
            boolean setDestDir = false;
            String[] stringArray = sa;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element;
                String sas = element = stringArray[i];
                if (appendFlag) {
                    sas = this.prependTestPath(sas);
                    appendFlag = false;
                } else if (appendFlags.contains(element)) {
                    appendFlag = true;
                }
                if (setDestDir) {
                    this.setDestDir(sas);
                    setDestDir = false;
                } else if (element.equals("-d")) {
                    setDestDir = true;
                }
                if (pathSep != ':' && sas.indexOf(58) >= 0) {
                    sas = SourceFileTest.replacePathSep(sas, pathSep);
                }
                sas = this.replaceEnvVariables(sas);
                args.add(sas);
            }
        }
        return args;
    }

    private static String replacePathSep(String sas, char pathSep) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < sas.length(); ++j) {
            if (sas.charAt(j) == '\\' && j + 1 < sas.length() && sas.charAt(j + 1) == ':') {
                ++j;
                sb.append(':');
                continue;
            }
            if (sas.charAt(j) == ':') {
                sb.append(pathSep);
                continue;
            }
            sb.append(sas.charAt(j));
        }
        return sb.toString();
    }

    private String replaceEnvVariables(String sas) {
        int start;
        while ((start = sas.indexOf(36)) >= 0) {
            int end;
            for (end = start + 1; end < sas.length() && (Character.isUnicodeIdentifierStart(sas.charAt(end)) || Character.isUnicodeIdentifierPart(sas.charAt(end))); ++end) {
            }
            String var = sas.substring(start + 1, end);
            String v = System.getenv(var);
            if (v == null && !this.undefinedEnvVars.contains(var)) {
                this.undefinedEnvVars.add(var);
                this.output.warning("environment variable $" + var + " undefined.");
                v = "";
            }
            sas = sas.substring(0, start) + v + sas.substring(end);
        }
        return sas;
    }

    protected String getExtensionClassname() {
        return this.extensionClassname;
    }

    protected void setExtensionClassname(String extClassname) {
        this.extensionClassname = extClassname;
    }

    protected String[] getExtraCmdLineArgs() {
        return this.extraArgs;
    }

    protected static String[] breakString(String s) {
        LinkedList<String> l = new LinkedList<String>();
        String token = "";
        char endChar = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (endChar != '\u0000' && c == endChar) {
                endChar = '\u0000';
                continue;
            }
            if (c == '\\') {
                c = s.charAt(++i);
                token = token + c;
                continue;
            }
            if (c == '\"' || c == '\'') {
                endChar = c;
                continue;
            }
            if (endChar == '\u0000' && Character.isWhitespace(c)) {
                if (token.length() > 0) {
                    l.add(token);
                }
                token = "";
                continue;
            }
            token = token + c;
        }
        if (token.length() > 0) {
            l.add(token);
        }
        return l.toArray(new String[l.size()]);
    }

    protected void setExtraCmdLineArgs(String args) {
        if (args != null) {
            this.extraArgs = SourceFileTest.breakString(args);
        }
    }

    protected String getAdditionalClasspath() {
        return Main.options.classpath;
    }

    protected void setDestDir(String dir) {
        this.destDir = dir;
    }

    protected String getDestDir() {
        return this.destDir;
    }

    protected String getSourceDir() {
        return this.getTestDir();
    }

    protected void setTestDir(String dir) {
        this.testDir = Main.options.testpath == null ? (dir == null ? null : dir) : (dir == null ? Main.options.testpath : Main.options.testpath + dir);
    }

    protected String getTestDir() {
        return this.testDir;
    }

    protected String prependTestPath(String filename) {
        String testpath = this.getTestDir();
        if (testpath != null) {
            if (filename != null) {
                return testpath + filename;
            }
            return testpath;
        }
        return filename;
    }
}

