/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import polyglot.pth.Options;
import polyglot.pth.OutputController;
import polyglot.pth.QuietOutputController;
import polyglot.pth.ScriptTestSuite;
import polyglot.pth.SilentOutputController;
import polyglot.pth.StdOutputController;
import polyglot.pth.VerboseOutputController;

public class Main {
    public static Options options;

    public static void main(String[] args) {
        new Main().start(args);
    }

    public void start(String[] args) {
        options = new Options();
        try {
            options.parseCommandLine(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        if (Main.options.inputFilenames.isEmpty()) {
            System.err.println("Need at least one script file.");
            System.exit(1);
        }
        OutputController outCtrl = this.createOutputController(options);
        for (String filename : Main.options.inputFilenames) {
            ScriptTestSuite t = new ScriptTestSuite(filename);
            t.setOutputController(outCtrl);
            if (Main.options.showResultsOnly) {
                outCtrl.displayTestSuiteResults(t.getName(), t);
                continue;
            }
            t.run();
        }
    }

    protected OutputController createOutputController(Options options) {
        switch (options.verbosity) {
            case 0: {
                return new SilentOutputController(System.out);
            }
            case 1: {
                return new QuietOutputController(System.out, false, true, false, false, false);
            }
            case 2: {
                return new QuietOutputController(System.out, false, true, false, false, true);
            }
            case 3: {
                return new QuietOutputController(System.out, true, true, false, false, true);
            }
            case 8: {
                return new VerboseOutputController(System.out, false);
            }
            case 9: {
                return new VerboseOutputController(System.out, true);
            }
        }
        return new StdOutputController(System.out);
    }
}

