/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.util.Date;
import polyglot.pth.OutputController;
import polyglot.pth.Test;
import polyglot.pth.TestResult;

public abstract class AbstractTest
implements Test {
    protected String name;
    protected String description;
    protected boolean success = false;
    protected boolean hasRun = false;
    protected String failureMessage = null;
    protected TestResult testResult;
    protected OutputController output;

    public AbstractTest(String name) {
        this.name = name;
    }

    @Override
    public void setOutputController(OutputController output) {
        this.output = output;
    }

    @Override
    public final boolean run() {
        this.preRun();
        this.success = this.runTest();
        this.hasRun = true;
        Date lastSuccess = null;
        if (this.getTestResult() != null) {
            lastSuccess = this.getTestResult().dateLastSuccess;
        }
        this.setTestResult(this.createTestResult(lastSuccess));
        this.postRun();
        return this.success();
    }

    protected abstract boolean runTest();

    protected void preRun() {
        this.output.startTest(this);
    }

    protected void postRun() {
        this.output.finishTest(this, null);
    }

    protected TestResult createTestResult(Date lastSuccess) {
        Date lastRun = new Date();
        if (this.success()) {
            lastSuccess = lastRun;
        }
        return new TestResult(this, lastRun, lastSuccess);
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public String getFailureMessage() {
        return this.failureMessage;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public TestResult getTestResult() {
        return this.testResult;
    }

    @Override
    public void setTestResult(TestResult tr) {
        this.testResult = tr;
    }
}

