/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.ast.DowngradeExpr;
import jif.extension.JifPreciseClassDel;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Instanceof;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public class PreciseClassChecker
extends DataFlow<DataFlowItem> {
    private FlowGraph.ExceptionEdgeKey EDGE_KEY_CLASS_CAST_EXC = null;

    public PreciseClassChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true);
    }

    public PreciseClassChecker(Job job) {
        this(job, job.extensionInfo().typeSystem(), job.extensionInfo().nodeFactory());
    }

    public NodeVisitor begin() {
        this.EDGE_KEY_CLASS_CAST_EXC = new FlowGraph.ExceptionEdgeKey((Type)this.typeSystem().ClassCastException());
        return super.begin();
    }

    public DataFlowItem createItem(FlowGraph<DataFlowItem> graph, Term n) {
        return new DataFlowItem();
    }

    protected DataFlowItem createInitialItem(FlowGraph<DataFlowItem> graph, Term node, boolean entry) {
        return new DataFlowItem();
    }

    protected Map<FlowGraph.EdgeKey, DataFlowItem> flow(List<DataFlowItem> inItems, List<FlowGraph.EdgeKey> inItemKeys, FlowGraph<DataFlowItem> graph, FlowGraph.Peer<DataFlowItem> peer) {
        return this.flowToBooleanFlow(inItems, inItemKeys, graph, peer);
    }

    public Map<FlowGraph.EdgeKey, DataFlowItem> flow(DataFlowItem trueItem, DataFlowItem falseItem, DataFlowItem otherItem, FlowGraph<DataFlowItem> graph, FlowGraph.Peer<DataFlowItem> peer) {
        DataFlowItem dfIn = (DataFlowItem)this.safeConfluence(trueItem, FlowGraph.EDGE_KEY_TRUE, falseItem, FlowGraph.EDGE_KEY_FALSE, otherItem, FlowGraph.EDGE_KEY_OTHER, peer, graph);
        if (peer.isEntry()) {
            return PreciseClassChecker.itemToMap((Object)((Object)dfIn), (Set)peer.succEdgeKeys());
        }
        Term n = peer.node();
        if (n instanceof Instanceof) {
            Instanceof io = (Instanceof)n;
            Expr e = io.expr();
            AccessPath ap = PreciseClassChecker.findAccessPathForExpr(e);
            if (ap != null) {
                Map<AccessPath, Set<Type>> trueBranch = this.addClass(dfIn.classTypes, ap, io.compareType().type());
                return PreciseClassChecker.itemsToMap((Object)((Object)new DataFlowItem(trueBranch)), (Object)((Object)dfIn), (Object)((Object)dfIn), (Set)peer.succEdgeKeys());
            }
        } else if (n instanceof Cast) {
            Cast cst = (Cast)n;
            Expr ex = cst.expr();
            AccessPath ap = PreciseClassChecker.findAccessPathForExpr(ex);
            if (ap != null) {
                Map m = PreciseClassChecker.itemToMap((Object)((Object)dfIn), (Set)peer.succEdgeKeys());
                for (Map.Entry entry : m.entrySet()) {
                    Map.Entry e = entry;
                    if (((FlowGraph.EdgeKey)e.getKey()).equals((Object)this.EDGE_KEY_CLASS_CAST_EXC)) continue;
                    DataFlowItem df = (DataFlowItem)((Object)e.getValue());
                    e.setValue(new DataFlowItem(this.addClass(df.classTypes, ap, cst.castType().type())));
                }
                return m;
            }
        } else {
            if (n instanceof LocalDecl) {
                LocalDecl x = (LocalDecl)n;
                Map<AccessPath, Set<Type>> m = this.killClasses(dfIn.classTypes, new AccessPathLocal(x.localInstance()));
                return PreciseClassChecker.itemToMap((Object)((Object)new DataFlowItem(m)), (Set)peer.succEdgeKeys());
            }
            if (n instanceof Assign) {
                Assign x = (Assign)n;
                AccessPath ap = PreciseClassChecker.findAccessPathForExpr(x.left());
                if (ap != null) {
                    Map<AccessPath, Set<Type>> m = this.killClasses(dfIn.classTypes, ap);
                    return PreciseClassChecker.itemToMap((Object)((Object)new DataFlowItem(m)), (Set)peer.succEdgeKeys());
                }
            } else {
                if (n instanceof Expr && ((Expr)n).type().isBoolean() && (n instanceof Binary || n instanceof Unary)) {
                    Map ret;
                    if (trueItem == null) {
                        trueItem = dfIn;
                    }
                    if (falseItem == null) {
                        falseItem = dfIn;
                    }
                    if ((ret = this.flowBooleanConditions(trueItem, falseItem, dfIn, graph, peer)) == null) {
                        ret = PreciseClassChecker.itemToMap((Object)((Object)dfIn), (Set)peer.succEdgeKeys());
                    }
                    return ret;
                }
                if (n instanceof DowngradeExpr && ((Expr)n).type().isBoolean()) {
                    if (trueItem == null) {
                        trueItem = dfIn;
                    }
                    if (falseItem == null) {
                        falseItem = dfIn;
                    }
                    return PreciseClassChecker.itemsToMap((Object)((Object)trueItem), (Object)((Object)falseItem), (Object)((Object)dfIn), (Set)peer.succEdgeKeys());
                }
            }
        }
        return PreciseClassChecker.itemToMap((Object)((Object)dfIn), (Set)peer.succEdgeKeys());
    }

    private Map<AccessPath, Set<Type>> killClasses(Map<AccessPath, Set<Type>> map, AccessPath ap) {
        boolean changed;
        HashMap<AccessPath, Set<Type>> m = new HashMap<AccessPath, Set<Type>>(map);
        boolean bl = changed = m.remove(ap) != null;
        if (ap instanceof AccessPathLocal) {
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                AccessPath key = (AccessPath)entry.getKey();
                if (!ap.equals(key.findRoot())) continue;
                iter.remove();
                changed = true;
            }
        }
        return changed ? m : map;
    }

    private Map<AccessPath, Set<Type>> addClass(Map<AccessPath, Set<Type>> map, AccessPath ap, Type type) {
        if (!type.isClass()) {
            return map;
        }
        HashMap<AccessPath, Set<Type>> m = new HashMap<AccessPath, Set<Type>>(map);
        LinkedHashSet<Object> s = (LinkedHashSet<Type>)m.get(ap);
        s = s == null ? new LinkedHashSet<Type>() : new LinkedHashSet(s);
        m.put(ap, s);
        s.add(type);
        return m;
    }

    protected DataFlowItem confluence(List<DataFlowItem> items, FlowGraph.Peer<DataFlowItem> peer, FlowGraph<DataFlowItem> graph) {
        return PreciseClassChecker.intersect(items);
    }

    private static DataFlowItem intersect(List<DataFlowItem> items) {
        Map<AccessPath, Set<Type>> smallest = null;
        for (int i = 0; i < items.size(); ++i) {
            Map<AccessPath, Set<Type>> candidate = items.get((int)i).classTypes;
            if (candidate.isEmpty()) {
                return new DataFlowItem(Collections.emptyMap());
            }
            if (smallest != null && smallest.size() <= candidate.size()) continue;
            smallest = candidate;
        }
        HashMap<AccessPath, Set<Type>> intersectMap = new HashMap<AccessPath, Set<Type>>(smallest);
        for (int i = 0; i < items.size(); ++i) {
            Map<AccessPath, Set<Type>> m = items.get((int)i).classTypes;
            Iterator iter = intersectMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                if (m.containsKey(e.getKey())) {
                    LinkedHashSet s = new LinkedHashSet((Collection)e.getValue());
                    Set<Type> t = m.get(e.getKey());
                    s.retainAll(t);
                    continue;
                }
                iter.remove();
            }
        }
        return new DataFlowItem(intersectMap);
    }

    protected void check(FlowGraph<DataFlowItem> graph, Term n, boolean entry, DataFlowItem inItem, Map<FlowGraph.EdgeKey, DataFlowItem> outItems) {
        if (n.del() instanceof JifPreciseClassDel) {
            DataFlowItem dfi = inItem;
            JifPreciseClassDel jpcd = (JifPreciseClassDel)n.del();
            AccessPath ap = PreciseClassChecker.findAccessPathForExpr(jpcd.getPreciseClassExpr());
            if (ap != null) {
                jpcd.setPreciseClass(dfi.classTypes.get(ap));
            }
        }
    }

    static AccessPath findAccessPathForExpr(Expr expr) {
        Field f;
        if (expr instanceof Special) {
            return new AccessPathThis();
        }
        if (expr instanceof Local) {
            return new AccessPathLocal(((Local)expr).localInstance());
        }
        if (expr instanceof Field && (f = (Field)expr).flags().isFinal()) {
            AccessPath target = null;
            if (f.target() instanceof Expr) {
                target = PreciseClassChecker.findAccessPathForExpr((Expr)f.target());
            } else if (f.target() instanceof TypeNode) {
                target = new AccessPathClass(((TypeNode)f.target()).type());
            }
            if (target == null) {
                return null;
            }
            return new AccessPathFinalField(target, f.fieldInstance());
        }
        if (expr instanceof DowngradeExpr) {
            DowngradeExpr de = (DowngradeExpr)expr;
            return PreciseClassChecker.findAccessPathForExpr(de.expr());
        }
        if (expr instanceof Cast) {
            Cast ce = (Cast)expr;
            return PreciseClassChecker.findAccessPathForExpr(ce.expr());
        }
        return null;
    }

    static class AccessPathClass
    extends AccessPath {
        final Type type;

        public AccessPathClass(Type type) {
            this.type = type;
        }

        @Override
        public AccessPath findRoot() {
            return this;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof AccessPathClass && ((AccessPathClass)o).type.equals(this.type);
        }

        public String toString() {
            return this.type.toString();
        }
    }

    static class AccessPathThis
    extends AccessPath {
        AccessPathThis() {
        }

        @Override
        public AccessPath findRoot() {
            return this;
        }

        public int hashCode() {
            return -45;
        }

        public boolean equals(Object o) {
            return o instanceof AccessPathThis;
        }

        public String toString() {
            return "this";
        }
    }

    static class AccessPathFinalField
    extends AccessPath {
        final AccessPath target;
        final FieldInstance fi;

        public AccessPathFinalField(AccessPath target, FieldInstance fi) {
            this.target = target;
            this.fi = fi;
        }

        @Override
        public AccessPath findRoot() {
            return this.target.findRoot();
        }

        public int hashCode() {
            return this.fi.hashCode() + this.target.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof AccessPathFinalField) {
                AccessPathFinalField that = (AccessPathFinalField)o;
                return that.fi.equals(this.fi) && that.target.equals(this.target);
            }
            return false;
        }

        public String toString() {
            return this.target + "." + this.fi.name();
        }
    }

    static class AccessPathLocal
    extends AccessPath {
        final LocalInstance li;

        public AccessPathLocal(LocalInstance li) {
            this.li = li;
        }

        @Override
        public AccessPath findRoot() {
            return this;
        }

        public int hashCode() {
            return this.li.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof AccessPathLocal && ((AccessPathLocal)o).li.equals(this.li);
        }

        public String toString() {
            return this.li.name();
        }
    }

    static abstract class AccessPath {
        AccessPath() {
        }

        public abstract AccessPath findRoot();
    }

    static class DataFlowItem
    extends DataFlow.Item {
        Map<AccessPath, Set<Type>> classTypes;

        DataFlowItem() {
            this.classTypes = new HashMap<AccessPath, Set<Type>>();
        }

        DataFlowItem(Map<AccessPath, Set<Type>> classTypes) {
            this.classTypes = classTypes;
        }

        DataFlowItem(DataFlowItem d) {
            this.classTypes = new HashMap<AccessPath, Set<Type>>(d.classTypes);
        }

        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return this.classTypes == ((DataFlowItem)((Object)o)).classTypes || this.classTypes.equals(((DataFlowItem)((Object)o)).classTypes);
            }
            return false;
        }

        public int hashCode() {
            return this.classTypes.hashCode();
        }

        public String toString() {
            return "[" + this.classTypes + "]";
        }
    }
}

