/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.ast.DowngradeExpr;
import jif.ast.LabelExpr;
import jif.ast.PrincipalNode;
import jif.extension.JifArrayAccessDel;
import jif.extension.JifCallDel;
import jif.extension.JifConstructorCallDel;
import jif.extension.JifFieldDel;
import jif.extension.JifFormalDel;
import jif.extension.JifNewDel;
import jif.extension.JifThrowDel;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.Param;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathClass;
import jif.types.label.AccessPathField;
import jif.types.label.AccessPathLocal;
import jif.types.label.AccessPathThis;
import jif.types.label.Label;
import jif.types.principal.Principal;
import jif.visit.PreciseClassChecker;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Call;
import polyglot.ast.Cast;
import polyglot.ast.Conditional;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.Formal;
import polyglot.ast.Instanceof;
import polyglot.ast.Lit;
import polyglot.ast.LocalDecl;
import polyglot.ast.New;
import polyglot.ast.NewArray;
import polyglot.ast.NodeFactory;
import polyglot.ast.NullLit;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.Throw;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public class NotNullChecker
extends DataFlow<DataFlowItem> {
    private FlowGraph.ExceptionEdgeKey EDGE_KEY_NPE = null;

    public NotNullChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true);
    }

    public NotNullChecker(Job job) {
        this(job, job.extensionInfo().typeSystem(), job.extensionInfo().nodeFactory());
    }

    public NodeVisitor begin() {
        this.EDGE_KEY_NPE = new FlowGraph.ExceptionEdgeKey((Type)this.typeSystem().NullPointerException());
        return super.begin();
    }

    public DataFlowItem createItem(FlowGraph<DataFlowItem> graph, Term n) {
        return new DataFlowItem();
    }

    protected DataFlowItem createInitialItem(FlowGraph<DataFlowItem> graph, Term node, boolean entry) {
        return new DataFlowItem();
    }

    protected Map<FlowGraph.EdgeKey, DataFlowItem> flow(List<DataFlowItem> inItems, List<FlowGraph.EdgeKey> inItemKeys, FlowGraph<DataFlowItem> graph, FlowGraph.Peer<DataFlowItem> peer) {
        return this.flowToBooleanFlow(inItems, inItemKeys, graph, peer);
    }

    public Map<FlowGraph.EdgeKey, DataFlowItem> flow(DataFlowItem trueItem, DataFlowItem falseItem, DataFlowItem otherItem, FlowGraph<DataFlowItem> graph, FlowGraph.Peer<DataFlowItem> peer) {
        LocalDecl x;
        DataFlowItem dfIn = (DataFlowItem)this.safeConfluence(trueItem, FlowGraph.EDGE_KEY_TRUE, falseItem, FlowGraph.EDGE_KEY_FALSE, otherItem, FlowGraph.EDGE_KEY_OTHER, peer, graph);
        if (peer.isEntry()) {
            return NotNullChecker.itemToMap((Object)((Object)dfIn), (Set)peer.succEdgeKeys());
        }
        Term n = peer.node();
        if (n instanceof LocalDecl) {
            x = (LocalDecl)n;
            if (dfIn.exprIsNotNull(x.init()) || dfIn.resultIsNotNull) {
                Set<PreciseClassChecker.AccessPath> s = NotNullChecker.addNotNull(dfIn.notNullAccessPaths, new PreciseClassChecker.AccessPathLocal(x.localInstance()));
                DataFlowItem newItem = new DataFlowItem(s, false);
                return this.checkNPE(NotNullChecker.itemToMap((Object)((Object)newItem), (Set)peer.succEdgeKeys()), n);
            }
        } else if (n instanceof Formal) {
            Formal f = (Formal)n;
            JifFormalDel d = (JifFormalDel)n.del();
            if (d.isCatchFormal()) {
                Set<PreciseClassChecker.AccessPath> s = NotNullChecker.addNotNull(dfIn.notNullAccessPaths, new PreciseClassChecker.AccessPathLocal(f.localInstance()));
                DataFlowItem newItem = new DataFlowItem(s, false);
                return this.checkNPE(NotNullChecker.itemToMap((Object)((Object)newItem), (Set)peer.succEdgeKeys()), n);
            }
        } else if (n instanceof Instanceof) {
            Instanceof io = (Instanceof)n;
            PreciseClassChecker.AccessPath ap = PreciseClassChecker.findAccessPathForExpr(io.expr());
            if (ap != null) {
                Set<PreciseClassChecker.AccessPath> trueBranch = NotNullChecker.addNotNull(dfIn.notNullAccessPaths, ap);
                return NotNullChecker.itemsToMap((Object)((Object)new DataFlowItem(trueBranch, false)), (Object)((Object)dfIn), (Object)((Object)dfIn), (Set)peer.succEdgeKeys());
            }
        } else if (n instanceof Assign) {
            x = (Assign)n;
            PreciseClassChecker.AccessPath ap = PreciseClassChecker.findAccessPathForExpr(x.left());
            if (ap != null && x.operator() == Assign.ASSIGN) {
                Set<PreciseClassChecker.AccessPath> s = NotNullChecker.killAccessPath(dfIn.notNullAccessPaths, ap);
                boolean resultIsNotNull = false;
                if (dfIn.exprIsNotNull(x.right()) || dfIn.resultIsNotNull) {
                    s = NotNullChecker.addNotNull(s, ap);
                    resultIsNotNull = true;
                }
                DataFlowItem newItem = new DataFlowItem(s, resultIsNotNull);
                return this.checkNPE(NotNullChecker.itemToMap((Object)((Object)newItem), (Set)peer.succEdgeKeys()), n);
            }
        } else if (n instanceof Binary && (Binary.EQ.equals((Object)((Binary)n).operator()) || Binary.NE.equals((Object)((Binary)n).operator()))) {
            Binary b = (Binary)n;
            if (b.left() instanceof NullLit || b.right() instanceof NullLit) {
                Expr e = b.left() instanceof NullLit ? b.right() : b.left();
                Map<FlowGraph.EdgeKey, DataFlowItem> m = NotNullChecker.comparisonToNull(e, Binary.EQ.equals((Object)b.operator()), dfIn, peer.succEdgeKeys());
                return this.checkNPE(m, n);
            }
        } else {
            if (n instanceof Expr && ((Expr)n).type().isBoolean() && (n instanceof Binary || n instanceof Unary)) {
                Map<FlowGraph.EdgeKey, DataFlowItem> ret;
                if (trueItem == null) {
                    trueItem = dfIn;
                }
                if (falseItem == null) {
                    falseItem = dfIn;
                }
                if ((ret = this.flowBooleanConditions(trueItem, falseItem, dfIn, graph, peer)) == null) {
                    ret = this.itemToMap(false, dfIn, peer.succEdgeKeys());
                }
                return this.checkNPE(ret, n);
            }
            if (n instanceof DowngradeExpr && ((Expr)n).type().isBoolean()) {
                dfIn = new DataFlowItem(dfIn.notNullAccessPaths, false);
                if (trueItem == null) {
                    trueItem = dfIn;
                }
                if (falseItem == null) {
                    falseItem = dfIn;
                }
                Map ret = NotNullChecker.itemsToMap((Object)((Object)trueItem), (Object)((Object)falseItem), (Object)((Object)dfIn), (Set)peer.succEdgeKeys());
                return this.checkNPE(ret, n);
            }
        }
        boolean resultIsNotNull = false;
        if (n instanceof Conditional && dfIn.resultIsNotNull && ((Conditional)n).type().isReference() || n instanceof Expr && dfIn.exprIsNotNull((Expr)n)) {
            resultIsNotNull = true;
        }
        return this.checkNPE(this.itemToMap(resultIsNotNull, dfIn, peer.succEdgeKeys()), n);
    }

    private Map<FlowGraph.EdgeKey, DataFlowItem> itemToMap(boolean resultIsNotNull, DataFlowItem dfIn, Set<FlowGraph.EdgeKey> succEdgeKeys) {
        if (dfIn.resultIsNotNull != resultIsNotNull) {
            dfIn = new DataFlowItem(dfIn.notNullAccessPaths, resultIsNotNull);
        }
        return NotNullChecker.itemToMap((Object)((Object)dfIn), succEdgeKeys);
    }

    private Map<FlowGraph.EdgeKey, DataFlowItem> checkNPE(Map<FlowGraph.EdgeKey, DataFlowItem> m, Term node) {
        if (node instanceof Field || node instanceof Call) {
            Receiver r = node instanceof Field ? ((Field)node).target() : ((Call)node).target();
            PreciseClassChecker.AccessPath ap = null;
            if (r instanceof Expr) {
                ap = PreciseClassChecker.findAccessPathForExpr((Expr)r);
            }
            if (ap != null && m.get(this.EDGE_KEY_NPE) != null) {
                HashMap<FlowGraph.EdgeKey, DataFlowItem> newMap = new HashMap<FlowGraph.EdgeKey, DataFlowItem>();
                for (Map.Entry<FlowGraph.EdgeKey, DataFlowItem> e : m.entrySet()) {
                    if (e.getKey().equals((Object)this.EDGE_KEY_NPE)) {
                        newMap.put(e.getKey(), e.getValue());
                        continue;
                    }
                    DataFlowItem dfi = e.getValue();
                    if (dfi.notNullAccessPaths.contains(ap)) {
                        newMap.put(e.getKey(), dfi);
                        continue;
                    }
                    Set<PreciseClassChecker.AccessPath> s = NotNullChecker.addNotNull(dfi.notNullAccessPaths, ap);
                    newMap.put(e.getKey(), new DataFlowItem(s, false));
                }
                return newMap;
            }
        }
        return m;
    }

    private static Map<FlowGraph.EdgeKey, DataFlowItem> comparisonToNull(Expr expr, boolean equalsEquals, DataFlowItem in, Set<FlowGraph.EdgeKey> edgeKeys) {
        PreciseClassChecker.AccessPath ap = PreciseClassChecker.findAccessPathForExpr(expr);
        if (ap != null) {
            Set<PreciseClassChecker.AccessPath> sEq = NotNullChecker.killAccessPath(in.notNullAccessPaths, ap);
            Set<PreciseClassChecker.AccessPath> sNeq = NotNullChecker.addNotNull(in.notNullAccessPaths, ap);
            if (equalsEquals) {
                return NotNullChecker.itemsToMap((Object)((Object)new DataFlowItem(sEq, false)), (Object)((Object)new DataFlowItem(sNeq, false)), (Object)((Object)in), edgeKeys);
            }
            return NotNullChecker.itemsToMap((Object)((Object)new DataFlowItem(sNeq, false)), (Object)((Object)new DataFlowItem(sEq, false)), (Object)((Object)in), edgeKeys);
        }
        return NotNullChecker.itemToMap((Object)((Object)in), edgeKeys);
    }

    private static Set<PreciseClassChecker.AccessPath> killAccessPath(Set<PreciseClassChecker.AccessPath> paths, PreciseClassChecker.AccessPath ap) {
        LinkedHashSet<PreciseClassChecker.AccessPath> p = new LinkedHashSet<PreciseClassChecker.AccessPath>(paths);
        boolean changed = p.remove(ap);
        if (ap instanceof PreciseClassChecker.AccessPathLocal) {
            Iterator iter = p.iterator();
            while (iter.hasNext()) {
                PreciseClassChecker.AccessPath v = (PreciseClassChecker.AccessPath)iter.next();
                if (!ap.equals(v.findRoot())) continue;
                iter.remove();
                changed = true;
            }
        }
        return changed ? p : paths;
    }

    private static Set<PreciseClassChecker.AccessPath> addNotNull(Set<PreciseClassChecker.AccessPath> notNullAccessPaths, PreciseClassChecker.AccessPath ap) {
        LinkedHashSet<PreciseClassChecker.AccessPath> s = new LinkedHashSet<PreciseClassChecker.AccessPath>(notNullAccessPaths);
        s.add(ap);
        return s;
    }

    protected DataFlowItem confluence(List<DataFlowItem> items, FlowGraph.Peer<DataFlowItem> peer, FlowGraph<DataFlowItem> graph) {
        return NotNullChecker.intersect(items);
    }

    private static DataFlowItem intersect(List<DataFlowItem> items) {
        Set<PreciseClassChecker.AccessPath> intersectSet = null;
        boolean resultIsNotNull = true;
        for (int i = 0; i < items.size(); ++i) {
            DataFlowItem dfi = items.get(i);
            Set<PreciseClassChecker.AccessPath> m = dfi.notNullAccessPaths;
            if (intersectSet == null) {
                intersectSet = new LinkedHashSet<PreciseClassChecker.AccessPath>(m);
            } else {
                intersectSet.retainAll(m);
            }
            resultIsNotNull = resultIsNotNull && dfi.resultIsNotNull;
        }
        if (intersectSet == null) {
            intersectSet = Collections.emptySet();
        }
        return new DataFlowItem(intersectSet, resultIsNotNull);
    }

    protected void check(FlowGraph<DataFlowItem> graph, Term n, boolean entry, DataFlowItem inItem, Map<FlowGraph.EdgeKey, DataFlowItem> outItems) {
        if (entry) {
            return;
        }
        if (n instanceof Assign) {
            if (n instanceof FieldAssign) {
                this.checkField((Field)((Assign)n).left(), inItem);
            } else if (n instanceof ArrayAccessAssign) {
                this.checkArrayAccess((ArrayAccess)((Assign)n).left(), inItem);
            }
        } else if (n instanceof Field) {
            this.checkField((Field)n, inItem);
        } else if (n instanceof Call) {
            Call c = (Call)n;
            Receiver r = c.target();
            this.checkReceiver(r, n, inItem);
            this.checkType((Type)c.methodInstance().container(), inItem);
        } else if (n instanceof Throw) {
            Throw t = (Throw)n;
            if (inItem != null && inItem.exprIsNotNull(t.expr()) || inItem == null && DataFlowItem.exprIsNotNullStatic(t.expr())) {
                ((JifThrowDel)t.del()).setThrownIsNeverNull();
            }
        } else if (n instanceof ArrayAccess) {
            this.checkArrayAccess((ArrayAccess)n, inItem);
        } else if (n instanceof LabelExpr) {
            this.checkLabelExpr((LabelExpr)n, inItem);
        } else if (n instanceof PrincipalNode) {
            this.checkPrincipalNode((PrincipalNode)n, inItem);
        } else if (n instanceof Cast) {
            this.checkTypeNode(((Cast)n).castType(), inItem);
        } else if (n instanceof Instanceof) {
            this.checkTypeNode(((Instanceof)n).compareType(), inItem);
        } else if (n instanceof New) {
            this.checkQualifier((New)n, inItem);
            this.checkTypeNode(((New)n).objectType(), inItem);
        } else if (n instanceof ConstructorCall) {
            this.checkQualifier((ConstructorCall)n, inItem);
        }
    }

    private void checkQualifier(ConstructorCall n, DataFlowItem inItem) {
        boolean neverNull = false;
        if (inItem != null && inItem.exprIsNotNull(n.qualifier()) || inItem == null && DataFlowItem.exprIsNotNullStatic(n.qualifier())) {
            neverNull = true;
        }
        ((JifConstructorCallDel)n.del()).setQualifierIsNeverNull(neverNull);
    }

    private void checkQualifier(New n, DataFlowItem inItem) {
        boolean neverNull = false;
        if (inItem != null && inItem.exprIsNotNull(n.qualifier()) || inItem == null && DataFlowItem.exprIsNotNullStatic(n.qualifier())) {
            neverNull = true;
        }
        ((JifNewDel)n.del()).setQualifierIsNeverNull(neverNull);
    }

    private void checkField(Field f, DataFlowItem inItem) {
        this.checkReceiver(f.target(), (Term)f, inItem);
    }

    private void checkReceiver(Receiver r, Term n, DataFlowItem inItem) {
        if (r instanceof Expr) {
            Expr e = (Expr)r;
            boolean neverNull = false;
            if (inItem != null && inItem.exprIsNotNull(e) || inItem == null && DataFlowItem.exprIsNotNullStatic(e)) {
                neverNull = true;
            }
            if (n instanceof Field) {
                ((JifFieldDel)n.del()).setTargetIsNeverNull(neverNull);
            } else {
                ((JifCallDel)n.del()).setTargetIsNeverNull(neverNull);
            }
        }
    }

    private void checkArrayAccess(ArrayAccess a, DataFlowItem inItem) {
        if (inItem.exprIsNotNull(a.array())) {
            ((JifArrayAccessDel)a.del()).setArrayIsNeverNull();
        }
    }

    private void checkLabelExpr(LabelExpr e, DataFlowItem inItem) {
        Label l = e.label().label();
        LabelNotNullSubst lnns = new LabelNotNullSubst(inItem);
        try {
            l.subst(lnns);
        }
        catch (SemanticException se) {
            throw new InternalCompilerError("Unexpected SemanticException", (Throwable)se);
        }
    }

    private void checkPrincipalNode(PrincipalNode pn, DataFlowItem inItem) {
        LabelNotNullSubst lnns = new LabelNotNullSubst(inItem);
        try {
            pn.principal().subst(lnns);
        }
        catch (SemanticException se) {
            throw new InternalCompilerError("Unexpected SemanticException", (Throwable)se);
        }
    }

    private void checkTypeNode(TypeNode tn, DataFlowItem inItem) {
        this.checkType(tn.type(), inItem);
    }

    private void checkType(Type t, DataFlowItem inItem) {
        if (t instanceof JifSubstType && ((JifTypeSystem)this.ts).isParamsRuntimeRep(t)) {
            LabelNotNullSubst lnns = new LabelNotNullSubst(inItem);
            JifSubstType jst = (JifSubstType)t;
            for (Param arg : jst.actuals()) {
                if (arg instanceof Label) {
                    Label L = (Label)arg;
                    try {
                        L.subst(lnns);
                        continue;
                    }
                    catch (SemanticException se) {
                        throw new InternalCompilerError("Unexpected SemanticException", (Throwable)se);
                    }
                }
                if (arg instanceof Principal) {
                    Principal p = (Principal)arg;
                    try {
                        p.subst(lnns);
                        continue;
                    }
                    catch (SemanticException se) {
                        throw new InternalCompilerError("Unexpected SemanticException", (Throwable)se);
                    }
                }
                throw new InternalCompilerError("Unexpected type for entry: " + arg.getClass().getName());
            }
        }
    }

    private class LabelNotNullSubst
    extends LabelSubstitution {
        DataFlowItem inItem;

        LabelNotNullSubst(DataFlowItem inItem) {
            this.inItem = inItem;
        }

        @Override
        public AccessPath substAccessPath(AccessPath ap) {
            this.checkPath(ap);
            return ap;
        }

        private void checkPath(AccessPath p) {
            PreciseClassChecker.AccessPath ap;
            while (p instanceof AccessPathField) {
                ap = this.labelAccessPathToDFAccessPath(p);
                AccessPathField apf = (AccessPathField)p;
                p = apf.path();
                if (ap == null || !this.inItem.notNullAccessPaths.contains(ap)) continue;
                apf.setIsNeverNull();
            }
            if (p instanceof AccessPathLocal) {
                ap = this.labelAccessPathToDFAccessPath(p);
                AccessPathLocal apl = (AccessPathLocal)p;
                if (this.inItem.notNullAccessPaths.contains(ap)) {
                    apl.setIsNeverNull();
                }
            }
        }

        private PreciseClassChecker.AccessPath labelAccessPathToDFAccessPath(AccessPath p) {
            AccessPathField apf;
            PreciseClassChecker.AccessPath target;
            if (p instanceof AccessPathLocal) {
                return new PreciseClassChecker.AccessPathLocal(((AccessPathLocal)p).localInstance());
            }
            if (p instanceof AccessPathThis) {
                return new PreciseClassChecker.AccessPathThis();
            }
            if (p instanceof AccessPathClass) {
                return new PreciseClassChecker.AccessPathClass(((AccessPathClass)p).type());
            }
            if (p instanceof AccessPathField && (target = this.labelAccessPathToDFAccessPath((apf = (AccessPathField)p).path())) != null && apf.fieldInstance().flags().isFinal()) {
                return new PreciseClassChecker.AccessPathFinalField(target, apf.fieldInstance());
            }
            return null;
        }
    }

    static class DataFlowItem
    extends DataFlow.Item {
        Set<PreciseClassChecker.AccessPath> notNullAccessPaths;
        boolean resultIsNotNull;

        DataFlowItem() {
            this.notNullAccessPaths = new LinkedHashSet<PreciseClassChecker.AccessPath>();
            this.resultIsNotNull = false;
        }

        DataFlowItem(Set<PreciseClassChecker.AccessPath> notNullAccessPaths, boolean resultIsNotNull) {
            this.notNullAccessPaths = notNullAccessPaths;
            this.resultIsNotNull = resultIsNotNull;
        }

        DataFlowItem(DataFlowItem d) {
            this.notNullAccessPaths = new LinkedHashSet<PreciseClassChecker.AccessPath>(d.notNullAccessPaths);
        }

        static boolean exprIsNotNullStatic(Expr e) {
            return e instanceof New || e instanceof NewArray || e instanceof ArrayInit || e instanceof Special || e instanceof Lit && !(e instanceof NullLit) || e instanceof Binary && ((Binary)e).type().typeSystem().String().equals(((Binary)e).type()) || e instanceof Cast && DataFlowItem.exprIsNotNullStatic(((Cast)e).expr()) || e instanceof DowngradeExpr && DataFlowItem.exprIsNotNullStatic(((DowngradeExpr)e).expr()) || e instanceof Conditional && DataFlowItem.exprIsNotNullStatic(((Conditional)e).consequent()) && DataFlowItem.exprIsNotNullStatic(((Conditional)e).alternative());
        }

        boolean exprIsNotNull(Expr e) {
            PreciseClassChecker.AccessPath ap = PreciseClassChecker.findAccessPathForExpr(e);
            return DataFlowItem.exprIsNotNullStatic(e) || ap != null && this.notNullAccessPaths.contains(ap) || e instanceof Cast && this.exprIsNotNull(((Cast)e).expr()) || e instanceof DowngradeExpr && this.exprIsNotNull(((DowngradeExpr)e).expr()) || e instanceof Conditional && DataFlowItem.exprIsNotNullStatic(((Conditional)e).consequent()) && DataFlowItem.exprIsNotNullStatic(((Conditional)e).alternative());
        }

        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return this.notNullAccessPaths == ((DataFlowItem)((Object)o)).notNullAccessPaths || this.notNullAccessPaths.equals(((DataFlowItem)((Object)o)).notNullAccessPaths);
            }
            return false;
        }

        public int hashCode() {
            return this.notNullAccessPaths.hashCode();
        }

        public String toString() {
            return "[nn access paths: " + this.notNullAccessPaths + "]";
        }
    }
}

