/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import java.util.ArrayList;
import java.util.List;
import jif.ast.JifConstructorDecl;
import polyglot.ast.Block;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Expr;
import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Flags;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class NativeConstructorAdder
extends NodeVisitor {
    private final NodeFactory nf;

    public NativeConstructorAdder(NodeFactory nf) {
        this.nf = nf;
    }

    public Node override(Node n) {
        if (n instanceof JifConstructorDecl) {
            JifConstructorDecl decl = (JifConstructorDecl)n;
            ClassType ct = decl.constructorInstance().container().toClass();
            if (decl.body() == null) {
                ConstructorCall dummy = this.dummyCall(ct);
                Block superCall = this.nf.Block(Position.compilerGenerated(), new Stmt[]{dummy});
                Flags flags = decl.constructorInstance().flags().clearNative();
                decl.constructorInstance().setFlags(flags);
                return ((JifConstructorDecl)decl.body(superCall)).flags(flags);
            }
            return decl;
        }
        return null;
    }

    private ConstructorCall dummyCall(ClassType ct) {
        ClassType sup = ct.superType().toClass();
        List cxs = sup.constructors();
        ConstructorInstance ci = cxs.isEmpty() ? ct.typeSystem().defaultConstructor(Position.compilerGenerated(), sup) : (ConstructorInstance)cxs.get(0);
        ArrayList<Expr> args = new ArrayList<Expr>();
        for (Type t : ci.formalTypes()) {
            args.add(this.dummyValue(t));
        }
        return this.nf.ConstructorCall(ct.position(), ConstructorCall.SUPER, args).constructorInstance(ci);
    }

    private Expr dummyValue(Type t) {
        Object e = null;
        e = t.isNumeric() ? this.nf.IntLit(Position.compilerGenerated(), IntLit.INT, 0L) : (t.isBoolean() ? this.nf.BooleanLit(Position.compilerGenerated(), false) : this.nf.NullLit(Position.compilerGenerated()));
        return e.type(t);
    }
}

