/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import java.util.ArrayList;
import java.util.List;
import jif.ast.JifConstructorDecl;
import jif.ast.JifMethodDecl;
import jif.ast.LabelNode;
import jif.types.ActsForConstraint;
import jif.types.ActsForParam;
import jif.types.Assertion;
import jif.types.AuthConstraint;
import jif.types.AutoEndorseConstraint;
import jif.types.CallerConstraint;
import jif.types.JifConstructorInstance;
import jif.types.JifFieldInstance;
import jif.types.JifLocalInstance;
import jif.types.JifMethodInstance;
import jif.types.JifProcedureInstance;
import jif.types.LabelLeAssertion;
import jif.types.LabelSubstitution;
import jif.types.TypeSubstitutor;
import jif.types.label.Label;
import jif.types.principal.Principal;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.TypeNode;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.visit.NodeVisitor;

public class LabelSubstitutionVisitor
extends NodeVisitor {
    private boolean skipBody;
    private LabelSubstitution substitution;
    private TypeSubstitutor typeSubstitutor;

    public LabelSubstitutionVisitor(LabelSubstitution substitution, boolean skipBody) {
        this(substitution, new TypeSubstitutor(substitution), skipBody);
    }

    public LabelSubstitutionVisitor(LabelSubstitution substitution, TypeSubstitutor typeSubst, boolean skipBody) {
        this.skipBody = skipBody;
        this.substitution = substitution;
        this.typeSubstitutor = typeSubst;
    }

    public Node override(Node n) {
        if (this.skipBody && n instanceof Block) {
            return n;
        }
        return null;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        try {
            if (n instanceof TypeNode) {
                TypeNode c = (TypeNode)n;
                c = this.rewriteTypeNode(c);
                return c;
            }
            if (n instanceof Expr) {
                Expr e = (Expr)n;
                if ((e = this.rewriteExpr(e)) instanceof Local) {
                    Local lc = (Local)e;
                    LocalInstance li = lc.localInstance();
                    Type t = this.rewriteType(li.type());
                    li.setType(t);
                    return lc;
                }
                return e;
            }
            if (n instanceof LabelNode) {
                LabelNode ln = (LabelNode)n;
                Label l = this.rewriteLabel(ln.label());
                ln = ln.label(l);
                return ln;
            }
            if (n instanceof Formal) {
                Formal fn = (Formal)n;
                JifLocalInstance li = (JifLocalInstance)fn.localInstance();
                Type t = this.rewriteType(li.type());
                li.setType(t);
                li.setLabel(this.rewriteLabel(li.label()));
                return fn;
            }
            if (n instanceof LocalDecl) {
                LocalDecl ld = (LocalDecl)n;
                JifLocalInstance li = (JifLocalInstance)ld.localInstance();
                Type t = this.rewriteType(li.type());
                li.setType(t);
                li.setLabel(this.rewriteLabel(li.label()));
                return ld;
            }
            if (n instanceof FieldDecl) {
                FieldDecl fd = (FieldDecl)n;
                JifFieldInstance fi = (JifFieldInstance)fd.fieldInstance();
                this.rewriteFieldInstance(fi);
                return fd;
            }
            if (n instanceof ProcedureDecl) {
                ProcedureDecl md = (ProcedureDecl)n;
                JifProcedureInstance mi = (JifProcedureInstance)md.procedureInstance();
                mi.setReturnLabel(this.rewriteLabel(mi.returnLabel()), mi.isDefaultReturnLabel());
                mi.setPCBound(this.rewriteLabel(mi.pcBound()), mi.isDefaultPCBound());
                ArrayList<Type> throwTypes = new ArrayList<Type>(mi.throwTypes());
                for (int i = 0; i < throwTypes.size(); ++i) {
                    throwTypes.set(i, this.rewriteType((Type)throwTypes.get(i)));
                }
                ArrayList<Type> formalTypes = new ArrayList<Type>(mi.formalTypes());
                for (int i = 0; i < formalTypes.size(); ++i) {
                    formalTypes.set(i, this.rewriteType((Type)formalTypes.get(i)));
                }
                ArrayList<Assertion> constraints = new ArrayList<Assertion>(mi.constraints().size());
                for (Assertion constraint : mi.constraints()) {
                    constraints.add(this.rewriteConstraint(constraint));
                }
                if (mi instanceof JifMethodInstance) {
                    JifMethodInstance jmi = (JifMethodInstance)mi;
                    jmi.setReturnType(this.rewriteType(jmi.returnType()));
                    jmi.setThrowTypes(throwTypes);
                    jmi.setFormalTypes(formalTypes);
                    jmi.setConstraints(constraints);
                    md = ((JifMethodDecl)md).methodInstance(jmi);
                } else if (mi instanceof JifConstructorInstance) {
                    JifConstructorInstance jci = (JifConstructorInstance)mi;
                    jci.setThrowTypes(throwTypes);
                    jci.setFormalTypes(formalTypes);
                    jci.setConstraints(constraints);
                    md = ((JifConstructorDecl)md).constructorInstance(jci);
                }
                return md;
            }
            return n;
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Unexpected SemanticException thrown", (Throwable)e);
        }
    }

    public TypeNode rewriteTypeNode(TypeNode tn) throws SemanticException {
        Type t = tn.type();
        return tn.type(this.rewriteType(t));
    }

    public Expr rewriteExpr(Expr e) throws SemanticException {
        Type t = e.type();
        return e.type(this.rewriteType(t));
    }

    private Type rewriteType(Type t) throws SemanticException {
        return this.typeSubstitutor.rewriteType(t);
    }

    protected <P extends ActsForParam> P rewriteActsForParam(P param) throws SemanticException {
        if (param == null) {
            return param;
        }
        ActsForParam result = param.subst(this.substitution).simplify();
        return (P)result;
    }

    protected Label rewriteLabel(Label L) throws SemanticException {
        return this.rewriteActsForParam(L);
    }

    protected Principal rewritePrincipal(Principal p) throws SemanticException {
        return this.rewriteActsForParam(p);
    }

    protected List<Principal> rewritePrincipals(List<Principal> principals) throws SemanticException {
        ArrayList<Principal> result = new ArrayList<Principal>(principals.size());
        for (Principal p : principals) {
            result.add(this.rewritePrincipal(p));
        }
        return result;
    }

    protected void rewriteFieldInstance(JifFieldInstance fi) throws SemanticException {
        fi.setType(this.rewriteType(fi.type()));
        fi.setLabel(this.rewriteLabel(fi.label()));
    }

    protected <Actor extends ActsForParam, Granter extends ActsForParam> ActsForConstraint<Actor, Granter> rewriteActsForConstraint(ActsForConstraint<Actor, Granter> afc) throws SemanticException {
        Actor actor = this.rewriteActsForParam((ActsForParam)afc.actor());
        Granter granter = this.rewriteActsForParam((ActsForParam)afc.granter());
        return afc.actor(actor).granter(granter);
    }

    protected Assertion rewriteConstraint(Assertion c) throws SemanticException {
        if (c instanceof ActsForConstraint) {
            return this.rewriteActsForConstraint((ActsForConstraint)c);
        }
        if (c instanceof AuthConstraint) {
            AuthConstraint ac = (AuthConstraint)c;
            return ac.principals(this.rewritePrincipals(ac.principals()));
        }
        if (c instanceof AutoEndorseConstraint) {
            AutoEndorseConstraint aec = (AutoEndorseConstraint)c;
            return aec.endorseTo(this.rewriteLabel(aec.endorseTo()));
        }
        if (c instanceof CallerConstraint) {
            CallerConstraint cc = (CallerConstraint)c;
            return cc.principals(this.rewritePrincipals(cc.principals()));
        }
        if (c instanceof LabelLeAssertion) {
            LabelLeAssertion lla = (LabelLeAssertion)c;
            Label lhs = this.rewriteLabel(lla.lhs());
            Label rhs = this.rewriteLabel(lla.rhs());
            return lla.lhs(lhs).rhs(rhs);
        }
        throw new InternalCompilerError("Unexpected subclass of Assertion: " + c.getClass());
    }
}

