/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import java.util.Map;
import java.util.Set;
import jif.types.JifClassType;
import jif.types.JifTypeSystem;
import jif.types.SemanticDetailedException;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.visit.DefiniteAssignmentChecker;
import polyglot.visit.FlowGraph;

public class JifInitChecker
extends DefiniteAssignmentChecker {
    public JifInitChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    protected void checkOther(FlowGraph<DefiniteAssignmentChecker.FlowItem> graph, Node n, DefiniteAssignmentChecker.FlowItem dfIn) throws SemanticException {
        block4: {
            ConstructorCall cc;
            block3: {
                if (!(n instanceof TypeNode)) break block3;
                TypeNode tn = (TypeNode)n;
                Type t = tn.type();
                if (!(t instanceof JifClassType)) break block4;
                JifTypeSystem ts = (JifTypeSystem)t.typeSystem();
                Set<LocalInstance> lis = ts.labelTypeCheckUtil().localInstancesUsed((JifClassType)t);
                for (LocalInstance li : lis) {
                    this.checkLocalInstanceInit(li, dfIn, tn.position());
                }
                break block4;
            }
            if (n instanceof ConstructorCall && (cc = (ConstructorCall)n).kind() == ConstructorCall.SUPER && this.superClassCouldAccessFinals(this.currCBI.currClass)) {
                for (Map.Entry e : dfIn.assignmentStatus.entrySet()) {
                    if (!(e.getKey() instanceof FieldInstance) || !((FieldInstance)e.getKey()).flags().isFinal() || ((FieldInstance)e.getKey()).flags().isStatic()) continue;
                    FieldInstance fi = (FieldInstance)e.getKey();
                    DefiniteAssignmentChecker.AssignmentStatus initCount = (DefiniteAssignmentChecker.AssignmentStatus)e.getValue();
                    if (initCount.definitelyAssigned) continue;
                    throw new SemanticDetailedException("Final field \"" + fi.name() + "\" must be initialized before " + "calling the superclass constructor.", "All final fields of a class must be initialized before the superclass constructor is called, to prevent ancestor classes from reading uninitialized final fields. The final field \"" + fi.name() + "\" needs to " + "be initialized before the superclass " + "constructor call.", cc.position());
                }
            }
        }
    }

    protected boolean superClassCouldAccessFinals(ClassType ct) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        if (ts.isSignature((Type)ct)) {
            return false;
        }
        return ts.isSignature((Type)ct) || !ts.isSignature(ct.superType()) || ts.hasUntrustedAncestor((Type)ct) != null;
    }
}

