/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jif.ExtensionInfo;
import jif.extension.JifDel;
import jif.extension.JifThrowDel;
import jif.types.JifLocalInstance;
import jif.types.JifTypeSystem;
import jif.types.LabeledType;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Catch;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.Stmt;
import polyglot.ast.Throw;
import polyglot.ast.Try;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ConstructorInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SubtypeSet;
import polyglot.util.UniqueID;
import polyglot.visit.ErrorHandlingVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;

public class JifExceptionChecker
extends ExceptionChecker {
    public JifExceptionChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    protected Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        JifExceptionChecker inner = (JifExceptionChecker)v;
        boolean isAncestor = false;
        JifExceptionChecker ec = inner;
        while (!isAncestor && ec != null) {
            isAncestor = isAncestor || ec == this;
            ec = (JifExceptionChecker)ec.outer;
        }
        if (!isAncestor) {
            throw new InternalCompilerError("oops!");
        }
        if (parent instanceof ProcedureDecl && this.throwsSet.size() > 0) {
            JifTypeSystem jifts = (JifTypeSystem)this.ts;
            ExtensionInfo extInfo = (ExtensionInfo)this.ts.extensionInfo();
            SubtypeSet fatalExcs = new SubtypeSet((Type)this.ts.Throwable());
            ProcedureDecl pd = (ProcedureDecl)parent;
            ProcedureInstance pi = pd.procedureInstance();
            for (Type uncaughtExc : this.throwsSet) {
                boolean declared = false;
                for (Type declaredExc : this.catchable) {
                    if (!this.ts.isSubtype(uncaughtExc, declaredExc)) continue;
                    declared = true;
                    break;
                }
                if (declared || !jifts.promoteToFatal(uncaughtExc)) continue;
                fatalExcs.add(uncaughtExc);
            }
            if (fatalExcs.size() > 0) {
                if (pi instanceof ConstructorInstance) {
                    throw new SemanticException("Fail on exception not yet supported in constructors. The following exceptions must be declared or caught: " + fatalExcs);
                }
                if (!extInfo.getJifOptions().noWarnings()) {
                    this.errorQueue().enqueue(0, "Uncaught exceptions in " + parent + " at " + parent.position() + " will be treated as fatal errors: " + fatalExcs);
                }
                Position pos = Position.compilerGenerated();
                String s = UniqueID.newID((String)"exc");
                LinkedList<Catch> catchBlocks = new LinkedList<Catch>();
                for (Type exType : fatalExcs) {
                    exType = exType instanceof LabeledType ? ((LabeledType)exType).labelPart(jifts.topLabel()) : jifts.labeledType(pos, exType, jifts.topLabel());
                    CanonicalTypeNode exTypeNode = this.nf.CanonicalTypeNode(pos, exType);
                    Formal exc = this.nf.Formal(pos, Flags.NONE, (TypeNode)exTypeNode, this.nf.Id(pos, s));
                    JifLocalInstance fli = (JifLocalInstance)jifts.localInstance(pos, Flags.NONE, exType, s);
                    fli.setLabel(jifts.topLabel());
                    exc = exc.localInstance((LocalInstance)fli);
                    Local loc = this.nf.Local(pos, this.nf.Id(pos, s));
                    JifLocalInstance lli = (JifLocalInstance)jifts.localInstance(pos, Flags.NONE, exType, s);
                    lli.setLabel(jifts.topLabel());
                    loc = loc.localInstance((LocalInstance)lli);
                    loc = (Local)loc.type(exType);
                    LinkedList<Local> args = new LinkedList<Local>();
                    args.add(loc);
                    New newExc = this.nf.New(pos, (TypeNode)this.nf.CanonicalTypeNode(pos, (Type)jifts.fatalException()), args);
                    ConstructorInstance ci = this.ts.findConstructor(jifts.fatalException(), Collections.singletonList(this.ts.Throwable()), jifts.fatalException());
                    newExc = newExc.constructorInstance(ci);
                    Throw thrw = this.nf.Throw(pos, newExc.type((Type)jifts.fatalException()));
                    ((JifThrowDel)thrw.del()).setThrownIsNeverNull();
                    Block body = this.nf.Block(pos, new Stmt[]{thrw});
                    Catch c = this.nf.Catch(pos, exc, body);
                    catchBlocks.add(c);
                }
                Block newBlock = (Block)n.visit((NodeVisitor)new FatalExceptionSetter(this.job, this.ts, this.nf, fatalExcs));
                List stmts = newBlock.statements();
                Try t = this.nf.Try(pos, this.nf.Block(pos, stmts), catchBlocks);
                List<Try> newStmts = Collections.singletonList(t);
                return newBlock.statements(newStmts);
            }
        }
        return n.del().exceptionCheck((ExceptionChecker)inner);
    }

    public void throwsException(Type t, Position pos) throws SemanticException {
        if (!t.isUncheckedException()) {
            boolean exceptionCaught = false;
            for (JifExceptionChecker ec = this; !exceptionCaught && ec != null; ec = (JifExceptionChecker)ec.pop()) {
                if (ec.catchable != null) {
                    for (Type catchType : ec.catchable) {
                        if (!this.ts.isSubtype(t, catchType)) continue;
                        exceptionCaught = true;
                        break;
                    }
                }
                if (!exceptionCaught && ec.throwsSet != null) {
                    ec.throwsSet.add(t);
                }
                if (!ec.catchAllThrowable) continue;
                exceptionCaught = true;
            }
            if (!exceptionCaught && !((JifTypeSystem)this.ts).promoteToFatal(t)) {
                this.reportUncaughtException(t, pos);
            }
        }
    }

    public static class FatalExceptionSetter
    extends ErrorHandlingVisitor {
        protected SubtypeSet toRemove;

        public FatalExceptionSetter(Job job, TypeSystem ts, NodeFactory nf, SubtypeSet toRemove) {
            super(job, ts, nf);
            this.toRemove = toRemove;
        }

        public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
            Throw th;
            if (n instanceof Throw && this.toRemove.contains((Object)(th = (Throw)n).expr().type())) {
                throw new SemanticException("Explicitly thrown exception " + th.expr().type() + " must either be caught or declared to be thrown." + " : " + this.toRemove + ":: " + th.expr().type(), th.position());
            }
            if (n.del() instanceof JifDel) {
                ((JifDel)n.del()).setFatalExceptions(this.ts, this.toRemove);
            }
            return n;
        }
    }
}

