/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jif.ExtensionInfo;
import jif.JifScheduler;
import jif.ast.JifUtil;
import jif.extension.JifFieldDeclExt;
import jif.types.JifClassType;
import jif.types.JifFieldInstance;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.LabeledType;
import jif.types.Solver;
import jif.types.VarMap;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathField;
import jif.types.label.Label;
import jif.types.label.VarLabel;
import jif.visit.LabelChecker;
import jif.visit.LabelSubstitutionVisitor;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.Job;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.goals.Goal;
import polyglot.types.FieldInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class FieldLabelResolver
extends ContextVisitor {
    private final JifTypeSystem ts;
    private VarMap bounds;
    private Map<Label, Label> fieldVarBounds;

    public FieldLabelResolver(Job job, JifTypeSystem ts, NodeFactory nf) {
        super(job, (TypeSystem)ts, nf);
        this.job = job;
        this.ts = ts;
    }

    public NodeVisitor enterCall(Node n) throws SemanticException {
        if (n instanceof ClassDecl) {
            this.fieldVarBounds = new HashMap<Label, Label>();
        }
        if (n instanceof ClassBody) {
            ClassBody d = (ClassBody)n;
            this.labelCheckClassBody(d);
        }
        if (n instanceof Field) {
            ParsedClassType pct;
            FieldInstance fi = ((Field)n).fieldInstance();
            if (fi == null) {
                Job next;
                Field f = (Field)n;
                JifScheduler sched = (JifScheduler)this.job().extensionInfo().scheduler();
                Type tp = this.ts.unlabel(f.target().type());
                if (tp instanceof ParsedClassType) {
                    ParsedClassType pct2 = (ParsedClassType)tp;
                    next = pct2.job();
                } else {
                    next = this.job();
                }
                Goal g = sched.TypeChecked(next);
                throw new MissingDependencyException(g);
            }
            JifScheduler scheduler = (JifScheduler)this.typeSystem().extensionInfo().scheduler();
            ReferenceType ct = fi.container();
            while (ct instanceof JifSubstType) {
                ct = ((JifSubstType)ct).base();
            }
            if (ct instanceof ParsedClassType && (pct = (ParsedClassType)ct).job() != null && pct.job() != this.job) {
                try {
                    scheduler.addPrerequisiteDependency(scheduler.LabelsDoubleChecked(this.job), (Goal)scheduler.FieldLabelInference(pct.job()));
                }
                catch (CyclicDependencyException e) {
                    throw new InternalCompilerError((Throwable)e);
                }
            }
        }
        return this;
    }

    private void labelCheckClassBody(ClassBody d) throws SemanticException {
        JifClassType ct = (JifClassType)this.context().currentClassScope();
        LabelChecker lc = ((ExtensionInfo)ct.typeSystem().extensionInfo()).createLabelChecker(this.job, true, false, false, false);
        if (lc == null) {
            throw new InternalCompilerError("Could not label check " + ct + ".", d.position());
        }
        List members = d.members();
        for (ClassMember m : members) {
            if (!(m instanceof FieldDecl)) continue;
            JifFieldDeclExt ext = (JifFieldDeclExt)JifUtil.jifExt((Node)m);
            ext.labelCheckField(lc, ct);
        }
        Solver solver = lc.solver();
        this.bounds = solver.solve();
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof FieldDecl) {
            FieldDecl f = (FieldDecl)n;
            JifFieldInstance fi = (JifFieldInstance)f.fieldInstance();
            if (fi.label() instanceof VarLabel) {
                this.fieldVarBounds.put(fi.label(), this.bounds.boundOf((VarLabel)fi.label()));
            }
            LabeledType lbledType = this.ts.labeledType(f.declType().position(), this.ts.unlabel(f.declType()), fi.label());
            return f.type(f.type().type((Type)lbledType));
        }
        if (n instanceof ClassBody) {
            LabelSubstitutionVisitor lsv = new LabelSubstitutionVisitor(new FieldVarLabelSubst(this.fieldVarBounds), false);
            n = n.del().visitChildren((NodeVisitor)lsv);
        }
        return n;
    }

    private static class FieldVarLabelSubst
    extends LabelSubstitution {
        Map<Label, Label> map;

        public FieldVarLabelSubst(Map<Label, Label> fieldVarBounds) {
            this.map = fieldVarBounds;
        }

        @Override
        public Label substLabel(Label L) {
            Label b = this.map.get(L);
            if (b != null) {
                return b;
            }
            return L;
        }

        @Override
        public AccessPath substAccessPath(AccessPath ap) throws SemanticException {
            if ((ap = super.substAccessPath(ap)) instanceof AccessPathField) {
                AccessPathField apf = (AccessPathField)ap;
                JifFieldInstance fi = (JifFieldInstance)apf.fieldInstance();
                fi.setLabel(this.substLabel(fi.label()));
            }
            return ap;
        }
    }
}

