/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import jif.types.JifTypeSystem;
import polyglot.ast.ArrayInit;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Lit;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.Type;
import polyglot.visit.NodeVisitor;

public class ConstChecker
extends NodeVisitor {
    private boolean isConst = true;
    private final ClassType currentClass;

    public ConstChecker(ClassType currentClass) {
        this.currentClass = currentClass;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public Node override(Node n) {
        if (!this.isConst) {
            return n;
        }
        return null;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        Type t;
        if (n instanceof Field) {
            FieldInstance fi = ((Field)n).fieldInstance();
            if (!fi.flags().isFinal()) {
                System.out.println("  non final field: " + n);
                this.isConst = false;
            }
        } else if (n instanceof Call || n instanceof New) {
            this.isConst = false;
        } else if (n instanceof Expr) {
            Type t2 = ((Expr)n).type();
            if (v == null) {
                System.out.println(n);
            }
            if (this.badType(n, t2)) {
                this.isConst = false;
            }
        } else if (n instanceof TypeNode && this.badType(n, t = ((TypeNode)n).type())) {
            this.isConst = false;
        }
        return n;
    }

    private boolean badType(Node n, Type t) {
        JifTypeSystem ts = (JifTypeSystem)t.typeSystem();
        if (n instanceof Lit || n instanceof ArrayInit) {
            return false;
        }
        return t.isReference() && !ts.String().equals(t) && (this.currentClass == null || !this.currentClass.equals(t));
    }
}

