/*
 * Decompiled with CFR 0.152.
 */
package jif.types.principal;

import java.util.List;
import jif.translate.PrincipalToJavaExpr;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathConstant;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import jif.types.principal.Principal_c;
import jif.visit.LabelChecker;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class DynamicPrincipal_c
extends Principal_c
implements DynamicPrincipal {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final AccessPath path;

    public DynamicPrincipal_c(AccessPath path, JifTypeSystem ts, Position pos, PrincipalToJavaExpr toJava) {
        super(ts, pos, toJava);
        this.path = path;
        if (path instanceof AccessPathConstant) {
            throw new InternalCompilerError("Don't expect to get AccessPathConstants for dynamic labels");
        }
    }

    @Override
    public AccessPath path() {
        return this.path;
    }

    @Override
    public boolean isRuntimeRepresentable() {
        return true;
    }

    @Override
    public boolean isCanonical() {
        return this.path.isCanonical();
    }

    public String toString() {
        if (Report.should_report((String)"debug", (int)1)) {
            return "<pr-dynamic " + this.path + ">";
        }
        return this.path().toString();
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicPrincipal)) {
            return false;
        }
        DynamicPrincipal that = (DynamicPrincipal)o;
        return this.path.equals(that.path());
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        return this.path.throwTypes(ts);
    }

    @Override
    public Principal subst(LabelSubstitution substitution) throws SemanticException {
        AccessPath newPath = substitution.substAccessPath(this.path);
        if (newPath != this.path) {
            JifTypeSystem ts = this.typeSystem();
            Principal newDP = ts.pathToPrincipal(this.position(), newPath);
            return substitution.substPrincipal(newDP);
        }
        return substitution.substPrincipal(this);
    }

    @Override
    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        return this.path.labelcheck(A, lc);
    }
}

