/*
 * Decompiled with CFR 0.152.
 */
package jif.types.principal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import jif.translate.PrincipalToJavaExpr;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.Principal;
import jif.types.principal.Principal_c;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class DisjunctivePrincipal_c
extends Principal_c
implements DisjunctivePrincipal {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final Set<Principal> disjuncts;

    public DisjunctivePrincipal_c(Collection<Principal> disjuncts, JifTypeSystem ts, Position pos, PrincipalToJavaExpr toJava) {
        super(ts, pos, toJava);
        this.disjuncts = new LinkedHashSet<Principal>(disjuncts);
        if (disjuncts.size() < 2) {
            throw new InternalCompilerError("DisjunctivePrincipal should have at least 2 members");
        }
    }

    @Override
    public boolean isRuntimeRepresentable() {
        for (Principal p : this.disjuncts) {
            if (p.isRuntimeRepresentable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCanonical() {
        for (Principal p : this.disjuncts) {
            if (p.isCanonical()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String sep = ",";
        if (Report.should_report((String)"debug", (int)1)) {
            sb.append("<");
            sep = " or ";
        } else if (Report.should_report((String)"debug", (int)2)) {
            sb.append("<disjunction: ");
            sep = " or ";
        }
        Iterator<Principal> iter = this.disjuncts.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(sep);
        }
        if (Report.should_report((String)"debug", (int)1)) {
            sb.append(">");
        } else if (Report.should_report((String)"debug", (int)2)) {
            sb.append(">");
        }
        return sb.toString();
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DisjunctivePrincipal) {
            DisjunctivePrincipal that = (DisjunctivePrincipal)o;
            return this.disjuncts.equals(that.disjuncts());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.disjuncts.hashCode();
    }

    @Override
    public Set<Principal> disjuncts() {
        return this.disjuncts;
    }

    @Override
    public Principal subst(LabelSubstitution substitution) throws SemanticException {
        HashSet<Principal> substDisjuncts = new HashSet<Principal>();
        for (Principal disjunct : this.disjuncts) {
            substDisjuncts.add(disjunct.subst(substitution));
        }
        if (substDisjuncts.size() > 1) {
            return new DisjunctivePrincipal_c(substDisjuncts, (JifTypeSystem)this.ts, this.position(), this.toJava);
        }
        if (substDisjuncts.size() == 1) {
            return (Principal)substDisjuncts.iterator().next();
        }
        throw new InternalCompilerError("No principals left after substitution.");
    }
}

