/*
 * Decompiled with CFR 0.152.
 */
package jif.types.principal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import jif.translate.PrincipalToJavaExpr;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.principal.ConjunctivePrincipal;
import jif.types.principal.DisjunctivePrincipal;
import jif.types.principal.Principal;
import jif.types.principal.Principal_c;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class ConjunctivePrincipal_c
extends Principal_c
implements ConjunctivePrincipal {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final Set<Principal> conjuncts;

    public ConjunctivePrincipal_c(Collection<Principal> conjuncts, JifTypeSystem ts, Position pos, PrincipalToJavaExpr toJava) {
        super(ts, pos, toJava);
        this.conjuncts = new LinkedHashSet<Principal>(conjuncts);
        if (conjuncts.size() < 2) {
            throw new InternalCompilerError("ConjunctivePrincipal should have at least 2 members");
        }
    }

    @Override
    public boolean isRuntimeRepresentable() {
        for (Principal p : this.conjuncts) {
            if (p.isRuntimeRepresentable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCanonical() {
        for (Principal p : this.conjuncts) {
            if (p.isCanonical()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String sep = "&";
        if (Report.should_report((String)"debug", (int)1)) {
            sb.append("<");
            sep = " and ";
        } else if (Report.should_report((String)"debug", (int)2)) {
            sb.append("<conjunction: ");
            sep = " and ";
        }
        Iterator<Principal> iter = this.conjuncts.iterator();
        while (iter.hasNext()) {
            Principal p = iter.next();
            if (p instanceof DisjunctivePrincipal) {
                sb.append('(');
                sb.append(p);
                sb.append(')');
            } else {
                sb.append(p);
            }
            if (!iter.hasNext()) continue;
            sb.append(sep);
        }
        if (Report.should_report((String)"debug", (int)1)) {
            sb.append(">");
        } else if (Report.should_report((String)"debug", (int)2)) {
            sb.append(">");
        }
        return sb.toString();
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ConjunctivePrincipal) {
            ConjunctivePrincipal that = (ConjunctivePrincipal)o;
            return this.conjuncts.equals(that.conjuncts());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.conjuncts.hashCode();
    }

    @Override
    public Set<Principal> conjuncts() {
        return Collections.unmodifiableSet(this.conjuncts);
    }

    @Override
    public Principal simplify() {
        if (!this.isCanonical()) {
            return this;
        }
        LinkedHashSet<Principal> needed = new LinkedHashSet<Principal>();
        JifTypeSystem jts = (JifTypeSystem)this.ts;
        for (Principal p : this.conjuncts) {
            Principal ci = p.simplify();
            if (ci.hasVariables()) {
                needed.add(ci);
                continue;
            }
            boolean subsumed = false;
            Iterator j = needed.iterator();
            while (j.hasNext()) {
                Principal cj = (Principal)j.next();
                if (cj.hasVariables()) continue;
                if (jts.actsFor(cj, ci)) {
                    subsumed = true;
                    break;
                }
                if (!jts.actsFor(ci, cj)) continue;
                j.remove();
            }
            if (subsumed) continue;
            needed.add(ci);
        }
        if (needed.equals(this.conjuncts)) {
            return this;
        }
        if (needed.size() == 1) {
            return (Principal)needed.iterator().next();
        }
        return new ConjunctivePrincipal_c(needed, (JifTypeSystem)this.ts, this.position(), this.toJava);
    }

    @Override
    public Principal subst(LabelSubstitution substitution) throws SemanticException {
        HashSet<Principal> substConjuncts = new HashSet<Principal>();
        for (Principal conjunct : this.conjuncts) {
            substConjuncts.add(conjunct.subst(substitution));
        }
        if (substConjuncts.size() > 1) {
            return new ConjunctivePrincipal_c(substConjuncts, (JifTypeSystem)this.ts, this.position(), this.toJava);
        }
        if (substConjuncts.size() == 1) {
            return (Principal)substConjuncts.iterator().next();
        }
        throw new InternalCompilerError("No principals left after substitution.");
    }
}

