/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.IntegPolicy;
import jif.types.label.IntegProjectionPolicy_c;
import jif.types.label.Label;
import jif.types.label.Policy;
import jif.types.label.Policy_c;
import jif.types.label.WriterPolicy;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class WriterPolicy_c
extends Policy_c
implements WriterPolicy {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final Principal owner;
    private final Principal writer;

    public WriterPolicy_c(Principal owner, Principal writer, JifTypeSystem ts, Position pos) {
        super(ts, pos);
        if (owner == null) {
            throw new InternalCompilerError("null owner");
        }
        this.owner = owner;
        this.writer = writer;
    }

    @Override
    public Principal owner() {
        return this.owner;
    }

    @Override
    public Principal writer() {
        return this.writer;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isCanonical() {
        return this.owner.isCanonical() && this.writer.isCanonical();
    }

    @Override
    public boolean isRuntimeRepresentable() {
        return this.owner.isRuntimeRepresentable() && this.writer.isRuntimeRepresentable();
    }

    @Override
    protected Policy simplifyImpl() {
        return this;
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof WriterPolicy_c) {
            WriterPolicy_c that = (WriterPolicy_c)o;
            if (this.owner == that.owner || this.owner != null && this.owner.equals(that.owner)) {
                return this.writer.equals(that.writer);
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.owner == null ? 0 : this.owner.hashCode()) ^ (this.writer == null ? 0 : this.writer.hashCode()) ^ 0x12D5B0;
    }

    @Override
    public boolean leq_(IntegPolicy p, LabelEnv env, LabelEnv.SearchState state) {
        if (this.isBottomIntegrity() || p.isTopIntegrity()) {
            return true;
        }
        if (p instanceof WriterPolicy) {
            WriterPolicy that = (WriterPolicy)p;
            if (!env.actsFor(this.owner, that.owner())) {
                return false;
            }
            return env.actsFor(this.writer(), that.owner()) || env.actsFor(this.writer(), that.writer());
        }
        if (p instanceof IntegProjectionPolicy_c) {
            Label lowb = env.findLowerBound(((IntegProjectionPolicy_c)p).label());
            return env.leq(this, lowb.integProjection());
        }
        return false;
    }

    @Override
    public String toString(Set<Label> printedLabels) {
        StringBuffer sb = new StringBuffer(this.owner.toString());
        sb.append("\u2190");
        if (!this.writer.isTopPrincipal()) {
            sb.append(this.writer.toString());
        }
        return sb.toString();
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> throwTypes = new ArrayList<Type>();
        throwTypes.addAll(this.owner.throwTypes(ts));
        throwTypes.addAll(this.writer.throwTypes(ts));
        return throwTypes;
    }

    @Override
    public Policy subst(LabelSubstitution substitution) throws SemanticException {
        Principal newWriter;
        boolean changed = false;
        Principal newOwner = this.owner.subst(substitution);
        if (newOwner != this.owner) {
            changed = true;
        }
        if ((newWriter = this.writer.subst(substitution)) != this.writer) {
            changed = true;
        }
        if (!changed) {
            return substitution.substPolicy(this).simplify();
        }
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        WriterPolicy newPolicy = ts.writerPolicy(this.position(), newOwner, newWriter);
        return substitution.substPolicy(newPolicy).simplify();
    }

    @Override
    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        PathMap X = this.owner.labelCheck(A, lc);
        this.updateContextForWriter(lc, A, X);
        PathMap Xr = this.writer.labelCheck(A, lc);
        X = X.join(Xr);
        return X;
    }

    protected void updateContextForWriter(LabelChecker lc, JifContext A, PathMap Xowner) {
        A.setPc(Xowner.N(), lc);
    }

    @Override
    public boolean isBottomIntegrity() {
        return this.owner.isTopPrincipal() && this.writer.isTopPrincipal();
    }

    @Override
    public boolean isTopIntegrity() {
        return this.owner.isBottomPrincipal() && this.writer.isBottomPrincipal();
    }

    @Override
    public boolean isTop() {
        return this.isTopIntegrity();
    }

    @Override
    public boolean isBottom() {
        return this.isBottomIntegrity();
    }

    @Override
    public IntegPolicy meet(IntegPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.meet(this, p);
    }

    @Override
    public IntegPolicy join(IntegPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.join(this, p);
    }
}

