/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.ConfPolicy;
import jif.types.label.Label;
import jif.types.label.Policy;
import jif.types.label.Policy_c;
import jif.types.label.ReaderPolicy;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class ReaderPolicy_c
extends Policy_c
implements ReaderPolicy {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final Principal owner;
    private final Principal reader;

    public ReaderPolicy_c(Principal owner, Principal reader, JifTypeSystem ts, Position pos) {
        super(ts, pos);
        if (owner == null) {
            throw new InternalCompilerError("null owner");
        }
        this.owner = owner;
        this.reader = reader;
    }

    @Override
    public Principal owner() {
        return this.owner;
    }

    @Override
    public Principal reader() {
        return this.reader;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isCanonical() {
        return this.owner.isCanonical() && this.reader.isCanonical();
    }

    @Override
    public boolean isRuntimeRepresentable() {
        return this.owner.isRuntimeRepresentable() && this.reader.isRuntimeRepresentable();
    }

    @Override
    protected Policy simplifyImpl() {
        return this;
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ReaderPolicy_c) {
            ReaderPolicy_c that = (ReaderPolicy_c)o;
            if (this.owner == that.owner || this.owner != null && this.owner.equals(that.owner)) {
                return this.reader.equals(that.reader);
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.owner == null ? 0 : this.owner.hashCode()) ^ this.reader.hashCode() ^ 0xE780A;
    }

    @Override
    public boolean leq_(ConfPolicy p, LabelEnv env, LabelEnv.SearchState state) {
        if (this.isBottomConfidentiality() || p.isTopConfidentiality()) {
            return true;
        }
        if (this.reader.isBottomPrincipal()) {
            return true;
        }
        if (p instanceof ReaderPolicy) {
            ReaderPolicy that = (ReaderPolicy)p;
            if (!env.actsFor(that.owner(), this.owner)) {
                return false;
            }
            return env.actsFor(that.reader(), this.owner()) || env.actsFor(that.reader(), this.reader());
        }
        return false;
    }

    @Override
    public String toString(Set<Label> printedLabels) {
        StringBuffer sb = new StringBuffer(this.owner.toString());
        sb.append("\u2192");
        if (!this.reader.isTopPrincipal()) {
            sb.append(this.reader.toString());
        }
        return sb.toString();
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> throwTypes = new ArrayList<Type>();
        throwTypes.addAll(this.owner.throwTypes(ts));
        throwTypes.addAll(this.reader.throwTypes(ts));
        return throwTypes;
    }

    @Override
    public Policy subst(LabelSubstitution substitution) throws SemanticException {
        Principal newReader;
        boolean changed = false;
        Principal newOwner = this.owner.subst(substitution);
        if (newOwner != this.owner) {
            changed = true;
        }
        if ((newReader = this.reader.subst(substitution)) != this.reader) {
            changed = true;
        }
        if (!changed) {
            return substitution.substPolicy(this);
        }
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        ReaderPolicy newPolicy = ts.readerPolicy(this.position(), newOwner, newReader);
        return substitution.substPolicy(newPolicy);
    }

    @Override
    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        PathMap X = this.owner.labelCheck(A, lc);
        this.updateContextForReader(lc, A, X);
        PathMap Xr = this.reader.labelCheck(A, lc);
        X = X.join(Xr);
        return X;
    }

    protected void updateContextForReader(LabelChecker lc, JifContext A, PathMap Xowner) {
        A.setPc(Xowner.N(), lc);
    }

    @Override
    public boolean isBottomConfidentiality() {
        return this.owner.isBottomPrincipal() && this.reader.isBottomPrincipal();
    }

    @Override
    public boolean isTopConfidentiality() {
        return this.owner.isTopPrincipal() && this.reader.isTopPrincipal();
    }

    @Override
    public boolean isTop() {
        return this.isTopConfidentiality();
    }

    @Override
    public boolean isBottom() {
        return this.isBottomConfidentiality();
    }

    @Override
    public ConfPolicy meet(ConfPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.meet(this, p);
    }

    @Override
    public ConfPolicy join(ConfPolicy p) {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        return ts.join(this, p);
    }
}

