/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.Label;
import jif.types.label.MeetPolicy;
import jif.types.label.Policy;
import jif.types.label.Policy_c;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public abstract class MeetPolicy_c<P extends Policy>
extends Policy_c
implements MeetPolicy<P> {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final Set<P> meetComponents;
    private Integer hashCode = null;

    public MeetPolicy_c(Set<P> components, JifTypeSystem ts, Position pos) {
        super(ts, pos);
        this.meetComponents = Collections.unmodifiableSet(MeetPolicy_c.flatten(components));
        if (this.meetComponents.isEmpty()) {
            throw new InternalCompilerError("Empty collection!");
        }
    }

    @Override
    public boolean isSingleton() {
        return this.meetComponents.size() == 1;
    }

    @Override
    public boolean isCanonical() {
        for (Policy c : this.meetComponents) {
            if (c.isCanonical()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRuntimeRepresentable() {
        for (Policy c : this.meetComponents) {
            if (c.isRuntimeRepresentable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MeetPolicy_c) {
            MeetPolicy_c that = (MeetPolicy_c)o;
            return this.hashCode() == that.hashCode() && this.meetComponents.equals(that.meetComponents);
        }
        if (o instanceof Policy) {
            return this.meetComponents.equals(Collections.singleton(o));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = new Integer(this.meetComponents.hashCode());
        }
        return this.hashCode;
    }

    @Override
    public String toString(Set<Label> printedLabels) {
        String s = "";
        Iterator<P> i = this.meetComponents.iterator();
        while (i.hasNext()) {
            Policy c = (Policy)i.next();
            s = s + c.toString(printedLabels);
            if (!i.hasNext()) continue;
            s = s + " meet ";
        }
        return s;
    }

    protected boolean leq_(Policy p, LabelEnv env, LabelEnv.SearchState state) {
        for (Policy pi : this.meetComponents) {
            if (!env.leq(pi, p, state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<P> meetComponents() {
        return Collections.unmodifiableCollection(this.meetComponents);
    }

    @Override
    protected Policy simplifyImpl() {
        if (this.meetComponents.isEmpty()) {
            return this;
        }
        if (this.meetComponents.size() == 1) {
            return ((Policy)this.meetComponents.iterator().next()).simplify();
        }
        Set<Policy> comps = MeetPolicy_c.flatten(this.meetComponents);
        LinkedHashSet<Policy> needed = new LinkedHashSet<Policy>();
        JifTypeSystem jts = (JifTypeSystem)this.ts;
        for (Policy comp : comps) {
            Policy ci = comp.simplify();
            if (ci.hasVariables() || ci.hasWritersToReaders()) {
                needed.add(ci);
                continue;
            }
            boolean subsumed = false;
            Iterator j = needed.iterator();
            while (j.hasNext()) {
                Policy cj = (Policy)j.next();
                if (cj.hasVariables() || cj.hasWritersToReaders()) continue;
                if (jts.leq(cj, ci)) {
                    subsumed = true;
                    break;
                }
                if (!jts.leq(ci, cj)) continue;
                j.remove();
            }
            if (subsumed) continue;
            needed.add(ci);
        }
        if (needed.equals(this.meetComponents)) {
            return this;
        }
        if (needed.size() == 1) {
            return (Policy)needed.iterator().next();
        }
        return this.constructMeetPolicy(needed, this.position);
    }

    protected abstract Policy constructMeetPolicy(Set<P> var1, Position var2);

    private static <P extends Policy> Set<P> flatten(Set<P> comps) {
        boolean needFlattening = false;
        for (Policy p : comps) {
            if (!(p instanceof MeetPolicy_c)) continue;
            needFlattening = true;
            break;
        }
        if (!needFlattening) {
            return comps;
        }
        LinkedHashSet<Object> c = new LinkedHashSet<Object>();
        for (Policy p : comps) {
            if (p.isBottom()) {
                return Collections.singleton(p);
            }
            if (p instanceof MeetPolicy_c) {
                MeetPolicy_c mp = (MeetPolicy_c)p;
                Collection<P> lComps = mp.meetComponents();
                c.addAll(lComps);
                continue;
            }
            c.add(p);
        }
        return c;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> throwTypes = new ArrayList<Type>();
        for (Policy L : this.meetComponents) {
            throwTypes.addAll(L.throwTypes(ts));
        }
        return throwTypes;
    }

    @Override
    public Policy subst(LabelSubstitution substitution) throws SemanticException {
        if (this.meetComponents.isEmpty()) {
            return substitution.substPolicy(this).simplify();
        }
        boolean changed = false;
        LinkedHashSet<Policy> s = new LinkedHashSet<Policy>();
        for (Policy c : this.meetComponents) {
            Policy newc = c.subst(substitution);
            if (newc != c) {
                changed = true;
            }
            s.add(newc);
        }
        if (!changed) {
            return substitution.substPolicy(this).simplify();
        }
        Policy newMeetPolicy = this.constructMeetPolicy(MeetPolicy_c.flatten(s), this.position);
        return substitution.substPolicy(newMeetPolicy).simplify();
    }

    @Override
    public boolean hasWritersToReaders() {
        for (Policy c : this.meetComponents) {
            if (!c.hasWritersToReaders()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasVariables() {
        for (Policy c : this.meetComponents) {
            if (!c.hasVariables()) continue;
            return true;
        }
        return false;
    }

    @Override
    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        PathMap X = ts.pathMap().N(A.pc()).NV(A.pc());
        if (this.meetComponents.isEmpty()) {
            return X;
        }
        A = (JifContext)A.pushBlock();
        for (Policy c : this.meetComponents) {
            this.updateContextForComp(lc, A, X);
            PathMap Xc = c.labelCheck(A, lc);
            X = X.join(Xc);
        }
        return X;
    }

    protected void updateContextForComp(LabelChecker lc, JifContext A, PathMap Xprev) {
        A.setPc(Xprev.N(), lc);
    }

    @Override
    public boolean isTop() {
        for (Policy c : this.meetComponents) {
            if (c.isTop()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBottom() {
        for (Policy c : this.meetComponents) {
            if (!c.isBottom()) continue;
            return true;
        }
        return false;
    }
}

