/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jif.translate.LabelToJavaExpr;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.ConfPolicy;
import jif.types.label.IntegPolicy;
import jif.types.label.Label;
import jif.types.label.Label_c;
import jif.types.label.MeetLabel;
import jif.types.label.Variable;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class MeetLabel_c
extends Label_c
implements MeetLabel {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final Set<Label> components;
    private Label normalized = null;

    public MeetLabel_c(Set<Label> components, JifTypeSystem ts, Position pos, LabelToJavaExpr trans) {
        super(ts, pos, trans);
        this.components = Collections.unmodifiableSet(MeetLabel_c.flatten(components));
        if (this.components.isEmpty()) {
            throw new InternalCompilerError("No empty meets");
        }
    }

    @Override
    public boolean isRuntimeRepresentable() {
        for (Label c : this.components) {
            if (c.isRuntimeRepresentable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCanonical() {
        for (Label c : this.components) {
            if (c.isCanonical()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isDisambiguatedImpl() {
        return true;
    }

    @Override
    public boolean isCovariant() {
        for (Label c : this.components) {
            if (!c.isCovariant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComparable() {
        for (Label c : this.components) {
            if (c.isComparable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isBottom() {
        if (this.components.isEmpty()) {
            return false;
        }
        for (Label c : this.components) {
            if (!c.isBottom()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTop() {
        return this.components.isEmpty();
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MeetLabel_c) {
            MeetLabel_c that = (MeetLabel_c)o;
            return this.components.equals(that.components);
        }
        if (o instanceof Label) {
            return this.components.equals(Collections.singleton(o));
        }
        return false;
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    @Override
    public String componentString(Set<Label> printedLabels) {
        String s = "";
        Iterator<Label> i = this.components.iterator();
        while (i.hasNext()) {
            Label c = i.next();
            s = s + c.toString(printedLabels);
            if (!i.hasNext()) continue;
            s = s + " \u2293 ";
        }
        return s;
    }

    @Override
    public boolean leq_(Label L, LabelEnv env, LabelEnv.SearchState state) {
        if (!L.isComparable() || !L.isEnumerable()) {
            throw new InternalCompilerError("Cannot compare " + L);
        }
        for (Label pi : this.components) {
            if (!env.leq(pi, L, state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Label> meetComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    @Override
    public MeetLabel_c copy() {
        MeetLabel_c l = (MeetLabel_c)super.copy();
        l.normalized = null;
        return l;
    }

    @Override
    public Label normalize() {
        if (this.normalized == null) {
            this.normalized = this.normalizeImpl();
        }
        return this.normalized;
    }

    private Label normalizeImpl() {
        if (this.components.size() == 1) {
            return this.components.iterator().next();
        }
        return this;
    }

    @Override
    protected Label simplifyImpl() {
        if (!this.isDisambiguated() || this.components.isEmpty()) {
            return this;
        }
        Set<Label> comps = MeetLabel_c.flatten(this.components);
        LinkedHashSet<Label> needed = new LinkedHashSet<Label>();
        JifTypeSystem jts = (JifTypeSystem)this.ts;
        for (Label ci : comps) {
            if ((ci = ci.simplify()).hasVariables() || ci.hasWritersToReaders()) {
                needed.add(ci);
                continue;
            }
            boolean subsumed = false;
            Iterator j = needed.iterator();
            while (j.hasNext()) {
                Label cj = (Label)j.next();
                if (cj.hasVariables() || cj.hasWritersToReaders()) continue;
                if (jts.leq(cj, ci)) {
                    subsumed = true;
                    break;
                }
                if (!jts.leq(ci, cj)) continue;
                j.remove();
            }
            if (subsumed) continue;
            needed.add(ci);
        }
        if (needed.equals(this.components)) {
            return this;
        }
        if (needed.size() == 1) {
            return (Label)needed.iterator().next();
        }
        return jts.meetLabel(this.position(), needed);
    }

    private static Set<Label> flatten(Set<Label> comps) {
        boolean needFlattening = false;
        for (Label L : comps) {
            if (!(L instanceof MeetLabel)) continue;
            needFlattening = true;
            break;
        }
        if (!needFlattening) {
            return comps;
        }
        LinkedHashSet<Label> c = new LinkedHashSet<Label>();
        for (Label L : comps) {
            if (L.isBottom()) {
                return Collections.singleton(L);
            }
            if (L instanceof MeetLabel) {
                Set<Label> lComps = ((MeetLabel)L).meetComponents();
                c.addAll(lComps);
                continue;
            }
            c.add(L);
        }
        return c;
    }

    @Override
    public ConfPolicy confProjection() {
        HashSet<ConfPolicy> confPols = new HashSet<ConfPolicy>();
        for (Label c : this.components) {
            confPols.add(c.confProjection());
        }
        return ((JifTypeSystem)this.ts).meetConfPolicy(this.position, confPols);
    }

    @Override
    public IntegPolicy integProjection() {
        HashSet<IntegPolicy> integPols = new HashSet<IntegPolicy>();
        for (Label c : this.components) {
            integPols.add(c.integProjection());
        }
        return ((JifTypeSystem)this.ts).meetIntegPolicy(this.position, integPols);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> throwTypes = new ArrayList<Type>();
        for (Label L : this.components) {
            throwTypes.addAll(L.throwTypes(ts));
        }
        return throwTypes;
    }

    @Override
    public Label subst(LabelSubstitution substitution) throws SemanticException {
        if (this.components.isEmpty() || substitution.stackContains(this) || !substitution.recurseIntoChildren(this)) {
            return substitution.substLabel(this);
        }
        substitution.pushLabel(this);
        boolean changed = false;
        LinkedHashSet<Label> s = new LinkedHashSet<Label>();
        for (Label c : this.components) {
            Label newc = c.subst(substitution);
            if (!changed && newc != c) {
                changed = true;
                s = new LinkedHashSet();
                for (Label d : this.components) {
                    if (c == d) break;
                    s.add(d);
                }
            }
            if (!changed) continue;
            s.add(newc);
        }
        substitution.popLabel(this);
        if (!changed) {
            return substitution.substLabel(this);
        }
        JifTypeSystem ts = this.typeSystem();
        Label newmeetLabel = ts.meetLabel(this.position(), MeetLabel_c.flatten(s));
        return substitution.substLabel(newmeetLabel);
    }

    @Override
    public boolean hasWritersToReaders() {
        for (Label ci : this.meetComponents()) {
            if (!ci.hasWritersToReaders()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Variable> variableComponents() {
        LinkedHashSet<Variable> s = new LinkedHashSet<Variable>();
        for (Label ci : this.meetComponents()) {
            s.addAll(ci.variableComponents());
        }
        return s;
    }

    @Override
    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        PathMap X = ts.pathMap().N(A.pc()).NV(A.pc());
        if (this.components.isEmpty()) {
            return X;
        }
        A = (JifContext)A.pushBlock();
        for (Label c : this.components) {
            this.updateContextForComp(lc, A, X);
            PathMap Xc = c.labelCheck(A, lc);
            X = X.join(Xc);
        }
        return X;
    }

    protected void updateContextForComp(LabelChecker lc, JifContext A, PathMap Xprev) {
        A.setPc(Xprev.N(), lc);
    }
}

