/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jif.translate.LabelToJavaExpr;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.ConfPolicy;
import jif.types.label.IntegPolicy;
import jif.types.label.JoinLabel;
import jif.types.label.Label;
import jif.types.label.Label_c;
import jif.types.label.PairLabel;
import jif.types.label.Variable;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public class JoinLabel_c
extends Label_c
implements JoinLabel {
    private static final long serialVersionUID = SerialVersionUID.generate();
    private final Set<Label> components;
    private Label normalized = null;

    public JoinLabel_c(Set<Label> components, JifTypeSystem ts, Position pos, LabelToJavaExpr trans) {
        super(ts, pos, trans);
        this.components = Collections.unmodifiableSet(JoinLabel_c.flatten(components));
        if (this.components.isEmpty()) {
            throw new InternalCompilerError("No empty joins");
        }
    }

    @Override
    public boolean isRuntimeRepresentable() {
        for (Label c : this.components) {
            if (c.isRuntimeRepresentable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCanonical() {
        for (Label c : this.components) {
            if (c.isCanonical()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isDisambiguatedImpl() {
        return true;
    }

    @Override
    public boolean isCovariant() {
        for (Label c : this.components) {
            if (!c.isCovariant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComparable() {
        for (Label c : this.components) {
            if (c.isComparable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isBottom() {
        return this.components.isEmpty();
    }

    @Override
    public boolean isTop() {
        if (this.components.isEmpty()) {
            return false;
        }
        for (Label c : this.components) {
            if (!c.isTop()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JoinLabel_c) {
            JoinLabel_c that = (JoinLabel_c)o;
            return this.components.equals(that.components);
        }
        if (o instanceof Label) {
            return this.components.equals(Collections.singleton(o));
        }
        return false;
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    @Override
    public String toString() {
        if (this.isTop()) {
            return "{\u22a4\u2192}";
        }
        return super.toString();
    }

    @Override
    public String componentString(Set<Label> printedLabels) {
        String s = "";
        Iterator<Label> i = this.components.iterator();
        while (i.hasNext()) {
            Label c = i.next();
            s = s + c.componentString(printedLabels);
            if (!i.hasNext()) continue;
            s = s + " \u2294 ";
        }
        return s;
    }

    @Override
    public boolean leq_(Label L, LabelEnv env, LabelEnv.SearchState state) {
        if (!L.isComparable() || !L.isEnumerable()) {
            throw new InternalCompilerError("Cannot compare " + L);
        }
        for (Label ci : this.components) {
            if (env.leq(ci, L, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<Label> joinComponents() {
        return Collections.unmodifiableCollection(this.components);
    }

    @Override
    public JoinLabel_c copy() {
        JoinLabel_c l = (JoinLabel_c)super.copy();
        l.normalized = null;
        return l;
    }

    @Override
    public Label normalize() {
        if (this.normalized == null) {
            this.normalized = this.normalizeImpl();
        }
        return this.normalized;
    }

    private Label normalizeImpl() {
        if (this.components.size() == 1) {
            return this.components.iterator().next();
        }
        JifTypeSystem ts = this.typeSystem();
        PairLabel pl = null;
        boolean combinedPL = false;
        for (Label lbl : this.joinComponents()) {
            if (!(lbl instanceof PairLabel)) continue;
            PairLabel p = (PairLabel)lbl;
            if (pl == null) {
                pl = p;
                continue;
            }
            combinedPL = true;
            pl = ts.pairLabel(this.position(), pl.confPolicy().join(p.confPolicy()), pl.integPolicy().join(p.integPolicy()));
        }
        if (combinedPL) {
            LinkedHashSet<Label> comps = new LinkedHashSet<Label>();
            comps.add(pl);
            for (Label lbl : this.joinComponents()) {
                if (lbl instanceof PairLabel) continue;
                comps.add(lbl);
            }
            return ts.joinLabel(this.position(), comps);
        }
        return this;
    }

    @Override
    protected Label simplifyImpl() {
        if (!this.isDisambiguated() || this.components.isEmpty()) {
            return this;
        }
        LinkedHashSet<Label> needed = new LinkedHashSet<Label>();
        JifTypeSystem jts = (JifTypeSystem)this.ts;
        for (Label ci : this.components) {
            if ((ci = ci.simplify()).hasVariables() || ci.hasWritersToReaders()) {
                needed.add(ci);
                continue;
            }
            boolean subsumed = false;
            Iterator j = needed.iterator();
            while (j.hasNext()) {
                Label cj = (Label)j.next();
                if (cj.hasVariables() || cj.hasWritersToReaders()) continue;
                if (jts.leq(ci, cj)) {
                    subsumed = true;
                    break;
                }
                if (!jts.leq(cj, ci)) continue;
                j.remove();
            }
            if (subsumed) continue;
            needed.add(ci);
        }
        if (needed.equals(this.components)) {
            return this;
        }
        if (needed.size() == 1) {
            return (Label)needed.iterator().next();
        }
        return jts.joinLabel(this.position(), needed);
    }

    private static Set<Label> flatten(Set<Label> comps) {
        boolean needFlattening = false;
        for (Label L : comps) {
            if (!(L instanceof JoinLabel)) continue;
            needFlattening = true;
            break;
        }
        if (!needFlattening) {
            return comps;
        }
        LinkedHashSet<Label> c = new LinkedHashSet<Label>();
        for (Label L : comps) {
            if (L.isTop()) {
                return Collections.singleton(L);
            }
            if (L instanceof JoinLabel) {
                Collection<Label> lComps = ((JoinLabel)L).joinComponents();
                c.addAll(lComps);
                continue;
            }
            c.add(L);
        }
        return c;
    }

    @Override
    public ConfPolicy confProjection() {
        HashSet<ConfPolicy> confPols = new HashSet<ConfPolicy>();
        for (Label c : this.components) {
            confPols.add(c.confProjection());
        }
        return ((JifTypeSystem)this.ts).joinConfPolicy(this.position, confPols);
    }

    @Override
    public IntegPolicy integProjection() {
        HashSet<IntegPolicy> integPols = new HashSet<IntegPolicy>();
        for (Label c : this.components) {
            integPols.add(c.integProjection());
        }
        return ((JifTypeSystem)this.ts).joinIntegPolicy(this.position, integPols);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> throwTypes = new ArrayList<Type>();
        for (Label L : this.components) {
            throwTypes.addAll(L.throwTypes(ts));
        }
        return throwTypes;
    }

    @Override
    public Label subst(LabelSubstitution substitution) throws SemanticException {
        if (this.components.isEmpty() || substitution.stackContains(this) || !substitution.recurseIntoChildren(this)) {
            return substitution.substLabel(this);
        }
        substitution.pushLabel(this);
        boolean changed = false;
        LinkedHashSet<Label> s = null;
        for (Label c : this.components) {
            Label newc = c.subst(substitution);
            if (!changed && newc != c) {
                changed = true;
                s = new LinkedHashSet<Label>();
                for (Label d : this.components) {
                    if (c == d) break;
                    s.add(d);
                }
            }
            if (!changed) continue;
            s.add(newc);
        }
        substitution.popLabel(this);
        if (!changed) {
            return substitution.substLabel(this);
        }
        JifTypeSystem ts = this.typeSystem();
        Label newJoinLabel = ts.joinLabel(this.position(), JoinLabel_c.flatten(s));
        return substitution.substLabel(newJoinLabel);
    }

    @Override
    public Set<Variable> variableComponents() {
        LinkedHashSet<Variable> s = new LinkedHashSet<Variable>();
        for (Label ci : this.joinComponents()) {
            s.addAll(ci.variableComponents());
        }
        return s;
    }

    @Override
    public boolean hasWritersToReaders() {
        for (Label ci : this.joinComponents()) {
            if (!ci.hasWritersToReaders()) continue;
            return true;
        }
        return false;
    }

    @Override
    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        PathMap X = ts.pathMap().N(A.pc()).NV(A.pc());
        if (this.components.isEmpty()) {
            return X;
        }
        A = (JifContext)A.pushBlock();
        for (Label c : this.components) {
            this.updateContextForComp(lc, A, X);
            PathMap Xc = c.labelCheck(A, lc);
            X = X.join(Xc);
        }
        return X;
    }

    protected void updateContextForComp(LabelChecker lc, JifContext A, PathMap Xprev) {
        A.setPc(Xprev.N(), lc);
    }
}

